/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.views.browser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.Format;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.graalvm.visualvm.core.ui.components.DataViewComponent;
import org.graalvm.visualvm.jfr.model.JFRDataDescriptor;
import org.graalvm.visualvm.jfr.model.JFREvent;
import org.graalvm.visualvm.jfr.model.JFREventType;
import org.graalvm.visualvm.jfr.model.JFREventTypeVisitor;
import org.graalvm.visualvm.jfr.model.JFREventVisitor;
import org.graalvm.visualvm.jfr.model.JFRModel;
import org.graalvm.visualvm.jfr.views.browser.BrowserNode;
import org.graalvm.visualvm.jfr.views.browser.BrowserRenderers;
import org.graalvm.visualvm.jfr.views.components.MessageComponent;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTable;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTableContainer;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTreeTable;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTreeTableModel;
import org.graalvm.visualvm.lib.ui.swing.renderer.FormattedLabelRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.HideableBarRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.LabelRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.ProfilerRenderer;

final class BrowserViewSupport {
    BrowserViewSupport() {
    }

    static abstract class EventsTableViewSupport
    extends JPanel {
        private final List<String> names = new ArrayList<String>();
        private final List<List<Comparable>> values = new ArrayList<List<Comparable>>();
        private EventsTableModel tableModel;
        private ProfilerTable table;

        EventsTableViewSupport() {
            this.initComponents();
        }

        JFREventVisitor getVisitor(final String eventType, final long eventsCount, final List<JFRDataDescriptor> dataDescriptors) {
            final ArrayList newValues = new ArrayList();
            return new JFREventVisitor(){

                @Override
                public void init() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            values.clear();
                            values.add(null);
                            tableModel.fireTableStructureChanged();
                        }
                    });
                }

                @Override
                public boolean visit(String typeName, JFREvent event) {
                    if (eventType == null) {
                        return true;
                    }
                    if (eventType.equals(typeName)) {
                        newValues.add(event.getDisplayableValues(true));
                    }
                    return (long)newValues.size() == eventsCount;
                }

                @Override
                public void done() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ArrayList<String> tooltips = new ArrayList<String>();
                            ArrayList<LabelRenderer> renderers = new ArrayList<LabelRenderer>();
                            names.clear();
                            if (dataDescriptors != null) {
                                for (JFRDataDescriptor descriptor : dataDescriptors) {
                                    LabelRenderer renderer;
                                    String dataName = descriptor.getDataName();
                                    names.add(dataName);
                                    String dataDescription = descriptor.getDataDescription();
                                    tooltips.add(dataDescription != null && !dataDescription.isEmpty() ? dataDescription : dataName);
                                    Format format = descriptor.getDataFormat();
                                    Object object = renderer = format == null ? new LabelRenderer() : new FormattedLabelRenderer(format);
                                    if (descriptor.isNumericData()) {
                                        renderer.setHorizontalAlignment(11);
                                    }
                                    renderers.add(renderer);
                                }
                            }
                            values.clear();
                            values.addAll(newValues);
                            newValues.clear();
                            tableModel.fireTableStructureChanged();
                            table.setSortColumn(0);
                            table.setColumnToolTips(tooltips.toArray(new String[0]));
                            for (int column = 0; column < renderers.size(); ++column) {
                                table.setColumnRenderer(column, (ProfilerRenderer)renderers.get(column));
                            }
                        }
                    });
                }
            };
        }

        DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView("Events", null, 10, (JComponent)this, null);
        }

        private void initComponents() {
            this.tableModel = new EventsTableModel();
            this.table = new ProfilerTable((TableModel)this.tableModel, true, true, null);
            this.table.setFitWidthColumn(-1);
            this.table.setSorting(0, SortOrder.UNSORTED);
            this.table.setDefaultSortOrder(SortOrder.ASCENDING);
            this.table.setDefaultRenderer(Comparable.class, (ProfilerRenderer)new LabelRenderer());
            this.setLayout(new BorderLayout());
            this.add((Component)new ProfilerTableContainer(this.table, false, null), "Center");
        }

        private class EventsTableModel
        extends AbstractTableModel {
            private EventsTableModel() {
            }

            @Override
            public String getColumnName(int columnIndex) {
                return EventsTableViewSupport.this.names.isEmpty() ? " " : (String)EventsTableViewSupport.this.names.get(columnIndex);
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return Comparable.class;
            }

            @Override
            public int getRowCount() {
                return EventsTableViewSupport.this.values.size();
            }

            @Override
            public int getColumnCount() {
                return EventsTableViewSupport.this.names.isEmpty() ? 1 : EventsTableViewSupport.this.names.size();
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                List row = (List)EventsTableViewSupport.this.values.get(rowIndex);
                if (row == null) {
                    return columnIndex == 0 ? "loading events..." : "";
                }
                return row.get(columnIndex);
            }
        }
    }

    static abstract class EventsTreeViewSupport
    extends JPanel
    implements JFREventTypeVisitor {
        private Map<String, JFREventType> types;
        private DataModel tableModel;
        private ProfilerTreeTable table;

        EventsTreeViewSupport(long eventsCount) {
            this.initComponents(eventsCount);
        }

        abstract void reloadEvents(JFREventVisitor var1);

        abstract void eventsSelected(String var1, long var2, List<JFRDataDescriptor> var4);

        @Override
        public void initTypes() {
            this.types = new HashMap<String, JFREventType>();
        }

        @Override
        public boolean visitType(String typeName, JFREventType eventType) {
            this.types.put(typeName, eventType);
            return false;
        }

        JFREventVisitor getVisitor() {
            return new BrowserNode.Root(){

                @Override
                public void done() {
                    super.done();
                    tableModel.setRoot((TreeNode)((Object)this));
                    EventsTreeViewSupport.initialExpand(table, this);
                }

                @Override
                void reloadEvents(JFREventVisitor visitor) {
                    this.reloadEvents(visitor);
                }

                @Override
                JFREventType type(String typeName) {
                    return (JFREventType)types.get(typeName);
                }
            };
        }

        DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView("Types", null, 10, (JComponent)this, null);
        }

        private void initComponents(long eventsCount) {
            this.tableModel = new DataModel();
            this.table = new ProfilerTreeTable((ProfilerTreeTableModel)this.tableModel, true, true, new int[]{0});
            this.table.setRootVisible(false);
            this.table.setShowsRootHandles(true);
            this.table.setMainColumn(0);
            this.table.setFitWidthColumn(0);
            this.table.setDefaultSortOrder(SortOrder.ASCENDING);
            this.table.setDefaultSortOrder(2, SortOrder.DESCENDING);
            this.table.setSortColumn(0);
            final BrowserRenderers.NameRenderer nameRenderer = new BrowserRenderers.NameRenderer();
            nameRenderer.setShowsCount(!BrowserRenderers.EventsCountRenderer.isInitiallyVisible());
            this.table.setTreeCellRenderer((ProfilerRenderer)nameRenderer);
            BrowserRenderers.TypeIDRenderer typeIDRenderer = new BrowserRenderers.TypeIDRenderer();
            this.table.setColumnRenderer(1, (ProfilerRenderer)typeIDRenderer);
            this.table.setDefaultColumnWidth(1, typeIDRenderer.getPreferredWidth());
            this.table.setColumnVisibility(1, BrowserRenderers.TypeIDRenderer.isInitiallyVisible());
            BrowserRenderers.EventsCountRenderer eventsCountRenderer = new BrowserRenderers.EventsCountRenderer();
            HideableBarRenderer eventsCountRendererH = new HideableBarRenderer((ProfilerRenderer)eventsCountRenderer, eventsCountRenderer.getPreferredWidth());
            eventsCountRendererH.setMaxValue(eventsCount);
            this.table.setColumnRenderer(2, (ProfilerRenderer)eventsCountRendererH);
            this.table.setDefaultColumnWidth(2, eventsCountRendererH.getOptimalWidth());
            this.table.setColumnVisibility(2, BrowserRenderers.EventsCountRenderer.isInitiallyVisible());
            this.table.getColumnModel().getColumn(2).addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("maxWidth".equals(evt.getPropertyName())) {
                        nameRenderer.setShowsCount(Integer.valueOf(0).equals(evt.getNewValue()));
                        table.repaint();
                    }
                }
            });
            this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        BrowserNode.EventType typeNode;
                        BrowserNode node = this.getSelectedNode();
                        BrowserNode.EventType eventType = typeNode = node instanceof BrowserNode.EventType ? (BrowserNode.EventType)node : null;
                        if (typeNode == null) {
                            this.eventsSelected(null, -1L, null);
                        } else {
                            this.eventsSelected(typeNode.typeName, typeNode.eventsCount, typeNode.type.getDisplayableDataDescriptors(true));
                        }
                    }
                }

                private BrowserNode getSelectedNode() {
                    int row = table.getSelectedRow();
                    return row == -1 ? null : (BrowserNode)((Object)table.getValueForRow(row));
                }
            });
            this.setLayout(new BorderLayout());
            this.add((Component)new ProfilerTableContainer((ProfilerTable)this.table, false, null), "Center");
        }

        private static void initialExpand(ProfilerTreeTable table, BrowserNode root) {
            TreePath path = new TreePath((Object)root);
            for (BrowserNode node : root.getChildren()) {
                table.expandPath(path.pathByAddingChild((Object)node));
            }
        }

        private static class DataModel
        extends ProfilerTreeTableModel.Abstract {
            DataModel() {
                super((TreeNode)((Object)new BrowserNode.Root("reading data..."){}));
            }

            public int getColumnCount() {
                return 3;
            }

            public Class getColumnClass(int column) {
                switch (column) {
                    case 0: {
                        return JTree.class;
                    }
                    case 1: {
                        return String.class;
                    }
                    case 2: {
                        return Long.class;
                    }
                }
                return null;
            }

            public String getColumnName(int column) {
                switch (column) {
                    case 0: {
                        return BrowserRenderers.NameRenderer.getDisplayName();
                    }
                    case 1: {
                        return BrowserRenderers.TypeIDRenderer.getDisplayName();
                    }
                    case 2: {
                        return BrowserRenderers.EventsCountRenderer.getDisplayName();
                    }
                }
                return null;
            }

            public Object getValueAt(TreeNode node, int column) {
                if (node == null) {
                    return null;
                }
                BrowserNode rnode = (BrowserNode)((Object)node);
                switch (column) {
                    case 0: {
                        return rnode;
                    }
                    case 1: {
                        return rnode instanceof BrowserNode.EventType && ((BrowserNode.EventType)rnode).type != null ? ((BrowserNode.EventType)rnode).type.getName() : null;
                    }
                    case 2: {
                        return rnode.eventsCount == 0L ? null : Long.valueOf(rnode.eventsCount);
                    }
                }
                return null;
            }

            public void setValueAt(Object o, TreeNode node, int column) {
            }

            public boolean isCellEditable(TreeNode node, int column) {
                return false;
            }
        }
    }

    static abstract class MasterViewSupport
    extends JPanel
    implements JFREventVisitor {
        MasterViewSupport(JFRModel model) {
            this.initComponents(model);
        }

        abstract void firstShown();

        abstract void reloadEvents();

        @Override
        public boolean visit(String typeName, JFREvent event) {
            return false;
        }

        @Override
        public void done() {
        }

        DataViewComponent.MasterView getMasterView() {
            return new DataViewComponent.MasterView("Browser", null, (JComponent)this);
        }

        private void initComponents(JFRModel model) {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            if (model == null) {
                this.add((Component)MessageComponent.notAvailable(), "Center");
            } else {
                this.addHierarchyListener(new HierarchyListener(){

                    @Override
                    public void hierarchyChanged(HierarchyEvent e) {
                        if ((e.getChangeFlags() & 4L) != 0L && this.isShowing()) {
                            this.removeHierarchyListener(this);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    this.firstShown();
                                }
                            });
                        }
                    }
                });
            }
        }
    }
}

