/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.model;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import org.graalvm.visualvm.jfr.model.JFRClass;
import org.graalvm.visualvm.jfr.model.JFRPropertyNotAvailableException;
import org.graalvm.visualvm.jfr.model.JFRStackTrace;
import org.graalvm.visualvm.jfr.model.JFRThread;

public abstract class JFREvent {
    public boolean getBoolean(String key) throws JFRPropertyNotAvailableException {
        Object value = this.getValue(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new JFRPropertyNotAvailableException("No boolean value available: " + key);
    }

    public byte getByte(String key) throws JFRPropertyNotAvailableException {
        Object value = this.getValue(key);
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        throw new JFRPropertyNotAvailableException("No byte value available: " + key);
    }

    public char getChar(String key) throws JFRPropertyNotAvailableException {
        Object value = this.getValue(key);
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        throw new JFRPropertyNotAvailableException("No char value available: " + key);
    }

    public double getDouble(String key) throws JFRPropertyNotAvailableException {
        Object value = this.getValue(key);
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        throw new JFRPropertyNotAvailableException("No double value available: " + key);
    }

    public float getFloat(String key) throws JFRPropertyNotAvailableException {
        Object value = this.getValue(key);
        if (value instanceof Number) {
            return ((Number)value).floatValue();
        }
        throw new JFRPropertyNotAvailableException("No float value available: " + key);
    }

    public int getInt(String key) throws JFRPropertyNotAvailableException {
        Object value = this.getValue(key);
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        throw new JFRPropertyNotAvailableException("No int value available: " + key);
    }

    public long getLong(String key) throws JFRPropertyNotAvailableException {
        Object value = this.getValue(key);
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        throw new JFRPropertyNotAvailableException("No long value available: " + key);
    }

    public short getShort(String key) throws JFRPropertyNotAvailableException {
        Object value = this.getValue(key);
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        throw new JFRPropertyNotAvailableException("No short value available: " + key);
    }

    public String getString(String key) throws JFRPropertyNotAvailableException {
        Object value = this.getValue(key);
        if (value instanceof String) {
            return (String)value;
        }
        if (value == null) {
            return null;
        }
        throw new JFRPropertyNotAvailableException("No string value available: " + key);
    }

    public abstract Duration getDuration(String var1) throws JFRPropertyNotAvailableException;

    public abstract Instant getInstant(String var1) throws JFRPropertyNotAvailableException;

    public abstract JFRClass getClass(String var1) throws JFRPropertyNotAvailableException;

    public abstract JFRThread getThread(String var1) throws JFRPropertyNotAvailableException;

    public abstract JFRStackTrace getStackTrace(String var1) throws JFRPropertyNotAvailableException;

    public abstract Object getValue(String var1) throws JFRPropertyNotAvailableException;

    public abstract List<Comparable> getDisplayableValues(boolean var1);
}

