/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodeinfo.processor;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.FilerException;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.graalvm.compiler.nodeinfo.processor.ElementException;
import org.graalvm.compiler.nodeinfo.processor.GraphNodeVerifier;
import org.graalvm.compiler.processor.AbstractProcessor;

@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@SupportedAnnotationTypes(value={"org.graalvm.compiler.nodeinfo.NodeInfo"})
public class GraphNodeProcessor
extends AbstractProcessor {
    private static final String NODE_INFO_CLASS_NAME = "org.graalvm.compiler.nodeinfo.NodeInfo";
    private Element scope;

    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    public static boolean isEnclosedIn(Element e, Element scopeElement) {
        List<Element> elementHierarchy = GraphNodeProcessor.getElementHierarchy(e);
        return elementHierarchy.contains(scopeElement);
    }

    void errorMessage(Element element, String format, Object ... args) {
        this.message(Diagnostic.Kind.ERROR, element, format, args);
    }

    void message(Diagnostic.Kind kind, Element element, String format, Object ... args) {
        if (this.scope != null && !GraphNodeProcessor.isEnclosedIn(element, this.scope)) {
            List<Element> elementHierarchy = GraphNodeProcessor.getElementHierarchy(element);
            Collections.reverse(elementHierarchy);
            String loc = elementHierarchy.stream().filter(e -> e.getKind() != ElementKind.PACKAGE).map(Object::toString).collect(Collectors.joining("."));
            this.processingEnv.getMessager().printMessage(kind, String.format(loc + ": " + format, args), this.scope);
        } else {
            this.processingEnv.getMessager().printMessage(kind, String.format(format, args), element);
        }
    }

    private static List<Element> getElementHierarchy(Element e) {
        Element enclosing;
        ArrayList<Element> elements = new ArrayList<Element>();
        elements.add(e);
        for (enclosing = e.getEnclosingElement(); enclosing != null && enclosing.getKind() != ElementKind.PACKAGE; enclosing = enclosing.getEnclosingElement()) {
            elements.add(enclosing);
        }
        if (enclosing != null) {
            elements.add(enclosing);
        }
        return elements;
    }

    private void reportException(Diagnostic.Kind kind, Element element, Throwable t) {
        StringWriter buf = new StringWriter();
        t.printStackTrace(new PrintWriter(buf));
        this.message(kind, element, "Exception thrown during processing: %s", buf.toString());
    }

    boolean isNodeType(Element element) {
        if (element.getKind() != ElementKind.CLASS) {
            return false;
        }
        TypeElement type = (TypeElement)element;
        Types types = this.processingEnv.getTypeUtils();
        while (type != null) {
            if (type.toString().equals("org.graalvm.compiler.graph.Node")) {
                return true;
            }
            type = (TypeElement)types.asElement(type.getSuperclass());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return false;
        }
        GraphNodeVerifier verifier = new GraphNodeVerifier(this);
        Iterator<? extends Element> iterator = roundEnv.getElementsAnnotatedWith(this.getTypeElement(NODE_INFO_CLASS_NAME)).iterator();
        while (iterator.hasNext()) {
            Element element;
            this.scope = element = iterator.next();
            try {
                if (!this.isNodeType(element)) {
                    this.errorMessage(element, "%s can only be applied to Node subclasses", GraphNodeProcessor.getSimpleName((String)NODE_INFO_CLASS_NAME));
                    continue;
                }
                AnnotationMirror nodeInfo = this.getAnnotation(element, this.getType(NODE_INFO_CLASS_NAME));
                if (nodeInfo == null) {
                    this.errorMessage(element, "Cannot get %s annotation from annotated element", GraphNodeProcessor.getSimpleName((String)NODE_INFO_CLASS_NAME));
                    continue;
                }
                TypeElement typeElement = (TypeElement)element;
                Set<Modifier> modifiers = typeElement.getModifiers();
                boolean found = false;
                for (Element element2 : typeElement.getEnclosedElements()) {
                    if (element2.getKind() != ElementKind.FIELD || !element2.getSimpleName().toString().equals("TYPE")) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    this.errorMessage(element, "%s annotated class must have a field named TYPE", GraphNodeProcessor.getSimpleName((String)NODE_INFO_CLASS_NAME));
                }
                if (typeElement.equals(verifier.Node) || modifiers.contains((Object)Modifier.ABSTRACT)) continue;
                verifier.verify(typeElement);
            }
            catch (ElementException ee) {
                this.errorMessage(ee.element, ee.getMessage(), new Object[0]);
            }
            catch (Throwable t) {
                this.reportException(GraphNodeProcessor.isBug367599(t) ? Diagnostic.Kind.NOTE : Diagnostic.Kind.ERROR, element, t);
            }
            finally {
                this.scope = null;
            }
        }
        return false;
    }

    public static boolean isBug367599(Throwable t) {
        if (t instanceof FilerException) {
            for (StackTraceElement ste : t.getStackTrace()) {
                if (!ste.toString().contains("org.eclipse.jdt.internal.apt.pluggable.core.filer.IdeFilerImpl.create")) continue;
                return true;
            }
        }
        if (t.getCause() != null) {
            return GraphNodeProcessor.isBug367599(t.getCause());
        }
        return false;
    }
}

