/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import javax.swing.Icon;
import org.openide.util.CachedHiDPIIcon;
import org.openide.util.Parameters;

final class FilteredIcon
extends CachedHiDPIIcon {
    private final RGBImageFilter filter;
    private final Icon delegate;

    private FilteredIcon(RGBImageFilter rGBImageFilter, Icon icon) {
        super(icon.getIconWidth(), icon.getIconHeight());
        Parameters.notNull((CharSequence)"filter", (Object)rGBImageFilter);
        Parameters.notNull((CharSequence)"delegate", (Object)icon);
        this.filter = rGBImageFilter;
        this.delegate = icon;
    }

    public static Icon create(RGBImageFilter rGBImageFilter, Icon icon) {
        return new FilteredIcon(rGBImageFilter, icon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Image createImage(Component component, GraphicsConfiguration graphicsConfiguration, int n, int n2, double d) {
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            graphics2D.clip(new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight()));
            graphics2D.scale(d, d);
            this.delegate.paintIcon(component, graphics2D, 0, 0);
        }
        finally {
            graphics2D.dispose();
        }
        return Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(bufferedImage.getSource(), this.filter));
    }
}

