/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.shadowed.org.bytedeco.javacpp.indexer;

import com.oracle.svm.shadowed.org.bytedeco.javacpp.indexer.HalfIndexer;

public class HalfArrayIndexer
extends HalfIndexer {
    protected short[] array;

    public HalfArrayIndexer(short[] array) {
        this(array, new long[]{array.length}, ONE_STRIDE);
    }

    public HalfArrayIndexer(short[] array, long[] sizes, long[] strides) {
        super(sizes, strides);
        this.array = array;
    }

    public short[] array() {
        return this.array;
    }

    @Override
    public float get(long i) {
        return HalfArrayIndexer.toFloat(this.array[(int)i]);
    }

    @Override
    public HalfIndexer get(long i, float[] h, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            h[offset + n] = HalfArrayIndexer.toFloat(this.array[(int)i * (int)this.strides[0] + n]);
        }
        return this;
    }

    @Override
    public float get(long i, long j) {
        return HalfArrayIndexer.toFloat(this.array[(int)i * (int)this.strides[0] + (int)j]);
    }

    @Override
    public HalfIndexer get(long i, long j, float[] h, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            h[offset + n] = HalfArrayIndexer.toFloat(this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + n]);
        }
        return this;
    }

    @Override
    public float get(long i, long j, long k) {
        return HalfArrayIndexer.toFloat(this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + (int)k]);
    }

    @Override
    public float get(long ... indices) {
        return HalfArrayIndexer.toFloat(this.array[(int)this.index(indices)]);
    }

    @Override
    public HalfIndexer get(long[] indices, float[] h, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            h[offset + n] = HalfArrayIndexer.toFloat(this.array[(int)this.index(indices) + n]);
        }
        return this;
    }

    @Override
    public HalfIndexer put(long i, float h) {
        this.array[(int)i] = (short)HalfArrayIndexer.fromFloat(h);
        return this;
    }

    @Override
    public HalfIndexer put(long i, float[] h, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[(int)i * (int)this.strides[0] + n] = (short)HalfArrayIndexer.fromFloat(h[offset + n]);
        }
        return this;
    }

    @Override
    public HalfIndexer put(long i, long j, float h) {
        this.array[(int)i * (int)this.strides[0] + (int)j] = (short)HalfArrayIndexer.fromFloat(h);
        return this;
    }

    @Override
    public HalfIndexer put(long i, long j, float[] h, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + n] = (short)HalfArrayIndexer.fromFloat(h[offset + n]);
        }
        return this;
    }

    @Override
    public HalfIndexer put(long i, long j, long k, float h) {
        this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + (int)k] = (short)HalfArrayIndexer.fromFloat(h);
        return this;
    }

    @Override
    public HalfIndexer put(long[] indices, float h) {
        this.array[(int)this.index((long[])indices)] = (short)HalfArrayIndexer.fromFloat(h);
        return this;
    }

    @Override
    public HalfIndexer put(long[] indices, float[] h, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[(int)this.index((long[])indices) + n] = (short)HalfArrayIndexer.fromFloat(h[offset + n]);
        }
        return this;
    }

    @Override
    public void release() {
        this.array = null;
    }
}

