/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.shadowed.org.bytedeco.javacpp.indexer;

import com.oracle.svm.shadowed.org.bytedeco.javacpp.BytePointer;
import com.oracle.svm.shadowed.org.bytedeco.javacpp.indexer.ByteArrayIndexer;
import com.oracle.svm.shadowed.org.bytedeco.javacpp.indexer.ByteBufferIndexer;
import com.oracle.svm.shadowed.org.bytedeco.javacpp.indexer.ByteRawIndexer;
import com.oracle.svm.shadowed.org.bytedeco.javacpp.indexer.Indexer;
import com.oracle.svm.shadowed.org.bytedeco.javacpp.indexer.Raw;
import java.nio.ByteBuffer;

public abstract class ByteIndexer
extends Indexer {
    public static final int VALUE_BYTES = 1;

    protected ByteIndexer(long[] sizes, long[] strides) {
        super(sizes, strides);
    }

    public static ByteIndexer create(byte[] array) {
        return new ByteArrayIndexer(array);
    }

    public static ByteIndexer create(ByteBuffer buffer) {
        return new ByteBufferIndexer(buffer);
    }

    public static ByteIndexer create(BytePointer pointer) {
        return ByteIndexer.create(pointer, new long[]{pointer.limit() - pointer.position()}, ONE_STRIDE);
    }

    public static ByteIndexer create(byte[] array, long[] sizes, long[] strides) {
        return new ByteArrayIndexer(array, sizes, strides);
    }

    public static ByteIndexer create(ByteBuffer buffer, long[] sizes, long[] strides) {
        return new ByteBufferIndexer(buffer, sizes, strides);
    }

    public static ByteIndexer create(BytePointer pointer, long[] sizes, long[] strides) {
        return ByteIndexer.create(pointer, sizes, strides, true);
    }

    public static ByteIndexer create(final BytePointer pointer, long[] sizes, long[] strides, boolean direct) {
        if (direct) {
            return Raw.getInstance() != null ? new ByteRawIndexer(pointer, sizes, strides) : new ByteBufferIndexer(pointer.asBuffer(), sizes, strides);
        }
        final long position = pointer.position();
        byte[] array = new byte[(int)Math.min(pointer.limit() - position, Integer.MAX_VALUE)];
        pointer.get(array);
        return new ByteArrayIndexer(array, sizes, strides){

            @Override
            public void release() {
                pointer.position(position).put(this.array);
                super.release();
            }
        };
    }

    public abstract byte get(long var1);

    public ByteIndexer get(long i, byte[] b) {
        return this.get(i, b, 0, b.length);
    }

    public abstract ByteIndexer get(long var1, byte[] var3, int var4, int var5);

    public abstract byte get(long var1, long var3);

    public ByteIndexer get(long i, long j, byte[] b) {
        return this.get(i, j, b, 0, b.length);
    }

    public abstract ByteIndexer get(long var1, long var3, byte[] var5, int var6, int var7);

    public abstract byte get(long var1, long var3, long var5);

    public abstract byte get(long ... var1);

    public ByteIndexer get(long[] indices, byte[] b) {
        return this.get(indices, b, 0, b.length);
    }

    public abstract ByteIndexer get(long[] var1, byte[] var2, int var3, int var4);

    public abstract ByteIndexer put(long var1, byte var3);

    public ByteIndexer put(long i, byte ... b) {
        return this.put(i, b, 0, b.length);
    }

    public abstract ByteIndexer put(long var1, byte[] var3, int var4, int var5);

    public abstract ByteIndexer put(long var1, long var3, byte var5);

    public ByteIndexer put(long i, long j, byte ... b) {
        return this.put(i, j, b, 0, b.length);
    }

    public abstract ByteIndexer put(long var1, long var3, byte[] var5, int var6, int var7);

    public abstract ByteIndexer put(long var1, long var3, long var5, byte var7);

    public abstract ByteIndexer put(long[] var1, byte var2);

    public ByteIndexer put(long[] indices, byte ... b) {
        return this.put(indices, b, 0, b.length);
    }

    public abstract ByteIndexer put(long[] var1, byte[] var2, int var3, int var4);

    public abstract short getShort(long var1);

    public abstract ByteIndexer putShort(long var1, short var3);

    public abstract int getInt(long var1);

    public abstract ByteIndexer putInt(long var1, int var3);

    public abstract long getLong(long var1);

    public abstract ByteIndexer putLong(long var1, long var3);

    public abstract float getFloat(long var1);

    public abstract ByteIndexer putFloat(long var1, float var3);

    public abstract double getDouble(long var1);

    public abstract ByteIndexer putDouble(long var1, double var3);

    public abstract char getChar(long var1);

    public abstract ByteIndexer putChar(long var1, char var3);

    @Override
    public double getDouble(long ... indices) {
        return this.get(indices);
    }

    @Override
    public ByteIndexer putDouble(long[] indices, double b) {
        return this.put(indices, (byte)b);
    }
}

