/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.agentscript.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.tools.agentscript.impl.ArrayObject;
import com.oracle.truffle.tools.agentscript.impl.NullObject;

@ExportLibrary(value=InteropLibrary.class)
final class SourceEventObject
implements TruffleObject {
    private final Source source;

    SourceEventObject(Source source) {
        this.source = source;
    }

    @ExportMessage
    static boolean hasMembers(SourceEventObject obj) {
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    static Object getMembers(SourceEventObject obj, boolean includeInternal) {
        return ArrayObject.wrap(Members.values());
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    static boolean isMemberReadable(SourceEventObject obj, String member) {
        try {
            return Members.valueOf(member) != null;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    static Object readMember(SourceEventObject obj, String member) throws UnknownIdentifierException {
        Members existingMember;
        try {
            existingMember = Members.valueOf(member);
        }
        catch (IllegalArgumentException ex) {
            throw UnknownIdentifierException.create((String)member);
        }
        switch (existingMember) {
            case characters: {
                return obj.source.getCharacters().toString();
            }
            case name: {
                return obj.source.getName();
            }
            case language: {
                return obj.source.getLanguage();
            }
            case mimeType: {
                return NullObject.nullCheck(obj.source.getMimeType());
            }
            case uri: {
                return obj.source.getURI().toASCIIString();
            }
        }
        throw new IllegalArgumentException(member);
    }

    static enum Members {
        characters,
        name,
        language,
        mimeType,
        uri;

    }
}

