/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.agentscript.impl;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.Option;
import com.oracle.truffle.api.TruffleContext;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.instrumentation.ContextsListener;
import com.oracle.truffle.api.instrumentation.Instrumenter;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.tools.agentscript.AgentScript;
import com.oracle.truffle.tools.agentscript.impl.AgentException;
import com.oracle.truffle.tools.agentscript.impl.AgentObject;
import com.oracle.truffle.tools.agentscript.impl.AgentScriptInstrumentOptionDescriptors;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.util.Map;
import java.util.function.Supplier;
import org.graalvm.options.OptionCategory;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionKey;
import org.graalvm.options.OptionStability;

@TruffleInstrument.Registration(id="agentscript", name="Agent Script", version="0.1", services={AgentScript.class})
public final class AgentScriptInstrument
extends TruffleInstrument
implements AgentScript {
    static final String NAME = "Agent Script";
    @Option(stability=OptionStability.EXPERIMENTAL, name="", help="Use provided agent script", category=OptionCategory.USER)
    static final OptionKey<String> SCRIPT = new OptionKey((Object)"");
    private TruffleInstrument.Env env;

    protected OptionDescriptors getOptionDescriptors() {
        return new AgentScriptInstrumentOptionDescriptors();
    }

    protected void onCreate(TruffleInstrument.Env tmp) {
        this.env = tmp;
        this.env.registerService((Object)this);
        String path = (String)this.env.getOptions().get(SCRIPT);
        if (path != null && path.length() > 0) {
            this.registerAgentScript(() -> {
                try {
                    TruffleFile file = this.env.getTruffleFile(path);
                    if (file == null || !file.exists(new LinkOption[0])) {
                        throw AgentException.notFound(file);
                    }
                    String mimeType = file.getMimeType();
                    String lang = null;
                    for (Map.Entry e : this.env.getLanguages().entrySet()) {
                        if (!((LanguageInfo)e.getValue()).getMimeTypes().contains(mimeType)) continue;
                        lang = (String)e.getKey();
                        break;
                    }
                    return Source.newBuilder(lang, (TruffleFile)file).uri(file.toUri()).internal(true).name(file.getName()).build();
                }
                catch (IOException ex) {
                    throw AgentException.raise(ex);
                }
            });
        }
    }

    @Override
    public void registerAgentScript(Source script) {
        this.registerAgentScript(() -> script);
    }

    private void registerAgentScript(final Supplier<Source> src) {
        Instrumenter instrumenter = this.env.getInstrumenter();
        instrumenter.attachContextsListener(new ContextsListener(){
            private AgentObject agent;

            public void onContextCreated(TruffleContext context) {
            }

            public void onLanguageContextCreated(TruffleContext context, LanguageInfo language) {
            }

            public void onLanguageContextInitialized(TruffleContext context, LanguageInfo language) {
                if (this.agent != null || language.isInternal()) {
                    return;
                }
                try {
                    Source script = (Source)src.get();
                    this.agent = new AgentObject(AgentScriptInstrument.this.env);
                    CallTarget target = AgentScriptInstrument.this.env.parse(script, new String[]{"agent"});
                    target.call(new Object[]{this.agent});
                    this.agent.initializationFinished();
                }
                catch (IOException ex) {
                    throw AgentException.raise(ex);
                }
            }

            public void onLanguageContextFinalized(TruffleContext context, LanguageInfo language) {
                if (this.agent != null) {
                    this.agent.onClosed();
                }
            }

            public void onLanguageContextDisposed(TruffleContext context, LanguageInfo language) {
            }

            public void onContextClosed(TruffleContext context) {
            }
        }, true);
    }

    protected void onDispose(TruffleInstrument.Env tmp) {
    }
}

