/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.agentscript.impl;

import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.EventContext;
import com.oracle.truffle.api.instrumentation.ExecutionEventNode;
import com.oracle.truffle.api.instrumentation.ExecutionEventNodeFactory;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.tools.agentscript.impl.AgentException;
import com.oracle.truffle.tools.agentscript.impl.EventContextObject;
import com.oracle.truffle.tools.agentscript.impl.VariablesObject;

final class AgentExecutionNode
extends ExecutionEventNode {
    @Node.Child
    private InteropLibrary enterDispatch;
    @Node.Child
    private InteropLibrary exitDispatch;
    private final TruffleInstrument.Env env;
    private final Object enter;
    private final Object exit;
    private final EventContextObject ctx;

    AgentExecutionNode(TruffleInstrument.Env env, Object enter, Object exit, EventContextObject ctx) {
        this.env = env;
        this.enter = enter;
        if (enter != null) {
            this.enterDispatch = (InteropLibrary)InteropLibrary.getFactory().createDispatched(3);
        }
        this.exit = exit;
        if (exit != null) {
            this.exitDispatch = (InteropLibrary)InteropLibrary.getFactory().createDispatched(3);
        }
        this.ctx = ctx;
    }

    protected void onEnter(VirtualFrame frame) {
        if (this.enter != null) {
            try {
                this.enterDispatch.execute(this.enter, new Object[]{this.ctx, new VariablesObject(this.env, (Node)this, (Frame)frame)});
            }
            catch (InteropException ex) {
                throw AgentException.raise((Exception)((Object)ex));
            }
        }
    }

    protected void onReturnValue(VirtualFrame frame, Object result) {
        if (this.exit != null) {
            try {
                this.exitDispatch.execute(this.exit, new Object[]{this.ctx, new VariablesObject(this.env, (Node)this, (Frame)frame)});
            }
            catch (InteropException ex) {
                throw AgentException.raise((Exception)((Object)ex));
            }
        }
    }

    protected void onReturnExceptional(VirtualFrame frame, Throwable exception) {
        if (this.exit != null) {
            try {
                this.enterDispatch.execute(this.exit, new Object[]{this.ctx, new VariablesObject(this.env, (Node)this, (Frame)frame)});
            }
            catch (InteropException ex) {
                throw AgentException.raise((Exception)((Object)ex));
            }
        }
    }

    static ExecutionEventNodeFactory factory(final TruffleInstrument.Env env, final Object enter, final Object exit) {
        return new ExecutionEventNodeFactory(){

            public ExecutionEventNode create(EventContext context) {
                EventContextObject ctx = new EventContextObject(context);
                return new AgentExecutionNode(env, enter, exit, ctx);
            }
        };
    }
}

