/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.agentscript.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleException;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.nodes.Node;

final class AgentException
extends RuntimeException
implements TruffleException {
    static final long serialVersionUID = 1L;
    private final int exitCode;

    @CompilerDirectives.TruffleBoundary
    private AgentException(String msg, Throwable cause, int exitCode) {
        super("agentscript: " + msg, cause);
        this.exitCode = exitCode;
    }

    @Override
    public Throwable fillInStackTrace() {
        return this;
    }

    public Node getLocation() {
        return null;
    }

    public boolean isExit() {
        return this.exitCode >= 0;
    }

    public int getExitStatus() {
        return this.exitCode;
    }

    @CompilerDirectives.TruffleBoundary
    static AgentException raise(Exception ex) throws AgentException {
        throw new AgentException(ex.getMessage(), ex, -1);
    }

    @CompilerDirectives.TruffleBoundary
    static AgentException notFound(TruffleFile file) {
        throw new AgentException(file.getName() + ": No such file or directory", null, 1);
    }
}

