/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.object.dsl.processor;

import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.TruffleTypes;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.object.dsl.processor.LayoutProcessor;
import com.oracle.truffle.object.dsl.processor.model.LayoutModel;
import com.oracle.truffle.object.dsl.processor.model.NameUtils;
import com.oracle.truffle.object.dsl.processor.model.PropertyBuilder;
import com.oracle.truffle.object.dsl.processor.model.PropertyModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public class LayoutParser {
    private final LayoutProcessor processor;
    private TypeMirror objectTypeSuperclass;
    private LayoutModel superLayout;
    private String name;
    private String packageName;
    private String interfaceFullName;
    private boolean hasObjectTypeGuard;
    private boolean hasObjectGuard;
    private boolean hasDynamicObjectGuard;
    private boolean hasShapeProperties;
    private boolean hasCreate;
    private boolean hasBuilder;
    private final List<String> constructorProperties = new ArrayList<String>();
    private final Map<String, PropertyBuilder> properties = new HashMap<String, PropertyBuilder>();
    private List<VariableElement> implicitCasts = new ArrayList<VariableElement>();
    private final TruffleTypes types = ProcessorContext.getInstance().getTypes();

    public LayoutParser(LayoutProcessor processor) {
        this.processor = processor;
    }

    public void parse(TypeElement layoutElement) {
        String simpleName;
        if (layoutElement.getKind() != ElementKind.INTERFACE) {
            this.processor.reportError(layoutElement, "@Layout should only be applied to interfaces", new Object[0]);
        }
        this.parseName(layoutElement);
        if (!layoutElement.getInterfaces().isEmpty()) {
            if (layoutElement.getInterfaces().size() > 1) {
                this.processor.reportError(layoutElement, "@Layout interfaces can have at most one super-interface", new Object[0]);
            }
            DeclaredType superInterface = (DeclaredType)layoutElement.getInterfaces().get(0);
            this.parseSuperLayout((TypeElement)superInterface.asElement());
        }
        for (AnnotationMirror annotationMirror : layoutElement.getAnnotationMirrors()) {
            VariableElement var;
            if (!this.isSameType(annotationMirror.getAnnotationType(), this.types.Layout)) continue;
            this.objectTypeSuperclass = ElementUtils.getAnnotationValue(TypeMirror.class, annotationMirror, "objectTypeSuperclass");
            if (ElementUtils.getAnnotationValue(Boolean.class, annotationMirror, "implicitCastIntToLong").booleanValue()) {
                var = ElementUtils.findVariableElement(this.types.Layout_ImplicitCast, "IntToLong");
                this.implicitCasts.add(var);
            }
            if (!ElementUtils.getAnnotationValue(Boolean.class, annotationMirror, "implicitCastIntToDouble").booleanValue()) continue;
            var = ElementUtils.findVariableElement(this.types.Layout_ImplicitCast, "IntToDouble");
            this.implicitCasts.add(var);
        }
        if (this.superLayout != null && !this.implicitCasts.isEmpty()) {
            this.processor.reportError(layoutElement, "@Layout implicit casts need to be specified in the base layout", new Object[0]);
        }
        for (Element element : layoutElement.getEnclosedElements()) {
            if (element.getKind() != ElementKind.FIELD) continue;
            simpleName = element.getSimpleName().toString();
            if (simpleName.endsWith("_IDENTIFIER")) {
                this.parseIdentifier((VariableElement)element);
                continue;
            }
            this.processor.reportError(element, "@Layout interface fields should only be identifier fields, ending with _IDENTIFIER", new Object[0]);
        }
        for (Element element : layoutElement.getEnclosedElements()) {
            if (element.getKind() != ElementKind.METHOD || !(simpleName = element.getSimpleName().toString()).equals("create" + this.name + "Shape")) continue;
            this.parseShapeConstructor((ExecutableElement)element);
        }
        for (Element element : layoutElement.getEnclosedElements()) {
            if (element.getKind() != ElementKind.METHOD || (simpleName = element.getSimpleName().toString()).equals("create" + this.name + "Shape")) continue;
            if (simpleName.equals("create" + this.name)) {
                this.parseConstructor((ExecutableElement)element);
                continue;
            }
            if (simpleName.equals("build")) {
                this.parseBuilder((ExecutableElement)element);
                continue;
            }
            if (simpleName.equals("is" + this.name)) {
                this.parseGuard((ExecutableElement)element);
                continue;
            }
            if (simpleName.startsWith("getAndSet")) {
                this.parseGetAndSet((ExecutableElement)element);
                continue;
            }
            if (simpleName.startsWith("compareAndSet")) {
                this.parseCompareAndSet((ExecutableElement)element);
                continue;
            }
            if (simpleName.startsWith("get")) {
                this.parseGetter((ExecutableElement)element);
                continue;
            }
            if (simpleName.startsWith("set")) {
                this.parseSetter((ExecutableElement)element);
                continue;
            }
            this.processor.reportError(element, "Unknown method prefix in @Layout interface - wouldn't know how to implement this method", new Object[0]);
        }
        for (Element element : layoutElement.getEnclosedElements()) {
            if (element.getKind() == ElementKind.FIELD || element.getKind() == ElementKind.METHOD) continue;
            this.processor.reportError(element, "@Layout interfaces can only contain fields and methods", new Object[0]);
        }
    }

    private void parseName(TypeElement layoutElement) {
        this.parsePackageName(layoutElement);
        this.interfaceFullName = ElementUtils.getQualifiedName(layoutElement);
        String nameString = layoutElement.getSimpleName().toString();
        if (!nameString.endsWith("Layout")) {
            this.processor.reportError(layoutElement, "@Layout interfaces should have a name ending with -Layout", new Object[0]);
        }
        this.name = nameString.substring(0, nameString.length() - "Layout".length());
    }

    private void parseSuperLayout(TypeElement superTypeElement) {
        LayoutParser superParser = new LayoutParser(this.processor);
        superParser.parse(superTypeElement);
        this.superLayout = superParser.build();
    }

    private void parseIdentifier(VariableElement fieldElement) {
        String identifierName = fieldElement.getSimpleName().toString();
        String propertyName = NameUtils.constantToIdentifier(identifierName.substring(0, identifierName.length() - "_IDENTIFIER".length()));
        this.getProperty(propertyName).setHasIdentifier(true);
    }

    private void parseShapeConstructor(ExecutableElement methodElement) {
        List<? extends VariableElement> parameters = methodElement.getParameters();
        if (!parameters.isEmpty()) {
            this.hasShapeProperties = true;
        }
        if (this.superLayout != null) {
            List<PropertyModel> superShapeProperties = this.superLayout.getAllShapeProperties();
            this.checkSharedParameters(methodElement, parameters, superShapeProperties);
            parameters = parameters.subList(superShapeProperties.size(), parameters.size());
        }
        for (VariableElement variableElement : parameters) {
            String parameterName = variableElement.getSimpleName().toString();
            this.constructorProperties.add(parameterName);
            PropertyBuilder property = this.getProperty(parameterName);
            this.setPropertyType(variableElement, property, variableElement.asType());
            this.parseConstructorParameterAnnotations(property, variableElement);
            property.setIsShapeProperty(true);
        }
    }

    private void parseConstructor(ExecutableElement methodElement) {
        this.hasCreate = true;
        this.checkCreateAndBuilder(methodElement);
        List<? extends VariableElement> parameters = methodElement.getParameters();
        if (this.hasShapeProperties) {
            VariableElement firstParameter;
            String firstParameterName;
            if (parameters.isEmpty()) {
                this.processor.reportError(methodElement, "If an @Layout has shape properties the constructor must have parameters", new Object[0]);
            }
            if (!LayoutParser.matches(firstParameterName = (firstParameter = parameters.get(0)).getSimpleName().toString(), "factory")) {
                this.processor.reportError(firstParameter, "If an @Layout has shape properties, the first parameter of the constructor must be called factory (was %s)", firstParameter.getSimpleName());
            }
            if (!this.isSameType(firstParameter.asType(), this.types.DynamicObjectFactory)) {
                this.processor.reportError(firstParameter, "If an @Layout has shape properties, the first parameter of the constructor must be of type DynamicObjectFactory (was %s)", firstParameter.asType());
            }
            parameters = parameters.subList(1, parameters.size());
        }
        this.addConstructorProperties(methodElement, parameters);
    }

    private void parseBuilder(ExecutableElement methodElement) {
        this.hasBuilder = true;
        this.checkCreateAndBuilder(methodElement);
        List<? extends VariableElement> parameters = methodElement.getParameters();
        if (!this.isSameType(methodElement.getReturnType(), ProcessorContext.getInstance().getType(Object[].class))) {
            this.processor.reportError(methodElement, "build() must have Object[] for return type", new Object[0]);
        }
        this.addConstructorProperties(methodElement, parameters);
    }

    private void checkCreateAndBuilder(ExecutableElement methodElement) {
        if (this.hasCreate && this.hasBuilder) {
            this.processor.reportError(methodElement, "Only one of create<Layout>() or build() may be specified.", new Object[0]);
            return;
        }
    }

    private void addConstructorProperties(ExecutableElement methodElement, List<? extends VariableElement> parameters) {
        List<? extends VariableElement> ownParameters = parameters;
        if (this.superLayout != null) {
            List<PropertyModel> superProperties = this.superLayout.getAllInstanceProperties();
            this.checkSharedParameters(methodElement, parameters, superProperties);
            ownParameters = parameters.subList(superProperties.size(), parameters.size());
        }
        for (VariableElement variableElement : ownParameters) {
            String parameterName = variableElement.getSimpleName().toString();
            if (parameterName.equals("factory")) {
                this.processor.reportError(methodElement, "Factory is a confusing name for a property", new Object[0]);
            }
            if (this.constructorProperties.contains(parameterName)) {
                this.processor.reportError(methodElement, "The property %s is duplicated", new Object[0]);
                continue;
            }
            this.constructorProperties.add(parameterName);
            PropertyBuilder property = this.getProperty(parameterName);
            this.setPropertyType(variableElement, property, variableElement.asType());
            this.parseConstructorParameterAnnotations(property, variableElement);
        }
    }

    private void checkSharedParameters(Element element, List<? extends VariableElement> parameters, List<PropertyModel> sharedProperties) {
        if (parameters.size() < sharedProperties.size()) {
            this.processor.reportError(element, "@Layout constructor cannot have less parameters than the super layout constructor " + parameters + " " + sharedProperties, new Object[0]);
        }
        for (int n = 0; n < sharedProperties.size(); ++n) {
            VariableElement parameter = parameters.get(n);
            String parameterName = parameter.getSimpleName().toString();
            PropertyModel superLayoutProperty = sharedProperties.get(n);
            if (superLayoutProperty.hasGeneratedName()) {
                superLayoutProperty.fixName(parameterName);
            }
            if (!parameterName.equals(superLayoutProperty.getName())) {
                this.processor.reportError(element, "@Layout constructor parameter %d needs to have the same name as the super layout constructor (is %s, should be %s)", n, parameter.getSimpleName(), superLayoutProperty.getName());
            }
            if (this.isSameType(parameter.asType(), superLayoutProperty.getType())) continue;
            this.processor.reportError(element, "@Layout constructor parameter %d needs to have the same type as the super layout constructor (is %s, should be %s)", n, parameter.asType(), superLayoutProperty.getType());
        }
    }

    private void parsePackageName(TypeElement layoutElement) {
        String[] packageComponents = ElementUtils.getQualifiedName(layoutElement).split("\\.");
        StringBuilder packageBuilder = new StringBuilder();
        for (int n = 0; n < packageComponents.length && !Character.isUpperCase(packageComponents[n].charAt(0)); ++n) {
            if (n > 0) {
                packageBuilder.append('.');
            }
            packageBuilder.append(packageComponents[n]);
        }
        this.packageName = packageBuilder.toString();
    }

    private void parseGuard(ExecutableElement methodElement) {
        String expectedParameterName;
        if (methodElement.getParameters().size() != 1) {
            this.processor.reportError(methodElement, "@Layout guard methods must have just one parameter", new Object[0]);
        }
        VariableElement parameter = methodElement.getParameters().get(0);
        TypeMirror type = parameter.asType();
        String parameterName = parameter.getSimpleName().toString();
        if (this.isSameType(type, this.types.DynamicObject)) {
            this.hasDynamicObjectGuard = true;
            expectedParameterName = "object";
        } else if (this.isSameType(type, this.types.ObjectType)) {
            this.hasObjectTypeGuard = true;
            expectedParameterName = "objectType";
        } else if (this.isSameType(type, ProcessorContext.getInstance().getType(Object.class))) {
            this.hasObjectGuard = true;
            expectedParameterName = "object";
        } else {
            this.processor.reportError(methodElement, "@Layout guard method with unknown parameter type %s - don't know how to guard on this", type);
            expectedParameterName = null;
        }
        if (expectedParameterName != null && !LayoutParser.matches(parameterName, expectedParameterName)) {
            this.processor.reportError(methodElement, "@Layout guard method should have a parameter named %s", expectedParameterName);
        }
    }

    private void parseGetter(ExecutableElement methodElement) {
        String expectedParameterName;
        boolean isObjectTypeGetter;
        boolean isShapeGetter;
        if (methodElement.getParameters().size() != 1) {
            this.processor.reportError(methodElement, "@Layout getter methods must have just one parameter", new Object[0]);
        }
        VariableElement parameter = methodElement.getParameters().get(0);
        TypeMirror parameterType = parameter.asType();
        String parameterName = parameter.getSimpleName().toString();
        if (this.isSameType(parameterType, this.types.DynamicObject)) {
            isShapeGetter = false;
            isObjectTypeGetter = false;
            expectedParameterName = "object";
        } else if (this.isSameType(parameterType, this.types.DynamicObjectFactory)) {
            isShapeGetter = true;
            isObjectTypeGetter = false;
            expectedParameterName = "factory";
        } else if (this.isSameType(parameterType, this.types.ObjectType)) {
            isShapeGetter = false;
            isObjectTypeGetter = true;
            expectedParameterName = "objectType";
        } else {
            isShapeGetter = false;
            isObjectTypeGetter = false;
            expectedParameterName = null;
            this.processor.reportError(methodElement, "@Layout getter methods must have a parameter of type DynamicObject or, for shape properties, DynamicObjectFactory or ObjectType", new Object[0]);
        }
        if (expectedParameterName != null && !LayoutParser.matches(parameterName, expectedParameterName)) {
            this.processor.reportError(methodElement, "@Layout getter method should have a parameter named %s", expectedParameterName);
        }
        String propertyName = NameUtils.titleToCamel(methodElement.getSimpleName().toString().substring("get".length()));
        PropertyBuilder property = this.getProperty(propertyName);
        if (isShapeGetter) {
            property.setHasShapeGetter(true);
        } else if (isObjectTypeGetter) {
            property.setHasObjectTypeGetter(true);
        } else {
            property.setHasGetter(true);
        }
        this.setPropertyType(methodElement, property, methodElement.getReturnType());
    }

    private void parseSetter(ExecutableElement methodElement) {
        VariableElement secondParameter;
        String secondParameterName;
        String expectedParameterName;
        boolean isShapeSetter;
        if (methodElement.getParameters().size() != 2) {
            this.processor.reportError(methodElement, "@Layout guard methods must have two parameters", new Object[0]);
        }
        VariableElement parameter = methodElement.getParameters().get(0);
        TypeMirror parameterType = parameter.asType();
        String parameterName = parameter.getSimpleName().toString();
        if (this.isSameType(parameterType, this.types.DynamicObject)) {
            isShapeSetter = false;
            expectedParameterName = "object";
        } else if (this.isSameType(parameterType, this.types.DynamicObjectFactory)) {
            isShapeSetter = true;
            expectedParameterName = "factory";
        } else {
            isShapeSetter = false;
            expectedParameterName = null;
            this.processor.reportError(methodElement, "@Layout setter methods must have a first parameter of type DynamicObject or, for shape properties, DynamicObjectFactory", new Object[0]);
        }
        if (expectedParameterName != null && !LayoutParser.matches(parameterName, expectedParameterName)) {
            this.processor.reportError(methodElement, "@Layout getter method should have a first parameter named %s", expectedParameterName);
        }
        if (!LayoutParser.matches(secondParameterName = (secondParameter = methodElement.getParameters().get(1)).getSimpleName().toString(), "value")) {
            this.processor.reportError(methodElement, "@Layout getter method should have a second parameter named value", new Object[0]);
        }
        boolean isUnsafeSetter = methodElement.getSimpleName().toString().endsWith("Unsafe");
        String propertyName = NameUtils.titleToCamel(methodElement.getSimpleName().toString().substring("set".length()));
        if (isUnsafeSetter) {
            propertyName = propertyName.substring(0, propertyName.length() - "Unsafe".length());
        }
        PropertyBuilder property = this.getProperty(propertyName);
        if (isShapeSetter) {
            property.setHasShapeSetter(true);
        } else if (isUnsafeSetter) {
            property.setHasUnsafeSetter(isUnsafeSetter);
        } else {
            property.setHasSetter(true);
        }
        this.setPropertyType(methodElement, property, methodElement.getParameters().get(1).asType());
    }

    private void parseCompareAndSet(ExecutableElement methodElement) {
        if (methodElement.getParameters().size() != 3) {
            this.processor.reportError(methodElement, "@Layout compare and set methods must have three parameters", new Object[0]);
        }
        VariableElement objectParameter = methodElement.getParameters().get(0);
        VariableElement currentValueParameter = methodElement.getParameters().get(1);
        VariableElement newValueParameter = methodElement.getParameters().get(2);
        if (!this.isSameType(objectParameter.asType(), this.types.DynamicObject)) {
            this.processor.reportError(methodElement, "@Layout compare and set method should have a first parameter of type DynamicObject", new Object[0]);
        }
        if (!objectParameter.getSimpleName().toString().equals("object")) {
            this.processor.reportError(methodElement, "@Layout compare and set method should have a first parameter named object", new Object[0]);
        }
        if (!currentValueParameter.getSimpleName().toString().equals("expectedValue")) {
            this.processor.reportError(methodElement, "@Layout compare and set method should have a second parameter named expectedValue", new Object[0]);
        }
        if (!newValueParameter.getSimpleName().toString().equals("value")) {
            this.processor.reportError(methodElement, "@Layout compare and set method should have a third parameter named value", new Object[0]);
        }
        String propertyName = NameUtils.titleToCamel(methodElement.getSimpleName().toString().substring("compareAndSet".length()));
        PropertyBuilder property = this.getProperty(propertyName);
        property.setHasCompareAndSet(true);
        this.setPropertyType(methodElement, property, methodElement.getParameters().get(1).asType());
        this.setPropertyType(methodElement, property, methodElement.getParameters().get(2).asType());
    }

    private void parseGetAndSet(ExecutableElement methodElement) {
        if (methodElement.getParameters().size() != 2) {
            this.processor.reportError(methodElement, "@Layout get and set methods must have two parameters", new Object[0]);
        }
        VariableElement objectParameter = methodElement.getParameters().get(0);
        VariableElement newValueParameter = methodElement.getParameters().get(1);
        if (!this.isSameType(objectParameter.asType(), this.types.DynamicObject)) {
            this.processor.reportError(methodElement, "@Layout get and set method should have a first parameter of type DynamicObject", new Object[0]);
        }
        if (!objectParameter.getSimpleName().toString().equals("object")) {
            this.processor.reportError(methodElement, "@Layout get and set method should have a first parameter named object", new Object[0]);
        }
        if (!newValueParameter.getSimpleName().toString().equals("value")) {
            this.processor.reportError(methodElement, "@Layout get and set method should have a second parameter named value", new Object[0]);
        }
        String propertyName = NameUtils.titleToCamel(methodElement.getSimpleName().toString().substring("getAndSet".length()));
        PropertyBuilder property = this.getProperty(propertyName);
        property.setHasGetAndSet(true);
        this.setPropertyType(methodElement, property, methodElement.getParameters().get(1).asType());
        this.setPropertyType(methodElement, property, methodElement.getReturnType());
    }

    private void parseConstructorParameterAnnotations(PropertyBuilder property, Element element) {
        if (ElementUtils.findAnnotationMirror(element, (TypeMirror)this.types.Nullable) != null) {
            property.setNullable(true);
        }
        if (ElementUtils.findAnnotationMirror(element, (TypeMirror)this.types.Volatile) != null) {
            property.setVolatile(true);
        }
    }

    private boolean isSameType(TypeMirror a, TypeMirror b) {
        return this.processor.getProcessingEnv().getTypeUtils().isSameType(a, b);
    }

    public static boolean isGeneratedName(String name) {
        return name.length() > 3 && name.startsWith("arg") && Character.isDigit(name.charAt(3));
    }

    private static boolean matches(String parameterName, String expected) {
        if (LayoutParser.isGeneratedName(parameterName)) {
            return true;
        }
        return parameterName.equals(expected);
    }

    private void setPropertyType(Element element, PropertyBuilder builder, TypeMirror type) {
        if (builder.getType() == null) {
            builder.setType(type);
        } else if (!this.isSameType(type, builder.getType())) {
            this.processor.reportError(element, "@Layout property types are inconsistent - was previously %s but now %s", builder.getType(), type);
        }
    }

    private PropertyBuilder getProperty(String propertyName) {
        PropertyBuilder builder = this.properties.get(propertyName);
        if (builder == null) {
            builder = new PropertyBuilder(propertyName);
            this.properties.put(propertyName, builder);
        }
        return builder;
    }

    public LayoutModel build() {
        return new LayoutModel(this.objectTypeSuperclass, this.superLayout, this.name, this.packageName, this.hasObjectTypeGuard, this.hasObjectGuard, this.hasDynamicObjectGuard, this.hasBuilder, this.buildProperties(), this.interfaceFullName, this.implicitCasts);
    }

    private List<PropertyModel> buildProperties() {
        ArrayList<PropertyModel> models = new ArrayList<PropertyModel>();
        for (String propertyName : this.constructorProperties) {
            models.add(this.getProperty(propertyName).build());
        }
        return models;
    }
}

