/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.parser;

import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.model.ImplicitCastData;
import com.oracle.truffle.dsl.processor.model.MethodSpec;
import com.oracle.truffle.dsl.processor.model.Parameter;
import com.oracle.truffle.dsl.processor.model.ParameterSpec;
import com.oracle.truffle.dsl.processor.model.TemplateMethod;
import com.oracle.truffle.dsl.processor.model.TypeSystemData;
import com.oracle.truffle.dsl.processor.parser.TypeSystemMethodParser;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public class ImplicitCastParser
extends TypeSystemMethodParser<ImplicitCastData> {
    public ImplicitCastParser(ProcessorContext context, TypeSystemData typeSystem) {
        super(context, typeSystem);
    }

    @Override
    public DeclaredType getAnnotationType() {
        return this.types.ImplicitCast;
    }

    @Override
    public MethodSpec createSpecification(ExecutableElement method, AnnotationMirror mirror) {
        MethodSpec spec = new MethodSpec(new ParameterSpec("target", this.getContext().getType(Object.class)));
        spec.addRequired(new ParameterSpec("source", this.getContext().getType(Object.class))).setSignature(true);
        return spec;
    }

    @Override
    public ImplicitCastData create(TemplateMethod method, boolean invalid) {
        TypeMirror sourceType;
        if (invalid) {
            return new ImplicitCastData(method, null, null);
        }
        Parameter target = method.findParameter("targetValue");
        Parameter source = method.findParameter("sourceValue");
        TypeMirror targetType = target.getType();
        if (ElementUtils.typeEquals(targetType, sourceType = source.getType())) {
            method.addError("Target type and source type of an @%s must not be the same type.", this.types.ImplicitCast.asElement().getSimpleName().toString());
        }
        if (!method.getMethod().getModifiers().contains((Object)Modifier.STATIC)) {
            method.addError("@%s annotated method %s must be static.", this.types.ImplicitCast.asElement().getSimpleName().toString(), method.getMethodName());
        }
        return new ImplicitCastData(method, sourceType, targetType);
    }
}

