/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.parser;

import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.model.CreateCastData;
import com.oracle.truffle.dsl.processor.model.MethodSpec;
import com.oracle.truffle.dsl.processor.model.NodeChildData;
import com.oracle.truffle.dsl.processor.model.NodeData;
import com.oracle.truffle.dsl.processor.model.ParameterSpec;
import com.oracle.truffle.dsl.processor.model.TemplateMethod;
import com.oracle.truffle.dsl.processor.parser.NodeMethodParser;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public class CreateCastParser
extends NodeMethodParser<CreateCastData> {
    public CreateCastParser(ProcessorContext context, NodeData operation) {
        super(context, operation);
    }

    @Override
    public DeclaredType getAnnotationType() {
        return this.types.CreateCast;
    }

    @Override
    public MethodSpec createSpecification(ExecutableElement method, AnnotationMirror mirror) {
        List<String> childNames = ElementUtils.getAnnotationValueList(String.class, mirror, "value");
        NodeChildData foundChild = null;
        for (String childName : childNames) {
            foundChild = this.getNode().findChild(childName);
            if (foundChild == null) continue;
            break;
        }
        TypeMirror baseType = this.types.Node;
        if (foundChild != null) {
            baseType = foundChild.getOriginalType();
        }
        MethodSpec spec = new MethodSpec(new ParameterSpec("child", baseType));
        this.addDefaultFieldMethodSpec(spec);
        ParameterSpec childSpec = new ParameterSpec("castedChild", baseType);
        childSpec.setSignature(true);
        spec.addRequired(childSpec);
        return spec;
    }

    @Override
    public CreateCastData create(TemplateMethod method, boolean invalid) {
        AnnotationMirror mirror = method.getMarkerAnnotation();
        List<String> childNames = ElementUtils.getAnnotationValueList(String.class, mirror, "value");
        CreateCastData cast = new CreateCastData(method, childNames);
        AnnotationValue value = ElementUtils.getAnnotationValue(mirror, "value");
        TypeMirror type = null;
        if (childNames == null || childNames.isEmpty()) {
            cast.addError(value, "No value specified but required.", new Object[0]);
            return cast;
        }
        for (String childName : childNames) {
            NodeChildData child = this.getNode().findChild(childName);
            if (child == null) {
                cast.addError(value, "Specified child '%s' not found.", childName);
                continue;
            }
            if (type == null) {
                type = child.getNodeType();
                continue;
            }
            if (ElementUtils.typeEquals(type, child.getNodeType())) continue;
            cast.addError(value, "All child nodes for a cast must have the same node type.", new Object[0]);
        }
        return cast;
    }
}

