/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.model;

import com.oracle.truffle.dsl.processor.ExpectError;
import com.oracle.truffle.dsl.processor.Log;
import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.TruffleTypes;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.model.GeneratedElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;

public abstract class MessageContainer
implements Iterable<MessageContainer> {
    private final List<Message> messages = new ArrayList<Message>();
    protected final TruffleTypes types = ProcessorContext.getInstance().getTypes();

    public final void addWarning(String text, Object ... params) {
        this.getMessages().add(new Message(null, null, null, this, String.format(text, params), Diagnostic.Kind.WARNING));
    }

    public final void addWarning(AnnotationValue value, String text, Object ... params) {
        this.getMessages().add(new Message(null, value, null, this, String.format(text, params), Diagnostic.Kind.WARNING));
    }

    public final void addError(String text, Object ... params) {
        this.addError((AnnotationValue)null, text, params);
    }

    public final void addError(Element enclosedElement, String text, Object ... params) {
        this.getMessages().add(new Message(null, null, enclosedElement, this, String.format(text, params), Diagnostic.Kind.ERROR));
    }

    public final void addError(AnnotationValue value, String text, Object ... params) {
        this.getMessages().add(new Message(null, value, null, this, String.format(text, params), Diagnostic.Kind.ERROR));
    }

    public final void addError(AnnotationMirror mirror, AnnotationValue value, String text, Object ... params) {
        this.getMessages().add(new Message(mirror, value, null, this, String.format(text, params), Diagnostic.Kind.ERROR));
    }

    protected List<MessageContainer> findChildContainers() {
        return Collections.emptyList();
    }

    public abstract Element getMessageElement();

    public MessageContainer getBaseContainer() {
        return null;
    }

    @Override
    public Iterator<MessageContainer> iterator() {
        return this.findChildContainers().iterator();
    }

    public final void redirectMessages(MessageContainer to) {
        if (!this.getMessages().isEmpty()) {
            for (Message message : this.getMessages()) {
                Element element = message.getEnclosedElement();
                if (element == null) {
                    element = message.getOriginalContainer().getMessageElement();
                }
                String reference = ElementUtils.getReadableReference(element);
                String prefix = "Message redirected from element " + reference + ":" + System.lineSeparator();
                to.getMessages().add(message.redirect(prefix, to.getMessageElement()));
            }
            this.getMessages().clear();
        }
        for (MessageContainer container : this.findChildContainers()) {
            container.redirectMessages(to);
        }
    }

    public final void redirectMessagesNotEnclosedIn(MessageContainer to) {
        if (!this.getMessages().isEmpty()) {
            Element baseElement = to.getMessageElement();
            ListIterator<Message> messageIterator = this.getMessages().listIterator();
            while (messageIterator.hasNext()) {
                Message message = messageIterator.next();
                if (ElementUtils.isEnclosedIn(baseElement, message.getEnclosedElement())) continue;
                messageIterator.set(message.redirect("", baseElement));
            }
        }
        for (MessageContainer container : this.findChildContainers()) {
            container.redirectMessagesNotEnclosedIn(to);
        }
    }

    public final void redirectMessagesOnGeneratedElements(MessageContainer to) {
        Element messageElement;
        if (!this.getMessages().isEmpty() && ((messageElement = this.getMessageElement()) == null || messageElement instanceof GeneratedElement || messageElement.getEnclosingElement() instanceof GeneratedElement)) {
            for (Message message : this.getMessages()) {
                to.getMessages().add(message.redirect("", to.getMessageElement()));
            }
            this.getMessages().clear();
        }
        for (MessageContainer container : this.findChildContainers()) {
            container.redirectMessagesOnGeneratedElements(to);
        }
    }

    public final void emitMessages(ProcessorContext context, Log log) {
        this.emitMessagesImpl(context, log, new HashSet<MessageContainer>(), null);
    }

    private void emitMessagesImpl(ProcessorContext context, Log log, Set<MessageContainer> visitedSinks, List<Message> verifiedMessages) {
        List<Message> childMessages = verifiedMessages == null ? this.collectMessagesWithElementChildren(new HashSet<MessageContainer>(), this.getMessageElement()) : verifiedMessages;
        if (verifiedMessages != null) {
            this.verifyExpectedMessages(context, log, childMessages);
        }
        for (int i = this.getMessages().size() - 1; i >= 0; --i) {
            this.emitDefault(context, log, this.getMessages().get(i));
        }
        for (MessageContainer sink : this.findChildContainers()) {
            if (visitedSinks.contains(sink)) continue;
            visitedSinks.add(sink);
            if (sink.getMessageElement() == this.getMessageElement()) {
                sink.emitMessagesImpl(context, log, visitedSinks, childMessages);
                continue;
            }
            sink.emitMessagesImpl(context, log, visitedSinks, null);
        }
    }

    private List<Message> collectMessagesWithElementChildren(Set<MessageContainer> visitedSinks, Element e) {
        if (visitedSinks.contains(this)) {
            return Collections.emptyList();
        }
        visitedSinks.add(this);
        ArrayList<Message> foundMessages = new ArrayList<Message>();
        if (this.getMessageElement() != null && ElementUtils.typeEquals(this.getMessageElement().asType(), e.asType())) {
            foundMessages.addAll(this.getMessages());
        }
        for (MessageContainer sink : this.findChildContainers()) {
            foundMessages.addAll(sink.collectMessagesWithElementChildren(visitedSinks, e));
        }
        return foundMessages;
    }

    private void verifyExpectedMessages(ProcessorContext context, Log log, List<Message> msgs) {
        Element element = this.getMessageElement();
        List<String> expectedErrors = ExpectError.getExpectedErrors(context.getEnvironment(), element);
        if (expectedErrors.size() > 0 && expectedErrors.size() != msgs.size()) {
            log.message(Diagnostic.Kind.ERROR, element, null, null, "Error count expected %s but was %s. Expected errors %s but got %s.", expectedErrors.size(), msgs.size(), expectedErrors.toString(), msgs.toString());
        }
    }

    private void emitDefault(ProcessorContext context, Log log, Message message) {
        Diagnostic.Kind kind = message.getKind();
        Element messageElement = this.getMessageElement();
        AnnotationMirror messageAnnotation = this.getMessageAnnotation();
        AnnotationValue messageValue = this.getMessageAnnotationValue();
        if (message.getAnnotationValue() != null) {
            messageValue = message.getAnnotationValue();
        }
        if (message.getAnnotationMirror() != null) {
            messageAnnotation = message.getAnnotationMirror();
        }
        Element enclosedElement = message.getEnclosedElement();
        if (messageElement instanceof GeneratedElement) {
            throw new AssertionError((Object)("Tried to emit message to generated element: " + messageElement + ". Make sure messages are redirected correctly. Message: " + message.getText()));
        }
        String text = message.getText();
        List<String> expectedErrors = ExpectError.getExpectedErrors(context.getEnvironment(), messageElement);
        if (!expectedErrors.isEmpty()) {
            if (ExpectError.isExpectedError(context.getEnvironment(), messageElement, text)) {
                return;
            }
            log.message(kind, messageElement, null, null, "Message expected one of '%s' but was '%s'.", expectedErrors, text);
        } else if (enclosedElement == null) {
            log.message(kind, messageElement, messageAnnotation, messageValue, text, new Object[0]);
        } else {
            log.message(kind, enclosedElement, null, null, text, new Object[0]);
        }
    }

    public AnnotationMirror getMessageAnnotation() {
        return null;
    }

    public AnnotationValue getMessageAnnotationValue() {
        return null;
    }

    public final boolean hasErrors() {
        return this.hasErrorsImpl(new HashSet<MessageContainer>(), false);
    }

    public final boolean hasErrorsOrWarnings() {
        return this.hasErrorsImpl(new HashSet<MessageContainer>(), true);
    }

    public final List<Message> collectMessages() {
        ArrayList<Message> collectedMessages = new ArrayList<Message>();
        this.collectMessagesImpl(collectedMessages, new HashSet<MessageContainer>());
        return collectedMessages;
    }

    private void collectMessagesImpl(List<Message> collectedMessages, Set<MessageContainer> visitedSinks) {
        collectedMessages.addAll(this.getMessages());
        for (MessageContainer sink : this.findChildContainers()) {
            if (visitedSinks.contains(sink)) {
                return;
            }
            visitedSinks.add(sink);
            sink.collectMessagesImpl(collectedMessages, visitedSinks);
        }
    }

    private boolean hasErrorsImpl(Set<MessageContainer> visitedSinks, boolean orWarnings) {
        for (Message msg : this.getMessages()) {
            if (msg.getKind() != Diagnostic.Kind.ERROR && (!orWarnings || msg.getKind() != Diagnostic.Kind.WARNING)) continue;
            return true;
        }
        for (MessageContainer sink : this.findChildContainers()) {
            if (visitedSinks.contains(sink)) continue;
            visitedSinks.add(sink);
            if (!sink.hasErrorsImpl(visitedSinks, orWarnings)) continue;
            return true;
        }
        return false;
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    public static final class Message {
        private final MessageContainer originalContainer;
        private final Element enclosedElement;
        private final AnnotationMirror annotationMirror;
        private final AnnotationValue annotationValue;
        private final String text;
        private final Diagnostic.Kind kind;

        public Message(AnnotationMirror annotationMirror, AnnotationValue annotationValue, Element enclosedElement, MessageContainer originalContainer, String text, Diagnostic.Kind kind) {
            this.annotationMirror = annotationMirror;
            this.annotationValue = annotationValue;
            this.enclosedElement = enclosedElement;
            this.originalContainer = originalContainer;
            this.text = text;
            this.kind = kind;
        }

        public Message redirect(String textPrefix, Element element) {
            return new Message(null, null, element, this.originalContainer, textPrefix + this.text, this.kind);
        }

        public Element getEnclosedElement() {
            return this.enclosedElement;
        }

        public AnnotationMirror getAnnotationMirror() {
            return this.annotationMirror;
        }

        public AnnotationValue getAnnotationValue() {
            return this.annotationValue;
        }

        public MessageContainer getOriginalContainer() {
            return this.originalContainer;
        }

        public String getText() {
            return this.text;
        }

        public Diagnostic.Kind getKind() {
            return this.kind;
        }

        public String toString() {
            return (Object)((Object)this.kind) + ": " + this.text;
        }
    }
}

