/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.library;

import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.generator.GeneratorUtils;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.compiler.CompilerFactory;
import com.oracle.truffle.dsl.processor.java.model.CodeAnnotationMirror;
import com.oracle.truffle.dsl.processor.java.model.CodeAnnotationValue;
import com.oracle.truffle.dsl.processor.java.model.CodeExecutableElement;
import com.oracle.truffle.dsl.processor.java.model.CodeNames;
import com.oracle.truffle.dsl.processor.java.model.CodeTypeElement;
import com.oracle.truffle.dsl.processor.java.model.CodeVariableElement;
import com.oracle.truffle.dsl.processor.library.ExportMessageData;
import com.oracle.truffle.dsl.processor.library.ExportsData;
import com.oracle.truffle.dsl.processor.library.ExportsLibrary;
import com.oracle.truffle.dsl.processor.library.LibraryData;
import com.oracle.truffle.dsl.processor.library.LibraryMessage;
import com.oracle.truffle.dsl.processor.library.LibraryParser;
import com.oracle.truffle.dsl.processor.model.NodeData;
import com.oracle.truffle.dsl.processor.parser.AbstractParser;
import com.oracle.truffle.dsl.processor.parser.NodeParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

public class ExportsParser
extends AbstractParser<ExportsData> {
    public static final String EXECUTE_PREFIX = "execute";
    public static final String EXECUTE_SUFFIX = "_";
    public final List<DeclaredType> annotations;
    final Map<String, NodeData> parsedNodeCache;

    public ExportsParser() {
        this.annotations = Arrays.asList(this.types.ExportMessage, this.types.ExportLibrary);
        this.parsedNodeCache = new HashMap<String, NodeData>();
    }

    @Override
    public boolean isDelegateToRootDeclaredType() {
        return false;
    }

    @Override
    protected ExportsData parse(Element element, List<AnnotationMirror> elementMirrors) {
        Element member;
        TypeElement type = (TypeElement)element;
        ExportsData model = this.parseExports(type, elementMirrors);
        if (model.hasErrors()) {
            return model;
        }
        this.parsedNodeCache.clear();
        PackageElement packageElement = ElementUtils.findPackageElement(type);
        List<Element> members = this.loadMembers(type);
        LinkedHashMap potentiallyMissedOverrides = new LinkedHashMap();
        TypeElement currentType = ElementUtils.getSuperType(type);
        while (currentType != null) {
            List<AnnotationMirror> exportedLibraries = ElementUtils.getRepeatedAnnotation(currentType.getAnnotationMirrors(), this.types.ExportLibrary);
            if (!exportedLibraries.isEmpty()) {
                Iterator<Element> foundInvisibleMembers = new ArrayList();
                List<Element> superTypeMembers = this.loadMembers(currentType);
                for (Element element2 : superTypeMembers) {
                    List<AnnotationMirror> exportedMessages = ElementUtils.getRepeatedAnnotation(element2.getAnnotationMirrors(), this.types.ExportMessage);
                    if (exportedMessages.isEmpty()) continue;
                    if (!ElementUtils.isVisible(packageElement, element2)) {
                        foundInvisibleMembers.add(element2);
                        continue;
                    }
                    if (!element2.getKind().isClass()) continue;
                    for (Element element3 : this.loadMembers((TypeElement)element2)) {
                        if (ElementUtils.findAnnotationMirror(element3, (TypeMirror)this.types.Specialization) == null || ElementUtils.isVisible(packageElement, element3)) continue;
                        foundInvisibleMembers.add(element3);
                    }
                }
                if (!foundInvisibleMembers.isEmpty()) {
                    StringBuilder b = new StringBuilder();
                    Iterator iterator = foundInvisibleMembers.iterator();
                    while (iterator.hasNext()) {
                        Element invisibleMember = (Element)iterator.next();
                        b.append(System.lineSeparator()).append("   - ");
                        b.append(ElementUtils.getReadableReference(invisibleMember, false));
                    }
                    model.addError("Found invisible exported elements in super type '%s': %s%nIncrease their visibility to resolve this problem.", ElementUtils.getSimpleName(currentType), b.toString());
                }
            }
            currentType = ElementUtils.getSuperType(currentType);
        }
        ArrayList<ExportMessageData> exportedElements = new ArrayList<ExportMessageData>();
        for (Element member2 : members) {
            List<AnnotationMirror> exportedMessageMirrors = ElementUtils.getRepeatedAnnotation(member2.getAnnotationMirrors(), this.types.ExportMessage);
            if (exportedMessageMirrors.isEmpty()) {
                boolean bl = ExportsParser.isMethodElement(member2);
                boolean isNode = ExportsParser.isNodeElement(member2);
                String name = null;
                if (bl) {
                    name = member2.getSimpleName().toString();
                } else if (isNode) {
                    name = ExportsParser.inferNodeMessageName((TypeElement)member2);
                }
                if (!bl && !isNode) continue;
                Element element4 = member2.getEnclosingElement();
                if (!ElementUtils.elementEquals(model.getTemplateType(), element4)) continue;
                potentiallyMissedOverrides.computeIfAbsent(name, n -> new ArrayList()).add(member2);
                continue;
            }
            for (AnnotationMirror exportMessage : exportedMessageMirrors) {
                exportedElements.addAll(this.parseExportedMessage(model, member2, exportMessage));
            }
        }
        for (ExportMessageData exportedMessage : exportedElements) {
            member = exportedMessage.getMessageElement();
            String string = exportedMessage.getResolvedMessage().getName();
            Map<String, ExportMessageData> exportedMessages = exportedMessage.getExportsLibrary().getExportedMessages();
            ExportMessageData existing = exportedMessages.get(string);
            if (existing != null) {
                Element currentEnclosingElement;
                Element element5 = existing.getMessageElement().getEnclosingElement();
                if (ElementUtils.elementEquals(element5, currentEnclosingElement = exportedMessage.getMessageElement().getEnclosingElement())) {
                    String error = String.format("Duplicate exported library message %s.", string);
                    model.addError(member, error, new Object[0]);
                    model.addError(existing.getMessageElement(), error, new Object[0]);
                    continue;
                }
                if (!ElementUtils.isSubtype(currentEnclosingElement.asType(), element5.asType())) continue;
                exportedMessages.put(string, exportedMessage);
                continue;
            }
            exportedMessages.put(string, exportedMessage);
        }
        for (ExportMessageData exportedElement : exportedElements) {
            member = exportedElement.getMessageElement();
            if (ExportsParser.isMethodElement(member)) {
                this.initializeExportedMethod(model, exportedElement);
                continue;
            }
            if (ExportsParser.isNodeElement(member)) {
                this.initializeExportedNode(exportedElement);
                continue;
            }
            throw new AssertionError((Object)"should not be reachable");
        }
        TypeMirror receiverClass = null;
        for (Map.Entry<String, ExportsLibrary> entry : model.getExportedLibraries().entrySet()) {
            ExportsLibrary exportsLibrary = entry.getValue();
            if (exportsLibrary.hasErrors()) continue;
            if (receiverClass == null) {
                receiverClass = exportsLibrary.getReceiverType();
            } else if (!ElementUtils.typeEquals(exportsLibrary.getReceiverType(), receiverClass)) {
                exportsLibrary.addError("All receiver classes must match for a declared java type. Found '%s' and '%s'.", ElementUtils.getSimpleName(receiverClass), ElementUtils.getSimpleName(exportsLibrary.getReceiverType()));
                continue;
            }
            LinkedHashSet<LibraryMessage> missingAbstractMessage = new LinkedHashSet<LibraryMessage>();
            for (LibraryMessage libraryMessage : exportsLibrary.getLibrary().getMethods()) {
                boolean isAbstract;
                ExportMessageData exportMessage;
                List elementsWithSameName = potentiallyMissedOverrides.getOrDefault(libraryMessage.getName(), Collections.emptyList());
                if (!elementsWithSameName.isEmpty()) {
                    for (Element overridingElement : elementsWithSameName) {
                        if (ElementUtils.findAnnotationMirror(overridingElement, (TypeMirror)this.types.ExportMessage_Ignore) != null) continue;
                        exportsLibrary.addError(overridingElement, "The method has the same name '%s' as a message in the exported library %s. Did you forget to export it? Use @%s to export the message, @%s to ignore this warning, rename the method or reduce the visibility of the method to private to resolve this warning.", overridingElement.getSimpleName().toString(), ElementUtils.getSimpleName(exportsLibrary.getLibrary().getTemplateType()), this.types.ExportMessage.asElement().getSimpleName().toString(), this.types.ExportMessage_Ignore.asElement().getSimpleName().toString());
                    }
                }
                if (!libraryMessage.isAbstract() || libraryMessage.getName().equals("accepts") || (exportMessage = exportsLibrary.getExportedMessages().get(libraryMessage.getName())) != null && exportMessage.getResolvedMessage() == libraryMessage) continue;
                if (!libraryMessage.getAbstractIfExported().isEmpty()) {
                    isAbstract = false;
                    for (LibraryMessage abstractIfExported : libraryMessage.getAbstractIfExported()) {
                        if (!exportsLibrary.getExportedMessages().containsKey(abstractIfExported.getName())) continue;
                        isAbstract = true;
                        break;
                    }
                } else {
                    isAbstract = true;
                }
                if (!isAbstract) continue;
                missingAbstractMessage.add(libraryMessage);
            }
            if (missingAbstractMessage.isEmpty()) continue;
            StringBuilder msg = new StringBuilder(String.format("The following message(s) of library %s are abstract and must be exported using:%n", ElementUtils.getSimpleName(exportsLibrary.getLibrary().getTemplateType())));
            for (LibraryMessage message3 : missingAbstractMessage) {
                msg.append("  ").append(ExportsParser.generateExpectedSignature(type, message3, exportsLibrary.getExplicitReceiver())).append(" {");
                if (!ElementUtils.isVoid(message3.getExecutable().getReturnType())) {
                    msg.append(" return ").append(ElementUtils.defaultValue(message3.getExecutable().getReturnType()));
                    msg.append(";");
                }
                msg.append(" }%n");
            }
            exportsLibrary.addError(msg.toString(), new Object[0]);
        }
        for (ExportsLibrary libraryExports : model.getExportedLibraries().values()) {
            ArrayList<NodeData> arrayList = new ArrayList<NodeData>();
            ArrayList<ExportMessageData> exportedMessages = new ArrayList<ExportMessageData>();
            for (ExportMessageData exportMessageData : libraryExports.getExportedMessages().values()) {
                if (exportMessageData.getSpecializedNode() == null) continue;
                arrayList.add(exportMessageData.getSpecializedNode());
                exportedMessages.add(exportMessageData);
            }
            libraryExports.setSharedExpressions(NodeParser.computeSharing(arrayList, true));
            for (int i = 0; i < arrayList.size(); ++i) {
                NodeData nodeData = (NodeData)arrayList.get(i);
                ExportMessageData exportedMessage = (ExportMessageData)exportedMessages.get(i);
                if (nodeData.hasErrorsOrWarnings()) {
                    nodeData.redirectMessagesOnGeneratedElements(exportedMessage);
                }
                nodeData.setGenerateUncached(false);
            }
        }
        for (ExportMessageData message : exportedElements) {
            if (ElementUtils.elementEquals(message.getMessageElement().getEnclosingElement(), model.getTemplateType())) continue;
            message.redirectMessages(message.getExportsLibrary());
        }
        return model;
    }

    private List<Element> loadMembers(TypeElement templateType) {
        ArrayList<Element> elements = new ArrayList<Element>(CompilerFactory.getCompiler(templateType).getAllMembersInDeclarationOrder(this.context.getEnvironment(), templateType));
        Iterator elementIterator = elements.iterator();
        while (elementIterator.hasNext()) {
            Element element = (Element)elementIterator.next();
            if (ElementUtils.typeEquals(element.getEnclosingElement().asType(), this.types.Node)) {
                elementIterator.remove();
                continue;
            }
            if (ElementUtils.typeEquals(element.getEnclosingElement().asType(), this.context.getType(Object.class))) {
                elementIterator.remove();
                continue;
            }
            if (ElementUtils.typeEquals(templateType.asType(), element.getEnclosingElement().asType()) || ElementUtils.isVisible(templateType, element)) continue;
            elementIterator.remove();
        }
        return elements;
    }

    private ExportsData parseExports(TypeElement type, List<AnnotationMirror> elementMirrors) {
        ExportsData model = new ExportsData(this.context, type, null);
        if (type.getKind().isInterface()) {
            model.addError("@%s is not supported for interfaces at the moment.", this.types.ExportLibrary.asElement().getSimpleName().toString());
            return model;
        }
        if (ElementUtils.getVisibility(type.getModifiers()) == Modifier.PRIVATE) {
            model.addError("The exported type must not be private. Increase visibility to resolve this.", new Object[0]);
            return model;
        }
        ArrayList<AnnotationMirror> mirrors = new ArrayList<AnnotationMirror>(elementMirrors);
        TypeElement superType = type;
        while ((superType = ElementUtils.getSuperType(superType)) != null) {
            mirrors.addAll(ElementUtils.getRepeatedAnnotation(superType.getAnnotationMirrors(), this.types.ExportLibrary));
        }
        LinkedHashMap<String, AnnotationMirror> mappedMirrors = new LinkedHashMap<String, AnnotationMirror>();
        for (AnnotationMirror annotationMirror : mirrors) {
            TypeMirror library = ElementUtils.getAnnotationValue(TypeMirror.class, annotationMirror, "value");
            mappedMirrors.putIfAbsent(ElementUtils.getTypeId(library), annotationMirror);
        }
        for (Map.Entry entry : mappedMirrors.entrySet()) {
            boolean explicitReceiver;
            AnnotationMirror exportAnnotationMirror = (AnnotationMirror)entry.getValue();
            String libraryId = (String)entry.getKey();
            TypeMirror libraryMirror = ElementUtils.getAnnotationValue(TypeMirror.class, exportAnnotationMirror, "value");
            AnnotationValue receiverClassValue = ElementUtils.getAnnotationValue(exportAnnotationMirror, "receiverType");
            TypeMirror receiverClass = ElementUtils.getAnnotationValue(TypeMirror.class, exportAnnotationMirror, "receiverType", false);
            if (receiverClass == null) {
                explicitReceiver = false;
                receiverClass = type.asType();
            } else {
                explicitReceiver = true;
            }
            LibraryParser parser = new LibraryParser();
            LibraryData libraryData = (LibraryData)parser.parse(ElementUtils.fromTypeMirror(libraryMirror));
            ExportsLibrary lib = new ExportsLibrary(this.context, type, exportAnnotationMirror, model, libraryData, receiverClass, explicitReceiver);
            ExportsLibrary otherLib = model.getExportedLibraries().get(libraryId);
            model.getExportedLibraries().put(libraryId, lib);
            if (ElementUtils.isPrimitive(receiverClass)) {
                lib.addError(exportAnnotationMirror, receiverClassValue, "Primitive receiver types are not supported yet.", new Object[0]);
                continue;
            }
            if (explicitReceiver) {
                boolean foundInvalidExportsOnReceiver = false;
                superType = ElementUtils.castTypeElement(receiverClass);
                block3: while ((superType = ElementUtils.getSuperType(superType)) != null) {
                    List<AnnotationMirror> exports = ElementUtils.getRepeatedAnnotation(superType.getAnnotationMirrors(), this.types.ExportLibrary);
                    for (AnnotationMirror export : exports) {
                        TypeMirror exportedLibrary = ElementUtils.getAnnotationValue(TypeMirror.class, export, "value");
                        if (ElementUtils.typeEquals(exportedLibrary, this.types.DynamicDispatchLibrary)) continue;
                        foundInvalidExportsOnReceiver = true;
                        continue block3;
                    }
                }
                if (foundInvalidExportsOnReceiver) {
                    lib.addError(exportAnnotationMirror, receiverClassValue, "An explicit receiver type must not export any libraries other than %s.", this.types.DynamicDispatchLibrary.asElement().getSimpleName().toString());
                    continue;
                }
            }
            if (libraryData == null) {
                lib.addError("Class '%s' is not a library annotated with @%s.", ElementUtils.getSimpleName(libraryMirror), this.types.GenerateLibrary.asElement().getSimpleName().toString());
                continue;
            }
            if (libraryData.hasErrors()) {
                lib.addError("Library specification %s has errors. Please resolve them first.", ElementUtils.getSimpleName(libraryMirror));
                continue;
            }
            if (otherLib != null) {
                String message = String.format("Duplicate library specified %s.", ElementUtils.getSimpleName(libraryMirror));
                otherLib.addError(message, new Object[0]);
                lib.addError(message, new Object[0]);
                continue;
            }
            if (explicitReceiver) {
                if (!ElementUtils.isSubtype(receiverClass, libraryData.getSignatureReceiverType())) {
                    lib.addError(exportAnnotationMirror, receiverClassValue, "The export receiver type %s is not compatible with the library receiver type '%s' of library '%s'. ", ElementUtils.getSimpleName(receiverClass), ElementUtils.getSimpleName(libraryData.getSignatureReceiverType()), ElementUtils.getSimpleName(libraryData.getTemplateType().asType()));
                }
            } else if (!ElementUtils.isSubtype(type.asType(), libraryData.getExportsReceiverType())) {
                lib.addError("Type %s is not compatible with the receiver type '%s' of exported library '%s'. Inhert from type '%s' to resolve this.", ElementUtils.getSimpleName(type.asType()), ElementUtils.getSimpleName(libraryData.getExportsReceiverType()), ElementUtils.getSimpleName(libraryData.getTemplateType().asType()), ElementUtils.getSimpleName(libraryData.getExportsReceiverType()));
            }
            for (LibraryMessage message : libraryData.getMethods()) {
                model.getLibraryMessages().computeIfAbsent(message.getName(), n -> new ArrayList()).add(message);
            }
        }
        for (ExportsLibrary exportsLibrary : model.getExportedLibraries().values()) {
            if (exportsLibrary.hasErrors()) continue;
            boolean explicitReceiver = exportsLibrary.isExplicitReceiver();
            if (exportsLibrary.getLibrary().isDynamicDispatch() && model.getExportedLibraries().size() > 1) {
                exportsLibrary.addError("@%s cannot be used for other libraries if the %s library is exported. Using dynamic dispatch and other libraries is mutually exclusive. To resolve this use the dynamic dispatch mechanism of the receiver type instead to export libraries.", this.types.ExportLibrary.asElement().getSimpleName().toString(), this.types.DynamicDispatchLibrary.asElement().getSimpleName().toString());
                continue;
            }
            if (!explicitReceiver || exportsLibrary.isDynamicDispatchTarget() || exportsLibrary.isDefaultExport()) continue;
            exportsLibrary.addError(exportsLibrary.getTemplateTypeAnnotation(), ElementUtils.getAnnotationValue(exportsLibrary.getTemplateTypeAnnotation(), "receiverType"), "Using explicit receiver types is only supported for default exports or types that export %s.%nTo resolve this use one of the following strategies:%n  - Make the receiver type implicit by applying '@%s(%s.class)' to the receiver type '%s' instead.%n  - Declare a default export on the '%s' library with '@%s(%s.class)'%n  - Enable dynamic dispatch by annotating the receiver type with '@%s(%s.class)'.", this.types.DynamicDispatchLibrary.asElement().getSimpleName().toString(), this.types.ExportLibrary.asElement().getSimpleName().toString(), exportsLibrary.getLibrary().getTemplateType().getSimpleName().toString(), ElementUtils.getSimpleName(exportsLibrary.getExplicitReceiver()), exportsLibrary.getLibrary().getTemplateType().getSimpleName().toString(), this.types.GenerateLibrary_DefaultExport.asElement().getSimpleName().toString(), ElementUtils.getSimpleName(exportsLibrary.getTemplateType().asType()), this.types.ExportLibrary.asElement().getSimpleName().toString(), this.types.DynamicDispatchLibrary.asElement().getSimpleName().toString());
        }
        return model;
    }

    private List<ExportMessageData> parseExportedMessage(ExportsData model, Element member, AnnotationMirror exportAnnotation) throws AssertionError {
        ArrayList<ExportMessageData> exportMessages;
        block25: {
            Iterator iterator;
            AnnotationValue nameValue = ElementUtils.getAnnotationValue(exportAnnotation, "name", false);
            String name = ElementUtils.getAnnotationValue(String.class, exportAnnotation, "name");
            String error = null;
            AnnotationValue errorValue = null;
            if (nameValue == null) {
                if (ExportsParser.isMethodElement(member)) {
                    name = member.getSimpleName().toString();
                } else if (ExportsParser.isNodeElement(member)) {
                    TypeElement type = (TypeElement)member;
                    name = ExportsParser.inferNodeMessageName(type);
                } else {
                    error = "Unsupported exported element.";
                }
            }
            AnnotationValue libraryValue = ElementUtils.getAnnotationValue(exportAnnotation, "library", false);
            TypeMirror library = ElementUtils.getAnnotationValue(TypeMirror.class, exportAnnotation, "library");
            if (libraryValue == null) {
                List<LibraryMessage> messages = model.getLibraryMessages().get(name);
                if (messages == null || messages.size() == 0) {
                    if (model.getExportedLibraries().isEmpty()) {
                        error = String.format("No libraries exported. Use @%s(MyLibrary.class) on the enclosing type to export libraries.", this.types.ExportLibrary.asElement().getSimpleName().toString());
                    } else {
                        StringBuilder libBuilder = new StringBuilder();
                        String sep = "";
                        for (ExportsLibrary lib : model.getExportedLibraries().values()) {
                            libBuilder.append(sep);
                            libBuilder.append(ElementUtils.getSimpleName(lib.getLibrary().getTemplateType().asType()));
                            sep = ", ";
                        }
                        error = model.getExportedLibraries().size() <= 1 ? String.format("No message '%s' found for library %s.", name, libBuilder) : String.format("No message '%s' found for libraries %s.", name, libBuilder);
                        List<String> fuzzyMatches = ExportsParser.fuzzyMatch(model.getLibraryMessages().keySet(), name, 0.7f);
                        if (fuzzyMatches.isEmpty()) {
                            fuzzyMatches = ExportsParser.fuzzyMatch(model.getLibraryMessages().keySet(), name, 0.5f);
                        }
                        if (!fuzzyMatches.isEmpty()) {
                            StringBuilder appendix = new StringBuilder(" Did you mean ");
                            sep = "";
                            for (String string : fuzzyMatches) {
                                appendix.append(sep);
                                appendix.append('\'').append(string).append('\'');
                                sep = ", ";
                            }
                            error = error + appendix.toString() + "?";
                        }
                        errorValue = nameValue;
                    }
                    model.addError(member, error, new Object[0]);
                    return Collections.emptyList();
                }
                if (messages.size() > 1) {
                    Object prevMessage = null;
                    boolean signatureMatches = true;
                    for (LibraryMessage message : messages) {
                        if (prevMessage != null && !ElementUtils.signatureEquals(((LibraryMessage)prevMessage).getExecutable(), message.getExecutable())) {
                            signatureMatches = false;
                            break;
                        }
                        prevMessage = message;
                    }
                    if (!signatureMatches) {
                        StringBuilder libBuilder = new StringBuilder();
                        String sep = "";
                        for (LibraryMessage ambiguousMessage : messages) {
                            libBuilder.append(sep);
                            libBuilder.append(ElementUtils.getSimpleName(ambiguousMessage.getLibrary().getTemplateType().asType()));
                            sep = " and ";
                        }
                        error = String.format("The message name '%s' is ambiguous for libraries %s. Disambiguate the library by specifying the library explicitely using @%s(library=Library.class).", name, libBuilder.toString(), this.types.ExportMessage.asElement().getSimpleName().toString());
                        model.addError(member, error, new Object[0]);
                        return Collections.emptyList();
                    }
                }
                exportMessages = new ArrayList<ExportMessageData>(messages.size());
                for (LibraryMessage message : messages) {
                    ExportsLibrary exportsLibrary = model.getExportedLibraries().get(ElementUtils.getTypeId(((TypeElement)message.getLibrary().getMessageElement()).asType()));
                    exportMessages.add(new ExportMessageData(exportsLibrary, message, member, exportAnnotation));
                }
            } else {
                ExportsLibrary exportsLibrary = model.getExportedLibraries().get(ElementUtils.getTypeId(library));
                if (exportsLibrary == null) {
                    AnnotationMirror mirror = ElementUtils.findAnnotationMirror(library.getAnnotationMirrors(), (TypeMirror)this.types.GenerateLibrary);
                    String qualifiedName = ElementUtils.getQualifiedName(library);
                    error = mirror == null ? String.format("Class '%s' is not a library annotated with @%s.", qualifiedName, this.types.GenerateLibrary.asElement().getSimpleName().toString()) : String.format("Explicitely specified library '%s' also needs to be exported on the class using @%s(%s.class).", qualifiedName, this.types.ExportLibrary.asElement().getSimpleName().toString(), ElementUtils.getSimpleName(library));
                    model.addError(member, error, new Object[0]);
                    return Collections.emptyList();
                }
                List<LibraryMessage> searchMessages = model.getLibraryMessages().get(name);
                LibraryMessage message = null;
                if (searchMessages != null) {
                    for (LibraryMessage searchMessage : searchMessages) {
                        if (searchMessage.getLibrary() != exportsLibrary.getLibrary()) continue;
                        message = searchMessage;
                        break;
                    }
                }
                if (message == null) {
                    StringBuilder libBuilder = new StringBuilder();
                    String sep = "";
                    for (ExportsLibrary lib : model.getExportedLibraries().values()) {
                        libBuilder.append(sep);
                        libBuilder.append(ElementUtils.getSimpleName(lib.getLibrary().getTemplateType().asType()));
                        sep = ", ";
                    }
                    error = String.format("No message '%s' found for library %s.", name, ElementUtils.getSimpleName(exportsLibrary.getLibrary().getTemplateType().asType()));
                    errorValue = nameValue;
                }
                exportMessages = new ArrayList(1);
                exportMessages.add(new ExportMessageData(exportsLibrary, message, member, exportAnnotation));
            }
            if (error == null || !(iterator = exportMessages.iterator()).hasNext()) break block25;
            ExportMessageData export = (ExportMessageData)iterator.next();
            export.addError(errorValue, error, new Object[0]);
        }
        return exportMessages;
    }

    private void initializeExportedNode(ExportMessageData exportElement) {
        TypeElement exportedTypeElement = (TypeElement)exportElement.getMessageElement();
        if (exportedTypeElement.getModifiers().contains((Object)Modifier.PRIVATE)) {
            exportElement.addError("Exported message node class must not be private.", new Object[0]);
            return;
        }
        if (!exportedTypeElement.getModifiers().contains((Object)Modifier.STATIC)) {
            exportElement.addError("Inner message node class must be static.", new Object[0]);
            return;
        }
        List<Element> typeMembers = this.loadMembers(exportedTypeElement);
        boolean hasSpecialization = false;
        boolean hasExecute = false;
        for (ExecutableElement method : ElementFilter.methodsIn(typeMembers)) {
            Set<Modifier> modifiers;
            if (!hasSpecialization && ElementUtils.findAnnotationMirror((Element)method, (TypeMirror)this.types.Specialization) != null) {
                hasSpecialization = true;
            }
            if ((modifiers = method.getModifiers()).contains((Object)Modifier.PRIVATE) || modifiers.contains((Object)Modifier.STATIC) || !method.getSimpleName().toString().startsWith(EXECUTE_PREFIX)) continue;
            exportElement.addError(method, "An @%s annotated class must not declare any visible methods starting with 'execute'. Use @%s annotated methods instead.", this.types.ExportMessage.asElement().getSimpleName().toString(), this.types.Specialization.asElement().getSimpleName().toString());
            return;
        }
        if (!ElementUtils.typeEquals(exportedTypeElement.getSuperclass(), this.context.getType(Object.class))) {
            exportElement.addError("An @%s annotated class must extend Object. Other base classes are not supported.", this.types.ExportMessage.asElement().getSimpleName().toString(), this.types.Node.asElement().getSimpleName().toString());
            return;
        }
        if (!hasSpecialization) {
            ExecutableElement signature = exportElement.getResolvedMessage().getExecutable();
            StringBuilder fix = new StringBuilder();
            fix.append("@").append(this.types.Specialization.asElement().getSimpleName().toString()).append(" ");
            fix.append("static ");
            fix.append(ElementUtils.getSimpleName(signature.getReturnType()));
            fix.append(" ").append("doDefault(");
            String sep = "";
            for (VariableElement variableElement : signature.getParameters()) {
                fix.append(sep);
                TypeMirror type = sep.length() == 0 ? exportElement.getExportsLibrary().getReceiverType() : variableElement.asType();
                fix.append(ElementUtils.getSimpleName(type));
                fix.append(" ");
                fix.append(variableElement.getSimpleName().toString());
                sep = ", ";
            }
            fix.append(") { ");
            if (!ElementUtils.isVoid(signature.getReturnType())) {
                fix.append("return ").append(ElementUtils.defaultValue(signature.getReturnType())).append("; ");
            }
            fix.append("}");
            exportElement.addError("An @%s annotated class must have at least one method with @%s annotation. Add the following method to resolve this:%n     %s", this.types.ExportMessage.asElement().getSimpleName().toString(), this.types.Specialization.asElement().getSimpleName().toString(), fix.toString());
            return;
        }
        if (hasExecute) {
            exportElement.addError("An @%s annotated class must not declary any visible methods starting with 'execute'.", this.types.ExportMessage.asElement().getSimpleName().toString());
            return;
        }
        if (exportElement.hasErrors()) {
            return;
        }
        NodeData parsedNodeData = this.parseNode(exportedTypeElement, exportElement, typeMembers);
        if (parsedNodeData == null) {
            exportElement.addError("Could not parse invalid node.", new Object[0]);
            return;
        }
        parsedNodeData.getNodeId();
        parsedNodeData.setGenerateUncached(false);
        exportElement.setSpecializedNode(parsedNodeData);
    }

    private void initializeExportedMethod(ExportsData model, ExportMessageData exportedElement) {
        ExecutableElement exportedMethod = (ExecutableElement)exportedElement.getMessageElement();
        LibraryMessage message = exportedElement.getResolvedMessage();
        ExportsLibrary exportsLibrary = exportedElement.getExportsLibrary();
        if (ElementUtils.getVisibility(exportedMethod.getModifiers()) == Modifier.PRIVATE) {
            exportedElement.addError("The exported method must not be private. Increase visibility to resolve this.", new Object[0]);
            return;
        }
        List<TypeMirror> cachedAnnotations = NodeParser.getCachedAnnotations();
        ArrayList<VariableElement> cachedNodes = new ArrayList<VariableElement>();
        ArrayList<VariableElement> cachedLibraries = new ArrayList<VariableElement>();
        int realParameterCount = 0;
        block0: for (VariableElement variableElement : exportedMethod.getParameters()) {
            AnnotationMirror cachedMirror = null;
            for (TypeMirror cachedAnnotation : cachedAnnotations) {
                AnnotationMirror found = ElementUtils.findAnnotationMirror(variableElement.getAnnotationMirrors(), cachedAnnotation);
                if (found == null) continue;
                if (cachedMirror == null) {
                    cachedMirror = found;
                    continue;
                }
                StringBuilder b = new StringBuilder();
                String sep = "";
                for (TypeMirror stringCachedAnnotation : cachedAnnotations) {
                    b.append(sep);
                    b.append("@");
                    b.append(ElementUtils.getSimpleName(stringCachedAnnotation));
                    sep = ", ";
                }
                exportedElement.addError(variableElement, "The following annotations are mutually exclusive for a parameter: %s.", b.toString());
                continue block0;
            }
            AnnotationMirror cachedLibraryMirror = ElementUtils.findAnnotationMirror(variableElement.getAnnotationMirrors(), (TypeMirror)this.types.CachedLibrary);
            if (cachedLibraryMirror != null) {
                cachedLibraries.add(variableElement);
                continue;
            }
            if (cachedMirror != null) {
                cachedNodes.add(variableElement);
                continue;
            }
            ++realParameterCount;
        }
        ExportsParser.verifyMethodSignature(model.getTemplateType(), message, exportedElement, exportedMethod, exportsLibrary.getReceiverType(), realParameterCount, true);
        if (exportedElement.hasErrors()) {
            return;
        }
        if (!cachedNodes.isEmpty() || !cachedLibraries.isEmpty()) {
            String nodeName = ElementUtils.firstLetterUpperCase(exportedMethod.getSimpleName().toString()) + "Node_";
            CodeTypeElement codeTypeElement = GeneratorUtils.createClass(model, null, ElementUtils.modifiers(Modifier.PUBLIC, Modifier.STATIC), nodeName, this.types.Node);
            AnnotationMirror importStatic = ElementUtils.findAnnotationMirror(model.getMessageElement(), (TypeMirror)this.types.ImportStatic);
            if (importStatic != null) {
                codeTypeElement.getAnnotationMirrors().add(importStatic);
            }
            codeTypeElement.getAnnotationMirrors().add(exportedElement.getMessageAnnotation());
            CodeExecutableElement element = CodeExecutableElement.clone(exportedMethod);
            element.getParameters().clear();
            element.getParameters().addAll(exportedMethod.getParameters());
            DeclaredType specializationType = this.types.Specialization;
            CodeAnnotationMirror specialization = new CodeAnnotationMirror(specializationType);
            specialization.setElementValue(ElementUtils.findExecutableElement(specializationType, "limit"), ElementUtils.getAnnotationValue(exportedElement.getMessageAnnotation(), "limit", false));
            element.getAnnotationMirrors().clear();
            element.addAnnotationMirror(specialization);
            boolean isStatic = element.getModifiers().contains((Object)Modifier.STATIC);
            if (!isStatic) {
                element.getParameters().add(0, new CodeVariableElement(exportedElement.getReceiverType(), "this"));
                element.getModifiers().add(Modifier.STATIC);
            }
            codeTypeElement.add(element);
            NodeData parsedNodeData = this.parseNode(codeTypeElement, exportedElement, Collections.emptyList());
            element.setEnclosingElement(exportedMethod.getEnclosingElement());
            if (parsedNodeData == null) {
                exportedElement.addError("Error could not parse synthetic node: %s", element);
            }
            exportedElement.setSpecializedNode(parsedNodeData);
        }
        if (exportsLibrary.isExplicitReceiver() && !exportedMethod.getModifiers().contains((Object)Modifier.STATIC)) {
            exportedElement.addError("Exported method must be static. @%s annotated types with explcit receiverClass must only contain static methods.", this.types.ExportLibrary.asElement().getSimpleName().toString());
        }
    }

    private NodeData parseNode(TypeElement nodeType, ExportMessageData exportedMessage, List<Element> members) {
        String nodeTypeId = ElementUtils.getTypeId(nodeType.asType());
        NodeData cachedData = this.parsedNodeCache.get(nodeTypeId);
        if (cachedData != null) {
            return cachedData;
        }
        for (ExecutableElement method : ElementFilter.methodsIn(members)) {
            if (method.getModifiers().contains((Object)Modifier.PRIVATE) || method.getModifiers().contains((Object)Modifier.STATIC) || !method.getSimpleName().toString().startsWith(EXECUTE_PREFIX)) continue;
            exportedMessage.addError(method, "A class annotated with with @%s must not specify methods starting with execute. Execute methods for such classes can be inferred automatically from the message signature.", this.types.ExportMessage.asElement().getSimpleName().toString());
        }
        if (exportedMessage.hasErrors()) {
            return null;
        }
        LibraryMessage message = exportedMessage.getResolvedMessage();
        CodeExecutableElement syntheticExecute = null;
        CodeTypeElement clonedType = CodeTypeElement.cloneShallow(nodeType);
        clonedType.setSuperClass(this.types.Node);
        syntheticExecute = CodeExecutableElement.clone(message.getExecutable());
        syntheticExecute.setSimpleName(CodeNames.of(EXECUTE_PREFIX + ElementUtils.firstLetterUpperCase(message.getName()) + EXECUTE_SUFFIX));
        syntheticExecute.getParameters().set(0, new CodeVariableElement(exportedMessage.getReceiverType(), "receiver"));
        syntheticExecute.getModifiers().add(Modifier.ABSTRACT);
        syntheticExecute.setVarArgs(false);
        clonedType.add(syntheticExecute);
        AnnotationMirror generateUncached = ElementUtils.findAnnotationMirror((Element)nodeType, (TypeMirror)this.types.GenerateUncached);
        AnnotationMirror importStatic = ElementUtils.findAnnotationMirror((Element)nodeType, (TypeMirror)this.types.ImportStatic);
        ArrayList<CodeAnnotationValue> staticImports = new ArrayList<CodeAnnotationValue>();
        if (importStatic != null) {
            for (TypeMirror existingImport : ElementUtils.getAnnotationValueList(TypeMirror.class, importStatic, "value")) {
                staticImports.add(new CodeAnnotationValue(existingImport));
            }
        }
        DeclaredType importStaticType = this.types.ImportStatic;
        staticImports.add(new CodeAnnotationValue(exportedMessage.getExportsLibrary().getTemplateType().asType()));
        CodeAnnotationMirror newImports = new CodeAnnotationMirror(importStaticType);
        newImports.setElementValue(ElementUtils.findExecutableElement(importStaticType, "value"), new CodeAnnotationValue(staticImports));
        clonedType.getAnnotationMirrors().clear();
        clonedType.getAnnotationMirrors().add(newImports);
        if (generateUncached != null) {
            clonedType.getAnnotationMirrors().add(generateUncached);
        } else {
            clonedType.getAnnotationMirrors().add(new CodeAnnotationMirror(this.types.GenerateUncached));
        }
        NodeData parsedNodeData = (NodeData)NodeParser.createExportParser(exportedMessage.getExportsLibrary().getLibrary().getTemplateType().asType(), exportedMessage.getExportsLibrary().getTemplateType()).parse((Element)clonedType, false);
        this.parsedNodeCache.put(nodeTypeId, parsedNodeData);
        return parsedNodeData;
    }

    private static boolean isNodeElement(Element member) {
        return member.getKind().isClass();
    }

    private static boolean isMethodElement(Element member) {
        return member.getKind() == ElementKind.METHOD;
    }

    private static String inferNodeMessageName(TypeElement type) {
        String name = type.getSimpleName().toString();
        return ElementUtils.firstLetterLowerCase(name);
    }

    private static boolean verifyMethodSignature(TypeElement type, LibraryMessage message, ExportMessageData exportedMessage, ExecutableElement exportedMethod, TypeMirror receiverType, int realParameterCount, boolean emitErrors) {
        TypeMirror expectedStaticReceiverType;
        ExecutableElement libraryMethod = message.getExecutable();
        if (exportedMessage.getExportsLibrary().isExplicitReceiver() && !exportedMethod.getModifiers().contains((Object)Modifier.STATIC)) {
            if (emitErrors) {
                exportedMessage.addError("Exported methods with explicit receiver must be static.", new Object[0]);
            }
            return false;
        }
        boolean explicitReceiver = exportedMethod.getModifiers().contains((Object)Modifier.STATIC);
        int paramOffset = !explicitReceiver ? 1 : 0;
        List<? extends VariableElement> expectedParameters = libraryMethod.getParameters().subList(paramOffset, libraryMethod.getParameters().size());
        List<? extends VariableElement> exportedParameters = exportedMethod.getParameters().subList(0, realParameterCount);
        TypeMirror typeMirror = expectedStaticReceiverType = explicitReceiver || exportedMessage.getExportsLibrary().isExplicitReceiver() ? receiverType : null;
        if (exportedParameters.size() != expectedParameters.size()) {
            if (emitErrors) {
                exportedMessage.addError(exportedMethod, "Expected parameter count %s for exported message, but was %s. Expected signature:%n    %s", expectedParameters.size(), exportedParameters.size(), ExportsParser.generateExpectedSignature(type, message, expectedStaticReceiverType));
            }
            return false;
        }
        if (!ElementUtils.isAssignable(exportedMethod.getReturnType(), libraryMethod.getReturnType())) {
            if (emitErrors) {
                exportedMessage.addError(exportedMethod, "Invalid exported return type. Expected '%s' but was '%s'. Expected signature:%n    %s", ElementUtils.getSimpleName(libraryMethod.getReturnType()), ElementUtils.getSimpleName(exportedMethod.getReturnType()), ExportsParser.generateExpectedSignature(type, message, expectedStaticReceiverType));
            }
            return false;
        }
        for (int i = 0; i < exportedParameters.size(); ++i) {
            TypeMirror libraryArgType;
            VariableElement exportedArg = exportedParameters.get(i);
            VariableElement libraryArg = expectedParameters.get(i);
            TypeMirror exportedArgType = exportedArg.asType();
            TypeMirror typeMirror2 = libraryArgType = explicitReceiver && i == 0 ? receiverType : libraryArg.asType();
            if (ElementUtils.typeEquals(exportedArgType, libraryArgType)) continue;
            if (emitErrors) {
                exportedMessage.addError(exportedArg, "Invalid parameter type. Expected '%s' but was '%s'. Expected signature:%n    %s", ElementUtils.getSimpleName(libraryArgType), ElementUtils.getSimpleName(exportedArgType), ExportsParser.generateExpectedSignature(type, message, expectedStaticReceiverType));
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static String generateExpectedSignature(TypeElement targetType, LibraryMessage message, TypeMirror staticReceiverType) {
        StringBuilder b = new StringBuilder();
        b.append("@").append(ProcessorContext.getInstance().getTypes().ExportMessage.asElement().getSimpleName().toString()).append(" ");
        if (staticReceiverType != null) {
            b.append("static ");
        } else if (!targetType.getModifiers().contains((Object)Modifier.FINAL)) {
            b.append("final ");
        }
        b.append(ElementUtils.getSimpleName(message.getExecutable().getReturnType()));
        b.append(" ");
        b.append(message.getName());
        b.append("(");
        int startIndex = staticReceiverType == null ? 1 : 0;
        List<? extends VariableElement> parameters = message.getExecutable().getParameters();
        for (int i = startIndex; i < parameters.size(); ++i) {
            void var8_9;
            VariableElement parameter = parameters.get(i);
            if (i == startIndex && staticReceiverType != null) {
                TypeMirror typeMirror = staticReceiverType;
            } else {
                TypeMirror typeMirror = parameter.asType();
            }
            if (i > startIndex) {
                b.append(", ");
            }
            b.append(ElementUtils.getSimpleName((TypeMirror)var8_9));
            b.append(" ");
            b.append(parameter.getSimpleName().toString());
        }
        b.append(")");
        if (!message.getExecutable().getThrownTypes().isEmpty()) {
            b.append(" throws ");
            String sep = "";
            for (TypeMirror typeMirror : message.getExecutable().getThrownTypes()) {
                b.append(sep);
                b.append(ElementUtils.getSimpleName(typeMirror));
                sep = ", ";
            }
        }
        return b.toString();
    }

    public static List<String> fuzzyMatch(Collection<String> descriptors, String optionKey, float minScore) {
        ArrayList<String> matches = new ArrayList<String>();
        for (String string : descriptors) {
            float score = ExportsParser.stringSimiliarity(string, optionKey);
            if (!(score >= minScore)) continue;
            matches.add(string);
        }
        return matches;
    }

    private static float stringSimiliarity(String str1, String str2) {
        int hit = 0;
        block0: for (int i = 0; i < str1.length() - 1; ++i) {
            for (int j = 0; j < str2.length() - 1; ++j) {
                if (str1.charAt(i) != str2.charAt(j) || str1.charAt(i + 1) != str2.charAt(j + 1)) continue;
                ++hit;
                continue block0;
            }
        }
        return 2.0f * (float)hit / (float)(str1.length() + str2.length());
    }

    @Override
    public DeclaredType getAnnotationType() {
        return this.types.ExportLibrary;
    }

    @Override
    public DeclaredType getRepeatAnnotationType() {
        return this.types.ExportLibrary_Repeat;
    }

    @Override
    public List<DeclaredType> getTypeDelegatedAnnotationTypes() {
        return Arrays.asList(this.types.ExportMessage, this.types.ExportMessage_Repeat);
    }
}

