/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.interop;

import com.oracle.truffle.dsl.processor.interop.ForeignAccessFactoryGenerator;
import com.oracle.truffle.dsl.processor.interop.Utils;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;

abstract class InteropNodeGenerator {
    protected final ProcessingEnvironment processingEnv;
    protected final TypeElement element;
    protected final String packageName;
    protected final String clazzName;
    protected final String userClassName;
    protected final ForeignAccessFactoryGenerator containingForeignAccessFactory;
    protected String indent = "    ";

    protected InteropNodeGenerator(ProcessingEnvironment processingEnv, TypeElement element, ForeignAccessFactoryGenerator containingForeignAccessFactory) {
        this.processingEnv = processingEnv;
        this.element = element;
        this.containingForeignAccessFactory = containingForeignAccessFactory;
        this.packageName = ElementUtils.getPackageName(element);
        this.userClassName = ElementUtils.getQualifiedName(element);
        this.clazzName = Utils.getSimpleResolveClassName(element);
    }

    public void addImports(Collection<String> imports) {
        imports.add("com.oracle.truffle.api.dsl.Specialization");
        imports.add("com.oracle.truffle.api.dsl.UnsupportedSpecializationException");
        imports.add("com.oracle.truffle.api.frame.VirtualFrame");
        imports.add("com.oracle.truffle.api.interop.UnsupportedTypeException");
        imports.add("com.oracle.truffle.api.nodes.RootNode");
    }

    public abstract void appendNode(Writer var1) throws IOException;

    public String getRootNodeFactoryInvocation() {
        return this.clazzName + ".createRoot()";
    }

    private String getGeneratedDSLNodeSuffix() {
        return this.clazzName.endsWith("Node") ? "Gen" : "NodeGen";
    }

    protected String getGeneratedDSLNodeQualifiedName() {
        return this.containingForeignAccessFactory.getFullClassName() + "Factory" + '.' + this.clazzName + this.getGeneratedDSLNodeSuffix();
    }

    public String toString() {
        return this.clazzName;
    }
}

