/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.generator;

import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.generator.CodeTypeElementFactory;
import com.oracle.truffle.dsl.processor.generator.FlatNodeGenFactory;
import com.oracle.truffle.dsl.processor.generator.GeneratorUtils;
import com.oracle.truffle.dsl.processor.generator.NodeFactoryFactory;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.model.CodeExecutableElement;
import com.oracle.truffle.dsl.processor.java.model.CodeTreeBuilder;
import com.oracle.truffle.dsl.processor.java.model.CodeTypeElement;
import com.oracle.truffle.dsl.processor.java.model.CodeVariableElement;
import com.oracle.truffle.dsl.processor.model.MessageContainer;
import com.oracle.truffle.dsl.processor.model.NodeChildData;
import com.oracle.truffle.dsl.processor.model.NodeData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;

public class NodeCodeGenerator
extends CodeTypeElementFactory<NodeData> {
    private static final String NODE_SUFFIX = "NodeGen";

    @Override
    public List<CodeTypeElement> create(ProcessorContext context, NodeData node) {
        LinkedHashMap<String, CodeVariableElement> libraryConstants = new LinkedHashMap<String, CodeVariableElement>();
        List<CodeTypeElement> rootTypes = NodeCodeGenerator.createImpl(context, node, libraryConstants);
        if (rootTypes != null) {
            if (rootTypes.size() != 1) {
                throw new AssertionError();
            }
            rootTypes.get(0).addAll(libraryConstants.values());
        }
        return rootTypes;
    }

    private static List<CodeTypeElement> createImpl(ProcessorContext context, NodeData node, Map<String, CodeVariableElement> libraryConstants) {
        ArrayList<CodeTypeElement> enclosedTypes = new ArrayList<CodeTypeElement>();
        for (NodeData childNode : node.getEnclosingNodes()) {
            List<CodeTypeElement> type = NodeCodeGenerator.createImpl(context, childNode, libraryConstants);
            if (type == null) continue;
            enclosedTypes.addAll(type);
        }
        List<CodeTypeElement> generatedNodes = NodeCodeGenerator.generateNodes(context, node, libraryConstants);
        if (!generatedNodes.isEmpty() || !enclosedTypes.isEmpty()) {
            ExecutableElement getFactories;
            CodeTypeElement type = generatedNodes.isEmpty() ? NodeCodeGenerator.createContainer(node) : NodeCodeGenerator.wrapGeneratedNodes(context, node, generatedNodes);
            for (CodeTypeElement enclosedFactory : enclosedTypes) {
                type.add(NodeCodeGenerator.makeInnerClass(enclosedFactory));
            }
            if (node.getDeclaringNode() == null && enclosedTypes.size() > 0 && (getFactories = NodeCodeGenerator.createGetFactories(context, node)) != null) {
                type.add(getFactories);
            }
            return Arrays.asList(type);
        }
        return null;
    }

    private static CodeTypeElement makeInnerClass(CodeTypeElement type) {
        Set<Modifier> modifiers = type.getModifiers();
        modifiers.add(Modifier.STATIC);
        return type;
    }

    private static CodeTypeElement wrapGeneratedNodes(ProcessorContext context, NodeData node, List<CodeTypeElement> generatedNodes) {
        CodeTypeElement first;
        if (node.isGenerateFactory()) {
            CodeTypeElement factoryElement = new NodeFactoryFactory(context, node, generatedNodes.get(0)).create();
            for (CodeTypeElement generatedNode : generatedNodes) {
                factoryElement.add(NodeCodeGenerator.makeInnerClass(generatedNode));
            }
            return factoryElement;
        }
        CodeTypeElement second = first = generatedNodes.get(0);
        if (generatedNodes.size() > 1) {
            second = generatedNodes.get(1);
            for (CodeTypeElement generatedNode : generatedNodes) {
                if (first == generatedNode) continue;
                first.add(NodeCodeGenerator.makeInnerClass(generatedNode));
            }
        }
        List<ExecutableElement> constructors = GeneratorUtils.findUserConstructors(second.asType());
        first.getEnclosedElements().addAll(NodeFactoryFactory.createFactoryMethods(node, constructors));
        ElementUtils.setVisibility(first.getModifiers(), ElementUtils.getVisibility(node.getTemplateType().getModifiers()));
        return first;
    }

    private static CodeTypeElement createContainer(NodeData node) {
        Modifier visibility = ElementUtils.getVisibility(node.getTemplateType().getModifiers());
        String containerName = NodeFactoryFactory.factoryClassName(node.getTemplateType());
        CodeTypeElement container = GeneratorUtils.createClass(node, null, ElementUtils.modifiers(new Modifier[0]), containerName, null);
        if (visibility != null) {
            container.getModifiers().add(visibility);
        }
        container.getModifiers().add(Modifier.FINAL);
        return container;
    }

    private static String getAccessorClassName(NodeData node) {
        return node.isGenerateFactory() ? NodeFactoryFactory.factoryClassName(node.getTemplateType()) : NodeCodeGenerator.createNodeTypeName(node.getTemplateType());
    }

    private static Element buildClassName(Element nodeElement, boolean first, boolean generateFactory) {
        if (nodeElement == null || nodeElement.getKind() == ElementKind.PACKAGE) {
            return nodeElement;
        }
        if (nodeElement.getKind().isClass()) {
            Element enclosingElement = NodeCodeGenerator.buildClassName(nodeElement.getEnclosingElement(), false, generateFactory);
            PackageElement enclosingPackage = null;
            CodeTypeElement enclosingClass = null;
            if (enclosingElement != null) {
                if (enclosingElement.getKind() == ElementKind.PACKAGE) {
                    enclosingPackage = (PackageElement)enclosingElement;
                } else if (enclosingElement.getKind().isClass()) {
                    enclosingClass = (CodeTypeElement)enclosingElement;
                }
            }
            if (first) {
                if (generateFactory) {
                    enclosingClass = NodeCodeGenerator.createClass(enclosingPackage, enclosingClass, NodeFactoryFactory.factoryClassName(nodeElement));
                }
                enclosingClass = NodeCodeGenerator.createClass(enclosingPackage, enclosingClass, NodeCodeGenerator.createNodeTypeName((TypeElement)nodeElement));
            } else {
                enclosingClass = NodeCodeGenerator.isSpecializedNode(nodeElement) ? NodeCodeGenerator.createClass(enclosingPackage, enclosingClass, NodeCodeGenerator.createNodeTypeName((TypeElement)nodeElement)) : NodeCodeGenerator.createClass(enclosingPackage, enclosingClass, NodeFactoryFactory.factoryClassName(nodeElement));
            }
            return enclosingClass;
        }
        return null;
    }

    private static CodeTypeElement createClass(PackageElement pack, CodeTypeElement enclosingClass, String name) {
        CodeTypeElement type = new CodeTypeElement(ElementUtils.modifiers(Modifier.PUBLIC), ElementKind.CLASS, pack, name);
        if (enclosingClass != null) {
            enclosingClass.add(type);
        }
        return type;
    }

    public static boolean isSpecializedNode(TypeMirror mirror) {
        TypeElement type = ElementUtils.castTypeElement(mirror);
        if (type != null) {
            return NodeCodeGenerator.isSpecializedNode(type);
        }
        return false;
    }

    static boolean isSpecializedNode(Element element) {
        if (element.getKind().isClass() && ElementUtils.isAssignable(element.asType(), ProcessorContext.getInstance().getTypes().Node)) {
            for (ExecutableElement method : ElementFilter.methodsIn(element.getEnclosedElements())) {
                if (ElementUtils.findAnnotationMirror((Element)method, (TypeMirror)ProcessorContext.getInstance().getTypes().Specialization) == null) continue;
                return true;
            }
        }
        return false;
    }

    public static TypeMirror nodeType(NodeData node) {
        TypeElement element = node.getTemplateType();
        CodeTypeElement type = (CodeTypeElement)NodeCodeGenerator.buildClassName(element, true, node.isGenerateFactory());
        return type.asType();
    }

    public static TypeMirror factoryOrNodeType(NodeData node) {
        TypeElement element = node.getTemplateType();
        CodeTypeElement type = (CodeTypeElement)NodeCodeGenerator.buildClassName(element, true, node.isGenerateFactory());
        if (node.isGenerateFactory()) {
            return type.getEnclosingElement().asType();
        }
        return type.asType();
    }

    private static String resolveNodeId(TypeElement node) {
        String nodeid = node.getSimpleName().toString();
        if (nodeid.endsWith("Node") && !nodeid.equals("Node")) {
            nodeid = nodeid.substring(0, nodeid.length() - 4);
        }
        return nodeid;
    }

    static String createNodeTypeName(TypeElement nodeType) {
        return NodeCodeGenerator.resolveNodeId(nodeType) + NODE_SUFFIX;
    }

    private static List<CodeTypeElement> generateNodes(ProcessorContext context, NodeData node, Map<String, CodeVariableElement> libraryConstants) {
        if (!node.needsFactory()) {
            return Collections.emptyList();
        }
        CodeTypeElement type = GeneratorUtils.createClass(node, null, ElementUtils.modifiers(Modifier.FINAL), NodeCodeGenerator.createNodeTypeName(node.getTemplateType()), node.getTemplateType().asType());
        ElementUtils.setVisibility(type.getModifiers(), ElementUtils.getVisibility(node.getTemplateType().getModifiers()));
        if (node.hasErrors()) {
            NodeCodeGenerator.generateErrorNode(context, node, type);
            return Arrays.asList(type);
        }
        type = new FlatNodeGenFactory(context, node, libraryConstants).create(type);
        return Arrays.asList(type);
    }

    private static void generateErrorNode(ProcessorContext context, NodeData node, CodeTypeElement type) {
        for (ExecutableElement superConstructor : GeneratorUtils.findUserConstructors(node.getTemplateType().asType())) {
            CodeExecutableElement constructor = GeneratorUtils.createConstructorUsingFields(ElementUtils.modifiers(new Modifier[0]), type, superConstructor);
            ElementUtils.setVisibility(constructor.getModifiers(), ElementUtils.getVisibility(superConstructor.getModifiers()));
            ArrayList<CodeVariableElement> childParameters = new ArrayList<CodeVariableElement>();
            for (NodeChildData child : node.getChildren()) {
                childParameters.add(new CodeVariableElement(child.getOriginalType(), child.getName()));
            }
            constructor.getParameters().addAll(superConstructor.getParameters().size(), childParameters);
            type.add(constructor);
        }
        for (ExecutableElement method : ElementFilter.methodsIn(context.getEnvironment().getElementUtils().getAllMembers(node.getTemplateType()))) {
            if (!method.getModifiers().contains((Object)Modifier.ABSTRACT) || ElementUtils.getVisibility(method.getModifiers()) == Modifier.PRIVATE) continue;
            CodeExecutableElement overrideMethod = CodeExecutableElement.clone(method);
            overrideMethod.getModifiers().remove((Object)Modifier.ABSTRACT);
            List<MessageContainer.Message> messages = node.collectMessages();
            String message = messages.toString();
            message = message.replace("\"", "\\\"");
            message = message.replace(System.lineSeparator(), "\\\\n");
            overrideMethod.createBuilder().startThrow().startNew(context.getType(RuntimeException.class)).doubleQuote("Truffle DSL compiler errors: " + message).end().end();
            type.add(overrideMethod);
        }
    }

    private static ExecutableElement createGetFactories(ProcessorContext context, NodeData node) {
        List<NodeData> factoryList = node.getNodesWithFactories();
        if (node.needsFactory() && node.isGenerateFactory()) {
            factoryList.add(node);
        }
        if (factoryList.isEmpty()) {
            return null;
        }
        ArrayList<TypeMirror> nodeTypesList = new ArrayList<TypeMirror>();
        TypeMirror prev = null;
        boolean allSame = true;
        for (NodeData child : factoryList) {
            nodeTypesList.add(child.getNodeType());
            if (prev != null && !ElementUtils.typeEquals(child.getNodeType(), prev)) {
                allSame = false;
            }
            prev = child.getNodeType();
        }
        TypeMirror commonNodeSuperType = ElementUtils.getCommonSuperType(context, nodeTypesList);
        Types types = context.getEnvironment().getTypeUtils();
        DeclaredType factoryType = context.getTypes().NodeFactory;
        DeclaredType baseType = allSame ? ElementUtils.getDeclaredType(ElementUtils.fromTypeMirror(factoryType), commonNodeSuperType) : ElementUtils.getDeclaredType(ElementUtils.fromTypeMirror(factoryType), types.getWildcardType(commonNodeSuperType, null));
        DeclaredType listType = ElementUtils.getDeclaredType(ElementUtils.fromTypeMirror(context.getType(List.class)), baseType);
        CodeExecutableElement method = new CodeExecutableElement(ElementUtils.modifiers(Modifier.PUBLIC, Modifier.STATIC), listType, "getFactories", new CodeVariableElement[0]);
        CodeTreeBuilder builder = method.createBuilder();
        builder.startReturn();
        if (factoryList.size() > 1) {
            builder.startStaticCall(context.getType(Arrays.class), "asList");
        } else {
            builder.startStaticCall(context.getType(Collections.class), "singletonList");
        }
        for (NodeData child : factoryList) {
            builder.startGroup();
            NodeData childNode = child;
            ArrayList<NodeData> factories = new ArrayList<NodeData>();
            while (childNode.getDeclaringNode() != null) {
                factories.add(childNode);
                childNode = childNode.getDeclaringNode();
            }
            Collections.reverse(factories);
            for (NodeData nodeData : factories) {
                builder.string(NodeCodeGenerator.getAccessorClassName(nodeData)).string(".");
            }
            builder.string("getInstance()");
            builder.end();
        }
        builder.end();
        builder.end();
        return method;
    }
}

