/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor;

import com.oracle.truffle.dsl.processor.CodeWriter;
import com.oracle.truffle.dsl.processor.ProcessorContext;
import com.oracle.truffle.dsl.processor.generator.CodeTypeElementFactory;
import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.model.CodeTypeElement;
import com.oracle.truffle.dsl.processor.java.transform.FixWarningsVisitor;
import com.oracle.truffle.dsl.processor.java.transform.GenerateOverrideVisitor;
import com.oracle.truffle.dsl.processor.model.Template;
import com.oracle.truffle.dsl.processor.parser.AbstractParser;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;

class AnnotationProcessor<M extends Template> {
    private final AbstractParser<M> parser;
    private final CodeTypeElementFactory<M> factory;
    private final Set<String> processedElements = new HashSet<String>();

    AnnotationProcessor(AbstractParser<M> parser, CodeTypeElementFactory<M> factory) {
        this.parser = parser;
        this.factory = factory;
    }

    public AbstractParser<M> getParser() {
        return this.parser;
    }

    public void process(Element element, boolean callback) {
        boolean firstRun;
        if (!callback) {
            String qualifiedName = ElementUtils.getQualifiedName((TypeElement)element);
            if (this.processedElements.contains(qualifiedName)) {
                return;
            }
            this.processedElements.add(qualifiedName);
        }
        ProcessorContext context = ProcessorContext.getInstance();
        TypeElement type = (TypeElement)element;
        Template model = context.getTemplate(type.asType(), false);
        boolean bl = firstRun = !context.containsTemplate(type);
        if (firstRun || !callback) {
            context.registerTemplate(type, null);
            model = (Template)this.parser.parse(element);
            context.registerTemplate(type, model);
            if (model != null) {
                List<CodeTypeElement> units;
                try {
                    units = this.factory.create(ProcessorContext.getInstance(), model);
                }
                catch (Throwable e) {
                    RuntimeException ex = new RuntimeException(String.format("Failed to write code for %s. Parserdump:%s.", ElementUtils.getQualifiedName(type), ""));
                    e.addSuppressed(ex);
                    throw e;
                }
                if (units == null || units.isEmpty()) {
                    return;
                }
                for (CodeTypeElement unit : units) {
                    unit.setGeneratorAnnotationMirror(model.getTemplateTypeAnnotation());
                    unit.setGeneratorElement(model.getTemplateType());
                    DeclaredType overrideType = (DeclaredType)context.getType(Override.class);
                    unit.accept(new GenerateOverrideVisitor(overrideType), null);
                    unit.accept(new FixWarningsVisitor(model.getTemplateType(), overrideType), null);
                    if (callback) continue;
                    unit.accept(new CodeWriter(context.getEnvironment(), element), null);
                }
            }
        }
    }
}

