/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.toolchain.launchers.darwin;

import com.oracle.truffle.llvm.toolchain.launchers.common.Driver;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public final class DarwinLinker
extends Driver {
    public static final String LD = "/usr/bin/ld";

    private DarwinLinker() {
        super(LD, false);
    }

    public static void link(String[] args) {
        new DarwinLinker().doLink(args);
    }

    private void doLink(String[] args) {
        ArrayList<String> sulongArgs = new ArrayList<String>();
        sulongArgs.add(this.exe);
        sulongArgs.add("-L" + this.getSulongHome().resolve("native").resolve("lib"));
        sulongArgs.add("-lto_library");
        sulongArgs.add(this.getLLVMBinDir().resolve("..").resolve("lib").resolve("libLTO.dylib").toString());
        List<String> userArgs = Arrays.asList(args);
        boolean verbose = userArgs.contains("-v");
        this.runDriver(sulongArgs, userArgs, verbose, false, false);
    }

    @Override
    public void runDriver(List<String> sulongArgs, List<String> userArgs, boolean verb, boolean hlp, boolean earlyexit) {
        DarwinLinker.runDriverWithSaveTemps(this, sulongArgs, userArgs, verb, hlp, earlyexit, "", true, userArgs.indexOf("-o"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void runDriverWithSaveTemps(Driver driver, List<String> sulongArgs, List<String> userArgs, boolean verb, boolean hlp, boolean earlyexit, String linkerOptionPrefix, boolean needLinkerFlags, int outputFlagPos) {
        Path tempDir = null;
        try {
            block10: {
                if (needLinkerFlags && !earlyexit) {
                    try {
                        tempDir = Files.createTempDirectory("graalvm-clang-wrapper", new FileAttribute[0]);
                        String newOutput = tempDir.resolve("temp.out").toString();
                        List<String> newUserArgs = DarwinLinker.newUserArgs(userArgs, newOutput, linkerOptionPrefix, outputFlagPos);
                        driver.runDriverReturn(sulongArgs, newUserArgs, verb, hlp, earlyexit);
                        String bcFile = newOutput + ".lto.opt.bc";
                        if (Files.exists(Paths.get(bcFile, new String[0]), new LinkOption[0])) {
                            sulongArgs.add(linkerOptionPrefix + "-sectcreate");
                            sulongArgs.add(linkerOptionPrefix + "__LLVM");
                            sulongArgs.add(linkerOptionPrefix + "__bundle");
                            sulongArgs.add(linkerOptionPrefix + bcFile);
                        }
                    }
                    catch (Exception e) {
                        if (!verb) break block10;
                        System.err.println("Running clang with `-save-temps` failed: " + e);
                    }
                }
            }
            driver.runDriverExit(sulongArgs, userArgs, verb, hlp, earlyexit);
            if (tempDir == null) return;
        }
        catch (Throwable throwable) {
            if (tempDir == null) throw throwable;
            try {
                Files.walk(tempDir, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                throw throwable;
            }
            catch (IOException e) {
                if (!verb) throw throwable;
                System.err.println("Deleting the temporary directory (" + tempDir + ") failed: " + e);
            }
            throw throwable;
        }
        try {
            Files.walk(tempDir, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            return;
        }
        catch (IOException e) {
            if (!verb) return;
            System.err.println("Deleting the temporary directory (" + tempDir + ") failed: " + e);
        }
    }

    private static List<String> newUserArgs(List<String> userArgs, String newOutput, String linkerOptionPrefix, int outputFlagPos) {
        ArrayList<String> newUserArgs = new ArrayList<String>(userArgs.size() + 2);
        if (outputFlagPos == -1) {
            newUserArgs.addAll(userArgs);
        } else {
            int i;
            for (i = 0; i < outputFlagPos; ++i) {
                newUserArgs.add(userArgs.get(i));
            }
            for (i = outputFlagPos + 2; i < userArgs.size(); ++i) {
                newUserArgs.add(userArgs.get(i));
            }
        }
        newUserArgs.add("-o");
        newUserArgs.add(newOutput);
        newUserArgs.add(linkerOptionPrefix + "-save-temps");
        return newUserArgs;
    }
}

