/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk.model;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectArrayInstance;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectFieldValue;
import org.graalvm.visualvm.lib.profiler.heapwalk.model.BrowserUtils;
import org.graalvm.visualvm.lib.profiler.heapwalk.model.HeapWalkerFieldNode;
import org.graalvm.visualvm.lib.profiler.heapwalk.model.HeapWalkerNode;
import org.graalvm.visualvm.lib.profiler.heapwalk.model.ObjectArrayNode;

public class ObjectArrayFieldNode
extends ObjectArrayNode
implements HeapWalkerFieldNode {
    private ObjectFieldValue fieldValue;

    public ObjectArrayFieldNode(ObjectFieldValue fieldValue, HeapWalkerNode parent) {
        this(fieldValue, parent, parent == null ? 1 : parent.getMode());
    }

    public ObjectArrayFieldNode(ObjectFieldValue fieldValue, HeapWalkerNode parent, int mode) {
        super((ObjectArrayInstance)fieldValue.getInstance(), fieldValue.getField().getName(), parent, mode);
        this.fieldValue = fieldValue;
    }

    public ObjectFieldValue getFieldValue() {
        return this.fieldValue;
    }

    @Override
    public boolean isStatic() {
        return this.fieldValue.getField().isStatic();
    }

    @Override
    protected Icon computeIcon() {
        ImageIcon icon = BrowserUtils.ICON_ARRAY;
        if (this.isStatic()) {
            icon = BrowserUtils.createStaticIcon(icon);
        }
        if (this.getMode() == 2 && this.getInstance().isGCRoot()) {
            icon = BrowserUtils.createGCRootIcon(icon);
        }
        return this.processLoopIcon(icon);
    }

    @Override
    public Object getNodeID() {
        return this.fieldValue;
    }
}

