/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk.details.basic;

import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectArrayInstance;
import org.graalvm.visualvm.lib.jfluid.heap.PrimitiveArrayInstance;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.basic.ArrayValueView;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.basic.Bundle;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsProvider;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsUtils;

public final class ArrayDetailsProvider
extends DetailsProvider {
    @Override
    public String getDetailsString(String className, Instance instance, Heap heap) {
        if (instance instanceof PrimitiveArrayInstance) {
            if ("char[]".equals(instance.getJavaClass().getName())) {
                return DetailsUtils.getPrimitiveArrayString(instance, 0, -1, null, "...");
            }
            return ArrayDetailsProvider.getItemsString(((PrimitiveArrayInstance)instance).getLength());
        }
        if (instance instanceof ObjectArrayInstance) {
            return ArrayDetailsProvider.getItemsString(((ObjectArrayInstance)instance).getLength());
        }
        return null;
    }

    @Override
    public DetailsProvider.View getDetailsView(String className, Instance instance, Heap heap) {
        if (instance instanceof PrimitiveArrayInstance) {
            return new ArrayValueView(className, instance, heap);
        }
        return null;
    }

    private static String getItemsString(int length) {
        return length == 1 ? Bundle.ArrayDetailsProvider_OneItemString() : Bundle.ArrayDetailsProvider_ItemsNumberString(length);
    }
}

