/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.heapviewer.HeapContext;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNodeFilter;
import org.graalvm.visualvm.heapviewer.model.Progress;
import org.graalvm.visualvm.heapviewer.model.RootNode;
import org.graalvm.visualvm.heapviewer.ui.Bundle;
import org.graalvm.visualvm.heapviewer.ui.HeapView;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerActions;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerNodeAction;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerRenderer;
import org.graalvm.visualvm.heapviewer.ui.PluggableTreeTableView;
import org.graalvm.visualvm.heapviewer.ui.TreeTableViewColumn;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.ui.components.ProfilerToolbar;
import org.graalvm.visualvm.lib.ui.swing.GrayLabel;
import org.openide.util.RequestProcessor;

public class NodeObjectsView
extends HeapView {
    private final HeapViewerNode viewNode;
    private String name;
    private String description;
    private Icon icon;
    private final PluggableTreeTableView objectsView;
    private ProfilerToolbar toolbar;
    private JComponent component;

    public NodeObjectsView(String viewID, HeapViewerNode node, HeapContext context, HeapViewerActions actions) {
        super(null, null);
        this.viewNode = node;
        Heap heap = context.getFragment().getHeap();
        Integer count = HeapViewerNode.getValue(node, DataType.COUNT, heap);
        boolean hasCount = !Objects.equals(count, DataType.COUNT.getUnsupportedValue());
        TreeTableViewColumn[] columns = hasCount ? TreeTableViewColumn.classes(heap, true) : TreeTableViewColumn.instances(heap, true);
        this.objectsView = new PluggableTreeTableView(viewID, context, actions, columns){

            @Override
            protected HeapViewerNode[] computeData(RootNode root, Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
                return new HeapViewerNode[]{NodeObjectsView.this.viewNode};
            }

            @Override
            protected void childrenChanged() {
                HeapViewerNode[] children;
                for (HeapViewerNode child : children = this.getRoot().getChildren()) {
                    this.expandNode(child);
                }
            }
        };
    }

    @Override
    public String getName() {
        if (this.toolbar == null) {
            this.initUI();
        }
        return this.name;
    }

    @Override
    public String getDescription() {
        if (this.toolbar == null) {
            this.initUI();
        }
        return this.description;
    }

    @Override
    public Icon getIcon() {
        if (this.toolbar == null) {
            this.initUI();
        }
        return this.icon;
    }

    @Override
    public JComponent getComponent() {
        if (this.toolbar == null) {
            this.initUI();
        }
        return this.component;
    }

    @Override
    public ProfilerToolbar getToolbar() {
        if (this.toolbar == null) {
            this.initUI();
        }
        return this.toolbar;
    }

    @Override
    protected void closed() {
        this.objectsView.closed();
    }

    private void initUI() {
        HeapViewerRenderer renderer = this.objectsView.getNodeRenderer(this.viewNode);
        this.name = renderer.getShortName();
        this.description = renderer.toString();
        this.icon = renderer.getIcon();
        this.toolbar = ProfilerToolbar.create((boolean)false);
        this.toolbar.addSpace(3);
        JLabel nodePresenter = new JLabel(this.name, this.icon, 10);
        nodePresenter.setToolTipText(this.description);
        this.toolbar.add((Component)nodePresenter);
        this.toolbar.addSpace(5);
        if (this.objectsView.hasPlugins()) {
            this.toolbar.addSeparator();
            this.toolbar.addSpace(5);
            this.toolbar.add((Component)new GrayLabel(Bundle.NodeObjectsView_Details()));
            this.toolbar.addSpace(2);
            this.toolbar.add(this.objectsView.getToolbar());
        }
        this.component = new ViewContainer(this.objectsView.getComponent(), this.viewNode);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NodeObjectsView.this.objectsView.selectNode(NodeObjectsView.this.viewNode);
                NodeObjectsView.this.objectsView.getComponent().requestFocusInWindow();
            }
        });
    }

    public static abstract class DefaultOpenAction
    extends OpenAction {
        public DefaultOpenAction(HeapViewerNode node, HeapContext context, HeapViewerActions actions) {
            super(Bundle.NodeObjectsView_NewTab(), 0, node, context, actions);
        }

        @Override
        public boolean isDefault() {
            return true;
        }

        @Override
        public boolean isMiddleButtonDefault(ActionEvent e) {
            return (e.getModifiers() & 2) != 2;
        }
    }

    public static abstract class OpenAction
    extends HeapViewerNodeAction {
        private final HeapViewerNode node;
        private final HeapContext context;
        private final HeapViewerActions actions;

        public OpenAction(String name, int position, HeapViewerNode node, HeapContext context, HeapViewerActions actions) {
            super(name, position);
            this.node = node;
            this.context = context;
            this.actions = actions;
            this.setEnabled(node != null);
        }

        public abstract NodeObjectsView createView(HeapViewerNode var1, HeapContext var2, HeapViewerActions var3);

        @Override
        public void actionPerformed(final ActionEvent e) {
            new RequestProcessor().post(new Runnable(){

                @Override
                public void run() {
                    NodeObjectsView view = this.createView(node, context, actions);
                    actions.addView(view, (e.getModifiers() & 1) == 0);
                }
            });
        }
    }

    private static class ViewContainer
    extends JPanel {
        private final HeapViewerNode node;

        ViewContainer(JComponent view, HeapViewerNode viewNode) {
            super(new BorderLayout());
            this.node = viewNode;
            this.setOpaque(false);
            this.setFocusable(false);
            this.add((Component)view, "Center");
        }

        @Override
        public boolean requestFocusInWindow() {
            if (this.getComponentCount() == 0) {
                return super.requestFocusInWindow();
            }
            return this.getComponent(0).requestFocusInWindow();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ViewContainer)) {
                return false;
            }
            return ((Object)((Object)this.node)).equals((Object)((ViewContainer)o).node);
        }

        public int hashCode() {
            return ((Object)((Object)this.node)).hashCode();
        }
    }
}

