/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.oql;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.net.URL;
import java.text.NumberFormat;
import java.util.List;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.ButtonGroup;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.graalvm.visualvm.core.ui.components.ScrollableContainer;
import org.graalvm.visualvm.heapviewer.HeapContext;
import org.graalvm.visualvm.heapviewer.java.ClassNode;
import org.graalvm.visualvm.heapviewer.java.InstanceNode;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNodeFilter;
import org.graalvm.visualvm.heapviewer.model.Progress;
import org.graalvm.visualvm.heapviewer.model.RootNode;
import org.graalvm.visualvm.heapviewer.oql.Bundle;
import org.graalvm.visualvm.heapviewer.oql.FilterUtils;
import org.graalvm.visualvm.heapviewer.oql.OQLEditorComponent;
import org.graalvm.visualvm.heapviewer.oql.OQLQueries;
import org.graalvm.visualvm.heapviewer.oql.OQLQueryExecutor;
import org.graalvm.visualvm.heapviewer.ui.HTMLView;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerActions;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerFeature;
import org.graalvm.visualvm.heapviewer.ui.PluggableTreeTableView;
import org.graalvm.visualvm.heapviewer.ui.TreeTableViewColumn;
import org.graalvm.visualvm.heapviewer.utils.HeapUtils;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;
import org.graalvm.visualvm.lib.profiler.api.ProfilerDialogs;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.profiler.heapwalk.OQLSupport;
import org.graalvm.visualvm.lib.profiler.oql.engine.api.OQLEngine;
import org.graalvm.visualvm.lib.ui.UIUtils;
import org.graalvm.visualvm.lib.ui.components.JExtendedSplitPane;
import org.graalvm.visualvm.lib.ui.components.ProfilerToolbar;
import org.graalvm.visualvm.lib.ui.swing.GrayLabel;
import org.netbeans.api.options.OptionsDisplayer;
import org.openide.util.RequestProcessor;

public class OQLConsoleView
extends HeapViewerFeature {
    private static final int RESULTS_LIMIT = Integer.parseInt(System.getProperty("OQLController.limitResults", "100"));
    private static final Color SEPARATOR_COLOR = UIManager.getColor("Separator.foreground");
    private final HeapContext context;
    private final HeapViewerActions actions;
    private ProfilerToolbar toolbar;
    private ProfilerToolbar objectsToolbar;
    private ProfilerToolbar pluginsToolbar;
    private ProfilerToolbar htmlToolbar;
    private ProfilerToolbar resultsToolbar;
    private ProfilerToolbar progressToolbar;
    private JComponent component;
    private Action runAction;
    private Action cancelAction;
    private Action loadAction;
    private Action saveAction;
    private Action editAction;
    private JLabel progressLabel;
    private JProgressBar progressBar;
    private JComboBox limitCombo;
    private OQLEditorComponent editor;
    private JPanel resultsContainer;
    private HTMLView htmlView;
    private PluggableTreeTableView objectsView;
    private JToggleButton rObjects;
    private JToggleButton rHTML;
    private Aggregation aggregation = Aggregation.INSTANCES;
    private JToggleButton tbPackages;
    private JToggleButton tbClasses;
    private JToggleButton tbInstances;
    private OQLQueryExecutor oqlExecutor;
    private boolean queryValid;
    private OQLSupport.Query currentQuery;
    private volatile boolean countVisible1 = true;
    private volatile boolean countVisible2 = false;

    public OQLConsoleView(HeapContext context, HeapViewerActions actions) {
        super("java_objects_oql", Bundle.OQLConsoleView_Name(), Bundle.OQLConsoleView_Description(), Icons.getIcon((String)"HeapWalkerIcons.OQLConsole"), 1000);
        this.context = context;
        this.actions = actions;
    }

    @Override
    public JComponent getComponent() {
        if (this.component == null) {
            this.init();
        }
        return this.component;
    }

    @Override
    public ProfilerToolbar getToolbar() {
        if (this.toolbar == null) {
            this.init();
        }
        return this.toolbar;
    }

    @Override
    protected void closed() {
        if (this.objectsView != null) {
            this.objectsView.closed();
        }
    }

    private void init() {
        this.toolbar = ProfilerToolbar.create((boolean)false);
        this.component = new JPanel(new BorderLayout());
        this.component.setOpaque(true);
        this.component.setBackground(UIUtils.getProfilerResultsBackground());
        JLabel l = new JLabel(Bundle.OQLConsoleView_InitializingEngine(), 0);
        l.setEnabled(false);
        l.setOpaque(false);
        this.component.add((Component)l, "Center");
        new RequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                Heap heap = OQLConsoleView.this.context.getFragment().getHeap();
                if (OQLEngine.isOQLSupported()) {
                    try {
                        final OQLEngine oqlEngine = new OQLEngine(heap);
                        OQLConsoleView.this.oqlExecutor = new OQLQueryExecutor(oqlEngine){

                            @Override
                            protected void queryStarted(BoundedRangeModel model) {
                                OQLConsoleView.this.queryStarted(model);
                            }

                            @Override
                            protected void queryFinished(boolean hasObjectsResults, boolean hasHTMLResults, String errorMessage) {
                                OQLConsoleView.this.queryFinished(hasObjectsResults, hasHTMLResults, errorMessage);
                            }
                        };
                        TreeTableViewColumn[] ownColumns = new TreeTableViewColumn[]{new TreeTableViewColumn.Name(heap), new TreeTableViewColumn.Count(heap, false, false), new TreeTableViewColumn.OwnSize(heap, true, true), new TreeTableViewColumn.RetainedSize(heap, true, false)};
                        OQLConsoleView.this.objectsView = new PluggableTreeTableView("java_objects_oql", OQLConsoleView.this.context, OQLConsoleView.this.actions, ownColumns){

                            @Override
                            protected HeapViewerNode[] computeData(RootNode root, Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
                                int aggr = Aggregation.INSTANCES.equals((Object)OQLConsoleView.this.aggregation) ? 0 : (Aggregation.CLASSES.equals((Object)OQLConsoleView.this.aggregation) ? 1 : 2);
                                return OQLConsoleView.this.oqlExecutor.getQueryObjects(root, heap, viewID, viewFilter, dataTypes, sortOrders, progress, aggr);
                            }

                            @Override
                            protected JComponent createComponent() {
                                JComponent comp = super.createComponent();
                                this.setFilterComponent(FilterUtils.createFilterPanel(this));
                                return comp;
                            }
                        };
                        OQLConsoleView.this.objectsView.setViewName(Bundle.OQLConsoleView_ViewName());
                        OQLConsoleView.this.htmlView = new HTMLView("java_objects_oql", OQLConsoleView.this.context, OQLConsoleView.this.actions, OQLConsoleView.this.oqlExecutor.getQueryHTML()){

                            @Override
                            protected HeapViewerNode nodeForURL(URL url, HeapContext context) {
                                return OQLConsoleView.getNode(url, context);
                            }
                        };
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                OQLConsoleView.this.runAction = new AbstractAction(Bundle.OQLConsoleView_RunAction(), Icons.getIcon((String)"GeneralIcons.Start")){
                                    {
                                        this.putValue("ShortDescription", Bundle.OQLConsoleView_RunActionTooltip());
                                    }

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        OQLConsoleView.this.executeQuery();
                                    }
                                };
                                JButton runButton = new JButton(OQLConsoleView.this.runAction){

                                    @Override
                                    public Dimension getPreferredSize() {
                                        Dimension d = super.getPreferredSize();
                                        d.width += 6;
                                        return d;
                                    }

                                    @Override
                                    public Dimension getMinimumSize() {
                                        return this.getPreferredSize();
                                    }

                                    @Override
                                    public Dimension getMaximumSize() {
                                        return this.getPreferredSize();
                                    }
                                };
                                runButton.putClientProperty("JComponent.sizeVariant", "regular");
                                OQLConsoleView.this.cancelAction = new AbstractAction(Bundle.OQLConsoleView_CancelAction(), Icons.getIcon((String)"GeneralIcons.Stop")){
                                    {
                                        this.putValue("ShortDescription", Bundle.OQLConsoleView_CancelActionTooltip());
                                    }

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        OQLConsoleView.this.cancelQuery();
                                    }
                                };
                                JButton cancelButton = new JButton(OQLConsoleView.this.cancelAction);
                                cancelButton.setHideActionText(true);
                                OQLConsoleView.this.loadAction = new AbstractAction(Bundle.OQLConsoleView_LoadAction(), OQLQueries.ICON_LOAD){
                                    {
                                        this.putValue("ShortDescription", Bundle.OQLConsoleView_LoadActionTooltip());
                                    }

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        if (e.getSource() instanceof JComponent) {
                                            JPopupMenu p = new JPopupMenu();
                                            OQLQueries.instance().populateLoadQuery(p, OQLConsoleView.this.currentQuery, new OQLQueries.Handler(){

                                                @Override
                                                protected void querySelected(OQLSupport.Query query) {
                                                    OQLConsoleView.this.currentQuery = query;
                                                    if (OQLConsoleView.this.editor != null) {
                                                        OQLConsoleView.this.editor.setScript(OQLConsoleView.this.currentQuery.getScript());
                                                    }
                                                }
                                            });
                                            JComponent c = (JComponent)e.getSource();
                                            if (p.getComponentCount() > 0) {
                                                if (c.getClientProperty("POPUP_LEFT") != null) {
                                                    p.show(c, c.getWidth() + 1, 0);
                                                } else {
                                                    p.show(c, 0, c.getHeight() + 1);
                                                }
                                            }
                                        }
                                    }
                                };
                                JButton loadButton = new JButton(OQLConsoleView.this.loadAction);
                                loadButton.setHideActionText(true);
                                OQLConsoleView.this.saveAction = new AbstractAction(Bundle.OQLConsoleView_SaveAction(), OQLQueries.ICON_SAVE){
                                    {
                                        this.putValue("ShortDescription", Bundle.OQLConsoleView_SaveActionTooltip());
                                    }

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        if (e.getSource() instanceof JComponent) {
                                            JPopupMenu p = new JPopupMenu();
                                            OQLQueries.instance().populateSaveQuery(p, OQLConsoleView.this.currentQuery, OQLConsoleView.this.editor.getScript(), new OQLQueries.Handler(){

                                                @Override
                                                protected void querySelected(OQLSupport.Query query) {
                                                    OQLConsoleView.this.currentQuery = query;
                                                }
                                            });
                                            JComponent c = (JComponent)e.getSource();
                                            if (p.getComponentCount() > 0) {
                                                if (c.getClientProperty("POPUP_LEFT") != null) {
                                                    p.show(c, c.getWidth() + 1, 0);
                                                } else {
                                                    p.show(c, 0, c.getHeight() + 1);
                                                }
                                            }
                                        }
                                    }
                                };
                                JButton saveButton = new JButton(OQLConsoleView.this.saveAction);
                                saveButton.setHideActionText(true);
                                OQLConsoleView.this.editAction = new AbstractAction(Bundle.OQLConsoleView_EditAction(), Icons.getIcon((String)"HeapWalkerIcons.Rules")){
                                    {
                                        this.putValue("ShortDescription", Bundle.OQLConsoleView_EditActionTooltip());
                                    }

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        OptionsDisplayer.getDefault().open("HeapViewerOptions");
                                    }
                                };
                                JButton editButton = new JButton(OQLConsoleView.this.editAction);
                                editButton.setHideActionText(true);
                                OQLConsoleView.this.progressToolbar = ProfilerToolbar.create((boolean)false);
                                OQLConsoleView.this.progressToolbar.getComponent().setVisible(false);
                                OQLConsoleView.this.progressToolbar.addSpace(2);
                                OQLConsoleView.this.progressToolbar.addSeparator();
                                OQLConsoleView.this.progressToolbar.addSpace(5);
                                OQLConsoleView.this.progressLabel = (JLabel)new GrayLabel(Bundle.OQLConsoleView_ExecutingProgress());
                                OQLConsoleView.this.progressToolbar.add((Component)OQLConsoleView.this.progressLabel);
                                OQLConsoleView.this.progressToolbar.addSpace(8);
                                OQLConsoleView.this.progressBar = new JProgressBar(0){

                                    @Override
                                    public Dimension getPreferredSize() {
                                        Dimension dim = super.getMinimumSize();
                                        dim.width = 120;
                                        return dim;
                                    }

                                    @Override
                                    public Dimension getMinimumSize() {
                                        return this.getPreferredSize();
                                    }

                                    @Override
                                    public Dimension getMaximumSize() {
                                        return this.getPreferredSize();
                                    }
                                };
                                OQLConsoleView.this.progressToolbar.add((Component)OQLConsoleView.this.progressBar);
                                OQLConsoleView.this.resultsToolbar = ProfilerToolbar.create((boolean)false);
                                OQLConsoleView.this.resultsToolbar.addSpace(2);
                                OQLConsoleView.this.resultsToolbar.addSeparator();
                                OQLConsoleView.this.resultsToolbar.addSpace(5);
                                OQLConsoleView.this.resultsToolbar.add((Component)new GrayLabel(Bundle.OQLConsoleView_Results()));
                                OQLConsoleView.this.resultsToolbar.addSpace(3);
                                ButtonGroup resultsBG = new ButtonGroup();
                                OQLConsoleView.this.rObjects = new JToggleButton(Icons.getIcon((String)"ProfilerIcons.TabHotSpots"), true){

                                    @Override
                                    protected void fireItemStateChanged(ItemEvent e) {
                                        if (e.getStateChange() == 1) {
                                            if (OQLConsoleView.this.resultsContainer != null) {
                                                ((CardLayout)OQLConsoleView.this.resultsContainer.getLayout()).first(OQLConsoleView.this.resultsContainer);
                                            }
                                            if (OQLConsoleView.this.objectsToolbar != null) {
                                                OQLConsoleView.this.objectsToolbar.getComponent().setVisible(true);
                                            }
                                            if (OQLConsoleView.this.pluginsToolbar != null) {
                                                OQLConsoleView.this.pluginsToolbar.getComponent().setVisible(true);
                                            }
                                            if (OQLConsoleView.this.htmlToolbar != null) {
                                                OQLConsoleView.this.htmlToolbar.getComponent().setVisible(false);
                                            }
                                        }
                                    }
                                };
                                OQLConsoleView.this.rObjects.putClientProperty("JButton.buttonType", "segmented");
                                OQLConsoleView.this.rObjects.putClientProperty("JButton.segmentPosition", "first");
                                OQLConsoleView.this.rObjects.setToolTipText(Bundle.OQLConsoleView_ObjectsTooltip());
                                resultsBG.add(OQLConsoleView.this.rObjects);
                                OQLConsoleView.this.resultsToolbar.add((Component)OQLConsoleView.this.rObjects);
                                OQLConsoleView.this.rHTML = new JToggleButton(Icons.getIcon((String)"HeapWalkerIcons.Properties")){

                                    @Override
                                    protected void fireItemStateChanged(ItemEvent e) {
                                        if (e.getStateChange() == 1) {
                                            if (OQLConsoleView.this.resultsContainer != null) {
                                                ((CardLayout)OQLConsoleView.this.resultsContainer.getLayout()).last(OQLConsoleView.this.resultsContainer);
                                            }
                                            if (OQLConsoleView.this.objectsToolbar != null) {
                                                OQLConsoleView.this.objectsToolbar.getComponent().setVisible(false);
                                            }
                                            if (OQLConsoleView.this.pluginsToolbar != null) {
                                                OQLConsoleView.this.pluginsToolbar.getComponent().setVisible(false);
                                            }
                                            if (OQLConsoleView.this.htmlToolbar != null) {
                                                OQLConsoleView.this.htmlToolbar.getComponent().setVisible(true);
                                            }
                                        }
                                    }
                                };
                                OQLConsoleView.this.rHTML.putClientProperty("JButton.buttonType", "segmented");
                                OQLConsoleView.this.rHTML.putClientProperty("JButton.segmentPosition", "last");
                                OQLConsoleView.this.rHTML.setToolTipText(Bundle.OQLConsoleView_HTMLTooltip());
                                resultsBG.add(OQLConsoleView.this.rHTML);
                                OQLConsoleView.this.resultsToolbar.add((Component)OQLConsoleView.this.rHTML);
                                OQLConsoleView.this.objectsToolbar = ProfilerToolbar.create((boolean)false);
                                OQLConsoleView.this.objectsToolbar.addSpace(8);
                                OQLConsoleView.this.objectsToolbar.add((Component)new GrayLabel(Bundle.OQLConsoleView_Aggregation()));
                                OQLConsoleView.this.objectsToolbar.addSpace(2);
                                final ButtonGroup aggregationBG = new ButtonGroup();
                                class AggregationButton
                                extends JToggleButton {
                                    private final Aggregation aggregation;

                                    AggregationButton(Aggregation aggregation, boolean selected) {
                                        super(aggregation.getIcon(), selected);
                                        this.aggregation = aggregation;
                                        this.setToolTipText(aggregation.toString());
                                        aggregationBG.add(this);
                                    }

                                    @Override
                                    protected void fireItemStateChanged(ItemEvent e) {
                                        if (e.getStateChange() == 1 && this.aggregation != null) {
                                            OQLConsoleView.this.setAggregation(this.aggregation);
                                        }
                                    }
                                }
                                OQLConsoleView.this.tbPackages = new AggregationButton(Aggregation.PACKAGES, Aggregation.PACKAGES.equals((Object)OQLConsoleView.this.aggregation));
                                OQLConsoleView.this.tbPackages.putClientProperty("JButton.buttonType", "segmented");
                                OQLConsoleView.this.tbPackages.putClientProperty("JButton.segmentPosition", "first");
                                OQLConsoleView.this.objectsToolbar.add((Component)OQLConsoleView.this.tbPackages);
                                OQLConsoleView.this.tbClasses = new AggregationButton(Aggregation.CLASSES, Aggregation.CLASSES.equals((Object)OQLConsoleView.this.aggregation));
                                OQLConsoleView.this.tbClasses.putClientProperty("JButton.buttonType", "segmented");
                                OQLConsoleView.this.tbClasses.putClientProperty("JButton.segmentPosition", "middle");
                                OQLConsoleView.this.objectsToolbar.add((Component)OQLConsoleView.this.tbClasses);
                                OQLConsoleView.this.tbInstances = new AggregationButton(Aggregation.INSTANCES, Aggregation.INSTANCES.equals((Object)OQLConsoleView.this.aggregation));
                                OQLConsoleView.this.tbInstances.putClientProperty("JButton.buttonType", "segmented");
                                OQLConsoleView.this.tbInstances.putClientProperty("JButton.segmentPosition", "last");
                                OQLConsoleView.this.objectsToolbar.add((Component)OQLConsoleView.this.tbInstances);
                                OQLConsoleView.this.resultsToolbar.add(OQLConsoleView.this.objectsToolbar);
                                if (OQLConsoleView.this.objectsView.hasPlugins()) {
                                    OQLConsoleView.this.pluginsToolbar = ProfilerToolbar.create((boolean)false);
                                    OQLConsoleView.this.pluginsToolbar.addSpace(8);
                                    OQLConsoleView.this.pluginsToolbar.add((Component)new GrayLabel(Bundle.OQLConsoleView_Details()));
                                    OQLConsoleView.this.pluginsToolbar.addSpace(2);
                                    OQLConsoleView.this.pluginsToolbar.add(OQLConsoleView.this.objectsView.getToolbar());
                                    OQLConsoleView.this.resultsToolbar.add(OQLConsoleView.this.pluginsToolbar);
                                }
                                OQLConsoleView.this.htmlToolbar = ProfilerToolbar.create((boolean)false);
                                OQLConsoleView.this.htmlToolbar.getComponent().setVisible(false);
                                OQLConsoleView.this.htmlToolbar.addSpace(8);
                                OQLConsoleView.this.htmlToolbar.add((Component)new GrayLabel(Bundle.OQLConsoleView_ResultsLimit()));
                                OQLConsoleView.this.htmlToolbar.addSpace(3);
                                TreeSet<Integer> limits = new TreeSet<Integer>();
                                limits.add(10);
                                limits.add(100);
                                limits.add(1000);
                                limits.add(RESULTS_LIMIT);
                                OQLConsoleView.this.limitCombo = new JComboBox<Object>(limits.toArray());
                                OQLConsoleView.this.limitCombo.setSelectedItem(RESULTS_LIMIT);
                                final NumberFormat numberFormat = NumberFormat.getNumberInstance();
                                final ListCellRenderer rendererImpl = OQLConsoleView.this.limitCombo.getRenderer();
                                ListCellRenderer renderer = new ListCellRenderer(){

                                    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                                        return rendererImpl.getListCellRendererComponent(list, numberFormat.format(value), index, isSelected, cellHasFocus);
                                    }
                                };
                                OQLConsoleView.this.limitCombo.setRenderer(renderer);
                                OQLConsoleView.this.htmlToolbar.add((Component)OQLConsoleView.this.limitCombo);
                                OQLConsoleView.this.resultsToolbar.add(OQLConsoleView.this.htmlToolbar);
                                OQLConsoleView.this.toolbar.add(OQLConsoleView.this.resultsToolbar);
                                OQLConsoleView.this.toolbar.add(OQLConsoleView.this.progressToolbar);
                                OQLConsoleView.this.editor = new OQLEditorComponent(oqlEngine){

                                    @Override
                                    protected void validityChanged(boolean valid) {
                                        OQLConsoleView.this.queryValid = valid;
                                        OQLConsoleView.this.updateUIState();
                                    }
                                };
                                OQLConsoleView.this.resultsContainer = new JPanel(new CardLayout());
                                OQLConsoleView.this.resultsContainer.add(OQLConsoleView.this.objectsView.getComponent());
                                OQLConsoleView.this.resultsContainer.add(new ResultsView(OQLConsoleView.this.htmlView.getComponent()));
                                JExtendedSplitPane masterSplit = new JExtendedSplitPane(0, true, (Component)OQLConsoleView.this.resultsContainer, (Component)new EditorView(OQLConsoleView.this.editor));
                                BasicSplitPaneDivider masterDivider = ((BasicSplitPaneUI)masterSplit.getUI()).getDivider();
                                masterDivider.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, SEPARATOR_COLOR));
                                masterDivider.setDividerSize(6);
                                masterSplit.setBorder(BorderFactory.createEmptyBorder());
                                masterSplit.setResizeWeight(0.7);
                                OQLConsoleView.this.component.removeAll();
                                OQLConsoleView.this.component.add((Component)masterSplit, "Center");
                                Container parent = OQLConsoleView.this.component.getParent();
                                if (parent != null) {
                                    parent.invalidate();
                                    parent.revalidate();
                                    parent.repaint();
                                }
                                OQLConsoleView.this.toolbar.getComponent().repaint();
                                OQLConsoleView.this.updateUIState();
                            }
                        });
                    }
                    catch (Exception e) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                JLabel l = new JLabel(Bundle.OQLConsoleView_EngineNotAvailable(), 0);
                                l.setEnabled(false);
                                l.setOpaque(false);
                                OQLConsoleView.this.component.removeAll();
                                OQLConsoleView.this.component.add((Component)l, "Center");
                                Container parent = OQLConsoleView.this.component.getParent();
                                if (parent != null) {
                                    parent.invalidate();
                                    parent.revalidate();
                                    parent.repaint();
                                }
                            }
                        });
                    }
                }
            }
        });
    }

    private synchronized void setAggregation(Aggregation aggregation) {
        boolean instancesInvolved = Aggregation.INSTANCES.equals((Object)aggregation) || Aggregation.INSTANCES.equals((Object)this.aggregation);
        this.aggregation = aggregation;
        if (instancesInvolved) {
            boolean countVisible = this.objectsView.isColumnVisible(DataType.COUNT);
            if (Aggregation.INSTANCES.equals((Object)aggregation)) {
                this.countVisible1 = countVisible;
                this.objectsView.setColumnVisible(DataType.COUNT, this.countVisible2);
            } else {
                this.countVisible2 = countVisible;
                this.objectsView.setColumnVisible(DataType.COUNT, this.countVisible1);
            }
        }
        this.objectsView.reloadView();
    }

    private synchronized Aggregation getAggregation() {
        return this.aggregation;
    }

    private void executeQuery() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OQLConsoleView.this.oqlExecutor.runQuery(OQLConsoleView.this.editor.getScript(), true, true, (Integer)OQLConsoleView.this.limitCombo.getSelectedItem());
            }
        });
    }

    private void cancelQuery() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OQLConsoleView.this.oqlExecutor.cancelQuery();
            }
        });
    }

    private void queryStarted(final BoundedRangeModel model) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OQLConsoleView.this.updateUIState();
                OQLConsoleView.this.resultsToolbar.getComponent().setVisible(false);
                OQLConsoleView.this.progressToolbar.getComponent().setVisible(true);
                OQLConsoleView.this.progressBar.setModel(model);
                OQLConsoleView.this.objectsView.reloadView();
                OQLConsoleView.this.htmlView.setText(OQLConsoleView.this.oqlExecutor.getQueryHTML());
            }
        });
    }

    private void queryFinished(final boolean hasObjectsResults, final boolean hasHTMLResults, final String errorMessage) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OQLConsoleView.this.updateUIState();
                OQLConsoleView.this.progressToolbar.getComponent().setVisible(false);
                OQLConsoleView.this.resultsToolbar.getComponent().setVisible(true);
                OQLConsoleView.this.progressBar.setModel(new DefaultBoundedRangeModel(0, 0, 0, 0));
                OQLConsoleView.this.objectsView.reloadView();
                String queryHTML = OQLConsoleView.this.oqlExecutor.getQueryHTML();
                OQLConsoleView.this.htmlView.setText(errorMessage != null ? errorMessage : queryHTML);
                if (errorMessage != null || !hasObjectsResults && hasHTMLResults) {
                    OQLConsoleView.this.rHTML.setSelected(true);
                }
            }
        });
    }

    private void updateUIState() {
        int scriptLength = this.editor.getScript().trim().length();
        this.saveAction.setEnabled(scriptLength > 0);
        if (this.oqlExecutor.isQueryRunning()) {
            this.runAction.setEnabled(false);
            this.cancelAction.setEnabled(true);
            this.loadAction.setEnabled(false);
            this.editor.setEditable(false);
        } else {
            this.runAction.setEnabled(scriptLength > 0 && this.queryValid);
            this.cancelAction.setEnabled(false);
            this.loadAction.setEnabled(true);
            this.editor.setEditable(true);
        }
    }

    private static HeapViewerNode getNode(URL url, HeapContext context) {
        String urls = url.toString();
        if (HeapUtils.isInstance(urls)) {
            Instance instance = HeapUtils.instanceFromHtml(urls, context.getFragment().getHeap());
            if (instance != null) {
                return new InstanceNode(instance);
            }
            ProfilerDialogs.displayError((String)Bundle.OQLConsoleView_CannotResolveInstanceMsg());
        } else if (HeapUtils.isClass(urls)) {
            JavaClass javaClass = HeapUtils.classFromHtml(urls, context.getFragment().getHeap());
            if (javaClass != null) {
                return new ClassNode(javaClass);
            }
            ProfilerDialogs.displayError((String)Bundle.OQLConsoleView_CannotResolveClassMsg());
        }
        return null;
    }

    private class ResultsView
    extends JPanel {
        ResultsView(JComponent results) {
            super(new BorderLayout());
            this.add((Component)new ScrollableContainer(results), "Center");
        }
    }

    private class EditorView
    extends JPanel {
        EditorView(OQLEditorComponent editor) {
            super(new BorderLayout());
            editor.clearScrollBorders();
            this.add((Component)editor, "Center");
            JToolBar controls = new JToolBar(1);
            controls.setFloatable(false);
            controls.setBorderPainted(false);
            controls.add(OQLConsoleView.this.runAction);
            controls.add(OQLConsoleView.this.cancelAction);
            controls.addSeparator();
            controls.add(OQLConsoleView.this.loadAction).putClientProperty("POPUP_LEFT", Boolean.TRUE);
            controls.add(OQLConsoleView.this.saveAction).putClientProperty("POPUP_LEFT", Boolean.TRUE);
            controls.add(OQLConsoleView.this.editAction).putClientProperty("POPUP_LEFT", Boolean.TRUE);
            JPanel controlsContainer = new JPanel(new BorderLayout());
            controlsContainer.setOpaque(false);
            controlsContainer.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, UIManager.getColor("Separator.foreground")), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
            controlsContainer.add((Component)controls, "Center");
            this.add((Component)controlsContainer, "West");
            int h = controls.getComponent((int)0).getPreferredSize().height;
            this.setMinimumSize(new Dimension(0, h += controls.getComponent((int)1).getPreferredSize().height + 2));
        }
    }

    private static enum Aggregation {
        PACKAGES(Bundle.OQLConsoleView_Packages(), Icons.getIcon((String)"LanguageIcons.Package")),
        CLASSES(Bundle.OQLConsoleView_Classes(), Icons.getIcon((String)"LanguageIcons.Class")),
        INSTANCES(Bundle.OQLConsoleView_Instances(), Icons.getIcon((String)"LanguageIcons.Instance"));

        private final String aggregationName;
        private final Icon aggregationIcon;

        private Aggregation(String aggregationName, Icon aggregationIcon) {
            this.aggregationName = aggregationName;
            this.aggregationIcon = aggregationIcon;
        }

        public String toString() {
            return this.aggregationName;
        }

        public Icon getIcon() {
            return this.aggregationIcon;
        }
    }
}

