/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.llvm;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.graal.code.CGlobalDataInfo;
import com.oracle.svm.core.graal.code.CGlobalDataReference;
import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.core.graal.code.SubstrateCallingConventionType;
import com.oracle.svm.core.graal.code.SubstrateDebugInfoBuilder;
import com.oracle.svm.core.graal.code.SubstrateNodeLIRBuilder;
import com.oracle.svm.core.graal.llvm.LLVMFeature;
import com.oracle.svm.core.graal.llvm.SubstrateLLVMGenerationResult;
import com.oracle.svm.core.graal.llvm.SubstrateLLVMGenerator;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.nodes.CGlobalDataLoadAddressNode;
import com.oracle.svm.core.nodes.SafepointCheckNode;
import com.oracle.svm.core.thread.Safepoint;
import com.oracle.svm.shadowed.org.bytedeco.javacpp.LLVM;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.core.common.calc.Condition;
import org.graalvm.compiler.core.llvm.LLVMGenerator;
import org.graalvm.compiler.core.llvm.LLVMUtils;
import org.graalvm.compiler.core.llvm.NodeLLVMBuilder;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.LoweredCallTargetNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.cfg.Block;

public class SubstrateNodeLLVMBuilder
extends NodeLLVMBuilder
implements SubstrateNodeLIRBuilder {
    private long nextCGlobalId = 0L;
    private final RuntimeConfiguration runtimeConfiguration;

    protected SubstrateNodeLLVMBuilder(StructuredGraph graph, LLVMGenerator gen, RuntimeConfiguration runtimeConfiguration) {
        super(graph, gen, SubstrateDebugInfoBuilder::new);
        this.runtimeConfiguration = runtimeConfiguration;
        gen.getBuilder().setPersonalityFunction(gen.getFunction((ResolvedJavaMethod)LLVMFeature.getPersonalityStub()));
        for (String alias : this.getGenerator().getAliases()) {
            this.builder.addAlias(alias);
        }
    }

    public void emitCGlobalDataLoadAddress(CGlobalDataLoadAddressNode node) {
        CGlobalDataInfo dataInfo = node.getDataInfo();
        String symbolName = dataInfo.isSymbolReference() ? dataInfo.getData().symbolName : "global_" + this.builder.getFunctionName() + "#" + this.nextCGlobalId++;
        ((SubstrateLLVMGenerationResult)this.gen.getLLVMResult()).recordCGlobal(new CGlobalDataReference(dataInfo), symbolName);
        this.setResult((ValueNode)node, this.builder.buildPtrToInt(this.builder.getExternalSymbol(symbolName), this.builder.longType()));
    }

    public Variable emitReadReturnAddress() {
        LLVM.LLVMValueRef returnAddress = this.getLIRGeneratorTool().getBuilder().buildReturnAddress(this.getLIRGeneratorTool().getBuilder().constantInt(0));
        return new LLVMUtils.LLVMVariable(returnAddress);
    }

    private SubstrateLLVMGenerator getGenerator() {
        return (SubstrateLLVMGenerator)this.gen;
    }

    protected int getParamIndex(int index) {
        int offset = this.getGenerator().isEntryPoint() ? 0 : LLVMFeature.SPECIAL_REGISTER_COUNT;
        return offset + index;
    }

    protected LLVM.LLVMValueRef[] getCallArguments(NodeInputList<ValueNode> arguments, CallingConvention.Type callType, ResolvedJavaMethod targetMethod) {
        LLVM.LLVMValueRef[] args = super.getCallArguments(arguments, callType, targetMethod);
        return this.gen.getCallArguments(args, callType, targetMethod);
    }

    protected LLVM.LLVMTypeRef[] getUnknownCallArgumentTypes(NodeInputList<ValueNode> arguments, LoweredCallTargetNode callTarget) {
        LLVM.LLVMTypeRef[] types = super.getUnknownCallArgumentTypes(arguments, callTarget);
        return this.gen.getUnknownCallArgumentTypes(types, callTarget.callType());
    }

    protected LLVM.LLVMValueRef emitCondition(LogicNode condition) {
        if (condition instanceof SafepointCheckNode) {
            LLVM.LLVMValueRef threadData = this.getGenerator().getSpecialRegister(LLVMFeature.THREAD_POINTER_INDEX);
            threadData = this.builder.buildIntToPtr(threadData, this.builder.rawPointerType());
            LLVM.LLVMValueRef safepointCounterAddr = this.builder.buildGEP(threadData, new LLVM.LLVMValueRef[]{this.builder.constantInt(Math.toIntExact(Safepoint.getThreadLocalSafepointRequestedOffset()))});
            LLVM.LLVMValueRef safepointCount = this.builder.buildLoad(safepointCounterAddr, this.builder.intType());
            safepointCount = this.builder.buildSub(safepointCount, this.builder.constantInt(1));
            this.builder.buildStore(safepointCount, safepointCounterAddr);
            return this.builder.buildICmp(Condition.LE, safepointCount, this.builder.constantInt(0));
        }
        return super.emitCondition(condition);
    }

    protected LLVM.LLVMValueRef emitCall(Invoke invoke, LoweredCallTargetNode callTarget, LLVM.LLVMValueRef callee, long patchpointId, LLVM.LLVMValueRef ... args) {
        if (!SubstrateBackend.hasJavaFrameAnchor((CallTargetNode)callTarget)) {
            return super.emitCall(invoke, callTarget, callee, patchpointId, args);
        }
        LLVM.LLVMValueRef anchor = this.llvmOperand((Node)SubstrateBackend.getJavaFrameAnchor((CallTargetNode)callTarget));
        anchor = this.builder.buildIntToPtr(anchor, this.builder.rawPointerType());
        LLVM.LLVMValueRef lastSPAddr = this.builder.buildGEP(anchor, new LLVM.LLVMValueRef[]{this.builder.constantInt(this.runtimeConfiguration.getJavaFrameAnchorLastSPOffset())});
        Register stackPointer = this.gen.getRegisterConfig().getFrameRegister();
        this.builder.buildStore(this.builder.buildReadRegister(this.builder.register(stackPointer.name)), lastSPAddr);
        if (((Boolean)SubstrateOptions.MultiThreaded.getValue()).booleanValue()) {
            LLVM.LLVMValueRef threadLocalArea = this.getGenerator().getSpecialRegister(LLVMFeature.THREAD_POINTER_INDEX);
            LLVM.LLVMValueRef statusIndex = this.builder.constantInt(this.runtimeConfiguration.getVMThreadStatusOffset());
            LLVM.LLVMValueRef statusAddress = this.builder.buildGEP(this.builder.buildIntToPtr(threadLocalArea, this.builder.rawPointerType()), new LLVM.LLVMValueRef[]{statusIndex});
            this.builder.buildStore(this.builder.constantInt(3), statusAddress);
        }
        LLVM.LLVMValueRef wrapper = this.builder.createJNIWrapper(callee, patchpointId, args.length, this.runtimeConfiguration.getJavaFrameAnchorLastIPOffset(), this.gen.getBlockEnd((Block)this.gen.getCurrentBlock()));
        LLVM.LLVMValueRef[] newArgs = new LLVM.LLVMValueRef[args.length + 2];
        newArgs[0] = anchor;
        newArgs[1] = callee;
        System.arraycopy(args, 0, newArgs, 2, args.length);
        return super.emitCall(invoke, callTarget, wrapper, patchpointId, newArgs);
    }

    public void emitReadExceptionObject(ValueNode node) {
        super.emitReadExceptionObject(node);
        LLVM.LLVMValueRef retrieveExceptionFunction = this.gen.getRetrieveExceptionFunction();
        LLVM.LLVMValueRef[] arguments = this.gen.getCallArguments(new LLVM.LLVMValueRef[0], (CallingConvention.Type)SubstrateCallingConventionType.JavaCall, null);
        LLVM.LLVMValueRef exception = this.builder.buildCall(retrieveExceptionFunction, arguments);
        this.setResult(node, exception);
    }
}

