/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.llvm;

import com.oracle.svm.core.graal.code.CGlobalDataReference;
import com.oracle.svm.core.graal.code.SubstrateDataBuilder;
import java.util.HashMap;
import java.util.Map;
import jdk.vm.ci.code.site.DataSectionReference;
import jdk.vm.ci.code.site.Reference;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.llvm.LLVMGenerationResult;
import org.graalvm.compiler.nodes.StructuredGraph;

public class SubstrateLLVMGenerationResult
extends LLVMGenerationResult {
    private Map<CGlobalDataReference, String> cGlobals = new HashMap<CGlobalDataReference, String>();

    public SubstrateLLVMGenerationResult(ResolvedJavaMethod method) {
        super(method);
    }

    public void recordCGlobal(CGlobalDataReference reference, String symbolName) {
        this.cGlobals.put(reference, symbolName);
    }

    public void populate(CompilationResult compilationResult, StructuredGraph graph) {
        super.populate(compilationResult, graph);
        this.cGlobals.forEach((reference, symbolName) -> compilationResult.recordDataPatchWithNote(0, (Reference)reference, symbolName));
        SubstrateDataBuilder dataBuilder = new SubstrateDataBuilder();
        this.getConstants().forEach((constant, symbolName) -> {
            DataSectionReference reference = compilationResult.getDataSection().insertData(dataBuilder.createDataItem(constant));
            compilationResult.recordDataPatchWithNote(0, (Reference)reference, symbolName);
        });
    }
}

