/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.llvm;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.core.graal.llvm.LLVMAddressLowering;
import com.oracle.svm.core.graal.llvm.LLVMOptions;
import com.oracle.svm.core.graal.llvm.SubstrateLLVMGenerationResult;
import com.oracle.svm.core.graal.llvm.SubstrateLLVMGenerator;
import com.oracle.svm.core.graal.llvm.SubstrateNodeLLVMBuilder;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.shadowed.org.bytedeco.javacpp.LLVM;
import java.util.Collections;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.CompilationRequest;
import jdk.vm.ci.code.CompiledCode;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.code.site.InfopointReason;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.llvm.LLVMCompilerBackend;
import org.graalvm.compiler.core.llvm.LLVMGenerationProvider;
import org.graalvm.compiler.core.llvm.LLVMGenerationResult;
import org.graalvm.compiler.core.llvm.LLVMGenerator;
import org.graalvm.compiler.core.llvm.LLVMIRBuilder;
import org.graalvm.compiler.core.llvm.NodeLLVMBuilder;
import org.graalvm.compiler.lir.asm.CompilationResultBuilderFactory;
import org.graalvm.compiler.lir.phases.LIRSuites;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.Phase;
import org.graalvm.compiler.phases.common.AddressLoweringPhase;
import org.graalvm.compiler.phases.util.Providers;

public class SubstrateLLVMBackend
extends SubstrateBackend
implements LLVMGenerationProvider {
    public SubstrateLLVMBackend(Providers providers) {
        super(providers);
    }

    public Phase newAddressLoweringPhase(CodeCacheProvider codeCache) {
        return new AddressLoweringPhase((AddressLoweringPhase.AddressLowering)new LLVMAddressLowering());
    }

    public CompilationResult createJNITrampolineMethod(ResolvedJavaMethod method, CompilationIdentifier identifier, RegisterValue threadArg, int threadIsolateOffset, RegisterValue methodIdArg, int methodObjEntryPointOffset) {
        LLVM.LLVMValueRef jumpAddressAddress;
        CompilationResult result = new CompilationResult(identifier);
        LLVMGenerationResult genResult = new LLVMGenerationResult(method);
        LLVM.LLVMContextRef context = LLVM.LLVMContextCreate();
        SubstrateLLVMGenerator generator = new SubstrateLLVMGenerator(this.getProviders(), genResult, method, context, 0);
        LLVMIRBuilder builder = generator.getBuilder();
        builder.addMainFunction(generator.getLLVMFunctionType(method, true));
        builder.setAttribute(builder.getMainFunction(), -1L, "naked");
        LLVM.LLVMBasicBlockRef block = builder.appendBasicBlock("main");
        builder.positionAtEnd(block);
        long startPatchpointId = LLVMIRBuilder.nextPatchpointId.getAndIncrement();
        builder.buildStackmap(builder.constantLong(startPatchpointId), new LLVM.LLVMValueRef[0]);
        if (((Boolean)SubstrateOptions.SpawnIsolates.getValue()).booleanValue()) {
            LLVM.LLVMValueRef thread = builder.buildInlineGetRegister(threadArg.getRegister().name);
            LLVM.LLVMValueRef heapBaseAddress = builder.buildGEP(builder.buildIntToPtr(thread, builder.rawPointerType()), new LLVM.LLVMValueRef[]{builder.constantInt(threadIsolateOffset)});
            LLVM.LLVMValueRef heapBase = builder.buildLoad(heapBaseAddress, builder.rawPointerType());
            LLVM.LLVMValueRef methodId = builder.buildInlineGetRegister(methodIdArg.getRegister().name);
            LLVM.LLVMValueRef methodBase = builder.buildGEP(builder.buildIntToPtr(heapBase, builder.rawPointerType()), new LLVM.LLVMValueRef[]{builder.buildIntToPtr(methodId, builder.rawPointerType())});
            jumpAddressAddress = builder.buildGEP(methodBase, new LLVM.LLVMValueRef[]{builder.constantInt(methodObjEntryPointOffset)});
        } else {
            LLVM.LLVMValueRef methodBase = builder.buildInlineGetRegister(methodIdArg.getRegister().name);
            jumpAddressAddress = builder.buildGEP(builder.buildIntToPtr(methodBase, builder.rawPointerType()), new LLVM.LLVMValueRef[]{builder.constantInt(methodObjEntryPointOffset)});
        }
        LLVM.LLVMValueRef jumpAddress = builder.buildLoad(jumpAddressAddress, builder.rawPointerType());
        builder.buildInlineJump(jumpAddress);
        builder.buildUnreachable();
        genResult.setBitcode(generator.getBuilder().getBitcode());
        byte[] bitcode = genResult.getBitcode();
        result.setTargetCode(bitcode, bitcode.length);
        result.setMethods(method, Collections.emptySet());
        result.recordInfopoint(NumUtil.safeToInt((long)startPatchpointId), null, InfopointReason.METHOD_START);
        return result;
    }

    protected CompiledCode createCompiledCode(ResolvedJavaMethod method, CompilationRequest compilationRequest, CompilationResult compilationResult, boolean isDefault, OptionValues options) {
        throw VMError.unimplemented();
    }

    public void emitBackEnd(StructuredGraph graph, Object stub, ResolvedJavaMethod installedCodeOwner, CompilationResult compilationResult, CompilationResultBuilderFactory factory, RegisterConfig config, LIRSuites lirSuites) {
        LLVMCompilerBackend.emitBackEnd((LLVMGenerationProvider)this, (StructuredGraph)graph, (CompilationResult)compilationResult);
    }

    public LLVMGenerator newLLVMGenerator(LLVMGenerationResult result) {
        LLVM.LLVMContextRef context = LLVM.LLVMContextCreate();
        return new SubstrateLLVMGenerator(this.getProviders(), result, result.getMethod(), context, (Integer)LLVMOptions.IncludeLLVMDebugInfo.getValue());
    }

    public NodeLLVMBuilder newNodeLLVMBuilder(StructuredGraph graph, LLVMGenerator generator) {
        return new SubstrateNodeLLVMBuilder(graph, generator, this.getRuntimeConfiguration());
    }

    public LLVMGenerationResult newLLVMGenerationResult(ResolvedJavaMethod method) {
        return new SubstrateLLVMGenerationResult(method);
    }
}

