/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.llvm;

import com.oracle.graal.pointsto.util.Timer;
import com.oracle.objectfile.ObjectFile;
import com.oracle.objectfile.SectionName;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.graal.code.CGlobalDataReference;
import com.oracle.svm.core.graal.llvm.LLVMOptions;
import com.oracle.svm.core.graal.llvm.LLVMStackMapInfo;
import com.oracle.svm.core.heap.SubstrateReferenceMap;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.c.util.FileUtils;
import com.oracle.svm.hosted.image.NativeBootImage;
import com.oracle.svm.hosted.image.NativeImageCodeCache;
import com.oracle.svm.hosted.image.NativeImageHeap;
import com.oracle.svm.hosted.image.RelocatableBuffer;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.MethodPointer;
import com.oracle.svm.shadowed.org.bytedeco.javacpp.BytePointer;
import com.oracle.svm.shadowed.org.bytedeco.javacpp.LLVM;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import jdk.vm.ci.code.ReferenceMap;
import jdk.vm.ci.code.site.Call;
import jdk.vm.ci.code.site.DataPatch;
import jdk.vm.ci.code.site.DataSectionReference;
import jdk.vm.ci.code.site.Infopoint;
import jdk.vm.ci.code.site.InfopointReason;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.llvm.LLVMUtils;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.debug.Indent;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

@Platforms(value={Platform.HOSTED_ONLY.class})
public class LLVMNativeImageCodeCache
extends NativeImageCodeCache {
    private static final String SYMBOL_PREFIX = ObjectFile.getNativeFormat() == ObjectFile.Format.MACH_O ? "_" : "";
    private HostedMethod[] methodIndex;
    private final Path basePath;
    private final FileWriter stackMapDump;
    private int batchSize;
    private Map<String, Integer> textSymbolOffsets = new HashMap<String, Integer>();
    private Map<Integer, String> offsetToSymbolMap = new TreeMap<Integer, String>();

    public LLVMNativeImageCodeCache(Map<HostedMethod, CompilationResult> compilations, NativeImageHeap imageHeap, Platform targetPlatform, Path tempDir) {
        super(compilations, imageHeap, targetPlatform);
        try {
            this.basePath = tempDir.resolve("llvm");
            Files.createDirectory(this.basePath, new FileAttribute[0]);
            this.stackMapDump = LLVMOptions.DumpLLVMStackMap.hasBeenSet() ? new FileWriter((String)LLVMOptions.DumpLLVMStackMap.getValue()) : null;
        }
        catch (IOException e) {
            throw new GraalError((Throwable)e);
        }
    }

    public int getCodeCacheSize() {
        return 0;
    }

    public void layoutMethods(DebugContext debug, String imageName) {
        try (Indent indent = debug.logAndIndent("layout methods");){
            int numBatches;
            try (Timer.StopTimer t = new Timer(imageName, "(bitcode)").start();){
                this.writeBitcode();
            }
            try (Timer.StopTimer t = new Timer(imageName, "(prelink)").start();){
                numBatches = this.createBitcodeBatches(debug);
            }
            t = new Timer(imageName, "(llvm)").start();
            try {
                this.compileBitcodeBatches(debug, numBatches);
            }
            finally {
                if (t != null) {
                    t.close();
                }
            }
            t = new Timer(imageName, "(postlink)").start();
            try {
                this.linkCompiledBatches(debug, numBatches);
            }
            finally {
                if (t != null) {
                    t.close();
                }
            }
        }
        catch (IOException e) {
            throw new GraalError((Throwable)e);
        }
    }

    private static <T> T readSection(Path path, SectionName sectionName, BiFunction<LLVM.LLVMSectionIteratorRef, LLVM.LLVMObjectFileRef, T> callback) {
        byte[] bytes;
        try {
            bytes = Files.readAllBytes(path);
        }
        catch (IOException e) {
            throw new GraalError((Throwable)e);
        }
        LLVM.LLVMMemoryBufferRef buffer = LLVM.LLVMCreateMemoryBufferWithMemoryRangeCopy((BytePointer)new BytePointer(bytes), (long)bytes.length, (BytePointer)new BytePointer(""));
        LLVM.LLVMObjectFileRef objectFile = LLVM.LLVMCreateObjectFile((LLVM.LLVMMemoryBufferRef)buffer);
        T result = null;
        LLVM.LLVMSectionIteratorRef sectionIterator = LLVM.LLVMGetSections((LLVM.LLVMObjectFileRef)objectFile);
        while (LLVM.LLVMIsSectionIteratorAtEnd((LLVM.LLVMObjectFileRef)objectFile, (LLVM.LLVMSectionIteratorRef)sectionIterator) == 0) {
            String currentSectionName;
            BytePointer sectionNamePointer = LLVM.LLVMGetSectionName((LLVM.LLVMSectionIteratorRef)sectionIterator);
            String string = currentSectionName = sectionNamePointer != null ? sectionNamePointer.getString() : "";
            if (currentSectionName.startsWith(sectionName.getFormatDependentName(ObjectFile.getNativeFormat()))) {
                result = callback.apply(sectionIterator, objectFile);
            }
            LLVM.LLVMMoveToNextSection((LLVM.LLVMSectionIteratorRef)sectionIterator);
        }
        LLVM.LLVMDisposeSectionIterator((LLVM.LLVMSectionIteratorRef)sectionIterator);
        LLVM.LLVMDisposeObjectFile((LLVM.LLVMObjectFileRef)objectFile);
        return result;
    }

    private Long readTextSection(LLVM.LLVMSectionIteratorRef sectionIterator, LLVM.LLVMObjectFileRef objectFile) {
        long codeSize = LLVM.LLVMGetSectionSize((LLVM.LLVMSectionIteratorRef)sectionIterator);
        long sectionAddress = LLVM.LLVMGetSectionAddress((LLVM.LLVMSectionIteratorRef)sectionIterator);
        LLVM.LLVMSymbolIteratorRef symbolIterator = LLVM.LLVMGetSymbols((LLVM.LLVMObjectFileRef)objectFile);
        while (LLVM.LLVMIsSymbolIteratorAtEnd((LLVM.LLVMObjectFileRef)objectFile, (LLVM.LLVMSymbolIteratorRef)symbolIterator) == 0) {
            if (LLVM.LLVMGetSectionContainsSymbol((LLVM.LLVMSectionIteratorRef)sectionIterator, (LLVM.LLVMSymbolIteratorRef)symbolIterator) == 1) {
                int offset = NumUtil.safeToInt((long)(LLVM.LLVMGetSymbolAddress((LLVM.LLVMSymbolIteratorRef)symbolIterator) - sectionAddress));
                String symbolName = LLVM.LLVMGetSymbolName((LLVM.LLVMSymbolIteratorRef)symbolIterator).getString();
                this.textSymbolOffsets.put(symbolName, offset);
                this.offsetToSymbolMap.put(offset, symbolName);
            }
            LLVM.LLVMMoveToNextSymbol((LLVM.LLVMSymbolIteratorRef)symbolIterator);
        }
        LLVM.LLVMDisposeSymbolIterator((LLVM.LLVMSymbolIteratorRef)symbolIterator);
        return codeSize;
    }

    private LLVMStackMapInfo readStackMapSection(LLVM.LLVMSectionIteratorRef sectionIterator, LLVM.LLVMObjectFileRef objectFile) {
        BytePointer stackMap = LLVM.LLVMGetSectionContents((LLVM.LLVMSectionIteratorRef)sectionIterator).limit(LLVM.LLVMGetSectionSize((LLVM.LLVMSectionIteratorRef)sectionIterator));
        return new LLVMStackMapInfo(stackMap.asByteBuffer());
    }

    private void storeMethodOffsets(long codeSize) throws IOException {
        List sortedMethodOffsets = this.textSymbolOffsets.values().stream().distinct().sorted().collect(Collectors.toList());
        this.textSymbolOffsets.forEach((symbol, offset) -> {
            if (symbol.startsWith(SYMBOL_PREFIX + "__llvm_jni_wrapper_")) {
                sortedMethodOffsets.remove(offset);
            }
        });
        sortedMethodOffsets.add(NumUtil.safeToInt((long)codeSize));
        this.compilations.entrySet().parallelStream().forEach(entry -> {
            HostedMethod method = (HostedMethod)entry.getKey();
            String methodSymbolName = SYMBOL_PREFIX + SubstrateUtil.uniqueShortName((ResolvedJavaMethod)method);
            int offset = this.textSymbolOffsets.get(methodSymbolName);
            int nextFunctionStartOffset = (Integer)sortedMethodOffsets.get(sortedMethodOffsets.indexOf(offset) + 1);
            int functionSize = nextFunctionStartOffset - offset;
            CompilationResult compilation = (CompilationResult)entry.getValue();
            compilation.setTargetCode(null, functionSize);
            method.setCodeAddressOffset(offset);
        });
        this.compilations.forEach((method, compilation) -> this.compilationsByStart.put(method.getCodeAddressOffset(), compilation));
        if (this.stackMapDump != null) {
            this.stackMapDump.write("Offsets\n=======\n");
        }
        for (int i = 0; i < sortedMethodOffsets.size() - 1; ++i) {
            int startOffset = (Integer)sortedMethodOffsets.get(i);
            int endOffset = (Integer)sortedMethodOffsets.get(i + 1);
            CompilationResult compilationResult = (CompilationResult)this.compilationsByStart.get(startOffset);
            assert (startOffset + compilationResult.getTargetCodeSize() == endOffset) : compilationResult.getName();
            if (this.stackMapDump == null) continue;
            String methodName = this.offsetToSymbolMap.get(startOffset);
            this.stackMapDump.write("[" + startOffset + "] " + methodName + " (" + compilationResult.getTargetCodeSize() + ")\n");
        }
        HostedMethod firstMethod = (HostedMethod)this.getFirstCompilation().getMethods()[0];
        this.buildRuntimeMetadata(MethodPointer.factory((ResolvedJavaMethod)firstMethod), (UnsignedWord)WordFactory.signed((long)codeSize));
    }

    private void readStackMap(LLVMStackMapInfo info, int batchId) {
        IntStream.range(this.getBatchStart(batchId), this.getBatchEnd(batchId)).forEach(id -> {
            HostedMethod method = this.methodIndex[id];
            String methodSymbolName = SYMBOL_PREFIX + SubstrateUtil.uniqueShortName((ResolvedJavaMethod)method);
            CompilationResult compilation = (CompilationResult)this.compilations.get(method);
            long startPatchpointID = compilation.getInfopoints().stream().filter((Predicate<Infopoint>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$readStackMap$3(jdk.vm.ci.code.site.Infopoint ), (Ljdk/vm/ci/code/site/Infopoint;)Z)()).findFirst().orElseThrow((Supplier<GraalError>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$readStackMap$4(java.lang.String ), ()Lorg/graalvm/compiler/debug/GraalError;)((String)methodSymbolName)).pcOffset;
            int totalFrameSize = NumUtil.safeToInt((long)(info.getFunctionStackSize(startPatchpointID) + (long)LLVMUtils.TargetSpecific.get().getCallFrameSeparation()));
            compilation.setTotalFrameSize(totalFrameSize);
            StringBuilder patchpointsDump = null;
            if (this.stackMapDump != null) {
                patchpointsDump = new StringBuilder();
                patchpointsDump.append(methodSymbolName);
                patchpointsDump.append(" -> f");
                patchpointsDump.append(id);
                patchpointsDump.append(" (");
                patchpointsDump.append(totalFrameSize);
                patchpointsDump.append(")\n");
            }
            ArrayList<Call> newInfopoints = new ArrayList<Call>();
            for (Infopoint infopoint : compilation.getInfopoints()) {
                if (!(infopoint instanceof Call)) continue;
                Call call = (Call)infopoint;
                for (int actualPcOffset : info.getPatchpointOffsets(call.pcOffset)) {
                    SubstrateReferenceMap referenceMap = new SubstrateReferenceMap();
                    info.forEachStatepointOffset(call.pcOffset, actualPcOffset, (o, b) -> referenceMap.markReferenceAtOffset(o.intValue(), b.intValue(), ((Boolean)SubstrateOptions.SpawnIsolates.getValue()).booleanValue()));
                    call.debugInfo.setReferenceMap((ReferenceMap)referenceMap);
                    if (LLVMOptions.DumpLLVMStackMap.hasBeenSet()) {
                        patchpointsDump.append("  [");
                        patchpointsDump.append(actualPcOffset);
                        patchpointsDump.append("] -> ");
                        patchpointsDump.append(call.target != null ? ((HostedMethod)call.target).format("%H.%n") : "???");
                        patchpointsDump.append(" (");
                        patchpointsDump.append(call.pcOffset);
                        patchpointsDump.append(") ");
                        referenceMap.dump(patchpointsDump);
                        patchpointsDump.append("\n");
                    }
                    newInfopoints.add(new Call(call.target, actualPcOffset, call.size, call.direct, call.debugInfo));
                }
            }
            compilation.clearInfopoints();
            newInfopoints.forEach(arg_0 -> ((CompilationResult)compilation).addInfopoint(arg_0));
            if (this.stackMapDump != null) {
                try {
                    this.stackMapDump.write(patchpointsDump.toString());
                }
                catch (IOException e) {
                    throw new GraalError((Throwable)e);
                }
            }
        });
    }

    private Path getBitcodePath(int id) {
        return this.basePath.resolve(this.getBitcodeFilename(id));
    }

    private String getBitcodeFilename(int id) {
        return "f" + id + ".bc";
    }

    private String getBatchBitcodeFilename(int id) {
        return (this.batchSize == 1 ? "f" : "b") + id + ".bc";
    }

    private String getBatchOptimizedFilename(int id) {
        return (this.batchSize == 1 ? "f" : "b") + id + "o.bc";
    }

    private Path getBatchCompiledPath(int id) {
        return this.basePath.resolve(this.getBatchCompiledFilename(id));
    }

    private String getBatchCompiledFilename(int id) {
        return (this.batchSize == 1 ? "f" : "b") + id + ".o";
    }

    private Path getLinkedPath() {
        return this.basePath.resolve(LLVMNativeImageCodeCache.getLinkedFilename());
    }

    private static String getLinkedFilename() {
        return "llvm.o";
    }

    private int getBatchStart(int id) {
        return id * this.batchSize;
    }

    private int getBatchEnd(int id) {
        return Math.min((id + 1) * this.batchSize, this.methodIndex.length);
    }

    public void patchMethods(DebugContext debug, RelocatableBuffer relocs, ObjectFile objectFile) {
        ObjectFile.Element rodataSection = objectFile.elementForName(SectionName.RODATA.getFormatDependentName(objectFile.getFormat()));
        ObjectFile.Element dataSection = objectFile.elementForName(SectionName.DATA.getFormatDependentName(objectFile.getFormat()));
        for (CompilationResult result : this.getCompilations().values()) {
            for (DataPatch dataPatch : result.getDataPatches()) {
                String symbolName;
                int offset;
                CGlobalDataReference reference;
                if (dataPatch.reference instanceof CGlobalDataReference) {
                    reference = (CGlobalDataReference)dataPatch.reference;
                    if (reference.getDataInfo().isSymbolReference()) {
                        objectFile.createUndefinedSymbol(reference.getDataInfo().getData().symbolName, 0, true);
                    }
                    offset = reference.getDataInfo().getOffset();
                    symbolName = (String)dataPatch.note;
                    if (objectFile.getOrCreateSymbolTable().getSymbol(symbolName) != null) continue;
                    objectFile.createDefinedSymbol(symbolName, dataSection, (long)offset + 0L, 0, false, true);
                    continue;
                }
                if (!(dataPatch.reference instanceof DataSectionReference)) continue;
                reference = (DataSectionReference)dataPatch.reference;
                offset = reference.getOffset();
                symbolName = (String)dataPatch.note;
                if (objectFile.getOrCreateSymbolTable().getSymbol(symbolName) != null) continue;
                objectFile.createDefinedSymbol(symbolName, rodataSection, (long)offset, 0, false, true);
            }
        }
    }

    public void writeCode(RelocatableBuffer buffer) {
    }

    private void writeBitcode() {
        this.methodIndex = new HostedMethod[this.compilations.size()];
        UninterruptibleUtils.AtomicInteger num = new UninterruptibleUtils.AtomicInteger(-1);
        this.compilations.entrySet().parallelStream().forEach(entry -> {
            int id = num.incrementAndGet();
            this.methodIndex[id] = (HostedMethod)entry.getKey();
            try (FileOutputStream fos = new FileOutputStream(this.getBitcodePath(id).toString());){
                fos.write(((CompilationResult)entry.getValue()).getTargetCode());
            }
            catch (IOException e) {
                throw new GraalError((Throwable)e);
            }
        });
    }

    private int createBitcodeBatches(DebugContext debug) {
        int numBatches;
        int maxThreads = NativeImageOptions.getMaximumNumberOfConcurrentThreads((OptionValues)((OptionValues)ImageSingletons.lookup(HostedOptionValues.class)));
        Integer parallelismLevel = (Integer)LLVMOptions.LLVMBatchesPerThread.getValue();
        switch (parallelismLevel) {
            case -1: {
                numBatches = this.methodIndex.length;
                break;
            }
            case 0: {
                numBatches = 1;
                break;
            }
            default: {
                numBatches = maxThreads * parallelismLevel;
            }
        }
        this.batchSize = this.methodIndex.length / numBatches + (this.methodIndex.length % numBatches == 0 ? 0 : 1);
        if (parallelismLevel != -1) {
            numBatches -= (numBatches * this.batchSize - this.methodIndex.length) / this.batchSize;
            IntStream.range(0, numBatches).parallel().forEach(batchId -> {
                List<String> batchInputs = IntStream.range(this.getBatchStart(batchId), this.getBatchEnd(batchId)).mapToObj(this::getBitcodeFilename).collect(Collectors.toList());
                this.llvmLink(debug, this.getBatchBitcodeFilename(batchId), batchInputs);
            });
        }
        return numBatches;
    }

    private void compileBitcodeBatches(DebugContext debug, int numBatches) throws IOException {
        if (this.stackMapDump != null) {
            this.stackMapDump.write("\nPatchpoints\n===========\n");
        }
        IntStream.range(0, numBatches).parallel().forEach(batchId -> {
            this.llvmOptimize(debug, this.getBatchOptimizedFilename(batchId), this.getBatchBitcodeFilename(batchId));
            this.llvmCompile(debug, this.getBatchCompiledFilename(batchId), this.getBatchOptimizedFilename(batchId));
            LLVMStackMapInfo stackMap = LLVMNativeImageCodeCache.readSection(this.getBatchCompiledPath(batchId), SectionName.LLVM_STACKMAPS, this::readStackMapSection);
            this.readStackMap(stackMap, batchId);
        });
    }

    private void linkCompiledBatches(DebugContext debug, int numBatches) throws IOException {
        List<String> compiledBatches = IntStream.range(0, numBatches).mapToObj(this::getBatchCompiledFilename).collect(Collectors.toList());
        this.nativeLink(debug, LLVMNativeImageCodeCache.getLinkedFilename(), compiledBatches);
        long codeSize = LLVMNativeImageCodeCache.readSection(this.getLinkedPath(), SectionName.TEXT, this::readTextSection);
        this.storeMethodOffsets(codeSize);
    }

    private void llvmOptimize(DebugContext debug, String outputPath, String inputPath) {
        try {
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add("opt");
            if (!Platform.includedIn(Platform.AMD64.class)) {
                cmd.add("-disable-inlining");
                cmd.add("-O2");
            }
            cmd.add("-mem2reg");
            cmd.add("-rewrite-statepoints-for-gc");
            cmd.add("-always-inline");
            cmd.add("-o");
            cmd.add(outputPath);
            cmd.add(inputPath);
            ProcessBuilder pb = new ProcessBuilder(cmd);
            pb.directory(this.basePath.toFile());
            pb.redirectErrorStream(true);
            Process p = pb.start();
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            FileUtils.drainInputStream((InputStream)p.getInputStream(), (OutputStream)output);
            int status = p.waitFor();
            if (status != 0) {
                debug.log("%s", (Object)((Object)output).toString());
                throw new GraalError("LLVM optimization failed for " + this.getFunctionName(inputPath) + ": " + status);
            }
        }
        catch (IOException | InterruptedException e) {
            throw new GraalError((Throwable)e);
        }
    }

    private void llvmCompile(DebugContext debug, String outputPath, String inputPath) {
        try {
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(LLVMOptions.CustomLLC.hasBeenSet() ? (String)LLVMOptions.CustomLLC.getValue() : "llc");
            cmd.add("-relocation-model=pic");
            cmd.add("-march=" + LLVMUtils.TargetSpecific.get().getLLVMArchName());
            cmd.addAll(LLVMUtils.TargetSpecific.get().getLLCAdditionalOptions());
            cmd.add("-O2");
            cmd.add("-filetype=obj");
            cmd.add("-o");
            cmd.add(outputPath);
            cmd.add(inputPath);
            ProcessBuilder pb = new ProcessBuilder(cmd);
            pb.directory(this.basePath.toFile());
            pb.redirectErrorStream(true);
            Process p = pb.start();
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            FileUtils.drainInputStream((InputStream)p.getInputStream(), (OutputStream)output);
            int status = p.waitFor();
            if (status != 0) {
                debug.log("%s", (Object)((Object)output).toString());
                throw new GraalError("LLVM compilation failed for " + this.getFunctionName(inputPath) + ": " + status);
            }
        }
        catch (IOException | InterruptedException e) {
            throw new GraalError((Throwable)e);
        }
    }

    private void llvmLink(DebugContext debug, String outputPath, List<String> inputPaths) {
        try {
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add("llvm-link");
            cmd.add("-v");
            cmd.add("-o");
            cmd.add(outputPath);
            cmd.addAll(inputPaths);
            ProcessBuilder pb = new ProcessBuilder(cmd);
            pb.directory(this.basePath.toFile());
            pb.redirectErrorStream(true);
            Process p = pb.start();
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            FileUtils.drainInputStream((InputStream)p.getInputStream(), (OutputStream)output);
            int status = p.waitFor();
            if (status != 0) {
                debug.log("%s", (Object)((Object)output).toString());
                throw new GraalError("LLVM linking failed into " + this.getFunctionName(outputPath) + ": " + status);
            }
        }
        catch (IOException | InterruptedException e) {
            throw new GraalError((Throwable)e);
        }
    }

    private void nativeLink(DebugContext debug, String outputPath, List<String> inputPaths) {
        try {
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add("ld");
            cmd.add("-r");
            cmd.add("-o");
            cmd.add(outputPath);
            cmd.addAll(inputPaths);
            ProcessBuilder pb = new ProcessBuilder(cmd);
            pb.directory(this.basePath.toFile());
            pb.redirectErrorStream(true);
            Process p = pb.start();
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            FileUtils.drainInputStream((InputStream)p.getInputStream(), (OutputStream)output);
            int status = p.waitFor();
            if (status != 0) {
                debug.log("%s", (Object)((Object)output).toString());
                throw new GraalError("Native linking failed into " + this.getFunctionName(outputPath) + ": " + status);
            }
        }
        catch (IOException | InterruptedException e) {
            throw new GraalError((Throwable)e);
        }
    }

    private String getFunctionName(String fileName) {
        String function;
        if (fileName.equals("llvm.o")) {
            function = "the final object file";
        } else {
            char type = fileName.charAt(0);
            String idString = fileName.substring(1, fileName.indexOf(46));
            if (idString.charAt(idString.length() - 1) == 'o') {
                idString = idString.substring(0, idString.length() - 1);
            }
            int id = Integer.parseInt(idString);
            switch (type) {
                case 'f': {
                    function = this.methodIndex[id].getQualifiedName();
                    break;
                }
                case 'b': {
                    function = "batch " + id + " (f" + this.getBatchStart(id) + "-f" + this.getBatchEnd(id) + "). Use -H:LLVMBatchesPerThread=-1 to compile each method individually.";
                    break;
                }
                default: {
                    throw VMError.shouldNotReachHere();
                }
            }
        }
        return function + " (" + this.basePath.resolve(fileName).toString() + ")";
    }

    public NativeBootImage.NativeTextSectionImpl getTextSectionImpl(RelocatableBuffer buffer, ObjectFile objectFile, NativeImageCodeCache codeCache) {
        return new NativeBootImage.NativeTextSectionImpl(buffer, objectFile, codeCache){

            protected void defineMethodSymbol(String name, boolean global, ObjectFile.Element section, HostedMethod method, CompilationResult result) {
                this.objectFile.createUndefinedSymbol(name, 0, true);
            }
        };
    }

    public String[] getCCInputFiles(Path tempDirectory, String imageName) {
        String bitcodeFileName = this.getLinkedPath().toString();
        String relocatableFileName = tempDirectory.resolve(imageName + ObjectFile.getFilenameSuffix()).toString();
        return new String[]{relocatableFileName, bitcodeFileName};
    }

    private static /* synthetic */ GraalError lambda$readStackMap$4(String methodSymbolName) {
        return new GraalError("no method start infopoint: " + methodSymbolName);
    }

    private static /* synthetic */ boolean lambda$readStackMap$3(Infopoint ip) {
        return ip.reason == InfopointReason.METHOD_START;
    }
}

