/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.llvm;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.graal.GraalFeature;
import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.core.graal.code.SubstrateBackendFactory;
import com.oracle.svm.core.graal.code.SubstrateLoweringProviderFactory;
import com.oracle.svm.core.graal.llvm.LLVMNativeImageCodeCache;
import com.oracle.svm.core.graal.llvm.LLVMOptions;
import com.oracle.svm.core.graal.llvm.LLVMPersonalityFunction;
import com.oracle.svm.core.graal.llvm.SubstrateLLVMBackend;
import com.oracle.svm.core.graal.llvm.SubstrateLLVMLoweringProvider;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.nodes.ExceptionStateNode;
import com.oracle.svm.core.graal.nodes.ReadExceptionObjectNode;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.nodes.CFunctionEpilogueNode;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.c.util.FileUtils;
import com.oracle.svm.hosted.code.CompileQueue;
import com.oracle.svm.hosted.image.NativeImageCodeCache;
import com.oracle.svm.hosted.image.NativeImageCodeCacheFactory;
import com.oracle.svm.hosted.image.NativeImageHeap;
import com.oracle.svm.hosted.meta.HostedMethod;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Executable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import jdk.vm.ci.meta.JavaMethod;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.java.LoadExceptionObjectNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.TargetGraphBuilderPlugins;
import org.graalvm.compiler.replacements.llvm.LLVMGraphBuilderPlugins;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CLibrary;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.DeprecatedPlatform;
import org.graalvm.nativeimage.impl.InternalPlatform;
import org.graalvm.word.Pointer;

@AutomaticFeature
@CLibrary(value="m")
@Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class, InternalPlatform.LINUX_JNI_AND_SUBSTITUTIONS.class, DeprecatedPlatform.DARWIN_SUBSTITUTION.class, InternalPlatform.DARWIN_JNI_AND_SUBSTITUTIONS.class})
public class LLVMFeature
implements Feature,
GraalFeature {
    private static HostedMethod personalityStub;
    public static HostedMethod retrieveExceptionMethod;
    public static final int SPECIAL_REGISTER_COUNT;
    public static final int THREAD_POINTER_INDEX;
    public static final int HEAP_BASE_INDEX;
    private static final int MIN_LLVM_MAJOR_VERSION = 8;
    private static final int MIN_LLVM_MINOR_VERSION = 0;

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return ((String)SubstrateOptions.CompilerBackend.getValue()).equals("llvm");
    }

    public static HostedMethod getPersonalityStub() {
        return personalityStub;
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        if (!LLVMOptions.CustomLLC.hasBeenSet()) {
            LLVMFeature.checkLLVMVersion();
        }
        ImageSingletons.add(SubstrateBackendFactory.class, (Object)new SubstrateBackendFactory(){

            public SubstrateBackend newBackend(Providers newProviders) {
                return new SubstrateLLVMBackend(newProviders);
            }
        });
        ImageSingletons.add(SubstrateLoweringProviderFactory.class, SubstrateLLVMLoweringProvider::new);
        ImageSingletons.add(NativeImageCodeCacheFactory.class, (Object)new NativeImageCodeCacheFactory(){

            public NativeImageCodeCache newCodeCache(CompileQueue compileQueue, NativeImageHeap heap, Platform platform, Path tempDir) {
                return new LLVMNativeImageCodeCache(compileQueue.getCompilations(), heap, platform, tempDir);
            }
        });
        ImageSingletons.add(SnippetRuntime.ExceptionUnwind.class, (Object)new SnippetRuntime.ExceptionUnwind(){

            public void unwindException(Pointer callerSP) {
                LLVMPersonalityFunction.raiseException();
            }
        });
        ImageSingletons.add(TargetGraphBuilderPlugins.class, (Object)new LLVMGraphBuilderPlugins());
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        FeatureImpl.BeforeAnalysisAccessImpl accessImpl = (FeatureImpl.BeforeAnalysisAccessImpl)access;
        try {
            accessImpl.registerAsCompiled((Executable)LLVMPersonalityFunction.class.getMethod("retrieveException", new Class[0]));
        }
        catch (NoSuchMethodException e) {
            throw VMError.shouldNotReachHere();
        }
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        FeatureImpl.BeforeCompilationAccessImpl accessImpl = (FeatureImpl.BeforeCompilationAccessImpl)access;
        personalityStub = accessImpl.getUniverse().lookup((JavaMethod)LLVMPersonalityFunction.getPersonalityStub());
        try {
            retrieveExceptionMethod = accessImpl.getMetaAccess().lookupJavaMethod((Executable)LLVMPersonalityFunction.class.getMethod("retrieveException", new Class[0]));
        }
        catch (NoSuchMethodException e) {
            throw VMError.shouldNotReachHere();
        }
    }

    public void registerLowerings(RuntimeConfiguration runtimeConfig, OptionValues options, Iterable<DebugHandlersFactory> factories, Providers providers, SnippetReflectionProvider snippetReflection, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings, boolean hosted) {
        lowerings.put(LoadExceptionObjectNode.class, new LLVMLoadExceptionObjectLowering());
    }

    private static void checkLLVMVersion() {
        String version = LLVMFeature.getLLVMVersion();
        String[] splitVersion = version.split("\\.");
        assert (splitVersion.length == 3);
        int majorVersion = Integer.parseInt(splitVersion[0]);
        int minorVersion = Integer.parseInt(splitVersion[1]);
        if (majorVersion < 8 || majorVersion == 8 && minorVersion < 0) {
            throw UserError.abort((String)("Unsupported LLVM version: " + version + ". Supported versions are LLVM " + 8 + "." + 0 + ".0 and above"));
        }
    }

    private static String getLLVMVersion() {
        int status;
        String output = null;
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add("llvm-config");
            cmd.add("--version");
            ProcessBuilder pb = new ProcessBuilder(cmd);
            pb.redirectErrorStream(true);
            Process p = pb.start();
            FileUtils.drainInputStream((InputStream)p.getInputStream(), (OutputStream)os);
            status = p.waitFor();
            output = ((Object)os).toString().trim();
        }
        catch (IOException | InterruptedException e) {
            status = -1;
        }
        if (status != 0) {
            throw UserError.abort((String)"Using the LLVM backend requires LLVM to be installed on your machine.");
        }
        return output;
    }

    static {
        int firstArgumentOffset = 0;
        THREAD_POINTER_INDEX = (Boolean)SubstrateOptions.MultiThreaded.getValue() != false ? firstArgumentOffset++ : -1;
        HEAP_BASE_INDEX = (Boolean)SubstrateOptions.SpawnIsolates.getValue() != false ? firstArgumentOffset++ : -1;
        SPECIAL_REGISTER_COUNT = firstArgumentOffset;
    }

    private static class LLVMLoadExceptionObjectLowering
    implements NodeLoweringProvider<LoadExceptionObjectNode> {
        private LLVMLoadExceptionObjectLowering() {
        }

        public void lower(LoadExceptionObjectNode node, LoweringTool tool) {
            FrameState exceptionState = node.stateAfter();
            assert (exceptionState != null);
            StructuredGraph graph = node.graph();
            FixedWithNextNode readRegNode = (FixedWithNextNode)graph.add((Node)new ReadExceptionObjectNode(StampFactory.objectNonNull()));
            graph.replaceFixedWithFixed((FixedWithNextNode)node, readRegNode);
            CFunctionEpilogueNode cFunctionEpilogueNode = new CFunctionEpilogueNode();
            graph.add((Node)cFunctionEpilogueNode);
            graph.addAfterFixed(readRegNode, (FixedNode)cFunctionEpilogueNode);
            cFunctionEpilogueNode.lower(tool);
            graph.addAfterFixed(readRegNode, (FixedNode)graph.add((Node)new ExceptionStateNode(exceptionState)));
        }
    }
}

