/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.llvm;

import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.core.llvm.LLVMUtils;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.phases.common.AddressLoweringPhase;

public class LLVMAddressLowering
extends AddressLoweringPhase.AddressLowering {
    public AddressNode lower(ValueNode base, ValueNode offset) {
        LLVMAddressNode ret = new LLVMAddressNode(base, offset);
        StructuredGraph graph = base.graph();
        return (AddressNode)graph.unique((Node)ret);
    }

    @NodeInfo
    public static class LLVMAddressNode
    extends AddressNode
    implements LIRLowerable {
        public static final NodeClass<LLVMAddressNode> TYPE = NodeClass.create(LLVMAddressNode.class);
        @Node.Input
        private ValueNode base;
        @Node.Input
        private ValueNode index;

        public LLVMAddressNode(ValueNode base, ValueNode offset) {
            super(TYPE);
            this.base = base;
            this.index = offset;
        }

        public ValueNode getBase() {
            return this.base;
        }

        public ValueNode getIndex() {
            return this.index;
        }

        public long getMaxConstantDisplacement() {
            return Long.MAX_VALUE;
        }

        public void generate(NodeLIRBuilderTool generator) {
            LIRGeneratorTool gen = generator.getLIRGeneratorTool();
            generator.setResult((ValueNode)this, (Value)new LLVMUtils.LLVMAddressValue((ValueKind)gen.getLIRKind(this.stamp(NodeView.DEFAULT)), generator.operand((Node)this.base), generator.operand((Node)this.index)));
        }
    }
}

