/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.llvm;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.AutomaticFeature;
import java.util.Collections;
import java.util.List;
import org.graalvm.compiler.core.llvm.LLVMUtils;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
@Platforms(value={Platform.AARCH64.class})
class LLVMAArch64TargetSpecificFeature
implements Feature {
    private static final int AARCH64_FP_IDX = 29;
    private static final int AARCH64_SP_IDX = 31;

    LLVMAArch64TargetSpecificFeature() {
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return ((String)SubstrateOptions.CompilerBackend.getValue()).equals("llvm");
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(LLVMUtils.TargetSpecific.class, (Object)new LLVMUtils.TargetSpecific(){

            public String getRegisterInlineAsm(String register) {
                return "MOV $0, " + this.getLLVMRegisterName(register);
            }

            public String getJumpInlineAsm() {
                return "BR $0";
            }

            public String getLLVMArchName() {
                return "aarch64";
            }

            public int getCallFrameSeparation() {
                return 0;
            }

            public int getFramePointerOffset() {
                return -2 * FrameAccess.wordSize();
            }

            public int getStackPointerDwarfRegNum() {
                return 31;
            }

            public int getFramePointerDwarfRegNum() {
                return 29;
            }

            public List<String> getLLCAdditionalOptions() {
                return Collections.singletonList("--frame-pointer=all");
            }

            public String getLLVMRegisterName(String register) {
                return register.replace("r", "x");
            }
        });
    }
}

