/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.launcher;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.graalvm.launcher.AbstractLanguageLauncher;
import org.graalvm.launcher.Launcher;
import org.graalvm.options.OptionCategory;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;

public class LLVMLauncher
extends AbstractLanguageLauncher {
    String[] programArgs;
    File file;
    private Launcher.VersionAction versionAction = Launcher.VersionAction.None;
    private boolean printToolchainPath = false;

    public static void main(String[] args) {
        new LLVMLauncher().launch(args);
    }

    protected void launch(Context.Builder contextBuilder) {
        System.exit(this.execute(contextBuilder));
    }

    protected String getLanguageId() {
        return "llvm";
    }

    protected List<String> preprocessArguments(List<String> arguments, Map<String, String> polyglotOptions) {
        ArrayList<String> unrecognizedOptions = new ArrayList<String>();
        ArrayList<String> path = new ArrayList<String>();
        ArrayList<String> libs = new ArrayList<String>();
        ListIterator<String> iterator = arguments.listIterator();
        block20: while (iterator.hasNext()) {
            String argument;
            String option = iterator.next();
            if (option.length() < 2 || !option.startsWith("-")) {
                iterator.previous();
                break;
            }
            switch (option) {
                case "--": {
                    continue block20;
                }
                case "--show-version": {
                    this.versionAction = Launcher.VersionAction.PrintAndContinue;
                    continue block20;
                }
                case "--version": {
                    this.versionAction = Launcher.VersionAction.PrintAndExit;
                    continue block20;
                }
                case "--print-toolchain-path": {
                    this.printToolchainPath = true;
                    continue block20;
                }
            }
            String optionName = option;
            int equalsIndex = option.indexOf(61);
            if (equalsIndex > 0) {
                argument = option.substring(equalsIndex + 1);
                optionName = option.substring(0, equalsIndex);
            } else {
                argument = iterator.hasNext() ? iterator.next() : null;
            }
            switch (optionName) {
                case "-L": {
                    if (argument == null) {
                        throw this.abort("Missing argument for " + optionName);
                    }
                    path.add(argument);
                    iterator.remove();
                    if (equalsIndex >= 0) continue block20;
                    iterator.previous();
                    iterator.remove();
                    continue block20;
                }
                case "--lib": {
                    if (argument == null) {
                        throw this.abort("Missing argument for " + optionName);
                    }
                    libs.add(argument);
                    iterator.remove();
                    if (equalsIndex >= 0) continue block20;
                    iterator.previous();
                    iterator.remove();
                    continue block20;
                }
            }
            unrecognizedOptions.add(option);
            if (equalsIndex >= 0 || argument == null) continue;
            iterator.previous();
        }
        if (this.printToolchainPath) {
            polyglotOptions.put("llvm.printToolchainPath", "true");
        }
        if (!path.isEmpty()) {
            polyglotOptions.put("llvm.libraryPath", path.stream().collect(Collectors.joining(":")));
        }
        if (!libs.isEmpty()) {
            polyglotOptions.put("llvm.libraries", libs.stream().collect(Collectors.joining(":")));
        }
        if (this.file == null && iterator.hasNext()) {
            this.file = Paths.get(iterator.next(), new String[0]).toFile();
        }
        List<String> programArgumentsList = arguments.subList(iterator.nextIndex(), arguments.size());
        this.programArgs = programArgumentsList.toArray(new String[programArgumentsList.size()]);
        return unrecognizedOptions;
    }

    protected void validateArguments(Map<String, String> polyglotOptions) {
        if (this.file == null && this.versionAction != Launcher.VersionAction.PrintAndExit && !this.printToolchainPath) {
            throw this.abort("No bitcode file provided.", 6);
        }
    }

    protected void printHelp(OptionCategory maxCategory) {
        System.out.println();
        System.out.println("Usage: lli [OPTION]... [FILE] [PROGRAM ARGS]");
        System.out.println("Run LLVM bitcode files on the GraalVM's lli.\n");
        System.out.println("Mandatory arguments to long options are mandatory for short options too.\n");
        System.out.println("Options:");
        LLVMLauncher.printOption("-L <path>", "set path where lli searches for libraries");
        LLVMLauncher.printOption("--lib <libraries>", "add library (*.bc or precompiled library *.so/*.dylib)");
        LLVMLauncher.printOption("--version", "print the version and exit");
        LLVMLauncher.printOption("--show-version", "print the version and continue");
        LLVMLauncher.printOption("--print-toolchain-path", "print the toolchain path and exit");
    }

    protected void collectArguments(Set<String> args) {
        args.addAll(Arrays.asList("-L", "--lib", "--version", "--show-version"));
    }

    protected static void printOption(String option, String description) {
        String opt;
        if (option.length() >= 22) {
            System.out.println(String.format("%s%s", "  ", option));
            opt = "";
        } else {
            opt = option;
        }
        System.out.println(String.format("  %-22s%s", opt, description));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int execute(Context.Builder contextBuilder) {
        contextBuilder.arguments(this.getLanguageId(), this.programArgs);
        try (Context context = contextBuilder.build();){
            this.runVersionAction(this.versionAction, context.getEngine());
            if (this.printToolchainPath) {
                context.getBindings(this.getLanguageId()).getMember("__sulong_print_toolchain_path").execute(new Object[0]);
                int n2 = 0;
                return n2;
            }
            Value library = context.eval(Source.newBuilder((String)this.getLanguageId(), (File)this.file).build());
            if (!library.canExecute()) {
                throw this.abort("no main function found");
            }
            int n = library.execute(new Object[0]).asInt();
            return n;
        }
        catch (PolyglotException e) {
            if (e.isExit()) {
                throw e;
            }
            if (e.isInternalError()) throw e;
            LLVMLauncher.printStackTraceSkipTrailingHost(e);
            return -1;
        }
        catch (IOException e) {
            throw this.abort(String.format("Error loading file '%s' (%s)", this.file, e.getMessage()));
        }
    }

    private static void printStackTraceSkipTrailingHost(PolyglotException e) {
        PolyglotException.StackFrame s2;
        ArrayList<PolyglotException.StackFrame> stackTrace = new ArrayList<PolyglotException.StackFrame>();
        for (PolyglotException.StackFrame s2 : e.getPolyglotStackTrace()) {
            stackTrace.add(s2);
        }
        ListIterator iterator = stackTrace.listIterator(stackTrace.size());
        while (iterator.hasPrevious() && (s2 = (PolyglotException.StackFrame)iterator.previous()).isHostFrame()) {
            iterator.remove();
        }
        System.err.println(e.isHostException() ? e.asHostException().toString() : e.getMessage());
        for (PolyglotException.StackFrame s2 : stackTrace) {
            System.err.println("\tat " + s2);
        }
    }
}

