/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.core.ui.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.graalvm.visualvm.core.snapshot.RegisteredSnapshotCategories;
import org.graalvm.visualvm.core.snapshot.SnapshotCategory;
import org.graalvm.visualvm.lib.profiler.api.ProfilerDialogs;
import org.openide.awt.Mnemonics;
import org.openide.awt.StatusDisplayer;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;

class LoadRecentSnapshot
implements Presenter.Menu {
    private static final String PROP_LOAD_RECENT = "LoadRecentSnapshot.item.";
    private static final int MAX_RECENT_ITEMS = 9;
    private static LoadRecentSnapshot INSTANCE;
    private final Preferences prefs = NbPreferences.forModule(LoadRecentSnapshot.class);
    private final List<String> files = LoadRecentSnapshot.loadFiles(this.prefs);
    private JMenu menu;

    public static synchronized LoadRecentSnapshot instance() {
        if (INSTANCE == null) {
            INSTANCE = new LoadRecentSnapshot();
        }
        return INSTANCE;
    }

    void setupMenu() {
        assert (SwingUtilities.isEventDispatchThread());
        this.menu.removeAll();
        if (this.files.isEmpty()) {
            this.menu.add(new JMenuItem(NbBundle.getMessage(LoadRecentSnapshot.class, (String)"LoadRecentSnapshot_NoRecentSnapshots")){
                {
                    this.setEnabled(false);
                }
            });
        } else {
            int i = 0;
            for (String file : this.files) {
                this.menu.add(new RecentFileItem(file, ++i));
            }
            this.menu.addSeparator();
            this.menu.add(new ClearRecentItem());
        }
    }

    public JMenuItem getMenuPresenter() {
        if (this.menu == null) {
            this.menu = new JMenu();
            Mnemonics.setLocalizedText((AbstractButton)this.menu, (String)NbBundle.getMessage(LoadRecentSnapshot.class, (String)"LoadRecentSnapshot_LoadRecentItem"));
        }
        this.setupMenu();
        return this.menu;
    }

    void addFile(File file) {
        String path = file.getAbsolutePath();
        if (this.files.contains(path)) {
            this.files.remove(path);
            this.files.add(0, path);
        } else {
            if (this.files.size() == 9) {
                this.files.remove(8);
            }
            this.files.add(0, path);
        }
        LoadRecentSnapshot.saveFiles(this.prefs, this.files);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LoadRecentSnapshot.this.setupMenu();
            }
        });
    }

    private static List<String> loadFiles(Preferences p) {
        ArrayList<String> f = new ArrayList<String>(9);
        int i = 0;
        String s = p.get(PROP_LOAD_RECENT + i, null);
        while (s != null && i < 9) {
            f.add(s);
            s = p.get(PROP_LOAD_RECENT + ++i, null);
        }
        return f;
    }

    private static void saveFiles(Preferences p, List<String> f) {
        int i = 0;
        while (p.get(PROP_LOAD_RECENT + i, null) != null) {
            p.remove(PROP_LOAD_RECENT + i++);
        }
        i = 0;
        for (String s : f) {
            p.put(PROP_LOAD_RECENT + i++, s);
        }
    }

    private LoadRecentSnapshot() {
    }

    private class ClearRecentItem
    extends JMenuItem {
        ClearRecentItem() {
            Mnemonics.setLocalizedText((AbstractButton)this, (String)NbBundle.getMessage(LoadRecentSnapshot.class, (String)"LoadRecentSnapshot_ClearRecentSnapshots"));
        }

        @Override
        protected void fireActionPerformed(ActionEvent e) {
            LoadRecentSnapshot.this.files.clear();
            LoadRecentSnapshot.saveFiles(LoadRecentSnapshot.this.prefs, LoadRecentSnapshot.this.files);
            LoadRecentSnapshot.this.setupMenu();
        }
    }

    private class RecentFileItem
    extends JMenuItem {
        private final String f;
        private final File file;

        RecentFileItem(String f, int idx) {
            this.f = f;
            this.file = new File(f);
            Mnemonics.setLocalizedText((AbstractButton)this, (String)("&" + idx + ". " + this.file.getName()));
        }

        @Override
        protected void fireStateChanged() {
            boolean active = this.isSelected() || this.isArmed();
            StatusDisplayer.getDefault().setStatusText(active ? this.file.getAbsolutePath() : null);
            super.fireStateChanged();
        }

        @Override
        protected void fireActionPerformed(ActionEvent e) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    if (RecentFileItem.this.file.exists()) {
                        List<SnapshotCategory> categories = RegisteredSnapshotCategories.sharedInstance().getOpenSnapshotCategories();
                        ArrayList<FileFilter> fileFilters = new ArrayList<FileFilter>();
                        for (SnapshotCategory category : categories) {
                            fileFilters.add(category.getFileFilter());
                        }
                        for (FileFilter ff : fileFilters) {
                            if (!ff.accept(RecentFileItem.this.file)) continue;
                            categories.get(fileFilters.indexOf(ff)).openSnapshot(RecentFileItem.this.file);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    LoadRecentSnapshot.this.files.remove(RecentFileItem.this.f);
                                    LoadRecentSnapshot.this.files.add(0, RecentFileItem.this.f);
                                    LoadRecentSnapshot.saveFiles(LoadRecentSnapshot.this.prefs, LoadRecentSnapshot.this.files);
                                    LoadRecentSnapshot.this.setupMenu();
                                }
                            });
                            return;
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                LoadRecentSnapshot.this.files.remove(RecentFileItem.this.f);
                                LoadRecentSnapshot.saveFiles(LoadRecentSnapshot.this.prefs, LoadRecentSnapshot.this.files);
                                LoadRecentSnapshot.this.setupMenu();
                                ProfilerDialogs.displayError((String)MessageFormat.format(NbBundle.getMessage(LoadRecentSnapshot.class, (String)"LoadRecentSnapshot_CannotLoadMsg"), RecentFileItem.this.file.getName()));
                            }
                        });
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                LoadRecentSnapshot.this.files.remove(RecentFileItem.this.f);
                                LoadRecentSnapshot.saveFiles(LoadRecentSnapshot.this.prefs, LoadRecentSnapshot.this.files);
                                LoadRecentSnapshot.this.setupMenu();
                                ProfilerDialogs.displayError((String)MessageFormat.format(NbBundle.getMessage(LoadRecentSnapshot.class, (String)"LoadRecentSnapshot_NotAvailableMsg"), RecentFileItem.this.file.getName()));
                            }
                        });
                    }
                }
            });
        }
    }
}

