/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public abstract class SIMDType {
    static final boolean LittleEndian = SIMDType.isLittleEndian();
    private static final int FLOAT32X4_BYTES_PER_ELEMENT = 4;
    private static final int FLOAT32X4_NUMBER_OF_ELEMENTS = 4;
    public static final SIMDTypeFactory<SIMDFloat32x4> FLOAT32X4_FACTORY = new SIMDTypeFactory<SIMDFloat32x4>(4, 4, "Float32x4", new SIMDFloat32x4());
    private static final int INT32X4_BYTES_PER_ELEMENT = 4;
    private static final int INT32X4_NUMBER_OF_ELEMENTS = 4;
    public static final SIMDTypeFactory<SIMDInt32x4> INT32X4_FACTORY = new SIMDTypeFactory<SIMDInt32x4>(4, 4, "Int32x4", new SIMDInt32x4());
    private static final int INT16X8_BYTES_PER_ELEMENT = 2;
    private static final int INT16X8_NUMBER_OF_ELEMENTS = 8;
    public static final SIMDTypeFactory<SIMDInt16x8> INT16X8_FACTORY = new SIMDTypeFactory<SIMDInt16x8>(2, 8, "Int16x8", new SIMDInt16x8());
    private static final int INT8X16_BYTES_PER_ELEMENT = 1;
    private static final int INT8X16_NUMBER_OF_ELEMENTS = 16;
    public static final SIMDTypeFactory<SIMDInt8x16> INT8X16_FACTORY = new SIMDTypeFactory<SIMDInt8x16>(1, 16, "Int8x16", new SIMDInt8x16());
    private static final int UINT32X4_BYTES_PER_ELEMENT = 4;
    private static final int UINT32X4_NUMBER_OF_ELEMENTS = 4;
    public static final SIMDTypeFactory<SIMDUint32x4> UINT32X4_FACTORY = new SIMDTypeFactory<SIMDUint32x4>(4, 4, "Uint32x4", new SIMDUint32x4());
    private static final int UINT16X8_BYTES_PER_ELEMENT = 2;
    private static final int UINT16X8_NUMBER_OF_ELEMENTS = 8;
    public static final SIMDTypeFactory<SIMDUint16x8> UINT16X8_FACTORY = new SIMDTypeFactory<SIMDUint16x8>(2, 8, "Uint16x8", new SIMDUint16x8());
    private static final int UINT8X16_BYTES_PER_ELEMENT = 1;
    private static final int UINT8X16_NUMBER_OF_ELEMENTS = 16;
    public static final SIMDTypeFactory<SIMDUint8x16> UINT8X16_FACTORY = new SIMDTypeFactory<SIMDUint8x16>(1, 16, "Uint8x16", new SIMDUint8x16());
    private static final int BOOL32X4_BYTES_PER_ELEMENT = 4;
    private static final int BOOL32X4_NUMBER_OF_ELEMENTS = 4;
    public static final SIMDTypeFactory<SIMDBool32x4> BOOL32X4_FACTORY = new SIMDTypeFactory<SIMDBool32x4>(4, 4, "Bool32x4", new SIMDBool32x4());
    private static final int BOOL16X8_BYTES_PER_ELEMENT = 2;
    private static final int BOOL16X8_NUMBER_OF_ELEMENTS = 8;
    public static final SIMDTypeFactory<SIMDBool16x8> BOOL16X8_FACTORY = new SIMDTypeFactory<SIMDBool16x8>(2, 8, "Bool16x8", new SIMDBool16x8());
    private static final int BOOL8X16_BYTES_PER_ELEMENT = 1;
    private static final int BOOL8X16_NUMBER_OF_ELEMENTS = 16;
    public static final SIMDTypeFactory<SIMDBool8x16> BOOL8X16_FACTORY = new SIMDTypeFactory<SIMDBool8x16>(1, 16, "Bool8x16", new SIMDBool8x16());
    public static final SIMDTypeFactory<? extends SIMDType>[] FACTORIES = SIMDType.createFactories();

    private static boolean isLittleEndian() {
        return ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN);
    }

    public abstract SIMDTypeFactory<? extends SIMDType> getFactory();

    public abstract void serialize(byte[] var1, int var2, Object var3);

    public abstract Object deserialize(byte[] var1, int var2);

    public abstract Object cast(Number var1);

    public abstract int getNumberOfElements();

    public abstract int getBytesPerElement();

    private static SIMDTypeFactory<? extends SIMDType>[] createFactories() {
        SIMDTypeFactory[] factories = new SIMDTypeFactory[]{FLOAT32X4_FACTORY, INT32X4_FACTORY, INT16X8_FACTORY, INT8X16_FACTORY, UINT32X4_FACTORY, UINT16X8_FACTORY, UINT8X16_FACTORY, BOOL32X4_FACTORY, BOOL16X8_FACTORY, BOOL8X16_FACTORY};
        for (int i = 0; i < factories.length; ++i) {
            factories[i].factoryIndex = i;
        }
        return factories;
    }

    public static SIMDTypeFactory<? extends SIMDType>[] factories() {
        return FACTORIES;
    }

    public static final class SIMDTypeFactory<T extends SIMDType>
    implements PrototypeSupplier {
        private final int bytesPerElement;
        private final int numberOfElements;
        @CompilerDirectives.CompilationFinal
        private int factoryIndex;
        private final String name;
        private final T simdType;

        SIMDTypeFactory(int bytesPerElement, int numberOfElements, String name, T simdType) {
            this.bytesPerElement = bytesPerElement;
            this.numberOfElements = numberOfElements;
            this.name = name;
            this.simdType = simdType;
        }

        public SIMDType createSimdType() {
            return this.simdType;
        }

        public int getBytesPerElement() {
            return this.bytesPerElement;
        }

        public int getNumberOfElements() {
            return this.numberOfElements;
        }

        public int getFactoryIndex() {
            return this.factoryIndex;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public DynamicObject getIntrinsicDefaultProto(JSRealm realm) {
            return realm.getSIMDTypeConstructor(this).getPrototype();
        }
    }

    public static final class SIMDBool8x16
    extends SIMDTypedBoolean {
        private SIMDBool8x16() {
        }

        public SIMDTypeFactory<SIMDBool8x16> getFactory() {
            return BOOL8X16_FACTORY;
        }

        @Override
        public int getNumberOfElements() {
            return 16;
        }

        @Override
        public int getBytesPerElement() {
            return 1;
        }
    }

    public static final class SIMDBool16x8
    extends SIMDTypedBoolean {
        private SIMDBool16x8() {
        }

        public SIMDTypeFactory<SIMDBool16x8> getFactory() {
            return BOOL16X8_FACTORY;
        }

        @Override
        public int getNumberOfElements() {
            return 8;
        }

        @Override
        public int getBytesPerElement() {
            return 2;
        }
    }

    public static final class SIMDBool32x4
    extends SIMDTypedBoolean {
        private SIMDBool32x4() {
        }

        public SIMDTypeFactory<SIMDBool32x4> getFactory() {
            return BOOL32X4_FACTORY;
        }

        @Override
        public int getNumberOfElements() {
            return 4;
        }

        @Override
        public int getBytesPerElement() {
            return 4;
        }
    }

    public static abstract class SIMDTypedBoolean
    extends SIMDType {
        @Override
        public void serialize(byte[] block, int offset, Object n) {
            throw new UnsupportedOperationException("Operation not defined for Boolean SIMD");
        }

        @Override
        public Object deserialize(byte[] block, int offset) {
            throw new UnsupportedOperationException("Operation not defined for Boolean SIMD");
        }

        @Override
        public Object cast(Number o) {
            return JSRuntime.toBoolean(o);
        }
    }

    public static abstract class SIMDTypedFloat
    extends SIMDType {
    }

    public static final class SIMDUint8x16
    extends SIMDTypedUInt {
        private SIMDUint8x16() {
        }

        public SIMDTypeFactory<SIMDUint8x16> getFactory() {
            return UINT8X16_FACTORY;
        }

        @Override
        public Object cast(Number o) {
            if (o instanceof Byte) {
                return (int)((Byte)o).byteValue();
            }
            if (o instanceof Float) {
                return JSRuntime.toUInt8(Float.valueOf(((Float)o).floatValue()));
            }
            return JSRuntime.toUInt8(o);
        }

        @Override
        public long getMax() {
            return 255L;
        }

        @Override
        public void serialize(byte[] block, int offset, Object n) {
            byte val = (byte)((Integer)n).intValue();
            ByteBuffer.wrap(block).put(offset, val);
        }

        @Override
        public Object deserialize(byte[] block, int offset) {
            byte val = 0;
            val = ByteBuffer.wrap(block).get(offset);
            return (int)val;
        }

        @Override
        public int getNumberOfElements() {
            return 16;
        }

        @Override
        public int getBytesPerElement() {
            return 1;
        }
    }

    public static final class SIMDUint16x8
    extends SIMDTypedUInt {
        private SIMDUint16x8() {
        }

        public SIMDTypeFactory<SIMDUint16x8> getFactory() {
            return UINT16X8_FACTORY;
        }

        @Override
        public Object cast(Number o) {
            if (o instanceof Short) {
                return (int)((Short)o).shortValue();
            }
            if (o instanceof Float) {
                return JSRuntime.toUInt16(Float.valueOf(((Float)o).floatValue()));
            }
            return JSRuntime.toUInt16(o);
        }

        @Override
        public long getMax() {
            return (long)(Math.pow(2.0, 16.0) - 1.0);
        }

        @Override
        public void serialize(byte[] block, int offset, Object n) {
            short val = (short)((Integer)n).intValue();
            if (LittleEndian) {
                val = Short.reverseBytes(val);
            }
            ByteBuffer.wrap(block).putShort(offset, val);
        }

        @Override
        public Object deserialize(byte[] block, int offset) {
            short val = 0;
            val = ByteBuffer.wrap(block).getShort(offset);
            if (LittleEndian) {
                val = Short.reverseBytes(val);
            }
            return (int)val;
        }

        @Override
        public int getNumberOfElements() {
            return 8;
        }

        @Override
        public int getBytesPerElement() {
            return 2;
        }
    }

    public static final class SIMDUint32x4
    extends SIMDTypedUInt {
        private SIMDUint32x4() {
        }

        public SIMDTypeFactory<SIMDUint32x4> getFactory() {
            return UINT32X4_FACTORY;
        }

        @Override
        public Object cast(Number o) {
            if (o instanceof Float) {
                return (int)JSRuntime.toUInt32(((Float)o).floatValue());
            }
            return (int)JSRuntime.toUInt32(o);
        }

        @Override
        public long getMax() {
            return (long)(Math.pow(2.0, 32.0) - 1.0);
        }

        @Override
        public void serialize(byte[] block, int offset, Object n) {
            int val = (int)JSRuntime.toInteger(n);
            if (LittleEndian) {
                val = Integer.reverseBytes(val);
            }
            ByteBuffer.wrap(block).putInt(offset, val);
        }

        @Override
        public Object deserialize(byte[] block, int offset) {
            int val = 0;
            val = ByteBuffer.wrap(block).getInt(offset);
            if (LittleEndian) {
                val = Integer.reverseBytes(val);
            }
            return val;
        }

        @Override
        public int getNumberOfElements() {
            return 4;
        }

        @Override
        public int getBytesPerElement() {
            return 4;
        }
    }

    public static abstract class SIMDTypedUInt
    extends SIMDTypeInt {
        @Override
        public long getMin() {
            return 0L;
        }
    }

    public static final class SIMDInt8x16
    extends SIMDTypeInt {
        private SIMDInt8x16() {
        }

        public SIMDTypeFactory<SIMDInt8x16> getFactory() {
            return INT8X16_FACTORY;
        }

        @Override
        public Object cast(Number o) {
            if (o instanceof Byte) {
                return (int)((Byte)o).byteValue();
            }
            if (o instanceof Float) {
                return JSRuntime.toInt8(Float.valueOf(((Float)o).floatValue()));
            }
            return JSRuntime.toInt8(o);
        }

        @Override
        public long getMax() {
            return 127L;
        }

        @Override
        public long getMin() {
            return -128L;
        }

        @Override
        public void serialize(byte[] block, int offset, Object n) {
            byte val = (byte)((Integer)n).intValue();
            ByteBuffer.wrap(block).put(offset, val);
        }

        @Override
        public Object deserialize(byte[] block, int offset) {
            byte val = 0;
            val = ByteBuffer.wrap(block).get(offset);
            return (int)val;
        }

        @Override
        public int getNumberOfElements() {
            return 16;
        }

        @Override
        public int getBytesPerElement() {
            return 1;
        }
    }

    public static final class SIMDInt16x8
    extends SIMDTypeInt {
        private SIMDInt16x8() {
        }

        public SIMDTypeFactory<SIMDInt16x8> getFactory() {
            return INT16X8_FACTORY;
        }

        @Override
        public Object cast(Number o) {
            if (o instanceof Short) {
                return (int)((Short)o).shortValue();
            }
            if (o instanceof Float) {
                return JSRuntime.toInt16(Float.valueOf(((Float)o).floatValue()));
            }
            return JSRuntime.toInt16(o);
        }

        @Override
        public long getMax() {
            return 32767L;
        }

        @Override
        public long getMin() {
            return -32768L;
        }

        @Override
        public void serialize(byte[] block, int offset, Object n) {
            short val = (short)((Integer)n).intValue();
            if (LittleEndian) {
                val = Short.reverseBytes(val);
            }
            ByteBuffer.wrap(block).putShort(offset, val);
        }

        @Override
        public Object deserialize(byte[] block, int offset) {
            short val = 0;
            val = ByteBuffer.wrap(block).getShort(offset);
            if (LittleEndian) {
                val = Short.reverseBytes(val);
            }
            return (int)val;
        }

        @Override
        public int getNumberOfElements() {
            return 8;
        }

        @Override
        public int getBytesPerElement() {
            return 2;
        }
    }

    public static final class SIMDInt32x4
    extends SIMDTypeInt {
        private SIMDInt32x4() {
        }

        public SIMDTypeFactory<SIMDInt32x4> getFactory() {
            return INT32X4_FACTORY;
        }

        @Override
        public Object cast(Number o) {
            if (o instanceof Float) {
                return JSRuntime.toInt32(((Float)o).floatValue());
            }
            return JSRuntime.toInt32(o);
        }

        @Override
        public long getMax() {
            return Integer.MAX_VALUE;
        }

        @Override
        public long getMin() {
            return Integer.MIN_VALUE;
        }

        @Override
        public int getNumberOfElements() {
            return 4;
        }

        @Override
        public int getBytesPerElement() {
            return 4;
        }
    }

    public static final class SIMDFloat32x4
    extends SIMDTypedFloat {
        private SIMDFloat32x4() {
        }

        public SIMDTypeFactory<SIMDFloat32x4> getFactory() {
            return FLOAT32X4_FACTORY;
        }

        @Override
        public Object cast(Number o) {
            if (o instanceof Float) {
                return o;
            }
            if (o instanceof Double) {
                return Float.valueOf((float)((Double)o).doubleValue());
            }
            return Float.valueOf(JSRuntime.floatValue(o));
        }

        @Override
        public void serialize(byte[] block, int offset, Object n) {
            int val = Float.floatToRawIntBits(((Float)n).floatValue());
            if (LittleEndian) {
                val = Integer.reverseBytes(val);
            }
            ByteBuffer.wrap(block, offset, ((SIMDTypeFactory)this.getFactory()).bytesPerElement).putInt(val);
        }

        @Override
        public Object deserialize(byte[] block, int offset) {
            int val = 0;
            val = ByteBuffer.wrap(block).getInt(offset);
            if (LittleEndian) {
                val = Integer.reverseBytes(val);
            }
            return Float.valueOf(Float.intBitsToFloat(val));
        }

        @Override
        public int getNumberOfElements() {
            return 4;
        }

        @Override
        public int getBytesPerElement() {
            return 4;
        }
    }

    public static abstract class SIMDTypeInt
    extends SIMDType {
        @Override
        public void serialize(byte[] block, int offset, Object n) {
            int val = (int)JSRuntime.toInteger(n);
            if (LittleEndian) {
                val = Integer.reverseBytes(val);
            }
            ByteBuffer.wrap(block).putInt(offset, val);
        }

        @Override
        public Object deserialize(byte[] block, int offset) {
            int val = 0;
            val = ByteBuffer.wrap(block).getInt(offset);
            if (LittleEndian) {
                val = Integer.reverseBytes(val);
            }
            return val;
        }

        public abstract long getMax();

        public abstract long getMin();
    }
}

