/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.access.GlobalScopeLookupNode;
import com.oracle.truffle.js.runtime.JSTruffleOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=GlobalScopeLookupNode.class)
public final class GlobalScopeLookupNodeGen
extends GlobalScopeLookupNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;
    @CompilerDirectives.CompilationFinal
    private Assumption absent_assumption_;
    @CompilerDirectives.CompilationFinal
    private Assumption absent_assumption0_;
    @CompilerDirectives.CompilationFinal
    private CachedData cached_cache;
    @CompilerDirectives.CompilationFinal
    private BranchProfile uncached_errorBranch_;

    private GlobalScopeLookupNodeGen(String varName, boolean write) {
        super(varName, write);
    }

    @Override
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    public boolean execute(Object arg0Value) {
        int state = this.state_;
        if (state != 0 && JSTypes.isDynamicObject(arg0Value)) {
            DynamicObject arg0Value_ = (DynamicObject)arg0Value;
            if ((state & 1) != 0) {
                if (!Assumption.isValidAssumption((Assumption)this.absent_assumption0_)) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.removeAbsent_();
                    return this.executeAndSpecialize(arg0Value_);
                }
                return GlobalScopeLookupNode.doAbsent(arg0Value_, this.absent_assumption_);
            }
            if ((state & 2) != 0) {
                CachedData s2_ = this.cached_cache;
                while (s2_ != null) {
                    if (!Assumption.isValidAssumption((Assumption)s2_.assumption0_)) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        this.removeCached_(s2_);
                        return this.executeAndSpecialize(arg0Value_);
                    }
                    if (arg0Value_.getShape() == s2_.cachedShape_) {
                        return this.doCached(arg0Value_, s2_.cachedShape_, s2_.exists_, s2_.dead_, s2_.constAssignment_);
                    }
                    s2_ = s2_.next_;
                }
            }
            if ((state & 4) != 0) {
                return this.doUncached(arg0Value_, this.uncached_errorBranch_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    private boolean executeAndSpecialize(Object arg0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            if (JSTypes.isDynamicObject(arg0Value)) {
                Assumption absent_assumption__;
                Assumption absent_assumption0;
                DynamicObject arg0Value_ = (DynamicObject)arg0Value;
                if ((exclude & 1) == 0 && Assumption.isValidAssumption((Assumption)(absent_assumption0 = (absent_assumption__ = this.getAbsentPropertyAssumption(arg0Value_.getShape()))))) {
                    this.absent_assumption_ = absent_assumption__;
                    this.absent_assumption0_ = absent_assumption0;
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = GlobalScopeLookupNode.doAbsent(arg0Value_, absent_assumption__);
                    return bl;
                }
                if ((exclude & 2) == 0) {
                    int count2_ = 0;
                    CachedData s2_ = this.cached_cache;
                    if ((state & 2) != 0) {
                        while (s2_ != null && (arg0Value_.getShape() != s2_.cachedShape_ || s2_.assumption0_ != null && !Assumption.isValidAssumption((Assumption)s2_.assumption0_))) {
                            s2_ = s2_.next_;
                            ++count2_;
                        }
                    }
                    if (s2_ == null) {
                        Assumption assumption0;
                        Shape cachedShape__ = arg0Value_.getShape();
                        if (arg0Value_.getShape() == cachedShape__ && Assumption.isValidAssumption((Assumption)(assumption0 = cachedShape__.getValidAssumption())) && count2_ < JSTruffleOptions.PropertyCacheLimit) {
                            s2_ = new CachedData(this.cached_cache);
                            s2_.cachedShape_ = cachedShape__;
                            s2_.exists_ = cachedShape__.hasProperty((Object)this.varName);
                            s2_.dead_ = this.isDead(cachedShape__);
                            s2_.constAssignment_ = this.isConstAssignment(cachedShape__);
                            s2_.assumption0_ = assumption0;
                            this.cached_cache = s2_;
                            this.exclude_ = exclude |= 1;
                            state &= 0xFFFFFFFE;
                            this.state_ = state |= 2;
                        }
                    }
                    if (s2_ != null) {
                        lock.unlock();
                        hasLock = false;
                        boolean bl = this.doCached(arg0Value_, s2_.cachedShape_, s2_.exists_, s2_.dead_, s2_.constAssignment_);
                        return bl;
                    }
                }
                this.uncached_errorBranch_ = BranchProfile.create();
                this.exclude_ = exclude |= 3;
                this.cached_cache = null;
                state &= 0xFFFFFFFC;
                this.state_ = state |= 4;
                lock.unlock();
                hasLock = false;
                boolean bl = this.doUncached(arg0Value_, this.uncached_errorBranch_);
                return bl;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        CachedData s2_;
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0 && ((s2_ = this.cached_cache) == null || s2_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    void removeAbsent_() {
        Lock lock = this.getLock();
        lock.lock();
        try {
            this.state_ &= 0xFFFFFFFE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCached_(Object s2_) {
        Lock lock = this.getLock();
        lock.lock();
        try {
            CachedData prev = null;
            CachedData cur = this.cached_cache;
            while (cur != null) {
                if (cur == s2_) {
                    if (prev == null) {
                        this.cached_cache = cur.next_;
                        break;
                    }
                    prev.next_ = cur.next_;
                    break;
                }
                prev = cur;
                cur = cur.next_;
            }
            if (this.cached_cache == null) {
                this.state_ &= 0xFFFFFFFD;
            }
        }
        finally {
            lock.unlock();
        }
    }

    public Introspection getIntrospectionData() {
        ArrayList<List<Object>> cached;
        Object[] data = new Object[4];
        data[0] = 0;
        int state = this.state_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doAbsent";
        if ((state & 1) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<Object>>();
            cached.add(Arrays.asList(this.absent_assumption_));
            s[2] = cached;
        } else {
            s[1] = (exclude & 1) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doCached";
        if ((state & 2) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            CachedData s2_ = this.cached_cache;
            while (s2_ != null) {
                cached.add(Arrays.asList(s2_.cachedShape_, s2_.exists_, s2_.dead_, s2_.constAssignment_));
                s2_ = s2_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = (exclude & 2) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[2] = s;
        s = new Object[3];
        s[0] = "doUncached";
        if ((state & 4) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.uncached_errorBranch_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[3] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static GlobalScopeLookupNode create(String varName, boolean write) {
        return new GlobalScopeLookupNodeGen(varName, write);
    }

    @GeneratedBy(value=GlobalScopeLookupNode.class)
    private static final class CachedData {
        @CompilerDirectives.CompilationFinal
        CachedData next_;
        @CompilerDirectives.CompilationFinal
        Shape cachedShape_;
        @CompilerDirectives.CompilationFinal
        boolean exists_;
        @CompilerDirectives.CompilationFinal
        boolean dead_;
        @CompilerDirectives.CompilationFinal
        boolean constAssignment_;
        @CompilerDirectives.CompilationFinal
        Assumption assumption0_;

        CachedData(CachedData next_) {
            this.next_ = next_;
        }
    }
}

