/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.simd;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.simd.SIMDCastNode;
import com.oracle.truffle.js.builtins.simd.SIMDTypeFunctionBuiltinsFactory;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.binary.JSEqualNode;
import com.oracle.truffle.js.nodes.cast.JSToLengthNode;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToUInt32Node;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.LargeInteger;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSArrayBuffer;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import com.oracle.truffle.js.runtime.builtins.JSSIMD;
import com.oracle.truffle.js.runtime.builtins.SIMDType;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.BufferUtil;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public final class SIMDTypeFunctionBuiltins
extends JSBuiltinsContainer.SwitchEnum<SIMDTypeFunction> {
    protected final SIMDType simdContext;

    public SIMDTypeFunctionBuiltins(String typeName, SIMDType simdContext) {
        super(typeName, SIMDTypeFunction.class);
        this.simdContext = simdContext;
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, SIMDTypeFunction builtinEnum) {
        switch (builtinEnum) {
            case abs: {
                return SIMDAbsNode.create(context, builtin, this.simdContext, SIMDTypeFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case add: {
                return SIMDAddNode.create(context, builtin, this.simdContext, SIMDTypeFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case addSaturate: {
                return SIMDAddSaturateNode.create(context, builtin, this.simdContext, SIMDTypeFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case allTrue: {
                return SIMDAllTrueNode.create(context, builtin, this.simdContext, SIMDTypeFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case and: {
                return SIMDAndNode.create(context, builtin, this.simdContext, SIMDTypeFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case anyTrue: {
                return SIMDAnyTrueNode.create(context, builtin, this.simdContext, SIMDTypeFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case check: {
                return SIMDCheckNode.create(context, builtin, this.simdContext, SIMDTypeFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case div: {
                return SIMDDivNode.create(context, builtin, this.simdContext, SIMDTypeFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case equal: {
                return SIMDEqualNode.create(context, builtin, this.simdContext, SIMDTypeFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case extractLane: {
                return SIMDExtractLaneNode.create(context, builtin, this.simdContext, SIMDTypeFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case fromInt32x4Bits: {
                return SIMDFromTIMDBitsNode.create(context, builtin, this.simdContext, SIMDType.INT32X4_FACTORY.createSimdType(), SIMDTypeFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case fromUint32x4Bits: {
                return SIMDFromTIMDBitsNode.create(context, builtin, this.simdContext, SIMDType.UINT32X4_FACTORY.createSimdType(), SIMDTypeFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case fromInt16x8Bits: {
                return SIMDFromTIMDBitsNode.create(context, builtin, this.simdContext, SIMDType.INT16X8_FACTORY.createSimdType(), SIMDTypeFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case fromUint16x8Bits: {
                return SIMDFromTIMDBitsNode.create(context, builtin, this.simdContext, SIMDType.UINT16X8_FACTORY.createSimdType(), SIMDTypeFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case fromInt8x16Bits: {
                return SIMDFromTIMDBitsNode.create(context, builtin, this.simdContext, SIMDType.INT8X16_FACTORY.createSimdType(), SIMDTypeFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case fromUint8x16Bits: {
                return SIMDFromTIMDBitsNode.create(context, builtin, this.simdContext, SIMDType.UINT8X16_FACTORY.createSimdType(), SIMDTypeFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case fromFloat32x4Bits: {
                return SIMDFromTIMDBitsNode.create(context, builtin, this.simdContext, SIMDType.FLOAT32X4_FACTORY.createSimdType(), SIMDTypeFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case fromInt32x4: {
                return SIMDFromTIMDNode.create(context, builtin, this.simdContext, SIMDType.INT32X4_FACTORY.createSimdType(), SIMDTypeFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case fromUint32x4: {
                return SIMDFromTIMDNode.create(context, builtin, this.simdContext, SIMDType.UINT32X4_FACTORY.createSimdType(), SIMDTypeFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case fromInt16x8: {
                return SIMDFromTIMDNode.create(context, builtin, this.simdContext, SIMDType.INT16X8_FACTORY.createSimdType(), SIMDTypeFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case fromUint16x8: {
                return SIMDFromTIMDNode.create(context, builtin, this.simdContext, SIMDType.UINT16X8_FACTORY.createSimdType(), SIMDTypeFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case fromInt8x16: {
                return SIMDFromTIMDNode.create(context, builtin, this.simdContext, SIMDType.INT8X16_FACTORY.createSimdType(), SIMDTypeFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case fromUint8x16: {
                return SIMDFromTIMDNode.create(context, builtin, this.simdContext, SIMDType.UINT8X16_FACTORY.createSimdType(), SIMDTypeFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case fromFloat32x4: {
                return SIMDFromTIMDNode.create(context, builtin, this.simdContext, SIMDType.FLOAT32X4_FACTORY.createSimdType(), SIMDTypeFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case greaterThan: {
                return SIMDGreaterThanNode.create(context, builtin, this.simdContext, SIMDTypeFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case greaterThanOrEqual: {
                return SIMDGreaterThanOrEqualNode.create(context, builtin, this.simdContext, SIMDTypeFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case lessThan: {
                return SIMDLessThanNode.create(context, builtin, this.simdContext, SIMDTypeFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case lessThanOrEqual: {
                return SIMDLessThanOrEqualNode.create(context, builtin, this.simdContext, SIMDTypeFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case load: {
                return SIMDLoadNode.create(context, builtin, this.simdContext, SIMDTypeFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case load1: {
                return SIMDLoadNode.create(context, builtin, this.simdContext, 1, SIMDTypeFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case load2: {
                return SIMDLoadNode.create(context, builtin, this.simdContext, 2, SIMDTypeFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case load3: {
                return SIMDLoadNode.create(context, builtin, this.simdContext, 3, SIMDTypeFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case max: {
                return SIMDMaxNode.create(context, builtin, this.simdContext, SIMDTypeFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case maxNum: {
                return SIMDMaxNumNode.create(context, builtin, this.simdContext, SIMDTypeFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case min: {
                return SIMDMinNode.create(context, builtin, this.simdContext, SIMDTypeFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case minNum: {
                return SIMDMinNumNode.create(context, builtin, this.simdContext, SIMDTypeFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case mul: {
                return SIMDMulNode.create(context, builtin, this.simdContext, SIMDTypeFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case neg: {
                return SIMDNegNode.create(context, builtin, this.simdContext, SIMDTypeFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case not: {
                return SIMDNotNode.create(context, builtin, this.simdContext, SIMDTypeFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case notEqual: {
                return SIMDNotEqualNode.create(context, builtin, this.simdContext, SIMDTypeFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case or: {
                return SIMDOrNode.create(context, builtin, this.simdContext, SIMDTypeFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case reciprocalApproximation: {
                return SIMDreciprocalApproximationNode.create(context, builtin, this.simdContext, SIMDTypeFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case reciprocalSqrtApproximation: {
                return SIMDreciprocalSqrtApproximationNode.create(context, builtin, this.simdContext, SIMDTypeFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case replaceLane: {
                return SIMDReplaceLaneNode.create(context, builtin, this.simdContext, SIMDTypeFunctionBuiltins.args().fixedArgs(3).createArgumentNodes(context));
            }
            case select: {
                return SIMDSelectNode.create(context, builtin, this.simdContext, SIMDTypeFunctionBuiltins.args().fixedArgs(3).createArgumentNodes(context));
            }
            case shiftLeftByScalar: {
                return SIMDShiftLeftByScalarNode.create(context, builtin, this.simdContext, SIMDTypeFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case shiftRightByScalar: {
                return SIMDShiftRightByScalarNode.create(context, builtin, this.simdContext, SIMDTypeFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case shuffle: {
                return SIMDShuffleNode.create(context, builtin, this.simdContext, SIMDTypeFunctionBuiltins.args().varArgs().createArgumentNodes(context));
            }
            case splat: {
                return SIMDSplatNode.create(context, builtin, this.simdContext, SIMDTypeFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case sqrt: {
                return SIMDSqrtNode.create(context, builtin, this.simdContext, SIMDTypeFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case store: {
                return SIMDStoreNode.create(context, builtin, this.simdContext, SIMDTypeFunctionBuiltins.args().fixedArgs(3).createArgumentNodes(context));
            }
            case store1: {
                return SIMDStoreNode.create(context, builtin, this.simdContext, 1, SIMDTypeFunctionBuiltins.args().fixedArgs(3).createArgumentNodes(context));
            }
            case store2: {
                return SIMDStoreNode.create(context, builtin, this.simdContext, 2, SIMDTypeFunctionBuiltins.args().fixedArgs(3).createArgumentNodes(context));
            }
            case store3: {
                return SIMDStoreNode.create(context, builtin, this.simdContext, 3, SIMDTypeFunctionBuiltins.args().fixedArgs(3).createArgumentNodes(context));
            }
            case sub: {
                return SIMDSubNode.create(context, builtin, this.simdContext, SIMDTypeFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case subSaturate: {
                return SIMDSubSaturateNode.create(context, builtin, this.simdContext, SIMDTypeFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case swizzle: {
                return SIMDSwizzleNode.create(context, builtin, this.simdContext, SIMDTypeFunctionBuiltins.args().varArgs().createArgumentNodes(context));
            }
            case xor: {
                return SIMDXorNode.create(context, builtin, this.simdContext, SIMDTypeFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
        }
        return null;
    }

    private static boolean fromTIMDGuard(SIMDType timd, SIMDType simdContext) {
        if (timd.equals(simdContext)) {
            return false;
        }
        if (simdContext.getFactory().getNumberOfElements() != timd.getFactory().getNumberOfElements()) {
            return false;
        }
        return !SIMDTypeFunctionBuiltins.isBooleanSIMD(timd) && !SIMDTypeFunctionBuiltins.isBooleanSIMD(simdContext);
    }

    private static boolean isBooleanSIMD(SIMDType t) {
        return SIMDType.SIMDTypedBoolean.class.isAssignableFrom(t.getClass());
    }

    public static abstract class SIMDFromTIMDBitsNode
    extends JSBasicSimdOperation {
        protected final SIMDType timd;

        protected SIMDFromTIMDBitsNode(JSContext context, JSBuiltin builtin, SIMDType simdContext, SIMDType timd) {
            super(context, builtin, simdContext, Math.max(simdContext.getNumberOfElements(), timd.getNumberOfElements()));
            this.timd = timd;
        }

        public static SIMDFromTIMDBitsNode create(JSContext context, JSBuiltin builtin, SIMDType simdContext, SIMDType createSimdType, JavaScriptNode[] createArgumentNodes) {
            return SIMDTypeFunctionBuiltinsFactory.SIMDFromTIMDBitsNodeGen.create(context, builtin, simdContext, createSimdType, createArgumentNodes);
        }

        @Specialization
        protected Object doFromTIMDBits(Object value) {
            if (!JSSIMD.isJSSIMD(value)) {
                this.errorBranch.enter();
                throw Errors.createSIMDExpected();
            }
            SIMDType olddesc = JSSIMD.simdTypeGetSIMDType((DynamicObject)value);
            int bytes = this.simdContext.getBytesPerElement() * this.numberOfElements;
            if (olddesc.getBytesPerElement() * olddesc.getNumberOfElements() != bytes) {
                this.errorBranch.enter();
                throw Errors.createError("assertion");
            }
            byte[] block = new byte[bytes];
            this.simdStore(block, olddesc, 0, (DynamicObject)value, olddesc.getNumberOfElements());
            return this.simdLoad(block, this.simdContext, 0, this.numberOfElements);
        }
    }

    public static abstract class SIMDFromTIMDNode
    extends JSBasicSimdOperation {
        protected final SIMDType timd;

        protected SIMDFromTIMDNode(JSContext context, JSBuiltin builtin, SIMDType simdContext, SIMDType timd) {
            super(context, builtin, simdContext);
            this.timd = timd;
        }

        public static SIMDFromTIMDNode create(JSContext context, JSBuiltin builtin, SIMDType simdContext, SIMDType createSimdType, JavaScriptNode[] createArgumentNodes) {
            return SIMDTypeFunctionBuiltinsFactory.SIMDFromTIMDNodeGen.create(context, builtin, simdContext, createSimdType, createArgumentNodes);
        }

        @Specialization
        protected Object doFrom(DynamicObject a) {
            if (!JSSIMD.isJSSIMD((Object)a)) {
                this.errorBranch.enter();
                throw Errors.createSIMDExpected();
            }
            if (!SIMDTypeFunctionBuiltins.fromTIMDGuard(this.timd, this.simdContext)) {
                this.errorBranch.enter();
                throw Errors.createTypeError("Should be undefined");
            }
            DynamicObject res = JSSIMD.createSIMD(this.getContext(), this.simdContext);
            if (this.timd.getClass().equals(SIMDType.SIMDUint32x4.class)) {
                this.doUIntFrom(a, res);
            } else if (this.timd.getClass().equals(SIMDType.SIMDFloat32x4.class)) {
                this.doFloatFrom(a, res);
            } else {
                this.doIntFrom(a, res);
            }
            return res;
        }

        @ExplodeLoop
        private void doIntFrom(DynamicObject a, DynamicObject res) {
            if (this.isIntegerSIMD(this.simdContext)) {
                SIMDType.SIMDTypeInt intdescriptor = (SIMDType.SIMDTypeInt)this.simdContext;
                for (int i = 0; i < this.numberOfElements; ++i) {
                    int intElement = (Integer)SIMDFromTIMDNode.getLane(a, i);
                    if ((long)intElement <= intdescriptor.getMax() && (long)intElement >= intdescriptor.getMin()) continue;
                    this.errorBranch.enter();
                    throw Errors.createRangeError("MIN/MAX");
                }
            }
            for (int i = 0; i < this.numberOfElements; ++i) {
                SIMDFromTIMDNode.setLane(res, i, this.cast(i, (int)((Integer)SIMDFromTIMDNode.getLane(a, i))));
            }
        }

        @ExplodeLoop
        private void doUIntFrom(DynamicObject a, DynamicObject res) {
            if (this.isIntegerSIMD(this.simdContext)) {
                SIMDType.SIMDTypeInt intdescriptor = (SIMDType.SIMDTypeInt)this.simdContext;
                for (int i = 0; i < this.numberOfElements; ++i) {
                    long intElement = Integer.toUnsignedLong((Integer)SIMDFromTIMDNode.getLane(a, i));
                    if (intElement <= intdescriptor.getMax() && intElement >= intdescriptor.getMin()) continue;
                    this.errorBranch.enter();
                    throw Errors.createRangeError("MIN/MAX");
                }
            }
            for (int i = 0; i < this.numberOfElements; ++i) {
                SIMDFromTIMDNode.setLane(res, i, this.cast(i, Integer.toUnsignedLong((Integer)SIMDFromTIMDNode.getLane(a, i))));
            }
        }

        @ExplodeLoop
        private void doFloatFrom(DynamicObject a, DynamicObject res) {
            long intElement;
            int i;
            SIMDType.SIMDTypeInt intdescriptor;
            if (this.isIntegerSIMD(this.simdContext) && this.isFloatSIMD(this.timd)) {
                intdescriptor = (SIMDType.SIMDTypeInt)this.simdContext;
                for (i = 0; i < this.numberOfElements; ++i) {
                    if (Float.isNaN(((Float)SIMDFromTIMDNode.getLane(a, i)).floatValue())) {
                        this.errorBranch.enter();
                        throw Errors.createRangeError("NaN");
                    }
                    intElement = JSRuntime.toInteger(Float.valueOf(((Float)SIMDFromTIMDNode.getLane(a, i)).floatValue()));
                    if (intElement <= intdescriptor.getMax() && intElement >= intdescriptor.getMin()) continue;
                    this.errorBranch.enter();
                    throw Errors.createRangeError("MIN/MAX");
                }
            }
            if (this.isIntegerSIMD(this.simdContext) && this.isIntegerSIMD(this.timd)) {
                intdescriptor = (SIMDType.SIMDTypeInt)this.simdContext;
                for (i = 0; i < this.numberOfElements; ++i) {
                    intElement = JSRuntime.toInteger(Float.valueOf(((Float)SIMDFromTIMDNode.getLane(a, i)).floatValue()));
                    if (intElement <= intdescriptor.getMax() && intElement >= intdescriptor.getMin()) continue;
                    this.errorBranch.enter();
                    throw Errors.createRangeError("MIN/MAX");
                }
            }
            for (int i2 = 0; i2 < this.numberOfElements; ++i2) {
                SIMDFromTIMDNode.setLane(res, i2, this.cast(i2, SIMDFromTIMDNode.getLane(a, i2)));
            }
        }
    }

    public static abstract class SIMDShuffleNode
    extends JSBasicSimdOperation {
        protected SIMDShuffleNode(JSContext context, JSBuiltin builtin, SIMDType simdContext) {
            super(context, builtin, simdContext);
        }

        public static SIMDShuffleNode create(JSContext context, JSBuiltin builtin, SIMDType simdContext, JavaScriptNode[] createArgumentNodes) {
            return SIMDTypeFunctionBuiltinsFactory.SIMDShuffleNodeGen.create(context, builtin, simdContext, createArgumentNodes);
        }

        @ExplodeLoop
        @Specialization
        protected Object doShuffle(Object[] args) {
            DynamicObject a = (DynamicObject)args[0];
            DynamicObject b = (DynamicObject)args[1];
            DynamicObject res = JSSIMD.createSIMD(this.getContext(), this.simdContext);
            for (int i = 0; i < this.numberOfElements; ++i) {
                int index;
                Object lane = 0;
                if (i < args.length - 2) {
                    lane = args[i + 2];
                }
                if ((index = this.simdToLane(this.numberOfElements * 2, lane)) >= this.numberOfElements) {
                    SIMDShuffleNode.setLane(res, i, SIMDShuffleNode.getLane(b, index - this.numberOfElements));
                    continue;
                }
                SIMDShuffleNode.setLane(res, i, SIMDShuffleNode.getLane(a, index));
            }
            return res;
        }
    }

    public static abstract class SIMDSwizzleNode
    extends JSBasicSimdOperation {
        public SIMDSwizzleNode(JSContext context, JSBuiltin builtin, SIMDType simdContext) {
            super(context, builtin, simdContext);
        }

        public static SIMDSwizzleNode create(JSContext context, JSBuiltin builtin, SIMDType simdContext, JavaScriptNode[] createArgumentNodes) {
            return SIMDTypeFunctionBuiltinsFactory.SIMDSwizzleNodeGen.create(context, builtin, simdContext, createArgumentNodes);
        }

        @ExplodeLoop
        @Specialization
        protected Object doSwizzle(Object[] args) {
            DynamicObject a = (DynamicObject)args[0];
            DynamicObject res = JSSIMD.createSIMD(this.getContext(), this.simdContext);
            for (int i = 0; i < this.numberOfElements; ++i) {
                Object lane = 0;
                if (i < args.length - 1) {
                    lane = args[i + 1];
                }
                int index = this.simdToLane(this.numberOfElements, lane);
                SIMDSwizzleNode.setLane(res, i, SIMDSwizzleNode.getLane(a, index));
            }
            return res;
        }
    }

    public static abstract class SIMDLoadNode
    extends JSBasicSimdOperation {
        protected final int length;

        protected SIMDLoadNode(JSContext context, JSBuiltin builtin, SIMDType simdContext) {
            super(context, builtin, simdContext);
            this.length = simdContext.getNumberOfElements();
        }

        public static SIMDLoadNode create(JSContext context, JSBuiltin builtin, SIMDType simdContext, int i, JavaScriptNode[] createArgumentNodes) {
            return SIMDTypeFunctionBuiltinsFactory.SIMDLoadNodeGen.create(context, builtin, simdContext, i, createArgumentNodes);
        }

        public static SIMDLoadNode create(JSContext context, JSBuiltin builtin, SIMDType simdContext, JavaScriptNode[] createArgumentNodes) {
            return SIMDTypeFunctionBuiltinsFactory.SIMDLoadNodeGen.create(context, builtin, simdContext, createArgumentNodes);
        }

        public SIMDLoadNode(JSContext context, JSBuiltin builtin, SIMDType simdContext, int length) {
            super(context, builtin, simdContext);
            this.length = length;
        }

        @Specialization
        protected Object doLoad(DynamicObject tarray, Object index) {
            return this.simdLoadFromTypedArray(tarray, index, this.simdContext, this.length);
        }
    }

    public static abstract class SIMDStoreNode
    extends JSBasicSimdOperation {
        protected final int length;

        protected SIMDStoreNode(JSContext context, JSBuiltin builtin, SIMDType simdContext) {
            super(context, builtin, simdContext);
            this.length = simdContext.getNumberOfElements();
        }

        public static SIMDStoreNode create(JSContext context, JSBuiltin builtin, SIMDType simdContext, int i, JavaScriptNode[] createArgumentNodes) {
            return SIMDTypeFunctionBuiltinsFactory.SIMDStoreNodeGen.create(context, builtin, simdContext, i, createArgumentNodes);
        }

        public static SIMDStoreNode create(JSContext context, JSBuiltin builtin, SIMDType simdContext, JavaScriptNode[] createArgumentNodes) {
            return SIMDTypeFunctionBuiltinsFactory.SIMDStoreNodeGen.create(context, builtin, simdContext, createArgumentNodes);
        }

        public SIMDStoreNode(JSContext context, JSBuiltin builtin, SIMDType simdContext, int length) {
            super(context, builtin, simdContext);
            this.length = length;
        }

        @Specialization
        protected Object doStore(DynamicObject tarray, Object index, DynamicObject simd) {
            if (!JSArrayBufferView.isJSArrayBufferView(tarray)) {
                this.errorBranch.enter();
                throw Errors.createTypeErrorArrayBufferViewExpected();
            }
            if (!JSSIMD.isJSSIMD((Object)simd)) {
                this.errorBranch.enter();
                throw Errors.createSIMDExpected();
            }
            return this.simdStoreInTypedArray(tarray, index, this.simdContext, simd, this.length);
        }
    }

    public static abstract class SIMDReplaceLaneNode
    extends JSBasicSimdOperation {
        protected SIMDReplaceLaneNode(JSContext context, JSBuiltin builtin, SIMDType simdContext) {
            super(context, builtin, simdContext);
        }

        public static SIMDReplaceLaneNode create(JSContext context, JSBuiltin builtin, SIMDType simdContext, JavaScriptNode[] createArgumentNodes) {
            return SIMDTypeFunctionBuiltinsFactory.SIMDReplaceLaneNodeGen.create(context, builtin, simdContext, createArgumentNodes);
        }

        @ExplodeLoop
        @Specialization
        protected Object doReplaceLane(DynamicObject a, Object lane, Object replacement) {
            int index = this.simdToLane(this.numberOfElements, lane);
            DynamicObject res = JSSIMD.createSIMD(this.getContext(), this.simdContext);
            for (int i = 0; i < this.numberOfElements; ++i) {
                SIMDReplaceLaneNode.setLane(res, i, SIMDReplaceLaneNode.getLane(a, i));
            }
            SIMDReplaceLaneNode.setLane(res, index, this.cast(0, replacement));
            return res;
        }
    }

    public static abstract class SIMDExtractLaneNode
    extends JSBasicSimdOperation {
        protected SIMDExtractLaneNode(JSContext context, JSBuiltin builtin, SIMDType simdContext) {
            super(context, builtin, simdContext);
        }

        public static SIMDExtractLaneNode create(JSContext context, JSBuiltin builtin, SIMDType simdContext, JavaScriptNode[] createArgumentNodes) {
            return SIMDTypeFunctionBuiltinsFactory.SIMDExtractLaneNodeGen.create(context, builtin, simdContext, createArgumentNodes);
        }

        @Specialization(guards={"lane < simdContext.getNumberOfElements()", "lane >= 0"})
        protected Object doExtract(DynamicObject a, int lane) {
            if (this.simdElementType.equals(SIMDType.SIMDUint32x4.class)) {
                return SIMDExtractLaneNode.doUIntExtract(a, lane);
            }
            if (this.simdElementType.equals(SIMDType.SIMDUint16x8.class)) {
                return SIMDExtractLaneNode.doUShortExtract(a, lane);
            }
            if (this.simdElementType.equals(SIMDType.SIMDUint8x16.class)) {
                return SIMDExtractLaneNode.doUByteExtract(a, lane);
            }
            if (this.simdElementType.equals(SIMDType.SIMDFloat32x4.class)) {
                return SIMDExtractLaneNode.doFloatExtract(a, lane);
            }
            return SIMDExtractLaneNode.doGeneralExtract(a, lane);
        }

        @Specialization
        protected Object doExtract(DynamicObject a, Object lane) {
            int index = this.simdToLane(this.simdContext.getNumberOfElements(), lane);
            return this.doExtract(a, index);
        }

        private static Object doUIntExtract(DynamicObject a, int lane) {
            return LargeInteger.valueOf(JSRuntime.toUInt32(((Integer)SIMDExtractLaneNode.getLane(a, lane)).intValue()));
        }

        private static Object doUShortExtract(DynamicObject a, int lane) {
            return JSRuntime.toUInt16(((Integer)SIMDExtractLaneNode.getLane(a, lane)).intValue());
        }

        private static Object doUByteExtract(DynamicObject a, int lane) {
            return JSRuntime.toUInt8(((Integer)SIMDExtractLaneNode.getLane(a, lane)).intValue());
        }

        private static Object doFloatExtract(DynamicObject a, int lane) {
            Object number = SIMDExtractLaneNode.getLane(a, lane);
            return JSRuntime.doubleValueVirtual((Number)number);
        }

        private static Object doGeneralExtract(DynamicObject a, int lane) {
            return SIMDExtractLaneNode.getLane(a, lane);
        }
    }

    public static abstract class SIMDShiftRightByScalarNode
    extends JSBasicSimdOperation {
        protected SIMDShiftRightByScalarNode(JSContext context, JSBuiltin builtin, SIMDType simdContext) {
            super(context, builtin, simdContext);
        }

        public static Object create(JSContext context, JSBuiltin builtin, SIMDType simdContext, JavaScriptNode[] createArgumentNodes) {
            return SIMDTypeFunctionBuiltinsFactory.SIMDShiftRightByScalarNodeGen.create(context, builtin, simdContext, createArgumentNodes);
        }

        @Specialization
        protected Object doShiftRight(DynamicObject a, Object bits) {
            long scalar = this.getToUInt32Node().executeLong(bits);
            long shiftCount = scalar % (long)(this.simdContext.getFactory().getBytesPerElement() * 8);
            DynamicObject res = JSSIMD.createSIMD(this.getContext(), this.simdContext);
            if (this.simdElementType.equals(SIMDType.SIMDInt32x4.class)) {
                this.doIntShiftRight(a, shiftCount, res);
            } else if (this.simdElementType.equals(SIMDType.SIMDInt16x8.class)) {
                this.doShortShiftRight(a, shiftCount, res);
            } else if (this.simdElementType.equals(SIMDType.SIMDInt8x16.class)) {
                this.doByteShiftRight(a, shiftCount, res);
            } else if (this.simdElementType.equals(SIMDType.SIMDUint32x4.class)) {
                this.doUIntShiftRight(a, shiftCount, res);
            } else if (this.simdElementType.equals(SIMDType.SIMDUint16x8.class)) {
                this.doUShortShiftRight(a, shiftCount, res);
            } else if (this.simdElementType.equals(SIMDType.SIMDUint8x16.class)) {
                this.doUByteShiftRight(a, shiftCount, res);
            }
            return res;
        }

        @ExplodeLoop
        private void doIntShiftRight(DynamicObject a, long shiftCount, DynamicObject res) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                int ax = (Integer)SIMDShiftRightByScalarNode.getLane(a, i);
                SIMDShiftRightByScalarNode.setLane(res, i, ax >> (int)shiftCount);
            }
        }

        @ExplodeLoop
        private void doShortShiftRight(DynamicObject a, long shiftCount, DynamicObject rest) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                int ax = (Integer)SIMDShiftRightByScalarNode.getLane(a, i);
                SIMDShiftRightByScalarNode.setLane(rest, i, (short)(ax >> (int)shiftCount));
            }
        }

        @ExplodeLoop
        private void doByteShiftRight(DynamicObject a, long shiftCount, DynamicObject rest) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                int ax = (Integer)SIMDShiftRightByScalarNode.getLane(a, i);
                SIMDShiftRightByScalarNode.setLane(rest, i, (byte)(ax >> (int)shiftCount));
            }
        }

        @ExplodeLoop
        private void doUIntShiftRight(DynamicObject a, long shiftCount, DynamicObject res) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                int ax = (Integer)SIMDShiftRightByScalarNode.getLane(a, i);
                SIMDShiftRightByScalarNode.setLane(res, i, ax >>> (int)shiftCount);
            }
        }

        @ExplodeLoop
        private void doUShortShiftRight(DynamicObject a, long shiftCount, DynamicObject rest) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                int ax = (Integer)SIMDShiftRightByScalarNode.getLane(a, i);
                SIMDShiftRightByScalarNode.setLane(rest, i, (short)(ax >>> (int)shiftCount));
            }
        }

        @ExplodeLoop
        private void doUByteShiftRight(DynamicObject a, long shiftCount, DynamicObject rest) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                int ax = (Integer)SIMDShiftRightByScalarNode.getLane(a, i);
                SIMDShiftRightByScalarNode.setLane(rest, i, (byte)(ax >>> (int)shiftCount));
            }
        }
    }

    public static abstract class SIMDShiftLeftByScalarNode
    extends JSBasicSimdOperation {
        protected SIMDShiftLeftByScalarNode(JSContext context, JSBuiltin builtin, SIMDType simdContext) {
            super(context, builtin, simdContext);
        }

        public static SIMDShiftLeftByScalarNode create(JSContext context, JSBuiltin builtin, SIMDType simdContext, JavaScriptNode[] createArgumentNodes) {
            return SIMDTypeFunctionBuiltinsFactory.SIMDShiftLeftByScalarNodeGen.create(context, builtin, simdContext, createArgumentNodes);
        }

        @Specialization
        protected Object doShiftLeft(DynamicObject a, Object bits) {
            long scalar = this.getToUInt32Node().executeLong(bits);
            long shiftCount = scalar % (long)(this.simdContext.getFactory().getBytesPerElement() * 8);
            DynamicObject res = JSSIMD.createSIMD(this.getContext(), this.simdContext);
            if (this.simdElementType.equals(SIMDType.SIMDInt32x4.class) || this.simdElementType.equals(SIMDType.SIMDUint32x4.class)) {
                this.doIntShiftLeft(a, shiftCount, res);
            } else if (this.simdElementType.equals(SIMDType.SIMDInt16x8.class) || this.simdElementType.equals(SIMDType.SIMDUint16x8.class)) {
                this.doShortShiftLeft(a, shiftCount, res);
            } else if (this.simdElementType.equals(SIMDType.SIMDInt8x16.class) || this.simdElementType.equals(SIMDType.SIMDUint8x16.class)) {
                this.doByteShiftLeft(a, shiftCount, res);
            }
            return res;
        }

        @ExplodeLoop
        private void doIntShiftLeft(DynamicObject a, long shiftCount, DynamicObject res) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                int ax = (Integer)SIMDShiftLeftByScalarNode.getLane(a, i);
                SIMDShiftLeftByScalarNode.setLane(res, i, ax << (int)shiftCount);
            }
        }

        @ExplodeLoop
        private void doShortShiftLeft(DynamicObject a, long shiftCount, DynamicObject rest) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                int ax = (Integer)SIMDShiftLeftByScalarNode.getLane(a, i);
                SIMDShiftLeftByScalarNode.setLane(rest, i, (short)(ax << (int)shiftCount));
            }
        }

        @ExplodeLoop
        private void doByteShiftLeft(DynamicObject a, long shiftCount, DynamicObject rest) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                int ax = (Integer)SIMDShiftLeftByScalarNode.getLane(a, i);
                SIMDShiftLeftByScalarNode.setLane(rest, i, (byte)(ax << (int)shiftCount));
            }
        }
    }

    public static abstract class SIMDSubSaturateNode
    extends JSBasicSimdOperation {
        protected SIMDSubSaturateNode(JSContext context, JSBuiltin builtin, SIMDType simdContext) {
            super(context, builtin, simdContext);
        }

        public static Object create(JSContext context, JSBuiltin builtin, SIMDType simdContext, JavaScriptNode[] createArgumentNodes) {
            return SIMDTypeFunctionBuiltinsFactory.SIMDSubSaturateNodeGen.create(context, builtin, simdContext, createArgumentNodes);
        }

        @ExplodeLoop
        @Specialization
        protected Object doSubSaturate(DynamicObject a, DynamicObject b) {
            DynamicObject res = JSSIMD.createSIMD(this.getContext(), this.simdContext);
            for (int i = 0; i < this.numberOfElements; ++i) {
                int ax = (Integer)SIMDSubSaturateNode.getLane(a, i);
                int bx = (Integer)SIMDSubSaturateNode.getLane(b, i);
                SIMDSubSaturateNode.setLane(res, i, (int)this.saturate((SIMDType.SIMDTypeInt)this.simdContext, ax - bx));
            }
            return res;
        }
    }

    public static abstract class SIMDAddSaturateNode
    extends JSBasicSimdOperation {
        protected SIMDAddSaturateNode(JSContext context, JSBuiltin builtin, SIMDType simdContext) {
            super(context, builtin, simdContext);
        }

        public static Object create(JSContext context, JSBuiltin builtin, SIMDType simdContext, JavaScriptNode[] createArgumentNodes) {
            return SIMDTypeFunctionBuiltinsFactory.SIMDAddSaturateNodeGen.create(context, builtin, simdContext, createArgumentNodes);
        }

        @ExplodeLoop
        @Specialization
        protected Object doAddSaturate(DynamicObject a, DynamicObject b) {
            DynamicObject res = JSSIMD.createSIMD(this.getContext(), this.simdContext);
            for (int i = 0; i < this.numberOfElements; ++i) {
                int ax = (Integer)SIMDAddSaturateNode.getLane(a, i);
                int bx = (Integer)SIMDAddSaturateNode.getLane(b, i);
                SIMDAddSaturateNode.setLane(res, i, (int)this.saturate((SIMDType.SIMDTypeInt)this.simdContext, ax + bx));
            }
            return res;
        }
    }

    public static abstract class SIMDSelectNode
    extends JSBasicSimdOperation {
        protected SIMDSelectNode(JSContext context, JSBuiltin builtin, SIMDType simdContext) {
            super(context, builtin, simdContext);
        }

        public static SIMDSelectNode create(JSContext context, JSBuiltin builtin, SIMDType simdContext, JavaScriptNode[] createArgumentNodes) {
            return SIMDTypeFunctionBuiltinsFactory.SIMDSelectNodeGen.create(context, builtin, simdContext, createArgumentNodes);
        }

        @ExplodeLoop
        @Specialization
        protected Object doSelect(DynamicObject selector, DynamicObject a, DynamicObject b) {
            if (!JSSIMD.isJSSIMD((Object)a) || !JSSIMD.isJSSIMD((Object)b)) {
                this.errorBranch.enter();
                throw Errors.createSIMDExpected();
            }
            SIMDType selDescriptor = this.simdBoolType(this.simdContext);
            if (selDescriptor != JSSIMD.simdTypeGetSIMDType(selector)) {
                this.errorBranch.enter();
                throw this.createTypeErrorInvalidArgumentType();
            }
            DynamicObject res = JSSIMD.createSIMD(this.getContext(), this.simdContext);
            for (int i = 0; i < this.numberOfElements; ++i) {
                if (((Boolean)SIMDSelectNode.getLane(selector, i)).booleanValue()) {
                    SIMDSelectNode.setLane(res, i, SIMDSelectNode.getLane(a, i));
                    continue;
                }
                SIMDSelectNode.setLane(res, i, SIMDSelectNode.getLane(b, i));
            }
            return res;
        }
    }

    public static abstract class SIMDAllTrueNode
    extends JSBasicSimdOperation {
        protected SIMDAllTrueNode(JSContext context, JSBuiltin builtin, SIMDType simdContext) {
            super(context, builtin, simdContext);
        }

        public static SIMDAllTrueNode create(JSContext context, JSBuiltin builtin, SIMDType simdContext, JavaScriptNode[] createArgumentNodes) {
            return SIMDTypeFunctionBuiltinsFactory.SIMDAllTrueNodeGen.create(context, builtin, simdContext, createArgumentNodes);
        }

        @ExplodeLoop
        @Specialization
        protected Object doAllTrue(DynamicObject a) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                if (((Boolean)SIMDAllTrueNode.getLane(a, i)).booleanValue()) continue;
                return false;
            }
            return true;
        }
    }

    public static abstract class SIMDAnyTrueNode
    extends JSBasicSimdOperation {
        protected SIMDAnyTrueNode(JSContext context, JSBuiltin builtin, SIMDType simdContext) {
            super(context, builtin, simdContext);
        }

        public static SIMDAnyTrueNode create(JSContext context, JSBuiltin builtin, SIMDType simdContext, JavaScriptNode[] createArgumentNodes) {
            return SIMDTypeFunctionBuiltinsFactory.SIMDAnyTrueNodeGen.create(context, builtin, simdContext, createArgumentNodes);
        }

        @ExplodeLoop
        @Specialization
        protected Object doAnyTrue(DynamicObject a) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                if (!((Boolean)SIMDAnyTrueNode.getLane(a, i)).booleanValue()) continue;
                return true;
            }
            return false;
        }
    }

    public static abstract class SIMDEqualNode
    extends JSBasicSimdOperation {
        protected SIMDEqualNode(JSContext context, JSBuiltin builtin, SIMDType simdContext) {
            super(context, builtin, simdContext);
        }

        public static SIMDEqualNode create(JSContext context, JSBuiltin builtin, SIMDType simdContext, JavaScriptNode[] createArgumentNodes) {
            return SIMDTypeFunctionBuiltinsFactory.SIMDEqualNodeGen.create(context, builtin, simdContext, createArgumentNodes);
        }

        @Specialization
        protected Object doEqual(DynamicObject a, DynamicObject b) {
            SIMDType descriptor = this.simdBoolType(this.simdContext);
            DynamicObject res = JSSIMD.createSIMD(this.getContext(), descriptor);
            if (this.simdElementType.equals(SIMDType.SIMDFloat32x4.class)) {
                this.doFloatEqual(a, b, res);
            } else {
                this.doIntEqual(a, b, res);
            }
            return res;
        }

        @ExplodeLoop
        private void doIntEqual(DynamicObject a, DynamicObject b, DynamicObject res) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                int bx;
                int ax = (Integer)SIMDEqualNode.getLane(a, i);
                SIMDEqualNode.setLane(res, i, ax == (bx = ((Integer)SIMDEqualNode.getLane(b, i)).intValue()));
            }
        }

        @ExplodeLoop
        private void doFloatEqual(DynamicObject a, DynamicObject b, DynamicObject rest) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                float bx;
                float ax = ((Float)SIMDEqualNode.getLane(a, i)).floatValue();
                SIMDEqualNode.setLane(rest, i, ax == (bx = ((Float)SIMDEqualNode.getLane(b, i)).floatValue()));
            }
        }
    }

    public static abstract class SIMDNotEqualNode
    extends JSBasicSimdOperation {
        protected SIMDNotEqualNode(JSContext context, JSBuiltin builtin, SIMDType simdContext) {
            super(context, builtin, simdContext);
        }

        public static SIMDNotEqualNode create(JSContext context, JSBuiltin builtin, SIMDType simdContext, JavaScriptNode[] createArgumentNodes) {
            return SIMDTypeFunctionBuiltinsFactory.SIMDNotEqualNodeGen.create(context, builtin, simdContext, createArgumentNodes);
        }

        @Specialization
        protected Object doNotEqual(DynamicObject a, DynamicObject b) {
            SIMDType descriptor = this.simdBoolType(this.simdContext);
            DynamicObject res = JSSIMD.createSIMD(this.getContext(), descriptor);
            if (this.simdElementType.equals(SIMDType.SIMDFloat32x4.class)) {
                this.doFloatNotEqual(a, b, res);
            } else {
                this.doIntNotEqual(a, b, res);
            }
            return res;
        }

        @ExplodeLoop
        private void doIntNotEqual(DynamicObject a, DynamicObject b, DynamicObject res) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                int bx;
                int ax = (Integer)SIMDNotEqualNode.getLane(a, i);
                SIMDNotEqualNode.setLane(res, i, ax != (bx = ((Integer)SIMDNotEqualNode.getLane(b, i)).intValue()));
            }
        }

        @ExplodeLoop
        private void doFloatNotEqual(DynamicObject a, DynamicObject b, DynamicObject rest) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                float bx;
                float ax = ((Float)SIMDNotEqualNode.getLane(a, i)).floatValue();
                SIMDNotEqualNode.setLane(rest, i, ax != (bx = ((Float)SIMDNotEqualNode.getLane(b, i)).floatValue()));
            }
        }
    }

    public static abstract class SIMDGreaterThanOrEqualNode
    extends JSBasicSimdOperation {
        protected SIMDGreaterThanOrEqualNode(JSContext context, JSBuiltin builtin, SIMDType simdContext) {
            super(context, builtin, simdContext);
        }

        public static SIMDGreaterThanOrEqualNode create(JSContext context, JSBuiltin builtin, SIMDType simdContext, JavaScriptNode[] createArgumentNodes) {
            return SIMDTypeFunctionBuiltinsFactory.SIMDGreaterThanOrEqualNodeGen.create(context, builtin, simdContext, createArgumentNodes);
        }

        @Specialization
        protected Object doGreaterThanOrEqual(DynamicObject a, DynamicObject b) {
            SIMDType descriptor = this.simdBoolType(this.simdContext);
            DynamicObject res = JSSIMD.createSIMD(this.getContext(), descriptor);
            if (this.simdElementType.equals(SIMDType.SIMDInt32x4.class) || this.simdElementType.equals(SIMDType.SIMDInt16x8.class) || this.simdElementType.equals(SIMDType.SIMDInt8x16.class)) {
                this.doIntGreaterThanOrEqual(a, b, res);
            } else if (this.simdElementType.equals(SIMDType.SIMDUint32x4.class) || this.simdElementType.equals(SIMDType.SIMDUint16x8.class) || this.simdElementType.equals(SIMDType.SIMDUint8x16.class)) {
                this.doUIntGreaterThanOrEqual(a, b, res);
            } else if (this.simdElementType.equals(SIMDType.SIMDFloat32x4.class)) {
                this.doFloatGreaterThanOrEqual(a, b, res);
            }
            return res;
        }

        @ExplodeLoop
        private void doUIntGreaterThanOrEqual(DynamicObject a, DynamicObject b, DynamicObject res) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                long bx;
                long ax = Integer.toUnsignedLong((Integer)SIMDGreaterThanOrEqualNode.getLane(a, i));
                SIMDGreaterThanOrEqualNode.setLane(res, i, ax >= (bx = Integer.toUnsignedLong((Integer)SIMDGreaterThanOrEqualNode.getLane(b, i))));
            }
        }

        @ExplodeLoop
        private void doIntGreaterThanOrEqual(DynamicObject a, DynamicObject b, DynamicObject res) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                int bx;
                int ax = (Integer)SIMDGreaterThanOrEqualNode.getLane(a, i);
                SIMDGreaterThanOrEqualNode.setLane(res, i, ax >= (bx = ((Integer)SIMDGreaterThanOrEqualNode.getLane(b, i)).intValue()));
            }
        }

        @ExplodeLoop
        private void doFloatGreaterThanOrEqual(DynamicObject a, DynamicObject b, DynamicObject rest) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                float bx;
                float ax = ((Float)SIMDGreaterThanOrEqualNode.getLane(a, i)).floatValue();
                SIMDGreaterThanOrEqualNode.setLane(rest, i, ax >= (bx = ((Float)SIMDGreaterThanOrEqualNode.getLane(b, i)).floatValue()));
            }
        }
    }

    public static abstract class SIMDGreaterThanNode
    extends JSBasicSimdOperation {
        protected SIMDGreaterThanNode(JSContext context, JSBuiltin builtin, SIMDType simdContext) {
            super(context, builtin, simdContext);
        }

        public static SIMDGreaterThanNode create(JSContext context, JSBuiltin builtin, SIMDType simdContext, JavaScriptNode[] createArgumentNodes) {
            return SIMDTypeFunctionBuiltinsFactory.SIMDGreaterThanNodeGen.create(context, builtin, simdContext, createArgumentNodes);
        }

        @Specialization
        protected Object doGreaterThan(DynamicObject a, DynamicObject b) {
            SIMDType descriptor = this.simdBoolType(this.simdContext);
            DynamicObject res = JSSIMD.createSIMD(this.getContext(), descriptor);
            if (this.simdElementType.equals(SIMDType.SIMDInt32x4.class) || this.simdElementType.equals(SIMDType.SIMDInt16x8.class) || this.simdElementType.equals(SIMDType.SIMDInt8x16.class)) {
                this.doIntGreaterThan(a, b, res);
            } else if (this.simdElementType.equals(SIMDType.SIMDUint32x4.class) || this.simdElementType.equals(SIMDType.SIMDUint16x8.class) || this.simdElementType.equals(SIMDType.SIMDUint8x16.class)) {
                this.doUIntGreaterThan(a, b, res);
            } else if (this.simdElementType.equals(SIMDType.SIMDFloat32x4.class)) {
                this.doFloatGreaterThan(a, b, res);
            }
            return res;
        }

        @ExplodeLoop
        private void doUIntGreaterThan(DynamicObject a, DynamicObject b, DynamicObject res) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                long bx;
                long ax = Integer.toUnsignedLong((Integer)SIMDGreaterThanNode.getLane(a, i));
                SIMDGreaterThanNode.setLane(res, i, ax > (bx = Integer.toUnsignedLong((Integer)SIMDGreaterThanNode.getLane(b, i))));
            }
        }

        @ExplodeLoop
        private void doIntGreaterThan(DynamicObject a, DynamicObject b, DynamicObject res) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                int bx;
                int ax = (Integer)SIMDGreaterThanNode.getLane(a, i);
                SIMDGreaterThanNode.setLane(res, i, ax > (bx = ((Integer)SIMDGreaterThanNode.getLane(b, i)).intValue()));
            }
        }

        @ExplodeLoop
        private void doFloatGreaterThan(DynamicObject a, DynamicObject b, DynamicObject rest) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                float bx;
                float ax = ((Float)SIMDGreaterThanNode.getLane(a, i)).floatValue();
                SIMDGreaterThanNode.setLane(rest, i, ax > (bx = ((Float)SIMDGreaterThanNode.getLane(b, i)).floatValue()));
            }
        }
    }

    public static abstract class SIMDLessThanOrEqualNode
    extends JSBasicSimdOperation {
        protected SIMDLessThanOrEqualNode(JSContext context, JSBuiltin builtin, SIMDType simdContext) {
            super(context, builtin, simdContext);
        }

        public static SIMDLessThanOrEqualNode create(JSContext context, JSBuiltin builtin, SIMDType simdContext, JavaScriptNode[] createArgumentNodes) {
            return SIMDTypeFunctionBuiltinsFactory.SIMDLessThanOrEqualNodeGen.create(context, builtin, simdContext, createArgumentNodes);
        }

        @Specialization
        protected Object doLessThanOrEqual(DynamicObject a, DynamicObject b) {
            SIMDType descriptor = this.simdBoolType(this.simdContext);
            DynamicObject res = JSSIMD.createSIMD(this.getContext(), descriptor);
            if (this.simdElementType.equals(SIMDType.SIMDInt32x4.class) || this.simdElementType.equals(SIMDType.SIMDInt16x8.class) || this.simdElementType.equals(SIMDType.SIMDInt8x16.class)) {
                this.doIntLessThanOrEqual(a, b, res);
            } else if (this.simdElementType.equals(SIMDType.SIMDUint32x4.class) || this.simdElementType.equals(SIMDType.SIMDUint16x8.class) || this.simdElementType.equals(SIMDType.SIMDUint8x16.class)) {
                this.doUIntLessThanOrEqual(a, b, res);
            } else if (this.simdElementType.equals(SIMDType.SIMDFloat32x4.class)) {
                this.doFloatLessThanOrEqual(a, b, res);
            }
            return res;
        }

        @ExplodeLoop
        private void doUIntLessThanOrEqual(DynamicObject a, DynamicObject b, DynamicObject res) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                long bx;
                long ax = Integer.toUnsignedLong((Integer)SIMDLessThanOrEqualNode.getLane(a, i));
                SIMDLessThanOrEqualNode.setLane(res, i, ax <= (bx = Integer.toUnsignedLong((Integer)SIMDLessThanOrEqualNode.getLane(b, i))));
            }
        }

        @ExplodeLoop
        private void doIntLessThanOrEqual(DynamicObject a, DynamicObject b, DynamicObject res) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                int bx;
                int ax = (Integer)SIMDLessThanOrEqualNode.getLane(a, i);
                SIMDLessThanOrEqualNode.setLane(res, i, ax <= (bx = ((Integer)SIMDLessThanOrEqualNode.getLane(b, i)).intValue()));
            }
        }

        @ExplodeLoop
        private void doFloatLessThanOrEqual(DynamicObject a, DynamicObject b, DynamicObject rest) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                float bx;
                float ax = ((Float)SIMDLessThanOrEqualNode.getLane(a, i)).floatValue();
                SIMDLessThanOrEqualNode.setLane(rest, i, ax <= (bx = ((Float)SIMDLessThanOrEqualNode.getLane(b, i)).floatValue()));
            }
        }
    }

    public static abstract class SIMDLessThanNode
    extends JSBasicSimdOperation {
        protected SIMDLessThanNode(JSContext context, JSBuiltin builtin, SIMDType simdContext) {
            super(context, builtin, simdContext);
        }

        public static SIMDLessThanNode create(JSContext context, JSBuiltin builtin, SIMDType simdContext, JavaScriptNode[] createArgumentNodes) {
            return SIMDTypeFunctionBuiltinsFactory.SIMDLessThanNodeGen.create(context, builtin, simdContext, createArgumentNodes);
        }

        @Specialization
        protected Object doLessThan(DynamicObject a, DynamicObject b) {
            SIMDType descriptor = this.simdBoolType(this.simdContext);
            DynamicObject res = JSSIMD.createSIMD(this.getContext(), descriptor);
            if (this.simdElementType.equals(SIMDType.SIMDInt32x4.class) || this.simdElementType.equals(SIMDType.SIMDInt16x8.class) || this.simdElementType.equals(SIMDType.SIMDInt8x16.class)) {
                this.doIntLessThan(a, b, res);
            } else if (this.simdElementType.equals(SIMDType.SIMDUint32x4.class)) {
                this.doUIntLessThan(a, b, res);
            } else if (this.simdElementType.equals(SIMDType.SIMDUint16x8.class)) {
                this.doIntLessThan(a, b, res);
            } else if (this.simdElementType.equals(SIMDType.SIMDUint8x16.class)) {
                this.doIntLessThan(a, b, res);
            } else if (this.simdElementType.equals(SIMDType.SIMDFloat32x4.class)) {
                this.doFloatLessThan(a, b, res);
            } else assert (false) : "TypeNotFound";
            return res;
        }

        @ExplodeLoop
        private void doUIntLessThan(DynamicObject a, DynamicObject b, DynamicObject res) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                long bx;
                long ax = Integer.toUnsignedLong((Integer)SIMDLessThanNode.getLane(a, i));
                SIMDLessThanNode.setLane(res, i, ax < (bx = Integer.toUnsignedLong((Integer)SIMDLessThanNode.getLane(b, i))));
            }
        }

        @ExplodeLoop
        private void doIntLessThan(DynamicObject a, DynamicObject b, DynamicObject res) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                int bx;
                int ax = (Integer)SIMDLessThanNode.getLane(a, i);
                SIMDLessThanNode.setLane(res, i, ax < (bx = ((Integer)SIMDLessThanNode.getLane(b, i)).intValue()));
            }
        }

        @ExplodeLoop
        private void doFloatLessThan(DynamicObject a, DynamicObject b, DynamicObject rest) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                float bx;
                float ax = ((Float)SIMDLessThanNode.getLane(a, i)).floatValue();
                SIMDLessThanNode.setLane(rest, i, ax < (bx = ((Float)SIMDLessThanNode.getLane(b, i)).floatValue()));
            }
        }
    }

    public static abstract class SIMDNotNode
    extends JSBasicSimdOperation {
        protected SIMDNotNode(JSContext context, JSBuiltin builtin, SIMDType simdContext) {
            super(context, builtin, simdContext);
        }

        public static SIMDNotNode create(JSContext context, JSBuiltin builtin, SIMDType simdContext, JavaScriptNode[] createArgumentNodes) {
            return SIMDTypeFunctionBuiltinsFactory.SIMDNotNodeGen.create(context, builtin, simdContext, createArgumentNodes);
        }

        @Specialization
        protected Object doNot(DynamicObject a) {
            DynamicObject res = JSSIMD.createSIMD(this.getContext(), this.simdContext);
            if (this.simdElementType.equals(SIMDType.SIMDInt32x4.class) || this.simdElementType.equals(SIMDType.SIMDUint32x4.class)) {
                this.doIntNot(a, res);
            } else if (this.simdElementType.equals(SIMDType.SIMDInt16x8.class) || this.simdElementType.equals(SIMDType.SIMDUint16x8.class)) {
                this.doShortNot(a, res);
            } else if (this.simdElementType.equals(SIMDType.SIMDInt8x16.class) || this.simdElementType.equals(SIMDType.SIMDUint8x16.class)) {
                this.doByteNot(a, res);
            } else if (this.simdElementType.equals(SIMDType.SIMDBool32x4.class) || this.simdElementType.equals(SIMDType.SIMDBool16x8.class) || this.simdElementType.equals(SIMDType.SIMDBool8x16.class)) {
                this.doBooleanNot(a, res);
            }
            return res;
        }

        @ExplodeLoop
        private void doIntNot(DynamicObject a, DynamicObject res) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                int ax = (Integer)SIMDNotNode.getLane(a, i);
                SIMDNotNode.setLane(res, i, ~ax);
            }
        }

        @ExplodeLoop
        private void doShortNot(DynamicObject a, DynamicObject rest) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                int ax = (Integer)SIMDNotNode.getLane(a, i);
                SIMDNotNode.setLane(rest, i, (short)(~ax));
            }
        }

        @ExplodeLoop
        private void doByteNot(DynamicObject a, DynamicObject rest) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                int ax = (Integer)SIMDNotNode.getLane(a, i);
                SIMDNotNode.setLane(rest, i, (byte)(~ax));
            }
        }

        @ExplodeLoop
        private void doBooleanNot(DynamicObject a, DynamicObject rest) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                boolean ax = (Boolean)SIMDNotNode.getLane(a, i);
                SIMDNotNode.setLane(rest, i, !ax);
            }
        }
    }

    public static abstract class SIMDOrNode
    extends JSBasicSimdOperation {
        protected SIMDOrNode(JSContext context, JSBuiltin builtin, SIMDType simdContext) {
            super(context, builtin, simdContext);
        }

        public static SIMDOrNode create(JSContext context, JSBuiltin builtin, SIMDType simdContext, JavaScriptNode[] createArgumentNodes) {
            return SIMDTypeFunctionBuiltinsFactory.SIMDOrNodeGen.create(context, builtin, simdContext, createArgumentNodes);
        }

        @Specialization
        protected Object doOr(DynamicObject a, DynamicObject b) {
            DynamicObject res = JSSIMD.createSIMD(this.getContext(), this.simdContext);
            if (this.simdElementType.equals(SIMDType.SIMDInt32x4.class) || this.simdElementType.equals(SIMDType.SIMDUint32x4.class)) {
                this.doIntOr(a, b, res);
            } else if (this.simdElementType.equals(SIMDType.SIMDInt16x8.class) || this.simdElementType.equals(SIMDType.SIMDUint16x8.class)) {
                this.doShortOr(a, b, res);
            } else if (this.simdElementType.equals(SIMDType.SIMDInt8x16.class) || this.simdElementType.equals(SIMDType.SIMDUint8x16.class)) {
                this.doByteOr(a, b, res);
            } else if (this.simdElementType.equals(SIMDType.SIMDBool32x4.class) || this.simdElementType.equals(SIMDType.SIMDBool16x8.class) || this.simdElementType.equals(SIMDType.SIMDBool8x16.class)) {
                this.doBooleanOr(a, b, res);
            }
            return res;
        }

        @ExplodeLoop
        private void doIntOr(DynamicObject a, DynamicObject b, DynamicObject res) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                int ax = (Integer)SIMDOrNode.getLane(a, i);
                int bx = (Integer)SIMDOrNode.getLane(b, i);
                SIMDOrNode.setLane(res, i, ax | bx);
            }
        }

        @ExplodeLoop
        private void doShortOr(DynamicObject a, DynamicObject b, DynamicObject rest) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                int ax = (Integer)SIMDOrNode.getLane(a, i);
                int bx = (Integer)SIMDOrNode.getLane(b, i);
                SIMDOrNode.setLane(rest, i, (short)(ax | bx));
            }
        }

        @ExplodeLoop
        private void doByteOr(DynamicObject a, DynamicObject b, DynamicObject rest) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                int ax = (Integer)SIMDOrNode.getLane(a, i);
                int bx = (Integer)SIMDOrNode.getLane(b, i);
                SIMDOrNode.setLane(rest, i, (byte)(ax | bx));
            }
        }

        @ExplodeLoop
        private void doBooleanOr(DynamicObject a, DynamicObject b, DynamicObject rest) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                boolean ax = (Boolean)SIMDOrNode.getLane(a, i);
                boolean bx = (Boolean)SIMDOrNode.getLane(b, i);
                SIMDOrNode.setLane(rest, i, ax || bx);
            }
        }
    }

    public static abstract class SIMDXorNode
    extends JSBasicSimdOperation {
        protected SIMDXorNode(JSContext context, JSBuiltin builtin, SIMDType simdContext) {
            super(context, builtin, simdContext);
        }

        public static SIMDXorNode create(JSContext context, JSBuiltin builtin, SIMDType simdContext, JavaScriptNode[] createArgumentNodes) {
            return SIMDTypeFunctionBuiltinsFactory.SIMDXorNodeGen.create(context, builtin, simdContext, createArgumentNodes);
        }

        @Specialization
        protected Object doXor(DynamicObject a, DynamicObject b) {
            DynamicObject res = JSSIMD.createSIMD(this.getContext(), this.simdContext);
            if (this.simdElementType.equals(SIMDType.SIMDInt32x4.class) || this.simdElementType.equals(SIMDType.SIMDUint32x4.class)) {
                this.doIntXor(a, b, res);
            } else if (this.simdElementType.equals(SIMDType.SIMDInt16x8.class) || this.simdElementType.equals(SIMDType.SIMDUint16x8.class)) {
                this.doShortXor(a, b, res);
            } else if (this.simdElementType.equals(SIMDType.SIMDInt8x16.class) || this.simdElementType.equals(SIMDType.SIMDUint8x16.class)) {
                this.doByteXor(a, b, res);
            } else if (this.simdElementType.equals(SIMDType.SIMDBool32x4.class) || this.simdElementType.equals(SIMDType.SIMDBool16x8.class) || this.simdElementType.equals(SIMDType.SIMDBool8x16.class)) {
                this.doBooleanXor(a, b, res);
            }
            return res;
        }

        @ExplodeLoop
        private void doIntXor(DynamicObject a, DynamicObject b, DynamicObject res) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                int ax = (Integer)SIMDXorNode.getLane(a, i);
                int bx = (Integer)SIMDXorNode.getLane(b, i);
                SIMDXorNode.setLane(res, i, ax ^ bx);
            }
        }

        @ExplodeLoop
        private void doShortXor(DynamicObject a, DynamicObject b, DynamicObject rest) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                int ax = (Integer)SIMDXorNode.getLane(a, i);
                int bx = (Integer)SIMDXorNode.getLane(b, i);
                SIMDXorNode.setLane(rest, i, (short)(ax ^ bx));
            }
        }

        @ExplodeLoop
        private void doByteXor(DynamicObject a, DynamicObject b, DynamicObject rest) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                int ax = (Integer)SIMDXorNode.getLane(a, i);
                int bx = (Integer)SIMDXorNode.getLane(b, i);
                SIMDXorNode.setLane(rest, i, (byte)(ax ^ bx));
            }
        }

        @ExplodeLoop
        private void doBooleanXor(DynamicObject a, DynamicObject b, DynamicObject rest) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                boolean ax = (Boolean)SIMDXorNode.getLane(a, i);
                boolean bx = (Boolean)SIMDXorNode.getLane(b, i);
                SIMDXorNode.setLane(rest, i, ax ^ bx);
            }
        }
    }

    public static abstract class SIMDAndNode
    extends JSBasicSimdOperation {
        protected SIMDAndNode(JSContext context, JSBuiltin builtin, SIMDType simdContext) {
            super(context, builtin, simdContext);
        }

        public static SIMDAndNode create(JSContext context, JSBuiltin builtin, SIMDType simdContext, JavaScriptNode[] createArgumentNodes) {
            return SIMDTypeFunctionBuiltinsFactory.SIMDAndNodeGen.create(context, builtin, simdContext, createArgumentNodes);
        }

        @Specialization
        protected Object doAnd(DynamicObject a, DynamicObject b) {
            DynamicObject res = JSSIMD.createSIMD(this.getContext(), this.simdContext);
            if (this.simdElementType.equals(SIMDType.SIMDInt32x4.class) || this.simdElementType.equals(SIMDType.SIMDUint32x4.class)) {
                this.doIntAnd(a, b, res);
            } else if (this.simdElementType.equals(SIMDType.SIMDInt16x8.class) || this.simdElementType.equals(SIMDType.SIMDUint16x8.class)) {
                this.doShortAnd(a, b, res);
            } else if (this.simdElementType.equals(SIMDType.SIMDInt8x16.class) || this.simdElementType.equals(SIMDType.SIMDUint8x16.class)) {
                this.doByteAnd(a, b, res);
            } else if (this.simdElementType.equals(SIMDType.SIMDBool32x4.class) || this.simdElementType.equals(SIMDType.SIMDBool16x8.class) || this.simdElementType.equals(SIMDType.SIMDBool8x16.class)) {
                this.doBooleanAnd(a, b, res);
            }
            return res;
        }

        @ExplodeLoop
        private void doIntAnd(DynamicObject a, DynamicObject b, DynamicObject res) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                int ax = (Integer)SIMDAndNode.getLane(a, i);
                int bx = (Integer)SIMDAndNode.getLane(b, i);
                SIMDAndNode.setLane(res, i, ax & bx);
            }
        }

        @ExplodeLoop
        private void doShortAnd(DynamicObject a, DynamicObject b, DynamicObject rest) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                int ax = (Integer)SIMDAndNode.getLane(a, i);
                int bx = (Integer)SIMDAndNode.getLane(b, i);
                SIMDAndNode.setLane(rest, i, (short)(ax & bx));
            }
        }

        @ExplodeLoop
        private void doByteAnd(DynamicObject a, DynamicObject b, DynamicObject rest) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                int ax = (Integer)SIMDAndNode.getLane(a, i);
                int bx = (Integer)SIMDAndNode.getLane(b, i);
                SIMDAndNode.setLane(rest, i, (byte)(ax & bx));
            }
        }

        @ExplodeLoop
        private void doBooleanAnd(DynamicObject a, DynamicObject b, DynamicObject rest) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                boolean ax = (Boolean)SIMDAndNode.getLane(a, i);
                boolean bx = (Boolean)SIMDAndNode.getLane(b, i);
                SIMDAndNode.setLane(rest, i, ax && bx);
            }
        }
    }

    public static abstract class SIMDAbsNode
    extends JSBasicSimdOperation {
        protected SIMDAbsNode(JSContext context, JSBuiltin builtin, SIMDType simdContext) {
            super(context, builtin, simdContext);
        }

        public static SIMDAbsNode create(JSContext context, JSBuiltin builtin, SIMDType simdContext, JavaScriptNode[] createArgumentNodes) {
            return SIMDTypeFunctionBuiltinsFactory.SIMDAbsNodeGen.create(context, builtin, simdContext, createArgumentNodes);
        }

        @ExplodeLoop
        @Specialization
        protected Object doAbs(DynamicObject a) {
            DynamicObject res = JSSIMD.createSIMD(this.getContext(), this.simdContext);
            for (int i = 0; i < this.numberOfElements; ++i) {
                float ax = ((Float)SIMDAbsNode.getLane(a, i)).floatValue();
                SIMDAbsNode.setLane(res, i, Float.valueOf(Math.abs(ax)));
            }
            return res;
        }
    }

    public static abstract class SIMDreciprocalSqrtApproximationNode
    extends JSBasicSimdOperation {
        protected SIMDreciprocalSqrtApproximationNode(JSContext context, JSBuiltin builtin, SIMDType simdContext) {
            super(context, builtin, simdContext);
        }

        public static SIMDreciprocalSqrtApproximationNode create(JSContext context, JSBuiltin builtin, SIMDType simdContext, JavaScriptNode[] createArgumentNodes) {
            return SIMDTypeFunctionBuiltinsFactory.SIMDreciprocalSqrtApproximationNodeGen.create(context, builtin, simdContext, createArgumentNodes);
        }

        @ExplodeLoop
        @Specialization
        protected Object doReciSqrtApprox(DynamicObject a) {
            DynamicObject res = JSSIMD.createSIMD(this.getContext(), this.simdContext);
            for (int i = 0; i < this.numberOfElements; ++i) {
                float ax = ((Float)SIMDreciprocalSqrtApproximationNode.getLane(a, i)).floatValue();
                SIMDreciprocalSqrtApproximationNode.setLane(res, i, Float.valueOf(this.reciprocalSqrtApproximation(ax)));
            }
            return res;
        }
    }

    public static abstract class SIMDreciprocalApproximationNode
    extends JSBasicSimdOperation {
        protected SIMDreciprocalApproximationNode(JSContext context, JSBuiltin builtin, SIMDType simdContext) {
            super(context, builtin, simdContext);
        }

        public static SIMDreciprocalApproximationNode create(JSContext context, JSBuiltin builtin, SIMDType simdContext, JavaScriptNode[] createArgumentNodes) {
            return SIMDTypeFunctionBuiltinsFactory.SIMDreciprocalApproximationNodeGen.create(context, builtin, simdContext, createArgumentNodes);
        }

        @ExplodeLoop
        @Specialization
        protected Object doReciApprox(DynamicObject a) {
            DynamicObject res = JSSIMD.createSIMD(this.getContext(), this.simdContext);
            for (int i = 0; i < this.numberOfElements; ++i) {
                float ax = ((Float)SIMDreciprocalApproximationNode.getLane(a, i)).floatValue();
                SIMDreciprocalApproximationNode.setLane(res, i, Float.valueOf(this.reciprocalApproximation(ax)));
            }
            return res;
        }
    }

    public static abstract class SIMDSqrtNode
    extends JSBasicSimdOperation {
        protected SIMDSqrtNode(JSContext context, JSBuiltin builtin, SIMDType simdContext) {
            super(context, builtin, simdContext);
        }

        public static SIMDSqrtNode create(JSContext context, JSBuiltin builtin, SIMDType simdContext, JavaScriptNode[] createArgumentNodes) {
            return SIMDTypeFunctionBuiltinsFactory.SIMDSqrtNodeGen.create(context, builtin, simdContext, createArgumentNodes);
        }

        @ExplodeLoop
        @Specialization
        protected Object doSqrt(DynamicObject a) {
            DynamicObject res = JSSIMD.createSIMD(this.getContext(), this.simdContext);
            for (int i = 0; i < this.numberOfElements; ++i) {
                float ax = ((Float)SIMDSqrtNode.getLane(a, i)).floatValue();
                SIMDSqrtNode.setLane(res, i, Float.valueOf((float)Math.sqrt(ax)));
            }
            return res;
        }
    }

    public static abstract class SIMDNegNode
    extends JSBasicSimdOperation {
        protected SIMDNegNode(JSContext context, JSBuiltin builtin, SIMDType simdContext) {
            super(context, builtin, simdContext);
        }

        public static SIMDNegNode create(JSContext context, JSBuiltin builtin, SIMDType simdContext, JavaScriptNode[] createArgumentNodes) {
            return SIMDTypeFunctionBuiltinsFactory.SIMDNegNodeGen.create(context, builtin, simdContext, createArgumentNodes);
        }

        @Specialization
        protected Object doNeg(DynamicObject a) {
            DynamicObject res = JSSIMD.createSIMD(this.getContext(), this.simdContext);
            if (this.simdElementType.equals(SIMDType.SIMDInt32x4.class) || this.simdElementType.equals(SIMDType.SIMDUint32x4.class)) {
                this.doIntNeg(a, res);
            } else if (this.simdElementType.equals(SIMDType.SIMDInt16x8.class) || this.simdElementType.equals(SIMDType.SIMDUint16x8.class)) {
                this.doShortNeg(a, res);
            } else if (this.simdElementType.equals(SIMDType.SIMDInt8x16.class) || this.simdElementType.equals(SIMDType.SIMDUint8x16.class)) {
                this.doByteNeg(a, res);
            } else if (this.simdElementType.equals(SIMDType.SIMDFloat32x4.class)) {
                this.doFloatNeg(a, res);
            }
            return res;
        }

        @ExplodeLoop
        private void doIntNeg(DynamicObject a, DynamicObject res) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                int ax = (Integer)SIMDNegNode.getLane(a, i);
                SIMDNegNode.setLane(res, i, -ax);
            }
        }

        @ExplodeLoop
        private void doShortNeg(DynamicObject a, DynamicObject rest) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                int ax = (Integer)SIMDNegNode.getLane(a, i);
                SIMDNegNode.setLane(rest, i, (short)(-ax));
            }
        }

        @ExplodeLoop
        private void doByteNeg(DynamicObject a, DynamicObject rest) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                int ax = (Integer)SIMDNegNode.getLane(a, i);
                SIMDNegNode.setLane(rest, i, (byte)(-ax));
            }
        }

        @ExplodeLoop
        private void doFloatNeg(DynamicObject a, DynamicObject rest) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                float ax = ((Float)SIMDNegNode.getLane(a, i)).floatValue();
                SIMDNegNode.setLane(rest, i, Float.valueOf(-ax));
            }
        }
    }

    public static abstract class SIMDMaxNumNode
    extends JSBasicSimdOperation {
        protected SIMDMaxNumNode(JSContext context, JSBuiltin builtin, SIMDType simdContext) {
            super(context, builtin, simdContext);
        }

        public static SIMDMaxNumNode create(JSContext context, JSBuiltin builtin, SIMDType simdContext, JavaScriptNode[] createArgumentNodes) {
            return SIMDTypeFunctionBuiltinsFactory.SIMDMaxNumNodeGen.create(context, builtin, simdContext, createArgumentNodes);
        }

        @ExplodeLoop
        @Specialization
        protected Object doMaxNum(DynamicObject a, DynamicObject b) {
            DynamicObject res = JSSIMD.createSIMD(this.getContext(), this.simdContext);
            for (int i = 0; i < this.numberOfElements; ++i) {
                float ax = ((Float)SIMDMaxNumNode.getLane(a, i)).floatValue();
                float bx = ((Float)SIMDMaxNumNode.getLane(b, i)).floatValue();
                if (Float.isNaN(ax)) {
                    SIMDMaxNumNode.setLane(res, i, Float.valueOf(bx));
                    continue;
                }
                if (Float.isNaN(bx)) {
                    SIMDMaxNumNode.setLane(res, i, Float.valueOf(ax));
                    continue;
                }
                SIMDMaxNumNode.setLane(res, i, Float.valueOf(Math.max(ax, bx)));
            }
            return res;
        }
    }

    public static abstract class SIMDMinNumNode
    extends JSBasicSimdOperation {
        protected SIMDMinNumNode(JSContext context, JSBuiltin builtin, SIMDType simdContext) {
            super(context, builtin, simdContext);
        }

        public static SIMDMinNumNode create(JSContext context, JSBuiltin builtin, SIMDType simdContext, JavaScriptNode[] createArgumentNodes) {
            return SIMDTypeFunctionBuiltinsFactory.SIMDMinNumNodeGen.create(context, builtin, simdContext, createArgumentNodes);
        }

        @ExplodeLoop
        @Specialization
        protected Object doMinNum(DynamicObject a, DynamicObject b) {
            DynamicObject res = JSSIMD.createSIMD(this.getContext(), this.simdContext);
            for (int i = 0; i < this.numberOfElements; ++i) {
                float ax = ((Float)SIMDMinNumNode.getLane(a, i)).floatValue();
                float bx = ((Float)SIMDMinNumNode.getLane(b, i)).floatValue();
                if (Float.isNaN(ax)) {
                    SIMDMinNumNode.setLane(res, i, Float.valueOf(bx));
                    continue;
                }
                if (Float.isNaN(bx)) {
                    SIMDMinNumNode.setLane(res, i, Float.valueOf(ax));
                    continue;
                }
                SIMDMinNumNode.setLane(res, i, Float.valueOf(Math.min(ax, bx)));
            }
            return res;
        }
    }

    public static abstract class SIMDMaxNode
    extends JSBasicSimdOperation {
        protected SIMDMaxNode(JSContext context, JSBuiltin builtin, SIMDType simdContext) {
            super(context, builtin, simdContext);
        }

        public static SIMDMaxNode create(JSContext context, JSBuiltin builtin, SIMDType simdContext, JavaScriptNode[] createArgumentNodes) {
            return SIMDTypeFunctionBuiltinsFactory.SIMDMaxNodeGen.create(context, builtin, simdContext, createArgumentNodes);
        }

        @ExplodeLoop
        @Specialization
        protected Object doMax(DynamicObject a, DynamicObject b) {
            DynamicObject res = JSSIMD.createSIMD(this.getContext(), this.simdContext);
            for (int i = 0; i < this.numberOfElements; ++i) {
                float ax = ((Float)SIMDMaxNode.getLane(a, i)).floatValue();
                float bx = ((Float)SIMDMaxNode.getLane(b, i)).floatValue();
                SIMDMaxNode.setLane(res, i, Float.valueOf(Math.max(ax, bx)));
            }
            return res;
        }
    }

    public static abstract class SIMDMinNode
    extends JSBasicSimdOperation {
        protected SIMDMinNode(JSContext context, JSBuiltin builtin, SIMDType simdContext) {
            super(context, builtin, simdContext);
        }

        public static SIMDMinNode create(JSContext context, JSBuiltin builtin, SIMDType simdContext, JavaScriptNode[] createArgumentNodes) {
            return SIMDTypeFunctionBuiltinsFactory.SIMDMinNodeGen.create(context, builtin, simdContext, createArgumentNodes);
        }

        @ExplodeLoop
        @Specialization
        protected Object doMin(DynamicObject a, DynamicObject b) {
            DynamicObject res = JSSIMD.createSIMD(this.getContext(), this.simdContext);
            for (int i = 0; i < this.numberOfElements; ++i) {
                float ax = ((Float)SIMDMinNode.getLane(a, i)).floatValue();
                float bx = ((Float)SIMDMinNode.getLane(b, i)).floatValue();
                SIMDMinNode.setLane(res, i, Float.valueOf(Math.min(ax, bx)));
            }
            return res;
        }
    }

    public static abstract class SIMDDivNode
    extends JSBasicSimdOperation {
        protected SIMDDivNode(JSContext context, JSBuiltin builtin, SIMDType simdContext) {
            super(context, builtin, simdContext);
        }

        public static SIMDDivNode create(JSContext context, JSBuiltin builtin, SIMDType simdContext, JavaScriptNode[] createArgumentNodes) {
            return SIMDTypeFunctionBuiltinsFactory.SIMDDivNodeGen.create(context, builtin, simdContext, createArgumentNodes);
        }

        @ExplodeLoop
        @Specialization
        protected Object doDiv(DynamicObject a, DynamicObject b) {
            DynamicObject res = JSSIMD.createSIMD(this.getContext(), this.simdContext);
            for (int i = 0; i < this.numberOfElements; ++i) {
                float ax = ((Float)SIMDDivNode.getLane(a, i)).floatValue();
                float bx = ((Float)SIMDDivNode.getLane(b, i)).floatValue();
                SIMDDivNode.setLane(res, i, Float.valueOf(ax / bx));
            }
            return res;
        }
    }

    public static abstract class SIMDMulNode
    extends JSBasicSimdOperation {
        protected SIMDMulNode(JSContext context, JSBuiltin builtin, SIMDType simdContext) {
            super(context, builtin, simdContext);
        }

        public static SIMDMulNode create(JSContext context, JSBuiltin builtin, SIMDType simdContext, JavaScriptNode[] createArgumentNodes) {
            return SIMDTypeFunctionBuiltinsFactory.SIMDMulNodeGen.create(context, builtin, simdContext, createArgumentNodes);
        }

        @Specialization
        protected Object doMul(DynamicObject a, DynamicObject b) {
            DynamicObject res = JSSIMD.createSIMD(this.getContext(), this.simdContext);
            if (this.simdElementType.equals(SIMDType.SIMDInt32x4.class) || this.simdElementType.equals(SIMDType.SIMDUint32x4.class)) {
                this.doIntMul(a, b, res);
            } else if (this.simdElementType.equals(SIMDType.SIMDInt16x8.class) || this.simdElementType.equals(SIMDType.SIMDUint16x8.class)) {
                this.doShortMul(a, b, res);
            } else if (this.simdElementType.equals(SIMDType.SIMDInt8x16.class) || this.simdElementType.equals(SIMDType.SIMDUint8x16.class)) {
                this.doByteMul(a, b, res);
            } else if (this.simdElementType.equals(SIMDType.SIMDFloat32x4.class)) {
                this.doFloatMul(a, b, res);
            }
            return res;
        }

        @ExplodeLoop
        private void doIntMul(DynamicObject a, DynamicObject b, DynamicObject res) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                int ax = (Integer)SIMDMulNode.getLane(a, i);
                int bx = (Integer)SIMDMulNode.getLane(b, i);
                SIMDMulNode.setLane(res, i, ax * bx);
            }
        }

        @ExplodeLoop
        private void doShortMul(DynamicObject a, DynamicObject b, DynamicObject rest) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                int ax = (Integer)SIMDMulNode.getLane(a, i);
                int bx = (Integer)SIMDMulNode.getLane(b, i);
                SIMDMulNode.setLane(rest, i, (short)(ax * bx));
            }
        }

        @ExplodeLoop
        private void doByteMul(DynamicObject a, DynamicObject b, DynamicObject rest) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                int ax = (Integer)SIMDMulNode.getLane(a, i);
                int bx = (Integer)SIMDMulNode.getLane(b, i);
                SIMDMulNode.setLane(rest, i, (byte)(ax * bx));
            }
        }

        @ExplodeLoop
        private void doFloatMul(DynamicObject a, DynamicObject b, DynamicObject rest) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                float ax = ((Float)SIMDMulNode.getLane(a, i)).floatValue();
                float bx = ((Float)SIMDMulNode.getLane(b, i)).floatValue();
                SIMDMulNode.setLane(rest, i, Float.valueOf(ax * bx));
            }
        }
    }

    public static abstract class SIMDSubNode
    extends JSBasicSimdOperation {
        protected SIMDSubNode(JSContext context, JSBuiltin builtin, SIMDType simdContext) {
            super(context, builtin, simdContext);
        }

        public static SIMDSubNode create(JSContext context, JSBuiltin builtin, SIMDType simdContext, JavaScriptNode[] createArgumentNodes) {
            return SIMDTypeFunctionBuiltinsFactory.SIMDSubNodeGen.create(context, builtin, simdContext, createArgumentNodes);
        }

        @Specialization
        protected Object doSub(DynamicObject a, DynamicObject b) {
            DynamicObject res = JSSIMD.createSIMD(this.getContext(), this.simdContext);
            if (this.simdElementType.equals(SIMDType.SIMDInt32x4.class) || this.simdElementType.equals(SIMDType.SIMDUint32x4.class)) {
                this.doIntSub(a, b, res);
            } else if (this.simdElementType.equals(SIMDType.SIMDInt16x8.class) || this.simdElementType.equals(SIMDType.SIMDUint16x8.class)) {
                this.doShortSub(a, b, res);
            } else if (this.simdElementType.equals(SIMDType.SIMDInt8x16.class) || this.simdElementType.equals(SIMDType.SIMDUint8x16.class)) {
                this.doByteSub(a, b, res);
            } else if (this.simdElementType.equals(SIMDType.SIMDFloat32x4.class)) {
                this.doFloatSub(a, b, res);
            }
            return res;
        }

        @ExplodeLoop
        private void doIntSub(DynamicObject a, DynamicObject b, DynamicObject res) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                int ax = (Integer)SIMDSubNode.getLane(a, i);
                int bx = (Integer)SIMDSubNode.getLane(b, i);
                SIMDSubNode.setLane(res, i, ax - bx);
            }
        }

        @ExplodeLoop
        private void doShortSub(DynamicObject a, DynamicObject b, DynamicObject rest) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                int ax = (Integer)SIMDSubNode.getLane(a, i);
                int bx = (Integer)SIMDSubNode.getLane(b, i);
                SIMDSubNode.setLane(rest, i, (short)(ax - bx));
            }
        }

        @ExplodeLoop
        private void doByteSub(DynamicObject a, DynamicObject b, DynamicObject rest) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                int ax = (Integer)SIMDSubNode.getLane(a, i);
                int bx = (Integer)SIMDSubNode.getLane(b, i);
                SIMDSubNode.setLane(rest, i, (byte)(ax - bx));
            }
        }

        @ExplodeLoop
        private void doFloatSub(DynamicObject a, DynamicObject b, DynamicObject rest) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                float ax = ((Float)SIMDSubNode.getLane(a, i)).floatValue();
                float bx = ((Float)SIMDSubNode.getLane(b, i)).floatValue();
                SIMDSubNode.setLane(rest, i, Float.valueOf(ax - bx));
            }
        }
    }

    public static abstract class SIMDAddNode
    extends JSBasicSimdOperation {
        protected SIMDAddNode(JSContext context, JSBuiltin builtin, SIMDType simdContext) {
            super(context, builtin, simdContext);
        }

        public static SIMDAddNode create(JSContext context, JSBuiltin builtin, SIMDType simdContext, JavaScriptNode[] createArgumentNodes) {
            return SIMDTypeFunctionBuiltinsFactory.SIMDAddNodeGen.create(context, builtin, simdContext, createArgumentNodes);
        }

        @Specialization
        protected Object doAdd(DynamicObject a, DynamicObject b) {
            DynamicObject res = JSSIMD.createSIMD(this.getContext(), this.simdContext);
            if (this.simdElementType.equals(SIMDType.SIMDInt32x4.class) || this.simdElementType.equals(SIMDType.SIMDUint32x4.class)) {
                this.doIntAdd(a, b, res);
            } else if (this.simdElementType.equals(SIMDType.SIMDInt16x8.class) || this.simdElementType.equals(SIMDType.SIMDUint16x8.class)) {
                this.doShortAdd(a, b, res);
            } else if (this.simdElementType.equals(SIMDType.SIMDInt8x16.class) || this.simdElementType.equals(SIMDType.SIMDUint8x16.class)) {
                this.doByteAdd(a, b, res);
            } else if (this.simdElementType.equals(SIMDType.SIMDFloat32x4.class)) {
                this.doFloatAdd(a, b, res);
            }
            return res;
        }

        @ExplodeLoop
        private void doIntAdd(DynamicObject a, DynamicObject b, DynamicObject res) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                int ax = (Integer)SIMDAddNode.getLane(a, i);
                int bx = (Integer)SIMDAddNode.getLane(b, i);
                SIMDAddNode.setLane(res, i, ax + bx);
            }
        }

        @ExplodeLoop
        private void doShortAdd(DynamicObject a, DynamicObject b, DynamicObject rest) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                int ax = (Integer)SIMDAddNode.getLane(a, i);
                int bx = (Integer)SIMDAddNode.getLane(b, i);
                SIMDAddNode.setLane(rest, i, (short)(ax + bx));
            }
        }

        @ExplodeLoop
        private void doByteAdd(DynamicObject a, DynamicObject b, DynamicObject rest) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                int ax = (Integer)SIMDAddNode.getLane(a, i);
                int bx = (Integer)SIMDAddNode.getLane(b, i);
                SIMDAddNode.setLane(rest, i, (byte)(ax + bx));
            }
        }

        @ExplodeLoop
        private void doFloatAdd(DynamicObject a, DynamicObject b, DynamicObject rest) {
            for (int i = 0; i < this.numberOfElements; ++i) {
                float ax = ((Float)SIMDAddNode.getLane(a, i)).floatValue();
                float bx = ((Float)SIMDAddNode.getLane(b, i)).floatValue();
                SIMDAddNode.setLane(rest, i, Float.valueOf(ax + bx));
            }
        }
    }

    public static abstract class SIMDCheckNode
    extends JSBasicSimdOperation {
        protected SIMDCheckNode(JSContext context, JSBuiltin builtin, SIMDType simdContext) {
            super(context, builtin, simdContext);
        }

        public static SIMDCheckNode create(JSContext context, JSBuiltin builtin, SIMDType simdContext, JavaScriptNode[] createArgumentNodes) {
            return SIMDTypeFunctionBuiltinsFactory.SIMDCheckNodeGen.create(context, builtin, simdContext, createArgumentNodes);
        }

        @Specialization
        protected Object doCheck(Object a) {
            if (!JSSIMD.isJSSIMD(a) || JSSIMD.simdTypeGetSIMDType((DynamicObject)a) != this.simdContext) {
                this.errorBranch.enter();
                throw Errors.createSIMDExpected();
            }
            return a;
        }
    }

    public static abstract class SIMDSplatNode
    extends JSBasicSimdOperation {
        protected SIMDSplatNode(JSContext context, JSBuiltin builtin, SIMDType simdContext) {
            super(context, builtin, simdContext);
        }

        public static Object create(JSContext context, JSBuiltin builtin, SIMDType simdContext, JavaScriptNode[] createArgumentNodes) {
            return SIMDTypeFunctionBuiltinsFactory.SIMDSplatNodeGen.create(context, builtin, simdContext, createArgumentNodes);
        }

        @ExplodeLoop
        @Specialization
        protected Object executeSplat(Object n) {
            DynamicObject res = JSSIMD.createSIMD(this.getContext(), this.simdContext);
            Object val = this.cast(0, n);
            for (int i = 0; i < this.numberOfElements; ++i) {
                SIMDSplatNode.setLane(res, i, val);
            }
            return res;
        }
    }

    public static abstract class JSBasicSimdOperation
    extends JSBuiltinNode {
        protected final Class<?> simdElementType;
        protected final int numberOfElements;
        protected final SIMDType simdContext;
        protected final BranchProfile errorBranch = BranchProfile.create();
        protected final ValueProfile typedArrayProfile = ValueProfile.createIdentityProfile();
        @Node.Child
        private JSToLengthNode toLengthNode;
        @Node.Child
        private JSEqualNode equalNode;
        @Node.Child
        private JSToNumberNode toNumberNode;
        @Node.Child
        protected JSToUInt32Node toUInt32Node;
        @Node.Children
        protected final SIMDCastNode[] castNodes;

        public JSBasicSimdOperation(JSContext context, JSBuiltin builtin, SIMDType simdContext, int numberOfNodes) {
            super(context, builtin);
            this.simdContext = simdContext;
            this.numberOfElements = simdContext == null ? 16 : simdContext.getNumberOfElements();
            this.simdElementType = simdContext != null ? simdContext.getClass() : null;
            this.castNodes = new SIMDCastNode[numberOfNodes];
            for (int i = 0; i < numberOfNodes; ++i) {
                this.castNodes[i] = SIMDCastNode.create(simdContext);
            }
        }

        public JSBasicSimdOperation(JSContext context, JSBuiltin builtin, SIMDType simdContext) {
            this(context, builtin, simdContext, simdContext == null ? 16 : simdContext.getNumberOfElements());
        }

        protected JSEqualNode getEqualNode() {
            if (this.equalNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.equalNode = (JSEqualNode)this.insert(JSEqualNode.create());
            }
            return this.equalNode;
        }

        protected JSToNumberNode getToNumberNode() {
            if (this.toNumberNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toNumberNode = (JSToNumberNode)this.insert(JSToNumberNode.create());
            }
            return this.toNumberNode;
        }

        protected JSToUInt32Node getToUInt32Node() {
            if (this.toUInt32Node == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toUInt32Node = (JSToUInt32Node)this.insert(JSToUInt32Node.create());
            }
            return this.toUInt32Node;
        }

        protected JSToLengthNode getToLengthNode() {
            if (this.toLengthNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toLengthNode = (JSToLengthNode)this.insert(JSToLengthNode.create());
            }
            return this.toLengthNode;
        }

        protected Object cast(int i, Object o) {
            return this.castNodes[i].execute(o);
        }

        protected static final Object getLane(DynamicObject simd, int lane) {
            Object obj = JSSIMD.simdGetArray(simd, JSSIMD.isJSSIMD((Object)simd));
            Object[] array = (Object[])obj;
            Object value = array[lane];
            assert (value != null);
            return value;
        }

        protected static final void setLane(DynamicObject simd, int lane, Object value) {
            Object obj = JSSIMD.simdGetArray(simd, JSSIMD.isJSSIMD((Object)simd));
            Object[] array = (Object[])obj;
            array[lane] = value;
        }

        protected boolean sameValueZero(Number x, Number y) {
            double xd = JSRuntime.toDouble(x);
            double yd = JSRuntime.toDouble(y);
            if (Double.isNaN(xd)) {
                return Double.isNaN(yd);
            }
            return xd == yd;
        }

        @ExplodeLoop
        public DynamicObject simdCreate(SIMDType descriptor, List<Object> vectorElements) {
            assert (vectorElements.size() == descriptor.getFactory().getNumberOfElements());
            assert (vectorElements.size() == this.numberOfElements);
            DynamicObject t = JSSIMD.createSIMD(this.getContext(), descriptor);
            for (int i = 0; i < this.numberOfElements; ++i) {
                JSBasicSimdOperation.setLane(t, i, this.cast(i, Boundaries.listGet(vectorElements, i)));
            }
            return t;
        }

        public int simdToLane(int max, Object lane) {
            Number index = this.getToNumberNode().executeNumber(lane);
            int in = JSRuntime.toInt32(index);
            if (!this.sameValueZero(index, this.getToLengthNode().executeLong(index)) || in < 0 || in >= max) {
                this.errorBranch.enter();
                throw Errors.createRangeError("lane out of bounds!");
            }
            return in;
        }

        protected Object simdLoad(byte[] dataBlock, SIMDType descriptor, int byteOffset, int length) {
            int i;
            if (byteOffset < 0 || byteOffset > dataBlock.length - descriptor.getBytesPerElement() * length) {
                this.errorBranch.enter();
                throw Errors.createError("assertion");
            }
            ArrayList<Object> elements = new ArrayList<Object>();
            for (i = 0; i < length; ++i) {
                Boundaries.listAdd(elements, descriptor.deserialize(dataBlock, byteOffset + i * descriptor.getBytesPerElement()));
            }
            for (i = length; i < descriptor.getFactory().getNumberOfElements(); ++i) {
                Boundaries.listAdd(elements, 0);
            }
            return this.simdCreate(descriptor, elements);
        }

        protected Object simdLoadFromTypedArray(DynamicObject tarray, Object index, SIMDType descriptor, int length) {
            byte[] block;
            if (!JSArrayBufferView.isJSArrayBufferView(tarray)) {
                this.errorBranch.enter();
                throw Errors.createTypeErrorArrayBufferViewExpected();
            }
            DynamicObject arrayBuffer = JSArrayBufferView.getArrayBuffer(tarray);
            if (!this.getContext().getTypedArrayNotDetachedAssumption().isValid() && JSArrayBuffer.isDetachedBuffer(arrayBuffer)) {
                this.errorBranch.enter();
                throw Errors.createTypeErrorDetachedBuffer();
            }
            boolean isHeapArrayBuffer = JSArrayBuffer.isJSHeapArrayBuffer(arrayBuffer);
            if (isHeapArrayBuffer) {
                block = JSArrayBuffer.getByteArray(arrayBuffer);
            } else {
                assert (JSArrayBuffer.isJSDirectArrayBuffer(arrayBuffer)) : JSObject.getJSClass(arrayBuffer);
                ByteBuffer byteBuffer = JSArrayBuffer.getDirectByteBuffer(arrayBuffer);
                block = new byte[JSArrayBuffer.getDirectByteLength(arrayBuffer)];
                ((ByteBuffer)BufferUtil.asBaseBuffer(byteBuffer.duplicate()).clear()).get(block);
            }
            long indx = this.getToLengthNode().executeLong(index);
            if (!(indx == 0L && index == Null.instance || this.getEqualNode().executeBoolean(index, indx))) {
                this.errorBranch.enter();
                throw Errors.createRangeError("index");
            }
            int byteLength = JSArrayBufferView.getByteLength(tarray, true, this.getContext(), this.typedArrayProfile);
            int elementlength = byteLength / JSArrayBufferView.typedArrayGetLength(tarray);
            long byteindex = indx * (long)elementlength;
            if (byteindex + (long)(this.simdContext.getFactory().getBytesPerElement() * length) > (long)byteLength || byteindex < 0L) {
                this.errorBranch.enter();
                throw Errors.createRangeError("");
            }
            return this.simdLoad(block, descriptor, (int)byteindex, length);
        }

        protected void simdStore(byte[] dataBlock, SIMDType descriptor, int byteOffset, DynamicObject n, int length) {
            if (byteOffset < 0 || byteOffset > dataBlock.length - descriptor.getBytesPerElement() * length) {
                this.errorBranch.enter();
                throw Errors.createError("assertion");
            }
            for (int i = 0; i < length; ++i) {
                descriptor.serialize(dataBlock, byteOffset + i * descriptor.getBytesPerElement(), JSBasicSimdOperation.getLane(n, i));
            }
        }

        protected Object simdStoreInTypedArray(DynamicObject tarray, Object index, SIMDType descriptor, DynamicObject n, int length) {
            byte[] block;
            if (!JSSIMD.isJSSIMD((Object)n)) {
                this.errorBranch.enter();
                throw Errors.createSIMDExpected();
            }
            if (!JSArrayBufferView.isJSArrayBufferView(tarray)) {
                this.errorBranch.enter();
                throw Errors.createTypeErrorArrayBufferViewExpected();
            }
            DynamicObject arrayBuffer = JSArrayBufferView.getArrayBuffer(tarray);
            if (arrayBuffer == null || arrayBuffer == Undefined.instance) {
                this.errorBranch.enter();
                throw Errors.createTypeError("TypedArray was null");
            }
            if (!this.getContext().getTypedArrayNotDetachedAssumption().isValid() && JSArrayBuffer.isDetachedBuffer(arrayBuffer)) {
                this.errorBranch.enter();
                throw Errors.createTypeErrorDetachedBuffer();
            }
            if (!JSArrayBufferView.isJSArrayBufferView(tarray)) {
                this.errorBranch.enter();
                throw Errors.createTypeError("not typed array");
            }
            boolean isHeapArrayBuffer = JSArrayBuffer.isJSHeapArrayBuffer(arrayBuffer);
            if (isHeapArrayBuffer) {
                block = JSArrayBuffer.getByteArray(arrayBuffer);
            } else {
                assert (JSArrayBuffer.isJSDirectArrayBuffer(arrayBuffer)) : JSObject.getJSClass(arrayBuffer);
                ByteBuffer byteBuffer = JSArrayBuffer.getDirectByteBuffer(arrayBuffer);
                block = new byte[JSArrayBuffer.getDirectByteLength(arrayBuffer)];
                ((ByteBuffer)BufferUtil.asBaseBuffer(byteBuffer.duplicate()).clear()).get(block);
            }
            long indx = this.getToLengthNode().executeLong(index);
            if (!(indx == 0L && index == Null.instance || this.getEqualNode().executeBoolean(indx, index))) {
                this.errorBranch.enter();
                throw Errors.createRangeError("invalid index");
            }
            int byteLength = JSArrayBufferView.getByteLength(tarray, true, this.getContext(), this.typedArrayProfile);
            int elementlength = byteLength / JSArrayBufferView.typedArrayGetLength(tarray);
            long byteindex = indx * (long)elementlength;
            if (byteindex + (long)(this.simdContext.getFactory().getBytesPerElement() * length) > (long)byteLength || byteindex < 0L) {
                this.errorBranch.enter();
                throw Errors.createRangeError("");
            }
            this.simdStore(block, this.simdContext, (int)byteindex, n, length);
            if (isHeapArrayBuffer) {
                JSArrayBufferView.typedArraySetArray(tarray, block);
            } else {
                ByteBuffer byteBuffer = JSArrayBuffer.getDirectByteBuffer(arrayBuffer);
                byteBuffer.duplicate().clear().put(block);
            }
            return n;
        }

        protected SIMDType simdBoolType(SIMDType descriptor) {
            if (descriptor.getFactory().getBytesPerElement() * 8 * descriptor.getFactory().getNumberOfElements() != 128) {
                this.errorBranch.enter();
                throw Errors.createError("not 128 bits");
            }
            switch (descriptor.getFactory().getNumberOfElements()) {
                case 4: {
                    return SIMDType.BOOL32X4_FACTORY.createSimdType();
                }
                case 8: {
                    return SIMDType.BOOL16X8_FACTORY.createSimdType();
                }
                case 16: {
                    return SIMDType.BOOL8X16_FACTORY.createSimdType();
                }
            }
            this.errorBranch.enter();
            throw Errors.createError("should not reach here");
        }

        protected boolean isUnsigned(SIMDType t) {
            return SIMDType.SIMDTypedUInt.class.isAssignableFrom(t.getClass());
        }

        protected boolean isIntegerSIMD(SIMDType t) {
            return SIMDType.SIMDTypeInt.class.isAssignableFrom(t.getClass());
        }

        protected boolean isFloatSIMD(SIMDType t) {
            return SIMDType.SIMDTypedFloat.class.isAssignableFrom(t.getClass());
        }

        protected float reciprocalApproximation(float n) {
            if (Float.isNaN(n)) {
                return Float.NaN;
            }
            if (new Float(n).equals(new Float(0.0))) {
                return Float.POSITIVE_INFINITY;
            }
            if (new Float(n).equals(new Float(-0.0))) {
                return Float.NEGATIVE_INFINITY;
            }
            if (n == Float.POSITIVE_INFINITY) {
                return 0.0f;
            }
            if (n == Float.NEGATIVE_INFINITY) {
                return 0.0f;
            }
            return (float)(1.0 / (double)n);
        }

        protected float reciprocalSqrtApproximation(float n) {
            if (Float.isNaN(n)) {
                return Float.NaN;
            }
            if (new Float(n).equals(new Float(0.0))) {
                return Float.POSITIVE_INFINITY;
            }
            if (new Float(n).equals(new Float(-0.0))) {
                return Float.NEGATIVE_INFINITY;
            }
            if (n == Float.POSITIVE_INFINITY) {
                return 0.0f;
            }
            if (n < 0.0f) {
                return Float.NaN;
            }
            return (float)(1.0 / Math.sqrt(n));
        }

        protected long saturate(SIMDType.SIMDTypeInt descriptor, long x) {
            if (x > descriptor.getMax()) {
                return descriptor.getMax();
            }
            if (x < descriptor.getMin()) {
                return descriptor.getMin();
            }
            return (int)x;
        }

        protected JSException createTypeErrorInvalidArgumentType() {
            return Errors.createTypeError("invalid argument Type");
        }
    }

    public static enum SIMDTypeFunction implements BuiltinEnum<SIMDTypeFunction>
    {
        splat(1),
        check(1),
        add(2),
        sub(2),
        mul(2),
        div(2),
        max(2),
        min(2),
        maxNum(2),
        minNum(2),
        neg(1),
        sqrt(1),
        reciprocalApproximation(1),
        reciprocalSqrtApproximation(1),
        abs(1),
        and(2),
        xor(2),
        or(2),
        not(2),
        lessThan(2),
        lessThanOrEqual(2),
        greaterThan(2),
        greaterThanOrEqual(2),
        equal(2),
        notEqual(2),
        anyTrue(1),
        allTrue(1),
        select(3),
        addSaturate(2),
        subSaturate(2),
        shiftLeftByScalar(2),
        shiftRightByScalar(2),
        extractLane(2),
        replaceLane(3),
        store(3),
        store1(3),
        store2(3),
        store3(3),
        load(2),
        load1(2),
        load2(2),
        load3(2),
        fromInt32x4Bits(1),
        fromUint32x4Bits(1),
        fromInt16x8Bits(1),
        fromUint16x8Bits(1),
        fromInt8x16Bits(1),
        fromUint8x16Bits(1),
        fromFloat32x4Bits(1),
        fromInt32x4(1),
        fromUint32x4(1),
        fromInt16x8(1),
        fromUint16x8(1),
        fromInt8x16(1),
        fromUint8x16(1),
        fromFloat32x4(1),
        swizzle(1),
        shuffle(2);

        private final int length;

        private SIMDTypeFunction(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }
}

