/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.helper;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.builtins.helper.JSCollectionsNormalizeNode;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.objects.JSLazyString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSCollectionsNormalizeNode.class)
public final class JSCollectionsNormalizeNodeGen
extends JSCollectionsNormalizeNode
implements Introspection.Provider {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;
    @CompilerDirectives.CompilationFinal
    private ConditionProfile jSLazyString_flatten_;
    @Node.Child
    private ForeignObject0Data foreignObject0_cache;
    @CompilerDirectives.CompilationFinal
    private ConditionProfile foreignObject1_primitiveProfile_;
    @Node.Child
    private JSCollectionsNormalizeNode foreignObject1_nestedNormalizeNode_;

    private JSCollectionsNormalizeNodeGen() {
    }

    @Override
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    public Object execute(Object arg0Value) {
        Object arg0Value_;
        int state = this.state_;
        if ((state & 1) != 0 && arg0Value instanceof Integer) {
            int arg0Value_2 = (Integer)arg0Value;
            return this.doInt(arg0Value_2);
        }
        if ((state & 2) != 0 && JSTypesGen.isImplicitDouble((state & 0x3C00) >>> 10, arg0Value)) {
            double arg0Value_3 = JSTypesGen.asImplicitDouble((state & 0x3C00) >>> 10, arg0Value);
            return this.doDouble(arg0Value_3);
        }
        if ((state & 4) != 0 && arg0Value instanceof JSLazyString) {
            JSLazyString arg0Value_4 = (JSLazyString)arg0Value;
            return this.doJSLazyString(arg0Value_4, this.jSLazyString_flatten_);
        }
        if ((state & 8) != 0 && JSTypesGen.isImplicitString((state & 0x3C000) >>> 14, arg0Value)) {
            String arg0Value_5 = JSTypesGen.asImplicitString((state & 0x3C000) >>> 14, arg0Value);
            return this.doString(arg0Value_5);
        }
        if ((state & 0x10) != 0 && arg0Value instanceof Boolean) {
            boolean arg0Value_6 = (Boolean)arg0Value;
            return this.doBoolean(arg0Value_6);
        }
        if ((state & 0x20) != 0 && JSTypes.isDynamicObject(arg0Value) && JSGuards.isJSType(arg0Value_ = (DynamicObject)arg0Value)) {
            return this.doDynamicObject((DynamicObject)arg0Value_);
        }
        if ((state & 0x40) != 0 && arg0Value instanceof Symbol) {
            arg0Value_ = (Symbol)arg0Value;
            return this.doSymbol((Symbol)arg0Value_);
        }
        if ((state & 0x80) != 0 && arg0Value instanceof BigInt) {
            arg0Value_ = (BigInt)arg0Value;
            return this.doBigInt((BigInt)arg0Value_);
        }
        if ((state & 0x300) != 0 && arg0Value instanceof TruffleObject) {
            arg0Value_ = (TruffleObject)arg0Value;
            if ((state & 0x100) != 0) {
                ForeignObject0Data s9_ = this.foreignObject0_cache;
                while (s9_ != null) {
                    if (s9_.interop_.accepts(arg0Value_) && JSGuards.isForeignObject((TruffleObject)arg0Value_)) {
                        return this.doForeignObject((TruffleObject)arg0Value_, s9_.interop_, s9_.primitiveProfile_, s9_.nestedNormalizeNode_);
                    }
                    s9_ = s9_.next_;
                }
            }
            if ((state & 0x200) != 0 && JSGuards.isForeignObject((TruffleObject)arg0Value_)) {
                return this.foreignObject1Boundary(state, (TruffleObject)arg0Value_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private Object foreignObject1Boundary(int state, TruffleObject arg0Value_) {
        Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
        try {
            Object object = this.doForeignObject(arg0Value_, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value_), this.foreignObject1_primitiveProfile_, this.foreignObject1_nestedNormalizeNode_);
            return object;
        }
        finally {
            NodeUtil.popEncapsulatingNode((Node)prev_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeAndSpecialize(Object arg0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            DynamicObject arg0Value_;
            if (arg0Value instanceof Integer) {
                int arg0Value_2 = (Integer)arg0Value;
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                Integer n = this.doInt(arg0Value_2);
                return n;
            }
            int doubleCast0 = JSTypesGen.specializeImplicitDouble(arg0Value);
            if (doubleCast0 != 0) {
                double arg0Value_3 = JSTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                state |= doubleCast0 << 10;
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                Object object = this.doDouble(arg0Value_3);
                return object;
            }
            if (arg0Value instanceof JSLazyString) {
                JSLazyString arg0Value_4 = (JSLazyString)arg0Value;
                this.jSLazyString_flatten_ = ConditionProfile.createBinaryProfile();
                this.state_ = state |= 4;
                lock.unlock();
                hasLock = false;
                String arg0Value_3 = this.doJSLazyString(arg0Value_4, this.jSLazyString_flatten_);
                return arg0Value_3;
            }
            int stringCast0 = JSTypesGen.specializeImplicitString(arg0Value);
            if (stringCast0 != 0) {
                String arg0Value_5 = JSTypesGen.asImplicitString(stringCast0, arg0Value);
                state |= stringCast0 << 14;
                this.state_ = state |= 8;
                lock.unlock();
                hasLock = false;
                String string = this.doString(arg0Value_5);
                return string;
            }
            if (arg0Value instanceof Boolean) {
                boolean arg0Value_6 = (Boolean)arg0Value;
                this.state_ = state |= 0x10;
                lock.unlock();
                hasLock = false;
                Boolean arg0Value_5 = this.doBoolean(arg0Value_6);
                return arg0Value_5;
            }
            if (JSTypes.isDynamicObject(arg0Value) && JSGuards.isJSType(arg0Value_ = (DynamicObject)arg0Value)) {
                this.state_ = state |= 0x20;
                lock.unlock();
                hasLock = false;
                Object arg0Value_5 = this.doDynamicObject(arg0Value_);
                return arg0Value_5;
            }
            if (arg0Value instanceof Symbol) {
                Symbol arg0Value_7 = (Symbol)arg0Value;
                this.state_ = state |= 0x40;
                lock.unlock();
                hasLock = false;
                Symbol arg0Value_5 = this.doSymbol(arg0Value_7);
                return arg0Value_5;
            }
            if (arg0Value instanceof BigInt) {
                BigInt arg0Value_8 = (BigInt)arg0Value;
                this.state_ = state |= 0x80;
                lock.unlock();
                hasLock = false;
                BigInt arg0Value_5 = this.doBigInt(arg0Value_8);
                return arg0Value_5;
            }
            if (arg0Value instanceof TruffleObject) {
                TruffleObject arg0Value_9 = (TruffleObject)arg0Value;
                if (exclude == 0) {
                    int count9_ = 0;
                    ForeignObject0Data s9_ = this.foreignObject0_cache;
                    if ((state & 0x100) != 0) {
                        while (!(s9_ == null || s9_.interop_.accepts((Object)arg0Value_9) && JSGuards.isForeignObject(arg0Value_9))) {
                            s9_ = s9_.next_;
                            ++count9_;
                        }
                    }
                    if (s9_ == null && JSGuards.isForeignObject(arg0Value_9) && count9_ < 3) {
                        s9_ = (ForeignObject0Data)super.insert((Node)new ForeignObject0Data(this.foreignObject0_cache));
                        s9_.interop_ = s9_.insertAccessor((InteropLibrary)INTEROP_LIBRARY_.create((Object)arg0Value_9));
                        s9_.primitiveProfile_ = ConditionProfile.createBinaryProfile();
                        s9_.nestedNormalizeNode_ = s9_.insertAccessor(JSCollectionsNormalizeNode.create());
                        this.foreignObject0_cache = s9_;
                        this.state_ = state |= 0x100;
                    }
                    if (s9_ != null) {
                        lock.unlock();
                        hasLock = false;
                        Object object = this.doForeignObject(arg0Value_9, s9_.interop_, s9_.primitiveProfile_, s9_.nestedNormalizeNode_);
                        return object;
                    }
                }
                Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                try {
                    if (JSGuards.isForeignObject(arg0Value_9)) {
                        this.foreignObject1_primitiveProfile_ = ConditionProfile.createBinaryProfile();
                        this.foreignObject1_nestedNormalizeNode_ = (JSCollectionsNormalizeNode)super.insert((Node)JSCollectionsNormalizeNode.create());
                        this.exclude_ = exclude |= 1;
                        this.foreignObject0_cache = null;
                        state &= 0xFFFFFEFF;
                        this.state_ = state |= 0x200;
                        lock.unlock();
                        hasLock = false;
                        Object object = this.doForeignObject(arg0Value_9, (InteropLibrary)INTEROP_LIBRARY_.getUncached((Object)arg0Value_9), this.foreignObject1_primitiveProfile_, this.foreignObject1_nestedNormalizeNode_);
                        return object;
                    }
                }
                finally {
                    NodeUtil.popEncapsulatingNode((Node)prev_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        ForeignObject0Data s9_;
        int state = this.state_;
        if ((state & 0x3FF) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & 0x3FF & (state & 0x3FF) - 1) == 0 && ((s9_ = this.foreignObject0_cache) == null || s9_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        ArrayList<List<Object>> cached;
        Object[] data = new Object[11];
        data[0] = 0;
        int state = this.state_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doInt";
        s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s;
        s = new Object[3];
        s[0] = "doDouble";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "doJSLazyString";
        if ((state & 4) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<Object>>();
            cached.add(Arrays.asList(this.jSLazyString_flatten_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[3] = s;
        s = new Object[3];
        s[0] = "doString";
        s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[4] = s;
        s = new Object[3];
        s[0] = "doBoolean";
        s[1] = (state & 0x10) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[5] = s;
        s = new Object[3];
        s[0] = "doDynamicObject";
        s[1] = (state & 0x20) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[6] = s;
        s = new Object[3];
        s[0] = "doSymbol";
        s[1] = (state & 0x40) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[7] = s;
        s = new Object[3];
        s[0] = "doBigInt";
        s[1] = (state & 0x80) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[8] = s;
        s = new Object[3];
        s[0] = "doForeignObject";
        if ((state & 0x100) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            ForeignObject0Data s9_ = this.foreignObject0_cache;
            while (s9_ != null) {
                cached.add(Arrays.asList(new Cloneable[]{s9_.interop_, s9_.primitiveProfile_, s9_.nestedNormalizeNode_}));
                s9_ = s9_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[9] = s;
        s = new Object[3];
        s[0] = "doForeignObject";
        if ((state & 0x200) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(new Cloneable[]{INTEROP_LIBRARY_.getUncached(), this.foreignObject1_primitiveProfile_, this.foreignObject1_nestedNormalizeNode_}));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[10] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static JSCollectionsNormalizeNode create() {
        return new JSCollectionsNormalizeNodeGen();
    }

    @GeneratedBy(value=JSCollectionsNormalizeNode.class)
    private static final class ForeignObject0Data
    extends Node {
        @Node.Child
        ForeignObject0Data next_;
        @Node.Child
        InteropLibrary interop_;
        @CompilerDirectives.CompilationFinal
        ConditionProfile primitiveProfile_;
        @Node.Child
        JSCollectionsNormalizeNode nestedNormalizeNode_;

        ForeignObject0Data(ForeignObject0Data next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

