/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.helper;

import com.oracle.truffle.js.runtime.JSTruffleOptions;
import com.sun.management.HotSpotDiagnosticMXBean;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.management.MBeanServer;

public final class HeapDump {
    private HeapDump() {
    }

    public static void dump(String fileName, boolean live) throws IOException {
        if (JSTruffleOptions.SubstrateVM) {
            HeapDump.dumpSVM(fileName, live);
        } else {
            HeapDump.dumpHotSpot(fileName, live);
        }
    }

    private static void dumpHotSpot(String fileName, boolean live) throws IOException {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        HotSpotDiagnosticMXBean hotspotMBean = ManagementFactory.newPlatformMXBeanProxy(server, "com.sun.management:type=HotSpotDiagnostic", HotSpotDiagnosticMXBean.class);
        hotspotMBean.dumpHeap(fileName, live);
    }

    private static void dumpSVM(String fileName, boolean live) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(fileName);){
            Compiler.command((Object)new Object[]{"HeapDump.dumpHeap(FileOutputStream, Boolean)Boolean", fileOutputStream, live});
        }
    }

    public static String defaultDumpName() {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy_MM_dd-HH_mm_ss");
        LocalDateTime now = LocalDateTime.now();
        return "heapdump-" + dtf.format(now) + ".hprof";
    }
}

