/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser.ir;

import com.oracle.js.parser.Lexer;
import com.oracle.js.parser.Token;
import com.oracle.js.parser.TokenType;
import com.oracle.js.parser.ir.Expression;
import com.oracle.js.parser.ir.LexicalContext;
import com.oracle.js.parser.ir.LexicalContextNode;
import com.oracle.js.parser.ir.Node;
import com.oracle.js.parser.ir.PropertyKey;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import com.oracle.js.parser.ir.visitor.TranslatorNodeVisitor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public abstract class LiteralNode<T>
extends Expression {
    protected final T value;

    protected LiteralNode(long token, int finish, T value) {
        super(token, finish);
        this.value = value;
    }

    protected LiteralNode(LiteralNode<T> literalNode) {
        this(literalNode, literalNode.value);
    }

    protected LiteralNode(LiteralNode<T> literalNode, T newValue) {
        super(literalNode);
        this.value = newValue;
    }

    public String getString() {
        return String.valueOf(this.value);
    }

    public Object getObject() {
        return this.value;
    }

    public boolean isArray() {
        return false;
    }

    public List<Expression> getElementExpressions() {
        return null;
    }

    public boolean isString() {
        return this.value instanceof String;
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> visitor) {
        if (visitor.enterLiteralNode(this)) {
            return visitor.leaveLiteralNode(this);
        }
        return this;
    }

    @Override
    public <R> R accept(TranslatorNodeVisitor<? extends LexicalContext, R> visitor) {
        return visitor.enterLiteralNode(this);
    }

    @Override
    public void toString(StringBuilder sb, boolean printType) {
        if (this.value == null) {
            sb.append("null");
        } else {
            sb.append(this.value.toString());
        }
    }

    public final T getValue() {
        return this.value;
    }

    private static Expression[] valueToArray(List<Expression> value) {
        return value.toArray(new Expression[value.size()]);
    }

    public static LiteralNode<Object> newInstance(long token, int finish) {
        return new NullLiteralNode(token, finish);
    }

    public static LiteralNode<Boolean> newInstance(long token, int finish, boolean value) {
        return new BooleanLiteralNode(token, finish, value);
    }

    public static LiteralNode<Number> newInstance(long token, int finish, Number value) {
        return new NumberLiteralNode(token, finish, value, null);
    }

    public static LiteralNode<Number> newInstance(long token, int finish, Number value, Function<Number, String> toStringConverter) {
        return new NumberLiteralNode(token, finish, value, toStringConverter);
    }

    public static LiteralNode<String> newInstance(long token, String value) {
        long tokenWithDelimiter = Token.withDelimiter(token);
        int newFinish = Token.descPosition(tokenWithDelimiter) + Token.descLength(tokenWithDelimiter);
        return new StringLiteralNode(tokenWithDelimiter, newFinish, value);
    }

    public static LiteralNode<Lexer.LexerToken> newInstance(long token, int finish, Lexer.LexerToken value) {
        return new LexerTokenLiteralNode(token, finish, value);
    }

    public static LiteralNode<Expression[]> newInstance(long token, int finish, List<Expression> value) {
        return LiteralNode.newInstance(token, finish, LiteralNode.valueToArray(value));
    }

    public static LiteralNode<Expression[]> newInstance(long token, int finish, List<Expression> value, boolean hasSpread, boolean hasTrailingComma, boolean hasCoverInitializedName) {
        return new ArrayLiteralNode(token, finish, LiteralNode.valueToArray(value), hasSpread, hasTrailingComma, hasCoverInitializedName);
    }

    public static LiteralNode<Expression[]> newInstance(long token, int finish, Expression[] value) {
        return new ArrayLiteralNode(token, finish, value);
    }

    public static final class ArrayLiteralNode
    extends LiteralNode<Expression[]>
    implements LexicalContextNode {
        private final boolean hasSpread;
        private final boolean hasTrailingComma;
        private final boolean hasCoverInitializedName;

        protected ArrayLiteralNode(long token, int finish, Expression[] value) {
            this(token, finish, value, false, false, false);
        }

        protected ArrayLiteralNode(long token, int finish, Expression[] value, boolean hasSpread, boolean hasTrailingComma, boolean hasCoverInitializedName) {
            super(Token.recast(token, TokenType.ARRAY), finish, value);
            this.hasSpread = hasSpread;
            this.hasTrailingComma = hasTrailingComma;
            this.hasCoverInitializedName = hasCoverInitializedName;
        }

        private ArrayLiteralNode(ArrayLiteralNode node, Expression[] value) {
            super(node, value);
            this.hasSpread = node.hasSpread;
            this.hasTrailingComma = node.hasTrailingComma;
            this.hasCoverInitializedName = node.hasCoverInitializedName;
        }

        @Override
        public boolean isArray() {
            return true;
        }

        public boolean hasSpread() {
            return this.hasSpread;
        }

        public boolean hasTrailingComma() {
            return this.hasTrailingComma;
        }

        public boolean hasCoverInitializedName() {
            return this.hasCoverInitializedName;
        }

        @Override
        public List<Expression> getElementExpressions() {
            return Collections.unmodifiableList(Arrays.asList((Expression[])this.value));
        }

        @Override
        public Node accept(NodeVisitor<? extends LexicalContext> visitor) {
            return LexicalContextNode.super.accept(visitor);
        }

        @Override
        public <R> R accept(TranslatorNodeVisitor<? extends LexicalContext, R> visitor) {
            return LexicalContextNode.super.accept(visitor);
        }

        @Override
        public Node accept(LexicalContext lc, NodeVisitor<? extends LexicalContext> visitor) {
            if (visitor.enterLiteralNode(this)) {
                List<Expression> newValue;
                List<Expression> oldValue = Arrays.asList((Expression[])this.value);
                return visitor.leaveLiteralNode(oldValue != (newValue = Node.accept(visitor, oldValue)) ? this.setValue(lc, newValue) : this);
            }
            return this;
        }

        @Override
        public <R> R accept(LexicalContext lc, TranslatorNodeVisitor<? extends LexicalContext, R> visitor) {
            return visitor.enterLiteralNode(this);
        }

        private ArrayLiteralNode setValue(LexicalContext lc, Expression[] value) {
            if (this.value == value) {
                return this;
            }
            return Node.replaceInLexicalContext(lc, this, new ArrayLiteralNode(this, value));
        }

        private ArrayLiteralNode setValue(LexicalContext lc, List<Expression> value) {
            return this.setValue(lc, value.toArray(new Expression[value.size()]));
        }

        @Override
        public void toString(StringBuilder sb, boolean printType) {
            sb.append('[');
            boolean first = true;
            for (Expression node : (Expression[])this.value) {
                if (!first) {
                    sb.append(',');
                    sb.append(' ');
                }
                if (node == null) {
                    sb.append("undefined");
                } else {
                    node.toString(sb, printType);
                }
                first = false;
            }
            sb.append(']');
        }
    }

    private static final class NullLiteralNode
    extends PrimitiveLiteralNode<Object> {
        private NullLiteralNode(long token, int finish) {
            super(Token.recast(token, TokenType.OBJECT), finish, null);
        }
    }

    private static final class LexerTokenLiteralNode
    extends LiteralNode<Lexer.LexerToken> {
        private LexerTokenLiteralNode(long token, int finish, Lexer.LexerToken value) {
            super(Token.recast(token, TokenType.STRING), finish, value);
        }

        private LexerTokenLiteralNode(LexerTokenLiteralNode literalNode) {
            super(literalNode);
        }

        @Override
        public void toString(StringBuilder sb, boolean printType) {
            sb.append(((Lexer.LexerToken)this.value).toString());
        }
    }

    private static final class StringLiteralNode
    extends PrimitiveLiteralNode<String> {
        private StringLiteralNode(long token, int finish, String value) {
            super(Token.recast(token, TokenType.STRING), finish, value);
        }

        @Override
        public void toString(StringBuilder sb, boolean printType) {
            sb.append('\"');
            sb.append((String)this.value);
            sb.append('\"');
        }
    }

    private static final class NumberLiteralNode
    extends PrimitiveLiteralNode<Number> {
        private final Function<Number, String> toStringConverter;

        private NumberLiteralNode(long token, int finish, Number value, Function<Number, String> toStringConverter) {
            super(Token.recast(token, TokenType.DECIMAL), finish, value);
            this.toStringConverter = toStringConverter;
        }

        private NumberLiteralNode(NumberLiteralNode literalNode) {
            super(literalNode);
            this.toStringConverter = literalNode.toStringConverter;
        }

        @Override
        public String getPropertyName() {
            return this.toStringConverter == null ? super.getPropertyName() : this.toStringConverter.apply((Number)this.getValue());
        }
    }

    private static final class BooleanLiteralNode
    extends PrimitiveLiteralNode<Boolean> {
        private BooleanLiteralNode(long token, int finish, boolean value) {
            super(Token.recast(token, value ? TokenType.TRUE : TokenType.FALSE), finish, value);
        }

        private BooleanLiteralNode(BooleanLiteralNode literalNode) {
            super(literalNode);
        }
    }

    public static class PrimitiveLiteralNode<T>
    extends LiteralNode<T>
    implements PropertyKey {
        private PrimitiveLiteralNode(long token, int finish, T value) {
            super(token, finish, value);
        }

        private PrimitiveLiteralNode(PrimitiveLiteralNode<T> literalNode) {
            super(literalNode);
        }

        @Override
        public String getPropertyName() {
            return String.valueOf(this.getObject());
        }
    }
}

