/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.spi;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public abstract class ProfilerStorageProvider {
    public abstract FileObject getGlobalFolder(boolean var1) throws IOException;

    public abstract void loadGlobalProperties(Properties var1, String var2) throws IOException;

    public abstract void saveGlobalProperties(Properties var1, String var2) throws IOException;

    public abstract void deleteGlobalProperties(String var1) throws IOException;

    public abstract FileObject getProjectFolder(Lookup.Provider var1, boolean var2) throws IOException;

    public abstract Lookup.Provider getProjectFromFolder(FileObject var1);

    public abstract void loadProjectProperties(Properties var1, Lookup.Provider var2, String var3) throws IOException;

    public abstract void saveProjectProperties(Properties var1, Lookup.Provider var2, String var3) throws IOException;

    public abstract void deleteProjectProperties(Lookup.Provider var1, String var2) throws IOException;

    public static abstract class Abstract
    extends ProfilerStorageProvider {
        protected String EXT = "xml";

        @Override
        public void loadGlobalProperties(Properties properties, String filename) throws IOException {
            FileObject folder = this.getGlobalFolder(false);
            if (folder == null) {
                return;
            }
            FileObject fo = folder.getFileObject(filename, this.EXT);
            if (fo == null) {
                return;
            }
            this.loadProperties(properties, fo);
        }

        @Override
        public void saveGlobalProperties(Properties properties, String filename) throws IOException {
            FileObject folder = this.getGlobalFolder(true);
            FileObject fo = folder.getFileObject(filename, this.EXT);
            if (fo == null) {
                fo = folder.createData(filename, this.EXT);
            }
            this.saveProperties(properties, fo);
        }

        @Override
        public void deleteGlobalProperties(String filename) throws IOException {
            FileObject fo;
            FileObject folder = this.getGlobalFolder(false);
            FileObject fileObject = fo = folder == null ? null : folder.getFileObject(filename, this.EXT);
            if (fo != null) {
                this.deleteProperties(fo);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void loadProjectProperties(Properties properties, Lookup.Provider project, String filename) throws IOException {
            FileObject folder = this.getProjectFolder(project, false);
            if (folder == null) {
                return;
            }
            FileObject fo = folder.getFileObject(filename, this.EXT);
            if (fo == null && (fo = folder.getFileObject(filename, "pp")) != null) {
                FileLock fol = fo.lock();
                try {
                    fo.rename(fol, filename, this.EXT);
                }
                finally {
                    fol.releaseLock();
                }
            }
            if (fo == null) {
                return;
            }
            this.loadProperties(properties, fo);
        }

        @Override
        public void saveProjectProperties(Properties properties, Lookup.Provider project, String filename) throws IOException {
            FileObject folder = this.getProjectFolder(project, true);
            FileObject fo = folder.getFileObject(filename, this.EXT);
            if (fo == null) {
                fo = folder.createData(filename, this.EXT);
            }
            this.saveProperties(properties, fo);
        }

        @Override
        public void deleteProjectProperties(Lookup.Provider project, String filename) throws IOException {
            FileObject fo;
            FileObject folder = this.getProjectFolder(project, false);
            FileObject fileObject = fo = folder == null ? null : folder.getFileObject(filename, this.EXT);
            if (fo != null) {
                this.deleteProperties(fo);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void loadProperties(Properties properties, FileObject storage) throws IOException {
            Abstract abstract_ = this;
            synchronized (abstract_) {
                InputStream is = storage.getInputStream();
                BufferedInputStream bis = new BufferedInputStream(is);
                try {
                    properties.loadFromXML(bis);
                }
                finally {
                    bis.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void saveProperties(Properties properties, FileObject storage) throws IOException {
            Abstract abstract_ = this;
            synchronized (abstract_) {
                OutputStream os = storage.getOutputStream();
                BufferedOutputStream bos = new BufferedOutputStream(os);
                try {
                    properties.storeToXML(bos, "");
                }
                finally {
                    if (bos != null) {
                        bos.close();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void deleteProperties(FileObject storage) throws IOException {
            Abstract abstract_ = this;
            synchronized (abstract_) {
                storage.delete();
            }
        }
    }
}

