/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.runtime.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.regex.runtime.nodes.ToCharNode;
import com.oracle.truffle.regex.runtime.nodes.ToCharNodeGen;
import com.oracle.truffle.regex.runtime.nodes.ToStringNode;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=ToStringNode.class)
public final class ToStringNodeGen
extends ToStringNode {
    private static final Uncached UNCACHED = new Uncached();
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;
    @Node.Child
    private BoxedString0Data boxedString0_cache;
    @Node.Child
    private BoxedCharArray0Data boxedCharArray0_cache;
    @Node.Child
    private ToCharNode boxedCharArray1_toCharNode_;

    private ToStringNodeGen() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    public String execute(Object arg0Value) throws UnsupportedTypeException {
        int state = this.state_;
        if ((state & 1) != 0 && arg0Value instanceof String) {
            String arg0Value_ = (String)arg0Value;
            return ToStringNode.doString(arg0Value_);
        }
        if ((state & 0x1E) != 0) {
            Node prev_;
            if ((state & 2) != 0) {
                BoxedString0Data s2_ = this.boxedString0_cache;
                while (s2_ != null) {
                    if (s2_.inputs_.accepts(arg0Value) && s2_.inputs_.isString(arg0Value)) {
                        return ToStringNode.doBoxedString(arg0Value, s2_.inputs_);
                    }
                    s2_ = s2_.next_;
                }
            }
            if ((state & 4) != 0) {
                prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                try {
                    if (((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value)).isString(arg0Value)) {
                        String string = ToStringNode.doBoxedString(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value));
                        return string;
                    }
                }
                finally {
                    NodeUtil.popEncapsulatingNode((Node)prev_);
                }
            }
            if ((state & 8) != 0) {
                BoxedCharArray0Data s4_ = this.boxedCharArray0_cache;
                while (s4_ != null) {
                    if (s4_.inputs_.accepts(arg0Value) && s4_.inputs_.hasArrayElements(arg0Value)) {
                        return ToStringNode.doBoxedCharArray(arg0Value, s4_.inputs_, s4_.toCharNode_);
                    }
                    s4_ = s4_.next_;
                }
            }
            if ((state & 0x10) != 0) {
                prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                try {
                    if (((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value)).hasArrayElements(arg0Value)) {
                        String string = ToStringNode.doBoxedCharArray(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value), this.boxedCharArray1_toCharNode_);
                        return string;
                    }
                }
                finally {
                    NodeUtil.popEncapsulatingNode((Node)prev_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executeAndSpecialize(Object arg0Value) throws UnsupportedTypeException {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            String string;
            Object inputs__;
            if (arg0Value instanceof String) {
                String arg0Value_ = (String)arg0Value;
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                String string2 = ToStringNode.doString(arg0Value_);
                return string2;
            }
            if ((exclude & 1) == 0) {
                int count2_ = 0;
                BoxedString0Data s2_ = this.boxedString0_cache;
                if ((state & 2) != 0) {
                    while (!(s2_ == null || s2_.inputs_.accepts(arg0Value) && s2_.inputs_.isString(arg0Value))) {
                        s2_ = s2_.next_;
                        ++count2_;
                    }
                }
                if (s2_ == null && (inputs__ = (InteropLibrary)super.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(arg0Value)))).isString(arg0Value) && count2_ < 2) {
                    s2_ = (BoxedString0Data)super.insert((Node)new BoxedString0Data(this.boxedString0_cache));
                    s2_.inputs_ = s2_.insertAccessor(inputs__);
                    this.boxedString0_cache = s2_;
                    this.state_ = state |= 2;
                }
                if (s2_ != null) {
                    lock.unlock();
                    hasLock = false;
                    inputs__ = ToStringNode.doBoxedString(arg0Value, s2_.inputs_);
                    return inputs__;
                }
            }
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                InteropLibrary boxedString1_inputs__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value);
                if (boxedString1_inputs__.isString(arg0Value)) {
                    this.exclude_ = exclude |= 1;
                    this.boxedString0_cache = null;
                    state &= 0xFFFFFFFD;
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    inputs__ = ToStringNode.doBoxedString(arg0Value, boxedString1_inputs__);
                    return inputs__;
                }
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
            if ((exclude & 2) == 0) {
                int count4_ = 0;
                BoxedCharArray0Data s4_ = this.boxedCharArray0_cache;
                if ((state & 8) != 0) {
                    while (!(s4_ == null || s4_.inputs_.accepts(arg0Value) && s4_.inputs_.hasArrayElements(arg0Value))) {
                        s4_ = s4_.next_;
                        ++count4_;
                    }
                }
                if (s4_ == null && (inputs__ = (InteropLibrary)super.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(arg0Value)))).hasArrayElements(arg0Value) && count4_ < 2) {
                    s4_ = (BoxedCharArray0Data)super.insert((Node)new BoxedCharArray0Data(this.boxedCharArray0_cache));
                    s4_.inputs_ = s4_.insertAccessor(inputs__);
                    s4_.toCharNode_ = s4_.insertAccessor(ToCharNode.create());
                    this.boxedCharArray0_cache = s4_;
                    this.state_ = state |= 8;
                }
                if (s4_ != null) {
                    lock.unlock();
                    hasLock = false;
                    string = ToStringNode.doBoxedCharArray(arg0Value, s4_.inputs_, s4_.toCharNode_);
                    return string;
                }
            }
            prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                InteropLibrary boxedCharArray1_inputs__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value);
                if (boxedCharArray1_inputs__.hasArrayElements(arg0Value)) {
                    this.boxedCharArray1_toCharNode_ = (ToCharNode)super.insert((Node)ToCharNode.create());
                    this.exclude_ = exclude |= 2;
                    this.boxedCharArray0_cache = null;
                    state &= 0xFFFFFFF7;
                    this.state_ = state |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    string = ToStringNode.doBoxedCharArray(arg0Value, boxedCharArray1_inputs__, this.boxedCharArray1_toCharNode_);
                    return string;
                }
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            BoxedString0Data s2_ = this.boxedString0_cache;
            BoxedCharArray0Data s4_ = this.boxedCharArray0_cache;
            if (!(s2_ != null && s2_.next_ != null || s4_ != null && s4_.next_ != null)) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    public static ToStringNode create() {
        return new ToStringNodeGen();
    }

    public static ToStringNode getUncached() {
        return UNCACHED;
    }

    @GeneratedBy(value=ToStringNode.class)
    private static final class Uncached
    extends ToStringNode {
        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public String execute(Object arg0Value) throws UnsupportedTypeException {
            if (arg0Value instanceof String) {
                String arg0Value_ = (String)arg0Value;
                return ToStringNode.doString(arg0Value_);
            }
            if (((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value)).isString(arg0Value)) {
                return ToStringNode.doBoxedString(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value));
            }
            if (((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value)).hasArrayElements(arg0Value)) {
                return ToStringNode.doBoxedCharArray(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value), ToCharNodeGen.getUncached());
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    @GeneratedBy(value=ToStringNode.class)
    private static final class BoxedCharArray0Data
    extends Node {
        @Node.Child
        BoxedCharArray0Data next_;
        @Node.Child
        InteropLibrary inputs_;
        @Node.Child
        ToCharNode toCharNode_;

        BoxedCharArray0Data(BoxedCharArray0Data next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }

    @GeneratedBy(value=ToStringNode.class)
    private static final class BoxedString0Data
    extends Node {
        @Node.Child
        BoxedString0Data next_;
        @Node.Child
        InteropLibrary inputs_;

        BoxedString0Data(BoxedString0Data next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

