/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.hotspot.libgraal;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.graalvm.compiler.truffle.common.hotspot.libgraal.SVMToHotSpot;
import org.graalvm.compiler.truffle.compiler.hotspot.libgraal.JNIExceptionWrapper;
import org.graalvm.libgraal.jni.JNI;
import org.graalvm.libgraal.jni.JNIUtil;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;

final class SVMToHotSpotUtil {
    private static final String HOTSPOT_ENTRY_POINTS_CLASS_NAME = "org.graalvm.compiler.truffle.runtime.hotspot.libgraal.SVMToHotSpotEntryPoints";
    private static final EnumMap<SVMToHotSpot.Id, JNIMethod> methods = new EnumMap(SVMToHotSpot.Id.class);
    private static final Map<String, JNIClass> classes = new ConcurrentHashMap<String, JNIClass>();
    private static final ThreadLocal<Boolean> inExceptionHandler = new ThreadLocal();
    private static JNIClass hsvmPeer;
    private static final Set<String> HotSpotCallNames;

    SVMToHotSpotUtil() {
    }

    @HotSpotCall
    static void callVoid(JNI.JNIEnv env, SVMToHotSpot.Id id, JNI.JValue args) {
        JNIMethod method = SVMToHotSpotUtil.getJNIMethod(env, id, Void.TYPE);
        SVMToHotSpotUtil.traceCall(id);
        env.getFunctions().getCallStaticVoidMethodA().call(env, SVMToHotSpotUtil.peer((JNI.JNIEnv)env).jclass, method.jniId, args);
        JNIExceptionWrapper.wrapAndThrowPendingJNIException(env);
    }

    @HotSpotCall
    static boolean callBoolean(JNI.JNIEnv env, SVMToHotSpot.Id id, JNI.JValue args) {
        JNIMethod method = SVMToHotSpotUtil.getJNIMethod(env, id, Boolean.TYPE);
        SVMToHotSpotUtil.traceCall(id);
        boolean res = env.getFunctions().getCallStaticBooleanMethodA().call(env, SVMToHotSpotUtil.peer((JNI.JNIEnv)env).jclass, method.jniId, args);
        JNIExceptionWrapper.wrapAndThrowPendingJNIException(env);
        return res;
    }

    @HotSpotCall
    static long callLong(JNI.JNIEnv env, SVMToHotSpot.Id id, JNI.JValue args) {
        JNIMethod method = SVMToHotSpotUtil.getJNIMethod(env, id, Long.TYPE);
        SVMToHotSpotUtil.traceCall(id);
        long res = env.getFunctions().getCallStaticLongMethodA().call(env, SVMToHotSpotUtil.peer((JNI.JNIEnv)env).jclass, method.jniId, args);
        JNIExceptionWrapper.wrapAndThrowPendingJNIException(env);
        return res;
    }

    @HotSpotCall
    static int callInt(JNI.JNIEnv env, SVMToHotSpot.Id id, JNI.JValue args) {
        JNIMethod method = SVMToHotSpotUtil.getJNIMethod(env, id, Integer.TYPE);
        SVMToHotSpotUtil.traceCall(id);
        int res = env.getFunctions().getCallStaticIntMethodA().call(env, SVMToHotSpotUtil.peer((JNI.JNIEnv)env).jclass, method.jniId, args);
        JNIExceptionWrapper.wrapAndThrowPendingJNIException(env);
        return res;
    }

    @HotSpotCall
    static <T extends JNI.JObject> T callJObject(JNI.JNIEnv env, SVMToHotSpot.Id id, JNI.JValue args) {
        JNIMethod method = SVMToHotSpotUtil.getJNIMethod(env, id, Object.class);
        SVMToHotSpotUtil.traceCall(id);
        JNI.JObject res = env.getFunctions().getCallStaticObjectMethodA().call(env, SVMToHotSpotUtil.peer((JNI.JNIEnv)env).jclass, method.jniId, args);
        JNIExceptionWrapper.wrapAndThrowPendingJNIException(env);
        return (T)res;
    }

    private static void traceCall(SVMToHotSpot.Id id) {
        JNIUtil.trace((int)1, (String)"SVM->HS: %s", (Object[])new Object[]{id});
    }

    static JNIClass getJNIClass(JNI.JNIEnv env, Class<?> clazz) {
        if (clazz.isArray()) {
            throw new UnsupportedOperationException("Array classes are not supported");
        }
        return SVMToHotSpotUtil.getJNIClass(env, clazz.getName());
    }

    private static JNIClass getJNIClass(JNI.JNIEnv env, String className) {
        try {
            return classes.computeIfAbsent(className, new Function<String, JNIClass>(){

                @Override
                public JNIClass apply(String name) {
                    try (CTypeConversion.CCharPointerHolder cName = CTypeConversion.toCString((CharSequence)JNIUtil.getBinaryName((String)name));){
                        JNI.JClass clazz = JNIUtil.FindClass((JNI.JNIEnv)env, (CCharPointer)cName.get());
                        if (clazz.isNull()) {
                            throw new InternalError("Cannot load class: " + name);
                        }
                        JNIClass jNIClass = new JNIClass(name, (JNI.JClass)JNIUtil.NewGlobalRef((JNI.JNIEnv)env, (JNI.JObject)clazz, (String)("Class<" + name + ">")));
                        return jNIClass;
                    }
                }
            });
        }
        catch (InternalError ie) {
            if (inExceptionHandler.get() != Boolean.TRUE) {
                inExceptionHandler.set(true);
                try {
                    JNIExceptionWrapper.wrapAndThrowPendingJNIException(env);
                }
                finally {
                    inExceptionHandler.remove();
                }
            }
            throw ie;
        }
    }

    private static JNIClass peer(JNI.JNIEnv env) {
        if (hsvmPeer == null) {
            hsvmPeer = SVMToHotSpotUtil.getJNIClass(env, HOTSPOT_ENTRY_POINTS_CLASS_NAME);
        }
        return hsvmPeer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JNIMethod getJNIMethod(JNI.JNIEnv env, SVMToHotSpot.Id hcId, Class<?> expectedReturnType) {
        assert (hcId.getReturnType() == expectedReturnType || expectedReturnType.isAssignableFrom(hcId.getReturnType()));
        try {
            return methods.computeIfAbsent(hcId, new Function<SVMToHotSpot.Id, JNIMethod>(){

                @Override
                public JNIMethod apply(SVMToHotSpot.Id id) {
                    JNIClass c = SVMToHotSpotUtil.peer(env);
                    String methodName = id.getMethodName();
                    try (CTypeConversion.CCharPointerHolder name = CTypeConversion.toCString((CharSequence)methodName);){
                        JNIMethod jNIMethod;
                        block13: {
                            CTypeConversion.CCharPointerHolder sig = CTypeConversion.toCString((CharSequence)id.getSignature());
                            try {
                                JNI.JMethodID jniId = JNIUtil.GetStaticMethodID((JNI.JNIEnv)env, (JNI.JClass)c.jclass, (CCharPointer)name.get(), (CCharPointer)sig.get());
                                if (jniId.isNull()) {
                                    throw new InternalError("No such method: " + methodName);
                                }
                                jNIMethod = new JNIMethod(id, jniId);
                                if (sig == null) break block13;
                            }
                            catch (Throwable throwable) {
                                if (sig != null) {
                                    try {
                                        sig.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            sig.close();
                        }
                        return jNIMethod;
                    }
                }
            });
        }
        catch (InternalError ie) {
            if (inExceptionHandler.get() != Boolean.TRUE) {
                inExceptionHandler.set(true);
                try {
                    JNIExceptionWrapper.wrapAndThrowPendingJNIException(env);
                }
                finally {
                    inExceptionHandler.remove();
                }
            }
            throw ie;
        }
    }

    static boolean isHotSpotCall(StackTraceElement frame) {
        if (!SVMToHotSpotUtil.class.getName().equals(frame.getClassName())) {
            return false;
        }
        return HotSpotCallNames.contains(frame.getMethodName());
    }

    static /* synthetic */ JNIClass access$000(JNI.JNIEnv x0) {
        return SVMToHotSpotUtil.peer(x0);
    }

    static {
        HashMap<String, Method> entryPoints = new HashMap<String, Method>();
        HashMap<String, Method> others = new HashMap<String, Method>();
        for (Method m : SVMToHotSpotUtil.class.getDeclaredMethods()) {
            if (m.getAnnotation(HotSpotCall.class) != null) {
                Method existing = entryPoints.put(m.getName(), m);
                if (existing == null) continue;
                throw new InternalError("Method annotated by " + HotSpotCall.class.getSimpleName() + " must have unique name: " + m + " and " + existing);
            }
            others.put(m.getName(), m);
        }
        for (Map.Entry entry : entryPoints.entrySet()) {
            Method existing = (Method)others.get(entry.getKey());
            if (existing == null) continue;
            throw new InternalError("Method annotated by " + HotSpotCall.class.getSimpleName() + " must have unique name: " + entry.getValue() + " and " + existing);
        }
        HotSpotCallNames = Collections.unmodifiableSet(entryPoints.keySet());
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    private static @interface HotSpotCall {
    }

    static final class JNIMethod {
        final SVMToHotSpot.Id hcId;
        final JNI.JMethodID jniId;

        JNIMethod(SVMToHotSpot.Id hcId, JNI.JMethodID jniId) {
            this.hcId = hcId;
            this.jniId = jniId;
        }

        public String toString() {
            return this.hcId + "[0x" + Long.toHexString(this.jniId.rawValue()) + ']';
        }
    }

    static final class JNIClass {
        final String className;
        final JNI.JClass jclass;

        JNIClass(String className, JNI.JClass clazz) {
            this.className = className;
            this.jclass = clazz;
        }
    }
}

