/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.hotspot.libgraal;

import java.net.URI;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.compiler.truffle.common.TruffleCallNode;
import org.graalvm.compiler.truffle.common.TruffleInliningPlan;
import org.graalvm.compiler.truffle.common.TruffleSourceLanguagePosition;
import org.graalvm.compiler.truffle.common.hotspot.libgraal.HotSpotToSVM;
import org.graalvm.compiler.truffle.common.hotspot.libgraal.SVMToHotSpot;
import org.graalvm.compiler.truffle.compiler.hotspot.libgraal.HSTruffleCallNode;
import org.graalvm.compiler.truffle.compiler.hotspot.libgraal.HSTruffleInliningPlanGen;
import org.graalvm.libgraal.LibGraal;
import org.graalvm.libgraal.jni.HSObject;
import org.graalvm.libgraal.jni.HotSpotToSVMScope;
import org.graalvm.libgraal.jni.JNI;
import org.graalvm.libgraal.jni.JNIUtil;

class HSTruffleInliningPlan
extends HSObject
implements TruffleInliningPlan {
    final HotSpotToSVMScope<HotSpotToSVM.Id> scope;

    HSTruffleInliningPlan(HotSpotToSVMScope<HotSpotToSVM.Id> scope, JNI.JObject handle) {
        super(scope, handle);
        this.scope = scope;
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.FindDecision)
    public TruffleInliningPlan.Decision findDecision(JavaConstant callNode) {
        long callNodeHandle = LibGraal.translate((HotSpotJVMCIRuntime)HotSpotJVMCIRuntime.runtime(), (Object)callNode);
        JNI.JNIEnv env = this.scope.getEnv();
        Object res = HSTruffleInliningPlanGen.callFindDecision(env, this.getHandle(), callNodeHandle);
        if (res.isNull()) {
            return null;
        }
        return new HSDecision(this.scope, (JNI.JObject)res);
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.FindCallNode)
    public TruffleCallNode findCallNode(JavaConstant callNode) {
        long nodeHandle = LibGraal.translate((HotSpotJVMCIRuntime)HotSpotJVMCIRuntime.runtime(), (Object)callNode);
        JNI.JNIEnv env = this.scope.getEnv();
        Object res = HSTruffleInliningPlanGen.callFindCallNode(env, this.getHandle(), nodeHandle);
        if (res.isNull()) {
            return null;
        }
        return new HSTruffleCallNode(this.scope, (JNI.JObject)res);
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.GetPosition)
    public TruffleSourceLanguagePosition getPosition(JavaConstant node) {
        long nodeHandle = LibGraal.translate((HotSpotJVMCIRuntime)HotSpotJVMCIRuntime.runtime(), (Object)node);
        JNI.JNIEnv env = this.scope.getEnv();
        Object res = HSTruffleInliningPlanGen.callGetPosition(env, this.getHandle(), nodeHandle);
        if (res.isNull()) {
            return null;
        }
        return new HSTruffleSourceLanguagePosition(this.scope, (JNI.JObject)res);
    }

    private static final class HSTruffleSourceLanguagePosition
    extends HSObject
    implements TruffleSourceLanguagePosition {
        HSTruffleSourceLanguagePosition(HotSpotToSVMScope<HotSpotToSVM.Id> scope, JNI.JObject handle) {
            super(scope, handle);
        }

        @SVMToHotSpot(value=SVMToHotSpot.Id.GetOffsetStart)
        public int getOffsetStart() {
            return HSTruffleInliningPlanGen.callGetOffsetStart(HotSpotToSVMScope.env(), this.getHandle());
        }

        @SVMToHotSpot(value=SVMToHotSpot.Id.GetOffsetEnd)
        public int getOffsetEnd() {
            return HSTruffleInliningPlanGen.callGetOffsetEnd(HotSpotToSVMScope.env(), this.getHandle());
        }

        @SVMToHotSpot(value=SVMToHotSpot.Id.GetLineNumber)
        public int getLineNumber() {
            return HSTruffleInliningPlanGen.callGetLineNumber(HotSpotToSVMScope.env(), this.getHandle());
        }

        @SVMToHotSpot(value=SVMToHotSpot.Id.GetLanguage)
        public String getLanguage() {
            JNI.JString res = (JNI.JString)HSTruffleInliningPlanGen.callGetLanguage(HotSpotToSVMScope.env(), this.getHandle());
            return JNIUtil.createString((JNI.JNIEnv)HotSpotToSVMScope.env(), (JNI.JString)res);
        }

        @SVMToHotSpot(value=SVMToHotSpot.Id.GetDescription)
        public String getDescription() {
            JNI.JString res = (JNI.JString)HSTruffleInliningPlanGen.callGetDescription(HotSpotToSVMScope.env(), this.getHandle());
            return JNIUtil.createString((JNI.JNIEnv)HotSpotToSVMScope.env(), (JNI.JString)res);
        }

        @SVMToHotSpot(value=SVMToHotSpot.Id.GetURI)
        public URI getURI() {
            JNI.JString res = (JNI.JString)HSTruffleInliningPlanGen.callGetURI(HotSpotToSVMScope.env(), this.getHandle());
            String stringifiedURI = JNIUtil.createString((JNI.JNIEnv)HotSpotToSVMScope.env(), (JNI.JString)res);
            return stringifiedURI == null ? null : URI.create(stringifiedURI);
        }
    }

    private static final class HSDecision
    extends HSTruffleInliningPlan
    implements TruffleInliningPlan.Decision {
        HSDecision(HotSpotToSVMScope<HotSpotToSVM.Id> scope, JNI.JObject handle) {
            super(scope, handle);
        }

        @SVMToHotSpot(value=SVMToHotSpot.Id.ShouldInline)
        public boolean shouldInline() {
            return HSTruffleInliningPlanGen.callShouldInline(this.scope.getEnv(), this.getHandle());
        }

        @SVMToHotSpot(value=SVMToHotSpot.Id.IsTargetStable)
        public boolean isTargetStable() {
            return HSTruffleInliningPlanGen.callIsTargetStable(this.scope.getEnv(), this.getHandle());
        }

        @SVMToHotSpot(value=SVMToHotSpot.Id.GetTargetName)
        public String getTargetName() {
            JNI.JNIEnv env = this.scope.getEnv();
            JNI.JString res = (JNI.JString)HSTruffleInliningPlanGen.callGetTargetName(env, this.getHandle());
            return JNIUtil.createString((JNI.JNIEnv)env, (JNI.JString)res);
        }

        @SVMToHotSpot(value=SVMToHotSpot.Id.GetNodeRewritingAssumption)
        public JavaConstant getNodeRewritingAssumption() {
            long javaConstantHandle = HSTruffleInliningPlanGen.callGetNodeRewritingAssumption(this.scope.getEnv(), this.getHandle());
            return (JavaConstant)LibGraal.unhand((HotSpotJVMCIRuntime)HotSpotJVMCIRuntime.runtime(), JavaConstant.class, (long)javaConstantHandle);
        }
    }
}

