/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.hotspot.libgraal;

import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.TruffleCallNode;
import org.graalvm.compiler.truffle.common.hotspot.libgraal.HotSpotToSVM;
import org.graalvm.compiler.truffle.common.hotspot.libgraal.SVMToHotSpot;
import org.graalvm.compiler.truffle.compiler.hotspot.libgraal.HSCompilableTruffleAST;
import org.graalvm.compiler.truffle.compiler.hotspot.libgraal.HSTruffleCallNodeGen;
import org.graalvm.libgraal.jni.HSObject;
import org.graalvm.libgraal.jni.HotSpotToSVMScope;
import org.graalvm.libgraal.jni.JNI;
import org.graalvm.libgraal.jni.JNIUtil;

final class HSTruffleCallNode
extends HSObject
implements TruffleCallNode {
    HSTruffleCallNode(HotSpotToSVMScope<HotSpotToSVM.Id> scope, JNI.JObject handle) {
        super(scope, handle);
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.GetCurrentCallTarget)
    public CompilableTruffleAST getCurrentCallTarget() {
        HotSpotToSVMScope scope = HotSpotToSVMScope.scope().narrow(HotSpotToSVM.Id.class);
        Object hsCompilable = HSTruffleCallNodeGen.callGetCurrentCallTarget(scope.getEnv(), this.getHandle());
        if (hsCompilable.isNull()) {
            return null;
        }
        return new HSCompilableTruffleAST((HotSpotToSVMScope<HotSpotToSVM.Id>)scope, (JNI.JObject)hsCompilable);
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.GetCallCount)
    public int getCallCount() {
        return HSTruffleCallNodeGen.callGetCallCount(HotSpotToSVMScope.env(), this.getHandle());
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.IsInliningForced)
    public boolean isInliningForced() {
        return HSTruffleCallNodeGen.callIsInliningForced(HotSpotToSVMScope.env(), this.getHandle());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != HSTruffleCallNode.class) {
            return false;
        }
        return JNIUtil.IsSameObject((JNI.JNIEnv)HotSpotToSVMScope.env(), (JNI.JObject)this.getHandle(), (JNI.JObject)((HSTruffleCallNode)((Object)obj)).getHandle());
    }

    @SVMToHotSpot(value=SVMToHotSpot.Id.CallNodeHashCode)
    public int hashCode() {
        return HSTruffleCallNodeGen.callCallNodeHashCode(HotSpotToSVMScope.env(), this.getHandle());
    }
}

