/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.jar;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.CRC32;
import org.graalvm.component.installer.Archive;
import org.graalvm.component.installer.CommandInput;
import org.graalvm.component.installer.model.ComponentInfo;

public class JarArchive
implements Archive {
    private static final int CHECKSUM_BUFFER_SIZE = 32768;
    private final JarFile jarFile;

    public JarArchive(JarFile jarFile) {
        this.jarFile = jarFile;
    }

    public Archive.FileEntry getEntry(String path) {
        return this.getJarEntry(path);
    }

    public Archive.FileEntry getJarEntry(String path) {
        JarEntry e = this.jarFile.getJarEntry(path);
        return e == null ? null : new JarEntryImpl(e);
    }

    @Override
    public Iterator<Archive.FileEntry> iterator() {
        return new EntryIterator(this.jarFile.entries());
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public InputStream getInputStream(Archive.FileEntry e) throws IOException {
        return this.jarFile.getInputStream(((JarEntryImpl)e).e);
    }

    @Override
    public boolean checkContentsMatches(ReadableByteChannel bc, Archive.FileEntry entry) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(32768);
        CRC32 crc = new CRC32();
        while (bc.read(bb) >= 0) {
            bb.flip();
            crc.update(bb);
            bb.clear();
        }
        return crc.getValue() == ((JarEntryImpl)entry).e.getCrc();
    }

    @Override
    public void completeMetadata(ComponentInfo info) throws IOException {
    }

    @Override
    public boolean verifyIntegrity(CommandInput input) {
        return true;
    }

    private static class JarEntryImpl
    implements Archive.FileEntry {
        private final JarEntry e;

        JarEntryImpl(JarEntry e) {
            this.e = e;
        }

        @Override
        public String getName() {
            return this.e.getName();
        }

        @Override
        public boolean isDirectory() {
            return this.e.isDirectory();
        }

        @Override
        public long getSize() {
            return this.e.getSize();
        }

        @Override
        public boolean isSymbolicLink() {
            return false;
        }

        @Override
        public String getLinkTarget() throws IOException {
            throw new IllegalStateException("Not a symbolic link");
        }
    }

    private static class EntryIterator
    implements Iterator<Archive.FileEntry> {
        private final Enumeration<JarEntry> enEntries;

        EntryIterator(Enumeration<JarEntry> enEntries) {
            this.enEntries = enEntries;
        }

        @Override
        public boolean hasNext() {
            return this.enEntries.hasMoreElements();
        }

        @Override
        public JarEntryImpl next() {
            return new JarEntryImpl(this.enEntries.nextElement());
        }
    }
}

