/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.nfi.impl.LibFFIType;
import com.oracle.truffle.nfi.impl.NativeArgumentBuffer;
import com.oracle.truffle.nfi.impl.NativeArgumentLibrary;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=NativeArgumentLibrary.class)
final class NativeArgumentLibraryGen
extends LibraryFactory<NativeArgumentLibrary> {
    private static final Class<NativeArgumentLibrary> LIBRARY_CLASS = NativeArgumentLibraryGen.lazyLibraryClass();
    private static final Message SERIALIZE = new MessageImpl("serialize", 0, Void.TYPE, LibFFIType.class, NativeArgumentBuffer.class, Object.class);
    private static final Message DESERIALIZE = new MessageImpl("deserialize", 1, Object.class, LibFFIType.class, NativeArgumentBuffer.class);
    private static final NativeArgumentLibraryGen INSTANCE = new NativeArgumentLibraryGen();
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private NativeArgumentLibraryGen() {
        super(LIBRARY_CLASS, Collections.unmodifiableList(Arrays.asList(SERIALIZE, DESERIALIZE)));
    }

    protected Class<?> getDefaultClass(Object receiver) {
        return NativeArgumentLibrary.class;
    }

    protected NativeArgumentLibrary createProxy(ReflectionLibrary library) {
        return new Proxy(library);
    }

    protected Object genericDispatch(Library originalLib, Object receiver, Message message, Object[] args, int offset) throws Exception {
        NativeArgumentLibrary lib = (NativeArgumentLibrary)originalLib;
        MessageImpl messageImpl = (MessageImpl)message;
        if (messageImpl.getParameterCount() - 1 != args.length - offset) {
            CompilerDirectives.transferToInterpreter();
            throw new IllegalArgumentException("Invalid number of arguments.");
        }
        switch (messageImpl.index) {
            case 0: {
                lib.serialize((LibFFIType)receiver, (NativeArgumentBuffer)args[offset], args[offset + 1]);
                return null;
            }
            case 1: {
                return lib.deserialize((LibFFIType)receiver, (NativeArgumentBuffer)args[offset]);
            }
        }
        CompilerDirectives.transferToInterpreter();
        throw new AbstractMethodError(message.toString());
    }

    protected NativeArgumentLibrary createDispatchImpl(int limit) {
        return new CachedDispatchFirst(null, null, limit);
    }

    protected NativeArgumentLibrary createUncachedDispatch() {
        return new UncachedDispatch();
    }

    private static Class<NativeArgumentLibrary> lazyLibraryClass() {
        try {
            return Class.forName("com.oracle.truffle.nfi.impl.NativeArgumentLibrary", false, NativeArgumentLibraryGen.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        LibraryExport.register(LIBRARY_CLASS, (LibraryExport[])new LibraryExport[]{new Default()});
        LibraryFactory.register(LIBRARY_CLASS, (LibraryFactory)INSTANCE);
    }

    @GeneratedBy(value=NativeArgumentLibrary.class)
    private static abstract class CachedDispatch
    extends NativeArgumentLibrary {
        @Node.Child
        NativeArgumentLibrary library;
        @Node.Child
        CachedDispatch next;

        CachedDispatch(NativeArgumentLibrary library, CachedDispatch next) {
            this.library = library;
            this.next = next;
        }

        abstract int getLimit();

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public void serialize(LibFFIType receiver_, NativeArgumentBuffer buffer, Object value) throws UnsupportedTypeException {
            while (true) {
                CachedDispatch current = this;
                do {
                    NativeArgumentLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.serialize(receiver_, buffer, value);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public Object deserialize(LibFFIType receiver_, NativeArgumentBuffer buffer) {
            while (true) {
                CachedDispatch current = this;
                do {
                    NativeArgumentLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.deserialize(receiver_, buffer);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void specialize(LibFFIType receiver_) {
            CachedDispatch current = this;
            NativeArgumentLibrary thisLibrary = current.library;
            if (thisLibrary == null) {
                this.library = (NativeArgumentLibrary)this.insert((Node)((NativeArgumentLibrary)INSTANCE.create(receiver_)));
            } else {
                Lock lock = this.getLock();
                lock.lock();
                try {
                    int count = 0;
                    do {
                        NativeArgumentLibrary currentLibrary;
                        if ((currentLibrary = current.library) != null && currentLibrary.accepts(receiver_)) {
                            return;
                        }
                        ++count;
                    } while ((current = current.next) != null);
                    if (count >= this.getLimit()) {
                        this.library = (NativeArgumentLibrary)this.insert((Node)new CachedToUncachedDispatch());
                        this.next = null;
                    } else {
                        this.next = (CachedDispatch)this.insert((Node)new CachedDispatchNext((NativeArgumentLibrary)INSTANCE.create(receiver_), this.next));
                    }
                }
                finally {
                    lock.unlock();
                }
            }
        }
    }

    @GeneratedBy(value=NativeArgumentLibrary.class)
    private static final class CachedDispatchFirst
    extends CachedDispatch {
        private final int limit_;

        CachedDispatchFirst(NativeArgumentLibrary library, CachedDispatch next, int limit_) {
            super(library, next);
            this.limit_ = limit_;
        }

        @Override
        int getLimit() {
            return this.limit_;
        }

        public NodeCost getCost() {
            if (this.library instanceof CachedToUncachedDispatch) {
                return NodeCost.MEGAMORPHIC;
            }
            CachedDispatch current = this;
            int count = 0;
            do {
                if (current.library == null) continue;
                ++count;
            } while ((current = current.next) != null);
            return NodeCost.fromCount((int)count);
        }
    }

    @GeneratedBy(value=NativeArgumentLibrary.class)
    private static final class CachedDispatchNext
    extends CachedDispatch {
        CachedDispatchNext(NativeArgumentLibrary library, CachedDispatch next) {
            super(library, next);
        }

        @Override
        int getLimit() {
            throw new AssertionError();
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }
    }

    @GeneratedBy(value=NativeArgumentLibrary.class)
    private static final class UncachedDispatch
    extends NativeArgumentLibrary {
        private UncachedDispatch() {
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void serialize(LibFFIType receiver_, NativeArgumentBuffer buffer, Object value) throws UnsupportedTypeException {
            ((NativeArgumentLibrary)INSTANCE.getUncached(receiver_)).serialize(receiver_, buffer, value);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object deserialize(LibFFIType receiver_, NativeArgumentBuffer buffer) {
            return ((NativeArgumentLibrary)INSTANCE.getUncached(receiver_)).deserialize(receiver_, buffer);
        }

        @CompilerDirectives.TruffleBoundary
        public boolean accepts(Object receiver_) {
            return true;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    @GeneratedBy(value=NativeArgumentLibrary.class)
    private static final class CachedToUncachedDispatch
    extends NativeArgumentLibrary {
        private CachedToUncachedDispatch() {
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void serialize(LibFFIType receiver_, NativeArgumentBuffer buffer, Object value) throws UnsupportedTypeException {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this.getParent());
            try {
                ((NativeArgumentLibrary)INSTANCE.getUncached(receiver_)).serialize(receiver_, buffer, value);
                return;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object deserialize(LibFFIType receiver_, NativeArgumentBuffer buffer) {
            assert (this.getRootNode() != null) : "Invalid libray usage. Cached library must be adopted by a RootNode before it is executed.";
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this.getParent());
            try {
                Object object = ((NativeArgumentLibrary)INSTANCE.getUncached(receiver_)).deserialize(receiver_, buffer);
                return object;
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }
    }

    @GeneratedBy(value=NativeArgumentLibrary.class)
    private static final class Proxy
    extends NativeArgumentLibrary {
        @Node.Child
        private ReflectionLibrary lib;

        Proxy(ReflectionLibrary lib) {
            this.lib = lib;
        }

        @Override
        public void serialize(LibFFIType receiver_, NativeArgumentBuffer buffer, Object value) throws UnsupportedTypeException {
            try {
                this.lib.send((Object)receiver_, SERIALIZE, new Object[]{buffer, value});
                return;
            }
            catch (UnsupportedTypeException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError((Object)e_);
            }
        }

        @Override
        public Object deserialize(LibFFIType receiver_, NativeArgumentBuffer buffer) {
            try {
                return this.lib.send((Object)receiver_, DESERIALIZE, new Object[]{buffer});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError((Object)e_);
            }
        }

        public boolean accepts(Object receiver_) {
            return this.lib.accepts(receiver_);
        }
    }

    @GeneratedBy(value=NativeArgumentLibrary.class)
    private static class MessageImpl
    extends Message {
        final int index;

        MessageImpl(String name, int index, Class<?> returnType, Class<?> ... parameters) {
            super(LIBRARY_CLASS, name, returnType, (Class[])parameters);
            this.index = index;
        }
    }

    @GeneratedBy(value=NativeArgumentLibrary.class)
    private static final class Default
    extends LibraryExport<NativeArgumentLibrary> {
        private Default() {
            super(NativeArgumentLibrary.class, LibFFIType.class, false);
        }

        protected NativeArgumentLibrary createUncached(Object receiver) {
            assert (receiver instanceof LibFFIType);
            return new Uncached(receiver);
        }

        protected NativeArgumentLibrary createCached(Object receiver) {
            assert (receiver instanceof LibFFIType);
            return new Cached(receiver);
        }

        @GeneratedBy(value=NativeArgumentLibrary.class)
        private static final class Uncached
        extends NativeArgumentLibrary {
            private final Class<? extends LibFFIType> receiverClass_;

            Uncached(Object receiver) {
                this.receiverClass_ = ((LibFFIType)receiver).getClass();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export 'com.oracle.truffle.nfi.impl.NativeArgumentLibrary'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver.getClass() == this.receiverClass_;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void serialize(LibFFIType receiver, NativeArgumentBuffer buffer, Object value) throws UnsupportedTypeException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object deserialize(LibFFIType receiver, NativeArgumentBuffer buffer) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }
        }

        @GeneratedBy(value=NativeArgumentLibrary.class)
        private static final class Cached
        extends NativeArgumentLibrary {
            private final Class<? extends LibFFIType> receiverClass_;

            Cached(Object receiver) {
                this.receiverClass_ = ((LibFFIType)receiver).getClass();
            }

            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export 'com.oracle.truffle.nfi.impl.NativeArgumentLibrary'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver.getClass() == this.receiverClass_;
            }

            @Override
            public void serialize(LibFFIType receiver, NativeArgumentBuffer buffer, Object value) throws UnsupportedTypeException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            public Object deserialize(LibFFIType receiver, NativeArgumentBuffer buffer) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }
        }
    }
}

