/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.nfi.BindSignatureNode;
import com.oracle.truffle.nfi.spi.NativeSymbolLibrary;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=BindSignatureNode.class)
final class BindSignatureNodeGen
extends BindSignatureNode {
    private static final Uncached UNCACHED = new Uncached();
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    private static final LibraryFactory<NativeSymbolLibrary> NATIVE_SYMBOL_LIBRARY_ = LibraryFactory.resolve(NativeSymbolLibrary.class);
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;
    @Node.Child
    private CachedSignature0Data cachedSignature0_cache;
    @Node.Child
    private CachedSignature1Data cachedSignature1_cache;
    @Node.Child
    private CachedSignatureString0Data cachedSignatureString0_cache;
    @Node.Child
    private CachedSignatureString1Data cachedSignatureString1_cache;
    @Node.Child
    private Generic0Data generic0_cache;

    private BindSignatureNodeGen() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    Object execute(Object arg0Value, Object arg1Value) throws UnsupportedMessageException, UnsupportedTypeException {
        int state = this.state_;
        if (state != 0) {
            if ((state & 1) != 0) {
                CachedSignature0Data s1_ = this.cachedSignature0_cache;
                while (s1_ != null) {
                    assert (s1_.interop_.accepts(s1_.cachedSignature_));
                    if (s1_.symbolLibrary_.accepts(arg0Value) && arg1Value == s1_.cachedSignature_) {
                        return BindSignatureNode.doCachedSignature(arg0Value, arg1Value, s1_.cachedSignature_, s1_.interop_, s1_.symbolLibrary_, s1_.parsedSignature_);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state & 2) != 0) {
                CachedSignature1Data s2_ = this.cachedSignature1_cache;
                while (s2_ != null) {
                    if (arg1Value == s2_.cachedSignature_) {
                        return this.cachedSignature1Boundary(state, s2_, arg0Value, arg1Value);
                    }
                    s2_ = s2_.next_;
                }
            }
            if ((state & 4) != 0) {
                CachedSignatureString0Data s3_ = this.cachedSignatureString0_cache;
                while (s3_ != null) {
                    if (s3_.interop_.accepts(arg1Value) && s3_.symbolLibrary_.accepts(arg0Value) && s3_.cachedSignature_.equals(BindSignatureNode.asString(s3_.interop_, arg1Value))) {
                        return BindSignatureNode.doCachedSignatureString(arg0Value, arg1Value, s3_.interop_, s3_.cachedSignature_, s3_.symbolLibrary_, s3_.parsedSignature_);
                    }
                    s3_ = s3_.next_;
                }
            }
            if ((state & 8) != 0) {
                CachedSignatureString1Data s4_ = this.cachedSignatureString1_cache;
                while (s4_ != null) {
                    Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                    try {
                        if (s4_.cachedSignature_.equals(BindSignatureNode.asString((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value), arg1Value))) {
                            Object object = BindSignatureNode.doCachedSignatureString(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value), s4_.cachedSignature_, (NativeSymbolLibrary)NATIVE_SYMBOL_LIBRARY_.getUncached(arg0Value), s4_.parsedSignature_);
                            return object;
                        }
                    }
                    finally {
                        NodeUtil.popEncapsulatingNode((Node)prev_);
                    }
                    s4_ = s4_.next_;
                }
            }
            if ((state & 0x10) != 0) {
                Generic0Data s5_ = this.generic0_cache;
                while (s5_ != null) {
                    if (s5_.interop_.accepts(arg1Value) && s5_.symbolLibrary_.accepts(arg0Value)) {
                        return BindSignatureNode.doGeneric(arg0Value, arg1Value, s5_.interop_, s5_.symbolLibrary_);
                    }
                    s5_ = s5_.next_;
                }
            }
            if ((state & 0x20) != 0) {
                return this.generic1Boundary(state, arg0Value, arg1Value);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value, arg1Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private Object cachedSignature1Boundary(int state, CachedSignature1Data s2_, Object arg0Value, Object arg1Value) throws UnsupportedMessageException, UnsupportedTypeException {
        Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
        try {
            Object object = BindSignatureNode.doCachedSignature(arg0Value, arg1Value, s2_.cachedSignature_, (InteropLibrary)INTEROP_LIBRARY_.getUncached(s2_.cachedSignature_), (NativeSymbolLibrary)NATIVE_SYMBOL_LIBRARY_.getUncached(arg0Value), s2_.parsedSignature_);
            return object;
        }
        finally {
            NodeUtil.popEncapsulatingNode((Node)prev_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private Object generic1Boundary(int state, Object arg0Value, Object arg1Value) throws UnsupportedMessageException, UnsupportedTypeException {
        Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
        try {
            Object object = BindSignatureNode.doGeneric(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value), (NativeSymbolLibrary)NATIVE_SYMBOL_LIBRARY_.getUncached(arg0Value));
            return object;
        }
        finally {
            NodeUtil.popEncapsulatingNode((Node)prev_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeAndSpecialize(Object arg0Value, Object arg1Value) throws UnsupportedMessageException, UnsupportedTypeException {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            Object object;
            if ((exclude & 1) == 0) {
                int count1_ = 0;
                CachedSignature0Data s1_ = this.cachedSignature0_cache;
                if ((state & 1) != 0) {
                    while (s1_ != null) {
                        assert (s1_.interop_.accepts(s1_.cachedSignature_));
                        if (s1_.symbolLibrary_.accepts(arg0Value) && arg1Value == s1_.cachedSignature_) break;
                        s1_ = s1_.next_;
                        ++count1_;
                    }
                }
                if (s1_ == null && count1_ < 5) {
                    s1_ = (CachedSignature0Data)super.insert((Node)new CachedSignature0Data(this.cachedSignature0_cache));
                    s1_.cachedSignature_ = arg1Value;
                    s1_.interop_ = s1_.insertAccessor((InteropLibrary)INTEROP_LIBRARY_.create(s1_.cachedSignature_));
                    s1_.symbolLibrary_ = s1_.insertAccessor((NativeSymbolLibrary)NATIVE_SYMBOL_LIBRARY_.create(arg0Value));
                    s1_.parsedSignature_ = BindSignatureNode.parseSignature(arg0Value, s1_.cachedSignature_, s1_.interop_, s1_.symbolLibrary_);
                    this.cachedSignature0_cache = s1_;
                    this.state_ = state |= 1;
                }
                if (s1_ != null) {
                    lock.unlock();
                    hasLock = false;
                    Object object2 = BindSignatureNode.doCachedSignature(arg0Value, arg1Value, s1_.cachedSignature_, s1_.interop_, s1_.symbolLibrary_, s1_.parsedSignature_);
                    return object2;
                }
            }
            if ((exclude & 2) == 0) {
                Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                try {
                    int count2_ = 0;
                    CachedSignature1Data s2_ = this.cachedSignature1_cache;
                    if ((state & 2) != 0) {
                        while (s2_ != null && arg1Value != s2_.cachedSignature_) {
                            s2_ = s2_.next_;
                            ++count2_;
                        }
                    }
                    if (s2_ == null && count2_ < 5) {
                        s2_ = (CachedSignature1Data)super.insert((Node)new CachedSignature1Data(this.cachedSignature1_cache));
                        s2_.cachedSignature_ = arg1Value;
                        s2_.parsedSignature_ = BindSignatureNode.parseSignature(arg0Value, s2_.cachedSignature_, (InteropLibrary)INTEROP_LIBRARY_.getUncached(s2_.cachedSignature_), (NativeSymbolLibrary)NATIVE_SYMBOL_LIBRARY_.getUncached(arg0Value));
                        this.cachedSignature1_cache = s2_;
                        this.exclude_ = exclude |= 1;
                        this.cachedSignature0_cache = null;
                        state &= 0xFFFFFFFE;
                        this.state_ = state |= 2;
                    }
                    if (s2_ != null) {
                        lock.unlock();
                        hasLock = false;
                        Object object3 = BindSignatureNode.doCachedSignature(arg0Value, arg1Value, s2_.cachedSignature_, (InteropLibrary)INTEROP_LIBRARY_.getUncached(s2_.cachedSignature_), (NativeSymbolLibrary)NATIVE_SYMBOL_LIBRARY_.getUncached(arg0Value), s2_.parsedSignature_);
                        return object3;
                    }
                }
                finally {
                    NodeUtil.popEncapsulatingNode((Node)prev_);
                }
            }
            if ((exclude & 4) == 0) {
                Object interop__;
                String cachedSignature__;
                int count3_ = 0;
                CachedSignatureString0Data s3_ = this.cachedSignatureString0_cache;
                if ((state & 4) != 0) {
                    while (!(s3_ == null || s3_.interop_.accepts(arg1Value) && s3_.symbolLibrary_.accepts(arg0Value) && s3_.cachedSignature_.equals(BindSignatureNode.asString(s3_.interop_, arg1Value)))) {
                        s3_ = s3_.next_;
                        ++count3_;
                    }
                }
                if (s3_ == null && (cachedSignature__ = BindSignatureNode.asString(interop__ = (InteropLibrary)super.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(arg1Value))), arg1Value)).equals(BindSignatureNode.asString(interop__, arg1Value)) && count3_ < 5) {
                    s3_ = (CachedSignatureString0Data)super.insert((Node)new CachedSignatureString0Data(this.cachedSignatureString0_cache));
                    s3_.interop_ = s3_.insertAccessor(interop__);
                    s3_.cachedSignature_ = cachedSignature__;
                    s3_.symbolLibrary_ = s3_.insertAccessor((NativeSymbolLibrary)NATIVE_SYMBOL_LIBRARY_.create(arg0Value));
                    s3_.parsedSignature_ = BindSignatureNode.parseSignature(arg0Value, arg1Value, interop__, s3_.symbolLibrary_);
                    this.cachedSignatureString0_cache = s3_;
                    this.exclude_ = exclude |= 3;
                    this.cachedSignature0_cache = null;
                    this.cachedSignature1_cache = null;
                    state &= 0xFFFFFFFC;
                    this.state_ = state |= 4;
                }
                if (s3_ != null) {
                    lock.unlock();
                    hasLock = false;
                    interop__ = BindSignatureNode.doCachedSignatureString(arg0Value, arg1Value, s3_.interop_, s3_.cachedSignature_, s3_.symbolLibrary_, s3_.parsedSignature_);
                    return interop__;
                }
            }
            if ((exclude & 8) == 0) {
                Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                try {
                    InteropLibrary interop__;
                    String cachedSignature__;
                    int count4_ = 0;
                    CachedSignatureString1Data s4_ = this.cachedSignatureString1_cache;
                    if ((state & 8) != 0) {
                        while (s4_ != null && !s4_.cachedSignature_.equals(BindSignatureNode.asString((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value), arg1Value))) {
                            s4_ = s4_.next_;
                            ++count4_;
                        }
                    }
                    if (s4_ == null && (cachedSignature__ = BindSignatureNode.asString(interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value), arg1Value)).equals(BindSignatureNode.asString(interop__, arg1Value)) && count4_ < 5) {
                        s4_ = (CachedSignatureString1Data)super.insert((Node)new CachedSignatureString1Data(this.cachedSignatureString1_cache));
                        s4_.cachedSignature_ = cachedSignature__;
                        s4_.parsedSignature_ = BindSignatureNode.parseSignature(arg0Value, arg1Value, interop__, (NativeSymbolLibrary)NATIVE_SYMBOL_LIBRARY_.getUncached(arg0Value));
                        this.cachedSignatureString1_cache = s4_;
                        this.exclude_ = exclude |= 7;
                        this.cachedSignature0_cache = null;
                        this.cachedSignature1_cache = null;
                        this.cachedSignatureString0_cache = null;
                        state &= 0xFFFFFFF8;
                        this.state_ = state |= 8;
                    }
                    if (s4_ != null) {
                        lock.unlock();
                        hasLock = false;
                        Object object4 = BindSignatureNode.doCachedSignatureString(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value), s4_.cachedSignature_, (NativeSymbolLibrary)NATIVE_SYMBOL_LIBRARY_.getUncached(arg0Value), s4_.parsedSignature_);
                        return object4;
                    }
                }
                finally {
                    NodeUtil.popEncapsulatingNode((Node)prev_);
                }
            }
            if ((exclude & 0x10) == 0) {
                int count5_ = 0;
                Generic0Data s5_ = this.generic0_cache;
                if ((state & 0x10) != 0) {
                    while (!(s5_ == null || s5_.interop_.accepts(arg1Value) && s5_.symbolLibrary_.accepts(arg0Value))) {
                        s5_ = s5_.next_;
                        ++count5_;
                    }
                }
                if (s5_ == null && count5_ < 3) {
                    s5_ = (Generic0Data)super.insert((Node)new Generic0Data(this.generic0_cache));
                    s5_.interop_ = s5_.insertAccessor((InteropLibrary)INTEROP_LIBRARY_.create(arg1Value));
                    s5_.symbolLibrary_ = s5_.insertAccessor((NativeSymbolLibrary)NATIVE_SYMBOL_LIBRARY_.create(arg0Value));
                    this.generic0_cache = s5_;
                    this.exclude_ = exclude |= 0xF;
                    this.cachedSignature0_cache = null;
                    this.cachedSignature1_cache = null;
                    this.cachedSignatureString0_cache = null;
                    this.cachedSignatureString1_cache = null;
                    state &= 0xFFFFFFF0;
                    this.state_ = state |= 0x10;
                }
                if (s5_ != null) {
                    lock.unlock();
                    hasLock = false;
                    Object object5 = BindSignatureNode.doGeneric(arg0Value, arg1Value, s5_.interop_, s5_.symbolLibrary_);
                    return object5;
                }
            }
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                this.exclude_ = exclude |= 0x1F;
                this.cachedSignature0_cache = null;
                this.cachedSignature1_cache = null;
                this.cachedSignatureString0_cache = null;
                this.cachedSignatureString1_cache = null;
                this.generic0_cache = null;
                state &= 0xFFFFFFE0;
                this.state_ = state |= 0x20;
                lock.unlock();
                hasLock = false;
                object = BindSignatureNode.doGeneric(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value), (NativeSymbolLibrary)NATIVE_SYMBOL_LIBRARY_.getUncached(arg0Value));
            }
            catch (Throwable throwable) {
                NodeUtil.popEncapsulatingNode((Node)prev_);
                throw throwable;
            }
            NodeUtil.popEncapsulatingNode((Node)prev_);
            return object;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            CachedSignature0Data s1_ = this.cachedSignature0_cache;
            CachedSignature1Data s2_ = this.cachedSignature1_cache;
            CachedSignatureString0Data s3_ = this.cachedSignatureString0_cache;
            CachedSignatureString1Data s4_ = this.cachedSignatureString1_cache;
            Generic0Data s5_ = this.generic0_cache;
            if (!(s1_ != null && s1_.next_ != null || s2_ != null && s2_.next_ != null || s3_ != null && s3_.next_ != null || s4_ != null && s4_.next_ != null || s5_ != null && s5_.next_ != null)) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    public static BindSignatureNode create() {
        return new BindSignatureNodeGen();
    }

    public static BindSignatureNode getUncached() {
        return UNCACHED;
    }

    @GeneratedBy(value=BindSignatureNode.class)
    private static final class Uncached
    extends BindSignatureNode {
        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        Object execute(Object arg0Value, Object arg1Value) throws UnsupportedMessageException, UnsupportedTypeException {
            return BindSignatureNode.doGeneric(arg0Value, arg1Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg1Value), (NativeSymbolLibrary)NATIVE_SYMBOL_LIBRARY_.getUncached(arg0Value));
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    @GeneratedBy(value=BindSignatureNode.class)
    private static final class Generic0Data
    extends Node {
        @Node.Child
        Generic0Data next_;
        @Node.Child
        InteropLibrary interop_;
        @Node.Child
        NativeSymbolLibrary symbolLibrary_;

        Generic0Data(Generic0Data next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }

    @GeneratedBy(value=BindSignatureNode.class)
    private static final class CachedSignatureString1Data
    extends Node {
        @Node.Child
        CachedSignatureString1Data next_;
        @CompilerDirectives.CompilationFinal
        String cachedSignature_;
        @CompilerDirectives.CompilationFinal
        Object parsedSignature_;

        CachedSignatureString1Data(CachedSignatureString1Data next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }
    }

    @GeneratedBy(value=BindSignatureNode.class)
    private static final class CachedSignatureString0Data
    extends Node {
        @Node.Child
        CachedSignatureString0Data next_;
        @Node.Child
        InteropLibrary interop_;
        @CompilerDirectives.CompilationFinal
        String cachedSignature_;
        @Node.Child
        NativeSymbolLibrary symbolLibrary_;
        @CompilerDirectives.CompilationFinal
        Object parsedSignature_;

        CachedSignatureString0Data(CachedSignatureString0Data next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }

    @GeneratedBy(value=BindSignatureNode.class)
    private static final class CachedSignature1Data
    extends Node {
        @Node.Child
        CachedSignature1Data next_;
        @CompilerDirectives.CompilationFinal
        Object cachedSignature_;
        @CompilerDirectives.CompilationFinal
        Object parsedSignature_;

        CachedSignature1Data(CachedSignature1Data next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }
    }

    @GeneratedBy(value=BindSignatureNode.class)
    private static final class CachedSignature0Data
    extends Node {
        @Node.Child
        CachedSignature0Data next_;
        @CompilerDirectives.CompilationFinal
        Object cachedSignature_;
        @Node.Child
        InteropLibrary interop_;
        @Node.Child
        NativeSymbolLibrary symbolLibrary_;
        @CompilerDirectives.CompilationFinal
        Object parsedSignature_;

        CachedSignature0Data(CachedSignature0Data next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

