/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapdump.impl;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.application.jvm.Jvm;
import org.graalvm.visualvm.application.jvm.JvmFactory;
import org.graalvm.visualvm.core.ui.actions.ActionUtils;
import org.graalvm.visualvm.core.ui.actions.SingleDataSourceAction;
import org.openide.util.NbBundle;

class HeapDumpOnOOMEAction
extends SingleDataSourceAction<Application> {
    private boolean oomeEnabled;
    private Application lastSelectedApplication;
    private final PropertyChangeListener stateListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            HeapDumpOnOOMEAction.this.updateState(ActionUtils.getSelectedDataSources(Application.class));
        }
    };
    private static HeapDumpOnOOMEAction instance;

    public static synchronized HeapDumpOnOOMEAction instance() {
        if (instance == null) {
            instance = new HeapDumpOnOOMEAction();
        }
        return instance;
    }

    protected void actionPerformed(Application application, ActionEvent actionEvent) {
        Jvm jvm = JvmFactory.getJVMFor((Application)application);
        jvm.setDumpOnOOMEnabled(!this.oomeEnabled);
        this.updateState(jvm);
    }

    protected boolean isEnabled(Application application) {
        this.lastSelectedApplication = application;
        this.lastSelectedApplication.addPropertyChangeListener("prop_state", this.stateListener);
        if (application.getState() != 1) {
            return false;
        }
        Jvm jvm = JvmFactory.getJVMFor((Application)application);
        if (!jvm.isDumpOnOOMEnabledSupported()) {
            return false;
        }
        this.updateState(jvm);
        return true;
    }

    private void updateState(Jvm jvm) {
        this.oomeEnabled = jvm.isDumpOnOOMEnabled();
        if (this.oomeEnabled) {
            this.putValue("Name", NbBundle.getMessage(HeapDumpOnOOMEAction.class, (String)"LBL_Disable_Heap_Dump_on_OOME"));
            this.putValue("ShortDescription", NbBundle.getMessage(HeapDumpOnOOMEAction.class, (String)"DESCR_Disable_Heap_Dump_on_OOME"));
        } else {
            this.putValue("Name", NbBundle.getMessage(HeapDumpOnOOMEAction.class, (String)"LBL_Enable_Heap_Dump_on_OOME"));
            this.putValue("ShortDescription", NbBundle.getMessage(HeapDumpOnOOMEAction.class, (String)"DESCR_Enable_Heap_Dump_on_OOME"));
        }
    }

    protected void updateState(Set<Application> applications) {
        if (this.lastSelectedApplication != null) {
            this.lastSelectedApplication.removePropertyChangeListener("prop_state", this.stateListener);
            this.lastSelectedApplication = null;
        }
        super.updateState(applications);
    }

    private HeapDumpOnOOMEAction() {
        super(Application.class);
    }
}

