/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import javax.swing.Action;
import org.openide.awt.ContextAction;
import org.openide.awt.ContextSelection;
import org.openide.util.Lookup;

final class StatefulAction<T>
extends ContextAction<T> {
    private final ContextAction.StatefulMonitor checkValueMonitor;
    private boolean selValue;
    private boolean first = true;

    public StatefulAction(ContextAction.Performer performer, ContextSelection contextSelection, Lookup lookup, Class clazz, boolean bl, ContextAction.StatefulMonitor statefulMonitor, ContextAction.StatefulMonitor statefulMonitor2) {
        super(performer, contextSelection, lookup, clazz, bl, statefulMonitor);
        this.checkValueMonitor = statefulMonitor2;
    }

    @Override
    void updateStateProperties() {
        super.updateStateProperties();
        if (!this.wasEnabled()) {
            LOG.log(Level.FINE, "Action {0} disabled, unchecked", this);
            this.putValue("SwingSelectedKey", false);
            return;
        }
        boolean bl = this.fetchStateValue();
        boolean bl2 = this.selValue;
        this.selValue = bl;
        LOG.log(Level.FINE, "Action {0}: old check state {1}, new check state {2}", new Object[]{this, bl2, bl});
        this.firePropertyChange("SwingSelectedKey", bl2, bl);
    }

    private boolean fetchStateValue() {
        this.first = false;
        if (this.checkValueMonitor.getType() == Action.class) {
            return this.global.runEnabled(this.type, this.selectMode, (list, provider) -> this.checkValueMonitor.enabled(Collections.singletonList(this.performer.delegate((Lookup.Provider)provider, (List<?>)list)), () -> (Action)this.performer.delegate((Lookup.Provider)provider, (List<?>)list)));
        }
        return this.global.runEnabled(this.checkValueMonitor.getType(), this.selectMode, (list, provider) -> this.checkValueMonitor.enabled(list, () -> (Action)this.performer.delegate((Lookup.Provider)provider, (List<?>)list)));
    }

    @Override
    public Object getValue(String string) {
        if ("SwingSelectedKey".equals(string)) {
            LOG.log(Level.FINER, "Action {0} state: {1}", new Object[]{this, this.selValue});
            return this.selValue;
        }
        return super.getValue(string);
    }

    @Override
    public Action createContextAwareInstance(Lookup lookup) {
        ContextAction.StatefulMonitor statefulMonitor = this.checkValueMonitor.createContextMonitor(lookup);
        ContextAction.StatefulMonitor statefulMonitor2 = this.enableMonitor == null ? null : this.enableMonitor.createContextMonitor(lookup);
        StatefulAction<T> statefulAction = new StatefulAction<T>(this.performer, this.selectMode, lookup, this.type, this.global.isSurvive(), statefulMonitor2, statefulMonitor);
        LOG.log(Level.FINE, "Created context Stateful instance: {0} from {1}, check monitor {2}, enable monitor {3}", new Object[]{statefulAction, this, statefulMonitor, statefulMonitor2});
        return statefulAction;
    }

    @Override
    void clearState() {
        super.clearState();
        this.checkValueMonitor.clear();
    }

    @Override
    protected void stopListeners() {
        Class<?> clazz = this.checkValueMonitor.getType();
        if (clazz != Action.class) {
            this.global.unregisterListener(this.checkValueMonitor.getType(), this);
        }
        this.checkValueMonitor.removeChangeListener(this);
        super.stopListeners();
    }

    @Override
    protected void startListeners() {
        super.startListeners();
        Class<?> clazz = this.checkValueMonitor.getType();
        if (clazz != Action.class) {
            this.global.registerListener(this.checkValueMonitor.getType(), this);
        }
        if (this.first) {
            this.selValue = this.fetchStateValue();
        }
        this.checkValueMonitor.addChangeListener(this);
    }
}

