/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.awt;

import java.awt.event.ActionListener;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.processing.Completion;
import javax.annotation.processing.Completions;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.swing.Action;
import javax.swing.JSeparator;
import javax.tools.Diagnostic;
import org.openide.awt.ActionID;
import org.openide.awt.ActionReference;
import org.openide.awt.ActionReferences;
import org.openide.awt.ActionRegistration;
import org.openide.awt.ActionState;
import org.openide.awt.DynamicMenuContent;
import org.openide.filesystems.annotations.LayerBuilder;
import org.openide.filesystems.annotations.LayerGeneratingProcessor;
import org.openide.filesystems.annotations.LayerGenerationException;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.Presenter;

@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
public final class ActionProcessor
extends LayerGeneratingProcessor {
    private static final String IDENTIFIER = "(?:\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)";
    private static final Pattern FQN = Pattern.compile("(?:\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)(?:[.](?:\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*))*");
    private static final String[] DEFAULT_COMPLETIONS = new String[]{"Menu", "Toolbars", "Shortcuts", "Loaders"};
    private Processor COMPLETIONS;

    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(ActionRegistration.class.getCanonicalName());
        hashSet.add(ActionID.class.getCanonicalName());
        hashSet.add(ActionReference.class.getCanonicalName());
        hashSet.add(ActionReferences.class.getCanonicalName());
        return hashSet;
    }

    /*
     * WARNING - void declaration
     */
    public Iterable<? extends Completion> getCompletions(Element element, AnnotationMirror annotationMirror, ExecutableElement executableElement, String string) {
        if (annotationMirror.getAnnotationType().asElement().getSimpleName().toString().contains(ActionReference.class.getSimpleName()) && executableElement.getSimpleName().contentEquals("path")) {
            if (string == null) {
                string = "";
            }
            if (string.startsWith("\"")) {
                string = string.substring(1);
            }
            HashSet<Completion> hashSet = new HashSet<Completion>();
            for (String string2 : DEFAULT_COMPLETIONS) {
                if (!string2.startsWith(string)) continue;
                hashSet.add(Completions.of("\"" + string2 + '/', NbBundle.getMessage(ActionProcessor.class, (String)("HINT_" + string2))));
            }
            if (!hashSet.isEmpty()) {
                return hashSet;
            }
            if (this.COMPLETIONS == null) {
                String string3 = System.getProperty(ActionReference.class.getName() + ".completion");
                if (string3 != null) {
                    void var7_10;
                    ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
                    if (classLoader == null) {
                        ClassLoader completion = Thread.currentThread().getContextClassLoader();
                    }
                    if (var7_10 == null) {
                        ClassLoader classLoader2 = ActionProcessor.class.getClassLoader();
                    }
                    try {
                        void var7_12;
                        this.COMPLETIONS = (Processor)Class.forName(string3, true, (ClassLoader)var7_12).newInstance();
                    }
                    catch (Exception exception) {
                        Exceptions.printStackTrace((Throwable)exception);
                        this.COMPLETIONS = this;
                    }
                } else {
                    return hashSet;
                }
            }
            if (this.COMPLETIONS != null && this.COMPLETIONS != this) {
                this.COMPLETIONS.init(this.processingEnv);
                for (Completion completion : this.COMPLETIONS.getCompletions(element, annotationMirror, executableElement, string)) {
                    hashSet.add(completion);
                }
            }
            return hashSet;
        }
        return Collections.emptyList();
    }

    protected boolean handleProcess(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) throws LayerGenerationException {
        ActionID actionID;
        Annotation annotation;
        TypeMirror typeMirror = this.type(ActionListener.class);
        TypeMirror typeMirror2 = this.type(Presenter.Menu.class);
        TypeMirror typeMirror3 = this.type(Presenter.Toolbar.class);
        TypeMirror typeMirror4 = this.type(Presenter.Popup.class);
        TypeMirror typeMirror5 = this.type(ContextAwareAction.class);
        TypeMirror typeMirror6 = this.type(DynamicMenuContent.class);
        TypeMirror typeMirror7 = this.type(Action.class);
        TypeMirror typeMirror8 = this.type(Object.class);
        TypeMirror typeMirror9 = this.type(EventListener.class);
        TypeMirror typeMirror10 = this.type(Void.class);
        for (Element element : roundEnvironment.getElementsAnnotatedWith(ActionRegistration.class)) {
            ActionReferences actionReferences;
            Object object;
            String string;
            Object object2;
            Object object3;
            String string2;
            annotation = element.getAnnotation(ActionRegistration.class);
            if (annotation == null) continue;
            actionID = element.getAnnotation(ActionID.class);
            if (actionID == null) {
                throw new LayerGenerationException("@ActionRegistration can only be used together with @ActionID annotation", element, this.processingEnv, annotation);
            }
            if (actionID.id() == null) continue;
            if (actionID.category().startsWith("Actions/")) {
                throw new LayerGenerationException("@ActionID category() should not start with Actions/", element, this.processingEnv, (Annotation)actionID, "category");
            }
            if (!FQN.matcher(actionID.id()).matches()) {
                throw new LayerGenerationException("@ActionID id() must be valid fully qualified name", element, this.processingEnv, (Annotation)actionID, "id");
            }
            ActionReference[] actionReferenceArray = actionID.id().replace('.', '-');
            LayerBuilder layerBuilder = this.layer(new Element[]{element});
            LayerBuilder.File file = layerBuilder.file("Actions/" + actionID.category() + "/" + (String)actionReferenceArray + ".instance");
            file.bundlevalue("displayName", annotation.displayName(), annotation, "displayName");
            String string3 = annotation.menuText();
            if (!string3.isEmpty()) {
                file.bundlevalue("menuText", string3, annotation, "menuText");
            }
            if (!(string2 = annotation.popupText()).isEmpty()) {
                file.bundlevalue("popupText", string2, annotation, "popupText");
            }
            boolean bl = true;
            if (element.getKind() == ElementKind.FIELD) {
                object3 = (VariableElement)element;
                object2 = this.type(String.class);
                if (!(element.asType() == object2 && element.getModifiers().contains((Object)Modifier.PUBLIC) && element.getModifiers().contains((Object)Modifier.STATIC) && element.getModifiers().contains((Object)Modifier.FINAL))) {
                    throw new LayerGenerationException("Only static string constant fields can be annotated", element, this.processingEnv, annotation);
                }
                if (annotation.key().length() != 0) {
                    throw new LayerGenerationException("When annotating field, one cannot define key()", element, this.processingEnv, annotation, "key");
                }
                bl = false;
                string = object3.getConstantValue().toString();
            } else if (element.getKind() == ElementKind.CLASS) {
                if (!this.isAssignable(element.asType(), typeMirror)) {
                    throw new LayerGenerationException("Class annotated with @ActionRegistration must implement java.awt.event.ActionListener!", element, this.processingEnv, annotation);
                }
                if (!element.getModifiers().contains((Object)Modifier.PUBLIC)) {
                    throw new LayerGenerationException("Class has to be public", element, this.processingEnv, annotation);
                }
                if (element.getEnclosingElement().getKind() == ElementKind.CLASS && !element.getModifiers().contains((Object)Modifier.STATIC)) {
                    throw new LayerGenerationException("Inner class annotated with @ActionRegistration has to be static", element);
                }
                string = annotation.key();
            } else {
                assert (element.getKind() == ElementKind.METHOD) : element;
                layerBuilder.instanceFile("dummy", null, ActionListener.class, annotation, null);
                string = annotation.key();
            }
            object3 = null;
            object2 = null;
            block3: for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                if (!annotationMirror.getAnnotationType().toString().equals(ActionRegistration.class.getCanonicalName())) continue;
                object2 = annotationMirror;
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                    if (!entry.getKey().getSimpleName().contentEquals("lazy")) continue;
                    object3 = (Boolean)entry.getValue().getValue() == false;
                    assert ((Boolean)object3 == !annotation.lazy());
                    continue block3;
                }
            }
            if (object3 == null) {
                if (element.getKind() == ElementKind.FIELD) {
                    object3 = false;
                } else {
                    object = element.getKind() == ElementKind.CLASS ? element.asType() : ((ExecutableElement)element).getReturnType();
                    object3 = this.isAssignable((TypeMirror)object, typeMirror2) || this.isAssignable((TypeMirror)object, typeMirror3) || this.isAssignable((TypeMirror)object, typeMirror4) || this.isAssignable((TypeMirror)object, typeMirror5) || this.isAssignable((TypeMirror)object, typeMirror6);
                    if (((Boolean)object3).booleanValue()) {
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Should explicitly specify lazy attribute", element);
                    }
                }
            }
            if (((Boolean)object3).booleanValue()) {
                if (string.length() != 0) {
                    throw new LayerGenerationException("Cannot specify key and use eager registration", element, this.processingEnv, annotation, "key");
                }
                if (!annotation.iconBase().isEmpty()) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "iconBase unused on eager registrations", element, (AnnotationMirror)object2);
                }
                file.instanceAttribute("instanceCreate", Action.class);
            } else {
                object = null;
                if (string.length() == 0) {
                    file.methodvalue("instanceCreate", "org.openide.awt.Actions", "alwaysEnabled");
                } else {
                    file.methodvalue("instanceCreate", "org.openide.awt.Actions", "callback");
                    if (bl) {
                        file.methodvalue("fallback", "org.openide.awt.Actions", "alwaysEnabled");
                    }
                    file.stringvalue("key", string);
                }
                if (bl) {
                    try {
                        file.instanceAttribute("delegate", ActionListener.class, annotation, null);
                    }
                    catch (LayerGenerationException layerGenerationException) {
                        object = this.generateContext(element, file, (ActionRegistration)annotation);
                    }
                }
                if (annotation.iconBase().length() > 0) {
                    layerBuilder.validateResource(annotation.iconBase(), element, annotation, "iconBase", true);
                    file.stringvalue("iconBase", annotation.iconBase());
                }
                file.boolvalue("noIconInMenu", !annotation.iconInMenu());
                if (annotation.asynchronous()) {
                    file.boolvalue("asynchronous", true);
                }
                if (annotation.surviveFocusChange()) {
                    file.boolvalue("surviveFocusChange", true);
                }
                this.processActionState(element, annotation.enabledOn(), file, (TypeMirror)object, true, typeMirror7, typeMirror8, typeMirror9, typeMirror10);
                this.processActionState(element, annotation.checkedOn(), file, (TypeMirror)object, false, typeMirror7, typeMirror8, typeMirror9, typeMirror10);
            }
            file.write();
            object = element.getAnnotation(ActionReference.class);
            if (object != null) {
                this.processReferences(element, (ActionReference)object, actionID);
            }
            if ((actionReferences = element.getAnnotation(ActionReferences.class)) == null) continue;
            for (ActionReference actionReference : actionReferences.value()) {
                this.processReferences(element, actionReference, actionID);
            }
        }
        for (Element element : roundEnvironment.getElementsAnnotatedWith(ActionReference.class)) {
            if (element.getAnnotation(ActionRegistration.class) != null || (annotation = element.getAnnotation(ActionReference.class)) == null) continue;
            actionID = element.getAnnotation(ActionID.class);
            if (actionID != null) {
                this.processReferences(element, (ActionReference)annotation, actionID);
                continue;
            }
            throw new LayerGenerationException("Don't use @ActionReference without @ActionID", element, this.processingEnv, annotation);
        }
        for (Element element : roundEnvironment.getElementsAnnotatedWith(ActionReferences.class)) {
            if (element.getAnnotation(ActionRegistration.class) != null || (annotation = element.getAnnotation(ActionReferences.class)) == null) continue;
            actionID = element.getAnnotation(ActionID.class);
            if (actionID != null) {
                for (ActionReference actionReference : annotation.value()) {
                    if (!actionReference.id().id().isEmpty() || !actionReference.id().category().isEmpty()) {
                        throw new LayerGenerationException("Don't specify additional id=@ActionID(...) when using @ActionID on the element", element, this.processingEnv, (Annotation)actionReference.id());
                    }
                    this.processReferences(element, actionReference, actionID);
                }
                continue;
            }
            for (ActionReference actionReference : annotation.value()) {
                if (actionReference.id().id().isEmpty() || actionReference.id().category().isEmpty()) {
                    throw new LayerGenerationException("Specify real id=@ActionID(...)", element, this.processingEnv, (Annotation)actionReference.id());
                }
                this.processReferences(element, actionReference, actionReference.id());
            }
        }
        return true;
    }

    private void processActionState(Element element, ActionState actionState, LayerBuilder.File file, TypeMirror typeMirror, boolean bl, TypeMirror typeMirror2, TypeMirror typeMirror3, TypeMirror typeMirror4, TypeMirror typeMirror5) throws LayerGenerationException {
        Set<Modifier> set;
        String string;
        String string2;
        Object object;
        String string3 = actionState.property();
        TypeMirror typeMirror6 = null;
        try {
            actionState.type();
        }
        catch (MirroredTypeException mirroredTypeException) {
            typeMirror6 = mirroredTypeException.getTypeMirror();
        }
        if (typeMirror6 == null || typeMirror6.getKind() != TypeKind.DECLARED) {
            throw new LayerGenerationException("Invalid enabled-on type in @ActionState", element, this.processingEnv, (Annotation)actionState, "type");
        }
        if (this.processingEnv.getTypeUtils().isSameType(typeMirror6, typeMirror5)) {
            return;
        }
        if (!actionState.useActionInstance() && this.processingEnv.getTypeUtils().isSameType(typeMirror6, typeMirror3) && "".equals(actionState.property()) && !bl) {
            throw new LayerGenerationException("Property must be specified", element, this.processingEnv, (Annotation)actionState);
        }
        DeclaredType declaredType = (DeclaredType)typeMirror6;
        if (this.processingEnv.getTypeUtils().isSameType(declaredType, typeMirror3)) {
            if (typeMirror == null) {
                throw new LayerGenerationException("Property owner type must be specified", element, this.processingEnv, (Annotation)actionState);
            }
            declaredType = (DeclaredType)typeMirror;
        }
        String string4 = this.processingEnv.getElementUtils().getBinaryName((TypeElement)declaredType.asElement()).toString();
        file.stringvalue(bl ? "enableOnType" : "checkedOnType", string4);
        if (!bl) {
            file.boolvalue("openide.awt.actionToggle", true);
        }
        boolean bl2 = this.processingEnv.getTypeUtils().isSameType(declaredType, typeMirror2);
        switch (string3) {
            case "": {
                if (actionState.useActionInstance()) {
                    string3 = null;
                    break;
                }
                string3 = bl ? "enabled" : "SwingSelectedKey";
                break;
            }
            case "#null": {
                string3 = null;
            }
        }
        Object object2 = (TypeElement)declaredType.asElement();
        if (string3 != null && !bl2) {
            Element object3 = null;
            ExecutableElement object4 = null;
            object = Character.toUpperCase(string3.charAt(0)) + string3.substring(1);
            string2 = "is" + (String)object;
            string = "get" + (String)object;
            for (ExecutableElement object5 : ElementFilter.methodsIn(this.processingEnv.getElementUtils().getAllMembers((TypeElement)object2))) {
                if (object5.getSimpleName().contentEquals(string2)) {
                    if (!object5.getParameters().isEmpty()) {
                        object4 = object5;
                    } else {
                        object3 = object5;
                        break;
                    }
                }
                if (!object5.getSimpleName().contentEquals(string)) continue;
                if (!object5.getParameters().isEmpty()) {
                    if (object4 != null) continue;
                    object4 = object5;
                    continue;
                }
                object3 = object5;
            }
            if (object3 == null) {
                if (object4 != null) {
                    throw new LayerGenerationException("Getter " + string4 + "." + object4.toString() + " must take no parameters", element, this.processingEnv, (Annotation)actionState, "property");
                }
                throw new LayerGenerationException("Property " + string3 + " not found in " + string4 + ".", element, this.processingEnv, (Annotation)actionState, "property");
            }
            set = object3.getModifiers();
            if (!set.contains((Object)Modifier.PUBLIC)) {
                throw new LayerGenerationException("Getter " + string4 + "." + object3.toString() + " must be public", element, this.processingEnv, (Annotation)actionState, "property");
            }
        }
        if (string3 != null) {
            file.stringvalue(bl ? "enableOnProperty" : "checkedOnProperty", string3);
        }
        TypeMirror typeMirror7 = null;
        try {
            actionState.listenOn();
            return;
        }
        catch (MirroredTypeException mirroredTypeException) {
            boolean bl3;
            typeMirror7 = mirroredTypeException.getTypeMirror();
            boolean bl4 = !this.processingEnv.getTypeUtils().isSameType(typeMirror7, typeMirror4);
            object = (TypeElement)((DeclaredType)typeMirror7).asElement();
            string2 = object.getSimpleName().toString();
            string = this.processingEnv.getElementUtils().getBinaryName((TypeElement)object).toString();
            set = "add" + string2;
            String string5 = "remove" + string2;
            if (bl4) {
                if (object.getKind() != ElementKind.INTERFACE) {
                    throw new LayerGenerationException(string + " is not an interface", element, this.processingEnv, (Annotation)actionState, "listenOn");
                }
                if (!object.getModifiers().contains((Object)Modifier.PUBLIC)) {
                    throw new LayerGenerationException(string + " is not public", element, this.processingEnv, (Annotation)actionState, "listenOn");
                }
            }
            ExecutableElement executableElement = null;
            ExecutableElement executableElement2 = null;
            ExecutableElement executableElement3 = null;
            ExecutableElement executableElement4 = null;
            for (ExecutableElement executableElement5 : ElementFilter.methodsIn(this.processingEnv.getElementUtils().getAllMembers((TypeElement)object2))) {
                if (executableElement5.getSimpleName().contentEquals((CharSequence)((Object)set))) {
                    executableElement2 = executableElement5;
                    if (!executableElement5.getModifiers().contains((Object)Modifier.PUBLIC) || executableElement5.getModifiers().contains((Object)Modifier.STATIC) || executableElement5.getParameters().size() != 1 || !this.processingEnv.getTypeUtils().isSameType(typeMirror7, executableElement5.getParameters().get(0).asType())) continue;
                    executableElement = executableElement5;
                    continue;
                }
                if (!executableElement5.getSimpleName().contentEquals(string5)) continue;
                executableElement4 = executableElement5;
                if (!executableElement5.getModifiers().contains((Object)Modifier.PUBLIC) || executableElement5.getModifiers().contains((Object)Modifier.STATIC) || executableElement5.getParameters().size() != 1 || !this.processingEnv.getTypeUtils().isSameType(typeMirror7, executableElement5.getParameters().get(0).asType())) continue;
                executableElement3 = executableElement5;
            }
            if (executableElement == null) {
                if (executableElement2 != null) {
                    throw new LayerGenerationException("Method add" + executableElement2.getSimpleName() + " must be public and take exactly one parameter of type " + string2 + ".", element, this.processingEnv, (Annotation)actionState, "listenOn");
                }
                if (bl4) {
                    throw new LayerGenerationException("Method add" + string2 + " not found on " + string4, element, this.processingEnv, (Annotation)actionState, "listenOn");
                }
            }
            if (executableElement3 == null) {
                if (executableElement4 != null) {
                    throw new LayerGenerationException("Method remove" + executableElement4.getSimpleName() + " must be public and take exactly one parameter of type " + string2 + ".", element, this.processingEnv, (Annotation)actionState, "listenOn");
                }
                if (bl4) {
                    throw new LayerGenerationException("Method remove" + string2 + " not found on " + string4, element, this.processingEnv, (Annotation)actionState, "listenOn");
                }
            }
            boolean bl5 = bl3 = bl4 || executableElement != null && executableElement3 != null;
            if (bl3) {
                file.stringvalue(bl ? "enableOnChangeListener" : "checkedOnChangeListener", string);
            }
            if (!"".equals(actionState.listenOnMethod())) {
                if (!bl4) {
                    throw new LayerGenerationException("Cannot specify listenOnMethod() without listenOn().", element, this.processingEnv, (Annotation)actionState, "listenOnMethod");
                }
                String string6 = actionState.listenOnMethod();
                int n = 0;
                for (ExecutableElement executableElement6 : ElementFilter.methodsIn(this.processingEnv.getElementUtils().getAllMembers((TypeElement)object))) {
                    if (!executableElement6.getSimpleName().contentEquals(string6)) continue;
                    n = 1;
                    break;
                }
                if (n == 0) {
                    throw new LayerGenerationException("Interface " + string + " does not contain method " + string6, element, this.processingEnv, (Annotation)actionState, "listenOnMethod");
                }
                file.stringvalue(bl ? "enableOnMethod" : "checkedOnMethod", string6);
            }
            if (!"".equals(actionState.checkedValue())) {
                switch (actionState.checkedValue()) {
                    case "#null": {
                        file.boolvalue(bl ? "enableOnNull" : "checkedOnNull", true);
                        break;
                    }
                    case "#non-null": {
                        file.boolvalue(bl ? "enableOnNull" : "checkedOnNull", false);
                        break;
                    }
                    default: {
                        file.stringvalue(bl ? "enableOnValue" : "checkedOnValue", actionState.checkedValue());
                    }
                }
            }
            if (actionState.useActionInstance()) {
                file.stringvalue(bl ? "enableOnActionProperty" : "checkedOnActionProperty", bl ? "enabled" : "SwingSelectedKey");
            }
            return;
        }
    }

    private TypeMirror type(Class<?> clazz) {
        TypeElement typeElement = this.processingEnv.getElementUtils().getTypeElement(clazz.getCanonicalName());
        return typeElement == null ? null : typeElement.asType();
    }

    private TypeMirror generateContext(Element element, LayerBuilder.File file, ActionRegistration actionRegistration) throws LayerGenerationException {
        ExecutableElement executableElement = null;
        ExecutableElement executableElement2 = null;
        for (ExecutableElement annotatedConstruct2 : ElementFilter.constructorsIn(element.getEnclosedElements())) {
            if (annotatedConstruct2.getKind() != ElementKind.CONSTRUCTOR) continue;
            executableElement2 = annotatedConstruct2;
            if (!annotatedConstruct2.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
            if (executableElement != null) {
                throw new LayerGenerationException("Only one public constructor allowed", element, this.processingEnv, (Annotation)actionRegistration);
            }
            executableElement = annotatedConstruct2;
        }
        if (executableElement == null || executableElement.getParameters().size() != 1) {
            if (executableElement2 != null) {
                throw new LayerGenerationException("Constructor has to be public with one argument", executableElement2);
            }
            throw new LayerGenerationException("Constructor must have one argument", (Element)executableElement);
        }
        VariableElement variableElement = executableElement.getParameters().get(0);
        TypeMirror typeMirror = variableElement.asType();
        switch (typeMirror.getKind()) {
            case ARRAY: {
                String declaredType = ((ArrayType)typeMirror).getComponentType().toString();
                throw new LayerGenerationException("Use List<" + declaredType + "> rather than " + declaredType + "[] in constructor", element, this.processingEnv, (Annotation)actionRegistration);
            }
            case DECLARED: {
                break;
            }
            default: {
                throw new LayerGenerationException("Must use SomeType (or List<SomeType>) in constructor, not " + (Object)((Object)typeMirror.getKind()));
            }
        }
        DeclaredType declaredType = (DeclaredType)typeMirror;
        String string = this.processingEnv.getElementUtils().getBinaryName((TypeElement)declaredType.asElement()).toString();
        if ("java.util.List".equals(string)) {
            if (declaredType.getTypeArguments().isEmpty()) {
                throw new LayerGenerationException("Use List<SomeType>", (Element)executableElement);
            }
            file.stringvalue("type", this.binaryName(declaredType.getTypeArguments().get(0)));
            file.methodvalue("delegate", "org.openide.awt.Actions", "inject");
            file.stringvalue("injectable", this.processingEnv.getElementUtils().getBinaryName((TypeElement)element).toString());
            file.stringvalue("selectionType", "ANY");
            file.methodvalue("instanceCreate", "org.openide.awt.Actions", "context");
            return declaredType.getTypeArguments().get(0);
        }
        if (!declaredType.getTypeArguments().isEmpty()) {
            throw new LayerGenerationException("No type parameters allowed in ", (Element)executableElement);
        }
        file.stringvalue("type", this.binaryName(typeMirror));
        file.methodvalue("delegate", "org.openide.awt.Actions", "inject");
        file.stringvalue("injectable", this.processingEnv.getElementUtils().getBinaryName((TypeElement)element).toString());
        file.stringvalue("selectionType", "EXACTLY_ONE");
        file.methodvalue("instanceCreate", "org.openide.awt.Actions", "context");
        return typeMirror;
    }

    private String binaryName(TypeMirror typeMirror) {
        Element element = this.processingEnv.getTypeUtils().asElement(typeMirror);
        if (element != null && (element.getKind().isClass() || element.getKind().isInterface())) {
            return this.processingEnv.getElementUtils().getBinaryName((TypeElement)element).toString();
        }
        return typeMirror.toString();
    }

    private boolean isAssignable(TypeMirror typeMirror, TypeMirror typeMirror2) {
        if (typeMirror2 == null) {
            return false;
        }
        return this.processingEnv.getTypeUtils().isAssignable(typeMirror, typeMirror2);
    }

    private void processReferences(Element element, ActionReference actionReference, ActionID actionID) throws LayerGenerationException {
        LayerBuilder.File file;
        LayerBuilder.File file2;
        if (!(actionReference.id().category().isEmpty() || actionReference.id().id().isEmpty() || actionID.id().equals(actionReference.id().id()) && actionID.category().equals(actionReference.id().category()))) {
            throw new LayerGenerationException("Can't specify id() attribute when @ActionID provided on the element", element, this.processingEnv, (Annotation)actionID);
        }
        String string = actionReference.name();
        if (string.isEmpty()) {
            string = actionID.id().replace('.', '-');
        }
        if (actionReference.path().startsWith("Shortcuts") && (file2 = Utilities.stringToKeys((String)string)) == null) {
            throw new LayerGenerationException("Registrations in Shortcuts folder need to represent a key. Specify value for 'name' attribute.\nSee org.openide.util.Utilities.stringToKeys for possible values. Current name=\"" + string + "\" is not valid.\n", element, this.processingEnv, (Annotation)actionReference, "path");
        }
        file2 = this.layer(new Element[]{element}).file(actionReference.path() + "/" + string + ".shadow");
        file2.stringvalue("originalFile", "Actions/" + actionID.category() + "/" + actionID.id().replace('.', '-') + ".instance");
        file2.position(actionReference.position());
        file2.write();
        if (actionReference.separatorAfter() != Integer.MAX_VALUE) {
            if (actionReference.position() == Integer.MAX_VALUE || actionReference.position() >= actionReference.separatorAfter()) {
                throw new LayerGenerationException("separatorAfter() must be greater than position()", element, this.processingEnv, (Annotation)actionReference);
            }
            file = this.layer(new Element[]{element}).file(actionReference.path() + "/" + string + "-separatorAfter.instance");
            file.newvalue("instanceCreate", JSeparator.class.getName());
            file.position(actionReference.separatorAfter());
            file.write();
        }
        if (actionReference.separatorBefore() != Integer.MAX_VALUE) {
            if (actionReference.position() == Integer.MAX_VALUE || actionReference.position() <= actionReference.separatorBefore()) {
                throw new LayerGenerationException("separatorBefore() must be lower than position()", element, this.processingEnv, (Annotation)actionReference);
            }
            file = this.layer(new Element[]{element}).file(actionReference.path() + "/" + string + "-separatorBefore.instance");
            file.newvalue("instanceCreate", JSeparator.class.getName());
            file.position(actionReference.separatorBefore());
            file.write();
        }
    }
}

