/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.libgraal.jni;

import org.graalvm.compiler.debug.TTY;
import org.graalvm.libgraal.jni.HotSpotToSVMScope;
import org.graalvm.libgraal.jni.JNI;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CLongPointer;
import org.graalvm.nativeimage.c.type.CShortPointer;
import org.graalvm.nativeimage.c.type.VoidPointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

public final class JNIUtil {
    private static Integer traceLevel;
    private static final String JNI_LIBGRAAL_TRACE_LEVEL_ENV_VAR_NAME = "JNI_LIBGRAAL_TRACE_LEVEL";

    public static boolean IsSameObject(JNI.JNIEnv env, JNI.JObject ref1, JNI.JObject ref2) {
        JNIUtil.traceJNI("IsSameObject");
        return env.getFunctions().getIsSameObject().call(env, ref1, ref2);
    }

    public static void DeleteLocalRef(JNI.JNIEnv env, JNI.JObject ref) {
        JNIUtil.traceJNI("DeleteLocalRef");
        env.getFunctions().getDeleteLocalRef().call(env, ref);
    }

    public static int PushLocalFrame(JNI.JNIEnv env, int capacity) {
        JNIUtil.traceJNI("PushLocalFrame");
        return env.getFunctions().getPushLocalFrame().call(env, capacity);
    }

    public static JNI.JObject PopLocalFrame(JNI.JNIEnv env, JNI.JObject result) {
        JNIUtil.traceJNI("PopLocalFrame");
        return env.getFunctions().getPopLocalFrame().call(env, result);
    }

    public static JNI.JClass DefineClass(JNI.JNIEnv env, CCharPointer name, JNI.JObject loader, CCharPointer buf, int bufLen) {
        return env.getFunctions().getDefineClass().call(env, name, loader, buf, bufLen);
    }

    public static JNI.JClass FindClass(JNI.JNIEnv env, CCharPointer name) {
        JNIUtil.traceJNI("FindClass");
        return env.getFunctions().getFindClass().call(env, name);
    }

    public static JNI.JMethodID GetStaticMethodID(JNI.JNIEnv env, JNI.JClass clazz, CCharPointer name, CCharPointer sig) {
        JNIUtil.traceJNI("GetStaticMethodID");
        return env.getFunctions().getGetStaticMethodID().call(env, clazz, name, sig);
    }

    public static JNI.JObjectArray NewObjectArray(JNI.JNIEnv env, int len, JNI.JClass componentClass, JNI.JObject initialElement) {
        JNIUtil.traceJNI("NewObjectArray");
        return env.getFunctions().getNewObjectArray().call(env, len, componentClass, initialElement);
    }

    public static JNI.JByteArray NewByteArray(JNI.JNIEnv env, int len) {
        JNIUtil.traceJNI("NewByteArray");
        return env.getFunctions().getNewByteArray().call(env, len);
    }

    public static JNI.JLongArray NewLongArray(JNI.JNIEnv env, int len) {
        JNIUtil.traceJNI("NewLongArray");
        return env.getFunctions().getNewLongArray().call(env, len);
    }

    public static int GetArrayLength(JNI.JNIEnv env, JNI.JArray array) {
        JNIUtil.traceJNI("GetArrayLength");
        return env.getFunctions().getGetArrayLength().call(env, array);
    }

    public static void SetObjectArrayElement(JNI.JNIEnv env, JNI.JObjectArray array, int index, JNI.JObject value) {
        JNIUtil.traceJNI("SetObjectArrayElement");
        env.getFunctions().getSetObjectArrayElement().call(env, array, index, value);
    }

    public static JNI.JObject GetObjectArrayElement(JNI.JNIEnv env, JNI.JObjectArray array, int index) {
        JNIUtil.traceJNI("GetObjectArrayElement");
        return env.getFunctions().getGetObjectArrayElement().call(env, array, index);
    }

    public static CLongPointer GetLongArrayElements(JNI.JNIEnv env, JNI.JLongArray array, JNI.JValue isCopy) {
        JNIUtil.traceJNI("GetLongArrayElements");
        return env.getFunctions().getGetLongArrayElements().call(env, array, isCopy);
    }

    public static void ReleaseLongArrayElements(JNI.JNIEnv env, JNI.JLongArray array, CLongPointer elems, int mode) {
        JNIUtil.traceJNI("ReleaseLongArrayElements");
        env.getFunctions().getReleaseLongArrayElements().call(env, array, elems, mode);
    }

    public static CCharPointer GetByteArrayElements(JNI.JNIEnv env, JNI.JByteArray array, JNI.JValue isCopy) {
        JNIUtil.traceJNI("GetByteArrayElements");
        return env.getFunctions().getGetByteArrayElements().call(env, array, isCopy);
    }

    public static void ReleaseByteArrayElements(JNI.JNIEnv env, JNI.JByteArray array, CCharPointer elems, int mode) {
        JNIUtil.traceJNI("ReleaseByteArrayElements");
        env.getFunctions().getReleaseByteArrayElements().call(env, array, elems, mode);
    }

    public static void Throw(JNI.JNIEnv env, JNI.JThrowable throwable) {
        JNIUtil.traceJNI("Throw");
        env.getFunctions().getThrow().call(env, throwable);
    }

    public static boolean ExceptionCheck(JNI.JNIEnv env) {
        JNIUtil.traceJNI("ExceptionCheck");
        return env.getFunctions().getExceptionCheck().call(env);
    }

    public static void ExceptionClear(JNI.JNIEnv env) {
        JNIUtil.traceJNI("ExceptionClear");
        env.getFunctions().getExceptionClear().call(env);
    }

    public static void ExceptionDescribe(JNI.JNIEnv env) {
        JNIUtil.traceJNI("ExceptionDescribe");
        env.getFunctions().getExceptionDescribe().call(env);
    }

    public static JNI.JThrowable ExceptionOccurred(JNI.JNIEnv env) {
        JNIUtil.traceJNI("ExceptionOccurred");
        return env.getFunctions().getExceptionOccurred().call(env);
    }

    public static <T extends JNI.JObject> T NewGlobalRef(JNI.JNIEnv env, T ref, String type) {
        JNIUtil.traceJNI("NewGlobalRef");
        JNI.JObject res = env.getFunctions().getNewGlobalRef().call(env, ref);
        if (JNIUtil.tracingAt(3)) {
            JNIUtil.trace(3, "New global reference for 0x%x of type %s -> 0x%x", ref.rawValue(), type, res.rawValue());
        }
        return (T)res;
    }

    public static void DeleteGlobalRef(JNI.JNIEnv env, JNI.JObject ref) {
        JNIUtil.traceJNI("DeleteGlobalRef");
        if (JNIUtil.tracingAt(3)) {
            JNIUtil.trace(3, "Delete global reference 0x%x", ref.rawValue());
        }
        env.getFunctions().getDeleteGlobalRef().call(env, ref);
    }

    public static VoidPointer GetDirectBufferAddress(JNI.JNIEnv env, JNI.JObject buf) {
        JNIUtil.traceJNI("GetDirectBufferAddress");
        return env.getFunctions().getGetDirectBufferAddress().call(env, buf);
    }

    private static void traceJNI(String function) {
        JNIUtil.trace(2, "SVM->JNI: %s", function);
    }

    private JNIUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createString(JNI.JNIEnv env, JNI.JString hsString) {
        if (hsString.isNull()) {
            return null;
        }
        int len = env.getFunctions().getGetStringLength().call(env, hsString);
        CShortPointer unicode = env.getFunctions().getGetStringChars().call(env, hsString, (JNI.JValue)WordFactory.nullPointer());
        try {
            char[] data = new char[len];
            for (int i = 0; i < len; ++i) {
                data[i] = (char)unicode.read(i);
            }
            String string = new String(data);
            return string;
        }
        finally {
            env.getFunctions().getReleaseStringChars().call(env, hsString, unicode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JNI.JString createHSString(JNI.JNIEnv env, String string) {
        if (string == null) {
            return (JNI.JString)WordFactory.nullPointer();
        }
        int len = string.length();
        CShortPointer buffer = (CShortPointer)UnmanagedMemory.malloc((int)(len << 1));
        try {
            for (int i = 0; i < len; ++i) {
                buffer.write(i, (short)string.charAt(i));
            }
            JNI.JString jString = env.getFunctions().getNewString().call(env, buffer, len);
            return jString;
        }
        finally {
            UnmanagedMemory.free((PointerBase)buffer);
        }
    }

    public static String getInternalName(String fqn) {
        return "L" + JNIUtil.getBinaryName(fqn) + ";";
    }

    public static String getBinaryName(String fqn) {
        return fqn.replace('.', '/');
    }

    private static int traceLevel() {
        if (traceLevel == null) {
            String var = System.getenv(JNI_LIBGRAAL_TRACE_LEVEL_ENV_VAR_NAME);
            if (var != null) {
                try {
                    traceLevel = Integer.parseInt(var);
                }
                catch (NumberFormatException e) {
                    TTY.printf((String)"Invalid value for %s: %s%n", (Object[])new Object[]{JNI_LIBGRAAL_TRACE_LEVEL_ENV_VAR_NAME, e});
                    traceLevel = 0;
                }
            } else {
                traceLevel = 0;
            }
        }
        return traceLevel;
    }

    public static boolean tracingAt(int level) {
        return JNIUtil.traceLevel() >= level;
    }

    public static void trace(int level, String format, Object ... args) {
        if (JNIUtil.traceLevel() >= level) {
            HotSpotToSVMScope<?> scope = HotSpotToSVMScope.scopeOrNull();
            String indent = scope == null ? "" : new String(new char[2 + scope.depth() * 2]).replace('\u0000', ' ');
            TTY.printf((String)(indent + format + "%n"), (Object[])args);
        }
    }
}

